<?php
    $cs = Yii::app()->getClientScript();
    $baseUrl = Yii::app()->baseUrl;
    ?>
<!DOCTYPE html>
<html lag="en">
<head>
	<meta charset="utf-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<title>Real Estate | Home</title>
	<!-- Tell the browser to be responsive to screen width -->
	<meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
	<link href="https://fonts.googleapis.com/icon?family=Material+Icons" rel="stylesheet">
	<link href='https://fonts.googleapis.com/css?family=Questrial' rel='stylesheet' type='text/css'>
	
	<!-- START CSS files -->
	<?php $cs->registerCssFile($baseUrl . "/css/front/bootstrap.min.css"); ?>
	<?php $cs->registerCssFile($baseUrl . "/css/front/font-awesome.min.css"); ?>
	<?php $cs->registerCssFile($baseUrl . "/css/front/owl.carousel.css"); ?>
	<?php $cs->registerCssFile($baseUrl . "/css/front/owl.theme.css"); ?>
	<?php $cs->registerCssFile($baseUrl . "/css/front/owl.transitions.css"); ?>
	<?php $cs->registerCssFile($baseUrl . "/css/front/animate.css"); ?>
	<?php $cs->registerCssFile($baseUrl . "/css/front/jquery.material.form.css"); ?>
	<?php $cs->registerCssFile($baseUrl . "/css/front/style.css"); ?>
    <?php $cs->registerCssFile($baseUrl . "/css/datatable.css"); ?>
	<!-- END CSS files -->
	
	<?php $cs->registerScriptFile($baseUrl . "/js/jquery-2.1.4.js", CClientScript::POS_HEAD); ?>
	<?php $cs->registerScriptFile($baseUrl . "/js/front/bootstrap.min.js", CClientScript::POS_HEAD); ?>
	<?php $cs->registerScriptFile($baseUrl . "/js/front/owl.carousel.js", CClientScript::POS_HEAD); ?>
	<?php $cs->registerScriptFile($baseUrl . "/js/front/jquery.material.form.js", CClientScript::POS_HEAD); ?>
	<?php $cs->registerScriptFile($baseUrl . "/js/front/script.js", CClientScript::POS_HEAD); ?>
	<?php $cs->registerScriptFile($baseUrl . "/js/jquery.dataTables.js", CClientScript::POS_END); ?>
	<!-- script src="js/jquery-2.1.1.js"></script> -->
	<script src='https://www.google.com/recaptcha/api.js'></script>
	<!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->
	<!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
    <!--[if lt IE 9]>
    <script src="https://oss.maxcdn.com/html5shiv/3.7.3/html5shiv.min.js"></script>
    <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
    <![endif]-->
</head>
<body>
	<header class="main">
		<div class="container">
			<div class="logo">
				<a href="<?php echo Yii::app()->createUrl('site/loginhome'); ?>">
				<img src="images/logo.png" alt="Bluesky CRM - Real Estate">
				</a>
			</div>
			<nav class="nav">
				<ul class="main-menu">
					<li><a href="<?php echo Yii::app()->createUrl('site/loginhome'); ?>">Home</a></li>
					<li><a href="<?php echo Yii::app()->createUrl('site/aboutus'); ?>">About Us</a></li>
					<?php if(isset(Yii::app()->user->user_id) && Yii::app()->user->user_id > 0 && Yii::app()->user->user_group > 0) {?>
					<li data-ripple-color="#FFF"><a href="<?php echo Yii::app()->createUrl('site/maintenancelist'); ?>">Maintenance</a></li>
					<li data-ripple-color="#FFF"><a href="<?php echo Yii::app()->createUrl('site/flatnotes'); ?>">Notes</a></li>
					<li data-ripple-color="#FFF"><a href="<?php echo Yii::app()->createUrl('site/paymenthistory'); ?>">Payment History</a></li>
					<?php }?>
				</ul>
				<ul class="right-nav">
					<li class="dropdown">
						<a class="dropdown-toggle ripple" data-ripple-color="#FFF" data-toggle="dropdown">User
							<span class="caret"></span>
						</a>
						<ul class="dropdown-menu dropdown-menu-right">
							<?php if(!isset(Yii::app()->user->user_id))
							{
								?>
								<li class="ripple" data-ripple-color="#FFF"><a href="#" data-toggle="modal" data-target="#login" >Login</a></li>
								<?php 
							} 
							?>
							<!-- li class="ripple" data-ripple-color="#FFF"><a href="register">Register</a></li> -->
							<?php if(isset(Yii::app()->user->user_id) && Yii::app()->user->user_id > 0 && Yii::app()->user->user_group > 0) {?>
							<li><a href="<?php echo $baseUrl . "/index.php?r="; ?>site/logout">Log out</a></li>
							<?php }?>
						</ul>
					</li>
				</ul>
			</nav>
		</div>
	</header>
 <?php echo $content;?>
		
		<input type="hidden" name="liveSite" id="liveSite" value="<?php echo $baseUrl . "/"; ?>">
		    <div id="login" class="modal fade" role="dialog">
      <div class="modal-dialog">
        <!-- Modal content-->

        <div class="modal-content">
          <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal">&times;</button>
            <h4 class="modal-title">LOGIN</h4>
          </div>
	<?php
	$form = $this->beginWidget('CActiveForm', array(
	    'id' => 'login-form',
	    'enableClientValidation' => true,
	    'enableAjaxValidation' => true,
	    'clientOptions' => array(
	        'validateOnSubmit' => true,
	    ),
	        ));
	$model=new User();
	?>
          <div class="modal-body">
          <div id="div_login_error" style="color: red;text-align:center;"></div>
            <div class="material">
              <div class="material-input">
                <?php echo $form->textField($model, 'username'); ?>
                <span class="highlight"></span>
                <label>Username</label>
                <div class="bar"></div>
              </div>
            </div>
            <div class="material">
              <div class="material-input">
                <?php echo $form->passwordField($model, 'password'); ?>
                <span class="highlight"></span>
                <label>Password</label>
                <div class="bar"></div>
              </div>
            </div>
          </div>
          <div class="modal-footer text-center">
           <?php echo CHtml::ajaxSubmitButton('LOGIN', Yii::app()->createUrl('site/login'), array(
				'dataType' => 'json',
				'type' => 'post',
				'success' => 'function(data) {
                    if(data.status=="success"){
                        location.href=$("#liveSite").val()+"index.php?r=site/loginhome";
                    } 
				    else 
					{  
					    $.each(data, function(key, val) { 
		                    $("#"+key).addClass("error");
           					$("#div_login_error").html(data.status);
						}); 
					} 
				}',
				'beforeSend' => 'function(){
           			if($("#User_username").val()=="")
           			{
           				$("#User_username").addClass("error");
           				$("#div_login_error").html("Please enter username");
           			}
           			else if($("#User_password").val()=="")
           			{
           				$("#User_password").addClass("error");
           				$("#div_login_error").html("Please enter password");
           			}
           			else
           			{
           				$("#div_login_error").html("");
           				$("#login-form .login-save-btn").prop("disabled", true);
           			}
                    
                }',
			'complete' => 'function(){
                	$("#login-form .login-save-btn").prop("disabled", false);
                }'
			), array('id' => 'mybtn' . rand(), 'class' => 'login-save-btn btn btn-primary')); ?>
          </div>
          <?php $this->endWidget(); ?>
        </div>

      </div>
    </div>
		
	<footer>
		<div class="container">
		<div class="row">
			<div class="col-sm-6">
			<ul class="social">
				<li class="ripple" data-ripple-color="#FFF"><a href="#"><i class="fa fa-facebook"></i></a></li>
				<li class="ripple" data-ripple-color="#FFF"><a href="#"><i class="fa fa-twitter"></i></a></li>
				<li class="ripple" data-ripple-color="#FFF"><a href="#"><i class="fa fa-google-plus"></i></a></li>
			</ul>
			</div>
			<div class="col-sm-6 text-right"> <a href="#">Home</a> | <a href="#">About Us</a> |  <a href="#">Lorem</a></div>
		</div>

		</div>
		<div class="footer-text">© 2016 Home delivery. All Rights Reserved. Powered by Bluesky Technology Consultants.</div>
	</footer>
	
</body>
</html>