<!DOCTYPE html>
<html>
<head>
  <title>Tenant Report PDF</title>
</head>
<body>
  <?php 
  $country_name =$state_name =$landlord_name ='ALL';
  if($country!='')
  {
    $country_name = MasterCountry::getCountryName($country);
  }
  if($landlord_id!='')
  {
    $landlord_name = Landlord::getLandlordName($landlord_id);
  }
  
  ?>


  <div class="report-container">
    <div class="heading">
      <div class="col-3" style="float:left;">
        <img src="images/logo.png" class="responsive">
      </div>
      <div class="col-8" style="float:left;">
        <div class="title"><h2>Tenant Report</h2></div>
      </div>
      <div class="clearfix"><br></div>
      <div class="col-6 left-label">
        
        <?php if($country!= '' && $country != "null"){
          echo '<p><label><b>Country </b></label>: ' .$country_name.'</p>';
        } ?>
        <?php if($location != '' && $location != "null"){
          echo '<p><label><b>Location </b></label>: ' .$location.'</p>';
        } ?>
        <?php if($landlord_id != '' && $landlord_id != "null"){
          echo '<p><label><b>Land Owner </b></label>: ' .$landlord_name.'</p>';
        } ?>
          <?php if($building_id != ''){
          echo '<p><label><b>Building</b></label>: ' .Building::getBuildingName($building_id).'</p>';
        } ?>
       </div>
      <div class="col-4 col-offset-2 right-label">
        
      </div>


    </div>
  </div>
  <div class="clearfix"><br></div>
<?php
    $cond  =  't.flat_status="2"';
    if($location!=''){
        $cond  .=  ' AND building.location="'.$location.'"';
    }
    if($building_id !=''){
        $cond  .=  ' AND t.building_id="'.$building_id.'"';
    }
    if($landlord_id !=''){
        $cond  .=  ' AND ownerdetail.landlord="'.$landlord_id.'"';
    }
    if($country!=''){
        $cond  .=  ' AND building.country = "'.$country.'"';           
    }
    $list_tenants =  Lease::model()->with('building','flat','tenant','flat.ownerdetail')->findAll(array('condition'=>$cond,'order'=>'flat.flat_no'));?>
<div class="panel-body">
<div class="table-responsive tbl-zoom">    
<table id="tbl_tenant" class="table table-striped table-primary">
    
        <tr>
              <th class="text-center">Flat No</th>
              <th colspan="3">Owner</th>
              <th class="text-center">Building</th>
              <th class="text-center">Country</th>
              <th class="text-center">Location</th>
              <th class="text-center">Tenant</th>
              <th class="text-center">Annual Rent</th>
        </tr>
    <?php
        if(!empty($list_tenants)){
            $totalamnt = 0;
            foreach ($list_tenants as $each_tenant)
            { 
                $totalamnt +=$each_tenant->lease_amount;
                ?>


            <tr>
                <td colspan="3"><?php echo isset($each_tenant->flat)?$each_tenant->flat->flat_no:'';?></td>
                <td><?php echo BuildingOwnerDetails::getFlatLandlordName($each_tenant->flat_id);?></td>
                <td><?php echo $each_tenant->building->building_name;?></td>
                <td><?php echo $each_tenant->building->countrydetail->country_name;?></td>
                <td><?php echo $each_tenant->building->location;?></td>
                <td><?php echo $each_tenant->tenant->name;?></td>
                <td class="text-right"><?php echo Yii::app()->numberFormatter->formatCurrency($each_tenant->lease_amount," ");?></td>
            </tr>

            <?php
            } ?>
            <tr>
                <th colspan="8">Total</th>
                <td class="text-right"><?php echo Yii::app()->numberFormatter->formatCurrency($totalamnt, " ");?></td>
            </tr>
            <?php
        }else{ ?>
          <tr>
                <th colspan="9">No Details Found</th>
            </tr>  
 <?php  }
?>
</table>
 </div>
</div>
<htmlpagefooter name="myfooter">
            <div style="text-align:center;width:100%;font-size:10px">This report is auto generated by Realestate on
        <?php
                  date_default_timezone_set("Asia/Dubai");
                 echo date('d/m/Y')." ".date("h:i:sa"); ?>
    </div>
         <div style="border-top: 1px dotted #000000; font-size: 12px; text-align: center; padding-top: 10px; ">
        <div style="binvoice-top: 1px dotted #000000; font-size: 12px; text-align: center; padding-top: 10px; ">
            <div style="text-align:center;width:100%">Page {PAGENO} of {nb} </div>
        </div></div>
    </htmlpagefooter>
</body></html>

    