<!DOCTYPE html>
<html>
<head>
  <title>Expense Report PDF</title>
</head>
<body>
  <?php 
  if($ledger_id!='')
  {
    $ledger_name = ExpenseType::model()->findByPk($ledger_id)->expense_type;    
  }
  
  ?>


  <div class="report-container">
    <div class="heading">
      <div class="col-3" style="float:left;">
        <img src="images/logo.png" class="responsive">
      </div>
      <div class="col-8" style="float:left;">
        <div class="title"><h2>Expense Report</h2></div>
      </div>
      <div class="clearfix"><br></div>
      <div class="col-6 left-label">
        
        <?php if($from_date != '' && $from_date != "null"){
          echo '<p><label><b>From Date </b></label>: ' .$from_date.'</p>';
        } ?>
        <?php if($to_date!= '' && $to_date != "null"){
          echo '<p><label><b>To Date </b></label>: ' .$to_date.'</p>';
        } ?>
        <?php if($ledger_id != '' && $ledger_id != "null"){
          echo '<p><label><b>Ledger </b></label>: ' .$ledger_name.'</p>';
        } ?>
          <?php if($building_id != ''){
          echo '<p><label><b>Building</b></label>: ' .Building::getBuildingName($building_id).'</p>';
        } ?>
       </div>
      <div class="col-4 col-offset-2 right-label">
        
      </div>


    </div>
  </div>
  <div class="clearfix"><br></div>
<?php
    $cond  =  '1=1 ';
    if($ledger_id !=''){
        $cond  .=  ' AND t.expense_type="'.$ledger_id.'"';
    }
    if($building_id !=''){
        $cond  .=  ' AND t.building_id="'.$building_id.'"';
    }
    if($from_date !=''){
        $from_date=str_replace('/', '-', $from_date);
        $cond  .=  ' AND t.expense_date >="'.date("Y-m-d", strtotime($from_date)).'"';
    }
    if($to_date!=''){
        $to_date=str_replace('/', '-', $to_date);
        $cond  .=  ' AND t.expense_date <="'.date("Y-m-d", strtotime($to_date)).'"';
    }
    $list_expenses = Expense::model()->with('building_details','flat_details','expense_type_details')->findAll(array('condition'=>$cond,'order'=>'t.expense_date desc'));?>
    
<div class="panel-body">
<div class="table-responsive tbl-zoom">    
<table id="tbl_tenant" class="table table-striped table-primary">
    
        <tr>
              <th class="text-center">No</th>
              <th class="text-center">Date</th>
              <th class="text-center">Building</th>
              <th class="text-center">Flat</th>
              <th class="text-center">Ledger</th>
              <th class="text-center">Notes</th>
              <th class="text-center">Amount</th>
        </tr>
    <?php
        if(!empty($list_expenses)){
            $totalamnt = 0;
            foreach ($list_expenses as $i=>$each_expense)
            { 
                $totalamnt +=$each_expense->expense_amount;
                ?>


            <tr>
                <td><?php echo ($i+1);?></td>
                <td><?php echo date("d/m/Y",strtotime($each_expense->expense_date));?></td>
                <td><?php echo $each_expense->building_details->building_name;?></td>
                <td><?php echo isset($each_expense->flat_details)?$each_expense->flat_details->flat_no:''; ?></td>
                <td><?php echo $each_expense->expense_type_details->expense_type;?></td>
                <td><?php echo $each_expense->remarks;?></td>
                <td class="text-right"><?php echo Yii::app()->numberFormatter->formatCurrency($each_expense->expense_amount," ");?></td>
            </tr>

            <?php
            } ?>
            <tr>
                <th colspan="6">Total</th>
                <td class="text-right"><?php echo Yii::app()->numberFormatter->formatCurrency($totalamnt, " ");?></td>
            </tr>
            <?php
        }else{ ?>
          <tr>
                <th colspan="7">No Details Found</th>
            </tr>  
 <?php  }
?>
</table>
 </div>
</div>
  </body>
<htmlpagefooter name="myfooter">
            <div style="text-align:center;width:100%;font-size:10px">This report is auto generated by Realestate on
        <?php
                  date_default_timezone_set("Asia/Dubai");
                 echo date('d/m/Y')." ".date("h:i:sa"); ?>
    </div>
         <div style="border-top: 1px dotted #000000; font-size: 12px; text-align: center; padding-top: 10px; ">
        <div style="binvoice-top: 1px dotted #000000; font-size: 12px; text-align: center; padding-top: 10px; ">
            <div style="text-align:center;width:100%">Page {PAGENO} of {nb} </div>
        </div></div>
    </htmlpagefooter>
</html>

    