<!DOCTYPE html>
<html>
<head>
  <title>Receipt Report PDF</title>
</head>
<body>
  <?php $condition="1=1";
  if($date_from!='')
  {
    $date_from = str_replace('/', '-', $date_from);
    $date_from = date("Y-m-d", strtotime($date_from));
    $condition.=" AND payment_date>='$date_from'";
  }
  if($date_to!='')
  {
    $date_to = str_replace('/', '-', $date_to);
    $date_to = date("Y-m-d", strtotime($date_to));
    $condition.=" AND payment_date<='$date_to'";
  }
  if($rel_from!='')
  {
    $rel_from = str_replace('/', '-', $rel_from);
    $rel_from = date("Y-m-d", strtotime($rel_from));
    $condition.=" AND realisation_date>='$rel_from'";
  }
  if($rel_to!='')
  {
    $rel_to = str_replace('/', '-', $rel_to);
    $rel_to = date("Y-m-d", strtotime($rel_to));
    $condition.=" AND realisation_date<='$rel_to'";
  }
  if($cheque_from!='')
  {
    $cheque_from = str_replace('/', '-', $cheque_from);
    $cheque_from = date("Y-m-d", strtotime($cheque_from));
    $condition.=" AND cheque_date>='$cheque_from'";
  }
  if($cheque_to!='')
  {
    $cheque_to = str_replace('/', '-', $cheque_to);
    $cheque_to = date("Y-m-d", strtotime($cheque_to));
    $condition.=" AND cheque_date<='$cheque_to'";
  }
  if($building!='' && $building!="null")
  {
    $condition.=" AND building_id IN(".$building.")";        
  }
  if($flat!='' && $flat!="null")
  {
    $condition.=" AND flat_id=$flat";
  }
  if($transaction!='' && $transaction!="null")
  {
    $condition.=" AND transaction_type=$transaction";
  }
  if($payment!='' && $payment!="null")
  {
    $condition.=" AND payment_type=$payment";
  }
  $model = Receipt::model()->findAll(array('condition'=>$condition));
  ?>


  <div class="report-container">
    <div class="heading">
      <div class="col-3" style="float:left;">
        <img src="images/logo.png" class="responsive">
      </div>
      <div class="col-8" style="float:left;">
        <div class="title"><h2>RECEIPT REPORT</h2></div>
      </div>
      <div class="clearfix"><br></div>
      <div class="col-6 left-label">
        
        <?php if($building != '' && $building != "null"){
          echo '<p><label><b>Building</b></label>:' .Building::getMultipleBuildingName($building).'</p>';
        } ?>
        <?php if($flat != '' && $flat != "null"){
          echo '<p><label><b>Flat</b></label>:' .Flat::getFlatName($flat).'</p>';
        } ?>
        <?php if($transaction != '' && $transaction != "null"){
          echo '<p><label><b>Transaction</b></label>:' .TransactionType::getTransactionName($transaction).'</p>';
        } ?>
        <?php if($payment != '' && $payment != "null"){
         echo '<p><label><b>Payment</b></label>:';
         if($payment == "1"){
           echo 'Cash'.'</p>';
         }else{
           echo 'Cheque'.'</p>';
         } } ?>
       </div>
      <div class="col-4 col-offset-2 right-label">
        <?php if($date_from != ''){
          echo '<p><label><b>Date From</b></label>:' . date("d/m/Y",strtotime($date_from)).'</p>';
        } ?>
        <?php if($date_to != ''){
          echo '<p><label><b>Date To</b></label>:' .date("d/m/Y",strtotime($date_to)).'</p>';
        } ?>
        <?php if($rel_from != ''){
          echo '<p><label><b>Realisation From</b></label>:' .date("d/m/Y",strtotime($rel_from)).'</p>';
        } ?>
        <?php if($rel_to != ''){
          echo '<p><label><b>Realisation To</b></label>:' .date("d/m/Y",strtotime($rel_to)).'</p>';
        } ?>
        <?php if($cheque_from != ''){
          echo '<p><label><b>Cheque From</b></label>:' .date("d/m/Y",strtotime($cheque_from)).'</p>';
        } ?>
        <?php if($cheque_to != ''){
          echo '<p><label><b>Cheque To</b></label>:' .date("d/m/Y",strtotime($cheque_to)).'</p>';
        } ?>
      </div>


    </div>
  </div>
  <div class="clearfix"><br></div>
   <table id="tbl_receipt_table" class="table table-striped table-primary">
    <thead>
      <tr>
        <th class="text-center">No</th>
        <th class="text-center">Receipt Date</th>
        <th class="text-center">Cheque Date</th>
        <th class="text-center">Realisation Date</th>
        <th class="text-center">Flat</th>
        <th class="text-center">Tenant</th>
        <th class="text-center">Transaction Type</th>
        <th class="text-center">Receipt Type</th>
        <th class="text-center">Status</th>
        <th class="text-center">Amount</th>
      </tr>
    </thead>

    <tbody>
      <?php
      $total_amount=0;
      foreach ($model as $i=>$row) {
        ?>
        <tr>
          <td><?php echo ($i+1);?></td>
          <?php if($row->payment_date != '0000-00-00') { ?>
            <td class="text-center"><?php echo date("d/m/Y",strtotime($row->payment_date));?></td>
            <?php } else { ?>
              <td> &nbsp; </td>
              <?php } ?>
              <?php if($row->cheque_date != '0000-00-00') { ?>
                <td class="text-center"><?php echo date("d/m/Y",strtotime($row->cheque_date));?></td>
                <?php } else { ?>
                  <td> &nbsp; </td>
                  <?php } ?>
                  <?php if($row->realisation_date != '0000-00-00') { ?>
                    <td class="text-center"><?php echo date("d/m/Y",strtotime($row->realisation_date));?></td>
                    <?php } else { ?>
                      <td> &nbsp; </td>
                      <?php } ?>
                      <td><?php echo $row->flat->flat_no;?></td>
                      <td><?php echo $row->lease->tenant->name;?></td>
                          <td><?php echo $row->transtype->trans_name;?></td>
                      <td><?php echo Receipt::getPaymentType($row->payment_type);?></td>
                      <td><?php echo Receipt::getPaymentStatus($row->status);?></td>
                      <td class="text-right"><?php
                        $total_amount+=$row->amount;
                        echo Yii::app()->numberFormatter->formatCurrency($row->amount,"");?></td>

                      </tr>
                      <?php
                    }
                    ?>

                  </tbody>
                  <tfoot>
                    <tr>
                      <th colspan="9" class="text-right h4">Total</th>
                      <th colspan="1" class="text-right h4"><?php echo Yii::app()->numberFormatter->formatCurrency($total_amount,"");?></th>
                    </tr>
                  </tfoot>
                </table>
              </div>
            </div>
          </div>

        </section>
      </div>
    </div>
