<div class="page">
  <div class="content">
    <div class="panel">
      <ul class="nav nav-tabs">
        <li class="active"><a data-toggle="tab" href="#div_inprocess_payment" ripple="ripple" ripple-color="#FFF">Not Cleared</a></li>
        <li><a data-toggle="tab" href="#div_completed_payment" ripple="ripple" ripple-color="#FFF">Cleared</a></li>
        <li><a data-toggle="tab" href="#div_bounced_payment"  ripple="ripple" ripple-color="#FFF" id="materials" >Bounced</a></li>
        <li><a data-toggle="tab" href="#div_cancelled_payment"  ripple="ripple" ripple-color="#FFF" id="materials" >Cancelled</a></li>
        <li><a data-toggle="tab" href="#div_receipt_print"  ripple="ripple" ripple-color="#FFF" id="materials" >Print Receipts</a></li>
        <div class="pull-right">
            <?php if(Yii::app()->user->authorised_user == 1 || Yii::app()->user->havePermissionOn['lease_receipt_add']){ ?>
          <div class="btn-on-nav">
            <a onclick="clearcheques();" id="clearcheque" title="Clear Cheques" class="btn btn-sm btn-white"><i class="fa fa-thumbs-o-up"></i></a>
          </div>
          <a class="btn-add" ripple="ripple" ripple-color="#FFFFFF" data-toggle="modal" onclick="loadPopupModal('receipt/create','Add Receipt','sm');" id="addModalButton" title="Add">+</a>
        <?php } ?>
        </div>
        <div class="pull-right">
            <div class="nav-controls">
                <?php echo CHtml::textField('date_from', '',array('placeholder'=>'Date From','class' =>'form-control date-picker')); ?>
                <?php echo CHtml::textField('date_to', '',array('placeholder'=>'Date To','class' =>'form-control date-picker')); ?>
                <?php echo CHtml::dropDownList('payment_type','',array('1'=>'Cash','2'=>'Cheque'),array('placeholder'=>'Cash/Cheque','onChange'=>'getPaymentFilter()','class' =>'form-control','prompt'=>'-Select Type-'));?>
            </div>
        </div>
      </ul>
      <div class="tab-content">
        <div id="div_inprocess_payment" class="tab-pane fade in active">
          <?php $this->renderPartial('inprocess');?>
        </div>
        <div id="div_completed_payment" class="tab-pane fade">
          <?php $this->renderPartial('completed');?>
        </div>
        <div id="div_bounced_payment" class="tab-pane fade">
         <?php $this->renderPartial('bounced');?>
       </div>
       <div id="div_cancelled_payment" class="tab-pane fade">
        <?php $this->renderPartial('cancelled');?>
      </div>
      <div id="div_receipt_print" class="tab-pane fade">
        <?php $this->renderPartial('receipt_list');?>
      </div>
    </div>
  </div>
</div>
</div>
<?php
$cs = Yii::app()->getClientScript();
$baseUrl = Yii::app()->baseUrl;
$cs->registerScript("getPaymentFilter",  "function getPaymentFilter(){
    getInProcessPayments();
    getBouncedPayments();
    getCancelledPayments();
    getCompletedPayments();
    getReceiptLists();
};", CClientScript::POS_HEAD);
$cs->registerScript("change_from_date", "$(document).ready(function(){
    $('#date_from').datepicker({
       onSelect: function(dateText, inst) {
           var date_from=$('#date_from').val();
           var date_from=date_from.split('/').reverse().join('-');
           getInProcessPayments();
           getBouncedPayments();
           getCancelledPayments();
           getCompletedPayments();
           getReceiptLists();
       }
});
  })", CClientScript::POS_HEAD);


$cs->registerScript("change_to_date", "$(document).ready(function(){
    $('#date_to').datepicker({
       onSelect: function(dateText, inst) {
           var date_to=$('#date_to').val();
           var date_to=date_to.split('/').reverse().join('-');
           getInProcessPayments();
           getBouncedPayments();
           getCancelledPayments();
           getCompletedPayments();
           getReceiptLists();
       }
    });
})", CClientScript::POS_HEAD);
$cs->registerScript("getInProcessPayments", "
	function getInProcessPayments(){
            var date_to=$('#date_to').val();
            var date_to=date_to.split('/').reverse().join('-');
            var date_from=$('#date_from').val();
            var date_from=date_from.split('/').reverse().join('-');
            var payment_type = $('#payment_type').val();
            jQuery.ajax({
                    'type': 'post',
                    'data':{'date_to':date_to,'date_from':date_from,'payment_type':payment_type},
                    'url': '" . Yii::app()->createUrl('receipt/getInProcessPayments') . "',
                    'cache': false,
                    'success': function(data)
                    {
                            $('#div_inprocess_payment').html(data);
                    }
            });
	}", CClientScript::POS_HEAD);
$cs->registerScript("getBouncedPayments", "
	function getBouncedPayments(){
            var date_to=$('#date_to').val();
            var date_to=date_to.split('/').reverse().join('-');
            var date_from=$('#date_from').val();
            var date_from=date_from.split('/').reverse().join('-');
            var payment_type = $('#payment_type').val();
            jQuery.ajax({
                    'type': 'post',
                    'data':{'date_to':date_to,'date_from':date_from,'payment_type':payment_type},
                    'url': '" . Yii::app()->createUrl('receipt/getBouncedPayments') . "',
                    'cache': false,
                    'success': function(data)
                    {
                            $('#div_bounced_payment').html(data);
                    }
            });
	}", CClientScript::POS_HEAD);
$cs->registerScript("getCancelledPayments", "
	function getCancelledPayments(){
            var date_to=$('#date_to').val();
            var date_to=date_to.split('/').reverse().join('-');
            var date_from=$('#date_from').val();
            var date_from=date_from.split('/').reverse().join('-');
            var payment_type = $('#payment_type').val();
            jQuery.ajax({
                    'type': 'post',
                    'data':{'date_to':date_to,'date_from':date_from,'payment_type':payment_type},
                    'url': '" . Yii::app()->createUrl('receipt/getCancelledPayments') . "',
                    'cache': false,
                    'success': function(data)
                    {
                            $('#div_cancelled_payment').html(data);
                    }
            });
	}", CClientScript::POS_HEAD);
$cs->registerScript("getCompletedPayments", "
	function getCompletedPayments(){
            var date_to=$('#date_to').val();
            var date_to=date_to.split('/').reverse().join('-');
            var date_from=$('#date_from').val();
            var date_from=date_from.split('/').reverse().join('-');
            var payment_type = $('#payment_type').val();
            jQuery.ajax({
                    'type': 'post',
                    'data':{'date_to':date_to,'date_from':date_from,'payment_type':payment_type},
                    'url': '" . Yii::app()->createUrl('receipt/getCompletedPayments') . "',
                    'cache': false,
                    'success': function(data)
                    {
                            $('#div_completed_payment').html(data);
                    }
            });
	}", CClientScript::POS_HEAD);
$cs->registerScript("getReceiptLists", "
	function getReceiptLists(){
            var date_to=$('#date_to').val();
            var date_to=date_to.split('/').reverse().join('-');
            var date_from=$('#date_from').val();
            var date_from=date_from.split('/').reverse().join('-');
            var payment_type = $('#payment_type').val();
            jQuery.ajax({
                    'type': 'post',
                    'data':{'date_to':date_to,'date_from':date_from,'payment_type':payment_type},
                    'url': '" . Yii::app()->createUrl('receipt/getReceiptLists') . "',
                    'cache': false,
                    'success': function(data)
                    {
                            $('#div_receipt_print').html(data);
                    }
            });
	}", CClientScript::POS_HEAD);


 ?>