<?php
$date_to = date("Y-m-d");
if (!empty($arr_details)) {
  $income_total = 0;
  $total_rent = 0;
  $total_rent_paid = 0;
  $total_rent_pending = 0;
  $rent_connection = Yii::app()->db->createCommand()
    ->select("SUM(LR.amount) as amount,LR.status")
    ->from("{{lease_receipt}} LR")
    ->where('LR.flat_id="' . $arr_details->id . '"')
    ->andWhere('LR.payment_date<="' . $date_to . '"')
    ->group("LR.status");

  $arr_rent = $rent_connection->queryAll();
  //echo $rent_connection->text;
  foreach ($arr_rent as $each_rdetail) {
    if ($each_rdetail["status"] == 1) {
      $total_rent_paid += $each_rdetail["amount"];
    }
    if ($each_rdetail["status"] == 0) {
      $total_rent_pending += $each_rdetail["amount"];
    }
  }

  $total_rent = $total_rent_pending + $total_rent_paid;
  $income_total = $total_rent;

  $expense_total = 0;
  $total_buying_value = 0;
  $total_depreciation = 0;
  $total_interest = 0;
  $total_expense = 0;
  $ts2 = strtotime($date_to);
  $tr_expense = '';
  $total_buying_value = $arr_details->buying_value;
  $ts1 = strtotime($arr_details->buying_date);
  $year1 = date('Y', $ts1);
  $year2 = date('Y', $ts2);
  $month1 = date('m', $ts1);
  $month2 = date('m', $ts2);
  $diff = (($year2 - $year1) * 12) + ($month2 - $month1);
  if ($diff == 0) {
    $total_depreciation = 0;
  } else {
    if ($arr_details->depreciation_months != 0) {
      $total_depreciation = ($total_buying_value * $diff) / ($arr_details->depreciation_months);
    } else {
      $total_depreciation = 0;
    }
    if ($total_depreciation > $total_buying_value)
      $total_depreciation = $total_buying_value;
  }
  $expense_connection = Yii::app()->db->createCommand()
    ->select("SUM(E.expense_amount) as expense_amount,ET.expense_type")
    ->from("{{expense}} E")
    ->leftjoin("{{expense_type}} ET", "ET.id= E.expense_type")
    ->where('E.flat_id="' . $arr_details->id . '"')
    ->andWhere('E.expense_date<="' . $date_to . '"')
    ->group("E.expense_type");
  $arr_expenses = $expense_connection->queryAll();
  //echo $expense_connection->text;
  foreach ($arr_expenses as $each_edetail) {
    $total_expense += $each_edetail["expense_amount"];
    $tr_expense .= '<tr class="show-expn hidden">
                <td class="pad-1">' . $each_edetail["expense_type"] . '</td>
                <td class="text-right">' . $each_edetail["expense_amount"] . '</td>
              </tr>';
  }
  $onetime_connection = Yii::app()->db->createCommand()
    ->select("id,amount")
    ->from("{{onetime_payments}}")
    ->where('flat_id="' . $arr_details->id . '"')
    ->andWhere('paying_date<="' . $date_to . '"');
  $arr_onetime = $onetime_connection->queryAll();
  //echo $onetime_connection->text;
  $total_onetime_paid = 0;
  foreach ($arr_onetime as $each_odetail) {
    $total_onetime_paid += $each_odetail["amount"];
  }
  $total_interest = 0;
  $finance_model = Finance::model()->find(array('condition' => 'flat_id=' . $arr_details->id));

  $down_pay_date = isset($finance_model->payment_date) ? $finance_model->payment_date : '';
  if (!empty($date_to) && !empty($down_pay_date)) {
    $idiff = abs(strtotime($date_to) - strtotime($down_pay_date));
  } else {
    // Handle the case where one or both dates are null or empty
    $idiff = 0; // or any default value that makes sense
  }
  $imonths = floor($idiff / (30 * 60 * 60 * 24));
  $interest_amount = 0;
  if ($finance_model !== null && $finance_model->down_payment > 0 && $finance_model->interest_percen > 0) {
    $interest_amount = (($finance_model->down_payment * $finance_model->interest_percen * $imonths) / (100 * 12));
  } else {
    // Handle the case where $finance_model is null or the conditions are not met
    $interest_amount = 0; // or any default value
  }
  $arr_cheque_details = Payment::model()->with('building_details', 'landlord_details')->findAll(array('condition' => 't.flat_id=' . $arr_details->id . ' AND t.payment_type =2 AND t.status =1'));
  $total_linterest = 0;
  $lmonths = 0;
  if (!empty($arr_cheque_details)) {
    foreach ($arr_cheque_details as $each_detail) {
      $realisation_date = $each_detail->realisation_date;
      if ($realisation_date != "0000-00-00") {
        $ldiff = abs(strtotime($date_to) - strtotime($realisation_date));
        $lmonths = floor($ldiff / (30 * 60 * 60 * 24));
        $linterest_amount = 0;
        if ($each_detail->amount > 0 && $finance_model->loan_percen > 0) {
          $linterest_amount = (($each_detail->amount * $finance_model->loan_percen * $lmonths) / (100 * 12));
          $total_linterest += $linterest_amount;
        }
      }
    }

  } else {
    $total_linterest = 0;
  }
  $total_interest = $interest_amount + $total_linterest;
  $expense_total = $total_buying_value + $total_onetime_paid + $total_expense + $total_depreciation + $total_interest;
  ?>
  <table id="tbl_summary" class="table table-striped table-primary">
    <tr>
      <th>Building Name</th>
      <td colspan="2"><?php echo $arr_details->buildings->building_name; ?></td>
      <th>Flat No</th>
      <td colspan="2"><?php echo $arr_details->flat_no; ?>
    </tr>
    <tr>
      <th>Buying Date</th>
      <td colspan="2"><?php echo $arr_details->buying_date; ?></td>
      </td>
      <th>Buying Value</th>
      <td colspan="2"><?php echo $arr_details->buying_value; ?></td>
    </tr>
    <tr>
      <td colspan="6">Owner Details</td>
    </tr>
    <tr>
      <th colspan="2">Owners</th>
      <th>Percentage</th>
      <th>BuyingValue</th>
      <th>Income</th>
      <th>Expense</th>
    </tr>
    <?php
    $model_details = BuildingOwnerDetails::model()->findAll(array('condition' => 'flat=' . $arr_details->id));
    if (!empty($model_details)) {
      foreach ($model_details as $i => $model_detail) { ?>
        <tr>
          <td colspan="2"><?php echo Landlord::getLandlordName($model_detail->landlord); ?></td>
          <td class="text-right"><?php echo $model_detail->percentage . '%'; ?></td>
          <td class="text-right"><?php $percent_owner = $model_detail->percentage;
          $buy_percent = ($total_buying_value * $percent_owner) / 100;
          echo Yii::app()->numberFormatter->formatCurrency($buy_percent, "");
          ?></td>
          <td class="text-right"><?php
          $income_percent = ($income_total * $percent_owner) / 100;
          echo Yii::app()->numberFormatter->formatCurrency($income_percent, ""); ?></td>
          <td class="text-right"><?php
          $expense_percent = ($expense_total * $percent_owner) / 100;
          echo Yii::app()->numberFormatter->formatCurrency($expense_percent, ""); ?></td>
        </tr>

      <?php }
    } else {
      echo '<tr><td colspan="6" class="text-center"> No Details Found</td></tr>';
    }
    ?>
  </table>
  <div class="panel-body">
    <div class="clearfix"></div>
    <div class="col-sm-6 np">
      <input type="hidden" name="myHidden" id="myHidden" value="0">
      <table id="tbl_income_table" class="exp-table">
        <thead>
          <tr>
            <th class="col-xs-8">Income</th>
            <th class="col-xs-4 text-right">Amount</th>
          </tr>
        </thead>
        <tbody>

          <tr>
            <td>Rent </td>
            <td class="text-right"><?php echo Yii::app()->numberFormatter->formatCurrency($total_rent, ""); ?></td>
          </tr>

        </tbody>
      </table>
    </div>
    <div class="col-sm-6 np">
      <table id="tbl_expense_table" class="exp-table">
        <thead>
          <tr>
            <th class="col-xs-8">Expense</th>
            <th class="col-xs-4 text-right">Amount</th>
          </tr>
        </thead>
        <tbody>
          <tr>
            <td>Buying Value</td>
            <td class="text-right">
              <?php echo Yii::app()->numberFormatter->formatCurrency($arr_details->buying_value, ""); ?></td>
          </tr>
          <tr>
            <td>One Time Payments</td>
            <td class="text-right"><?php echo Yii::app()->numberFormatter->formatCurrency($total_onetime_paid, ""); ?></td>
          </tr>
          <tr>
            <td>Expenses <button class="btn-sm btn btn-success pull-right" type="button"
                onclick="$('.show-expn').toggleClass('hidden');$('#icon_id1').toggleClass('fa-minus');"><i id="icon_id1"
                  class="fa fa-plus"></i></button></td>
            <td class="text-right"><?php echo Yii::app()->numberFormatter->formatCurrency($total_expense, ""); ?>
            </td>
          </tr>
          <?php echo $tr_expense; ?>
          <tr>
            <td>Interest<button class="btn-sm btn btn-success pull-right" type="button"
                onclick="loadPopupModal('purchasedflat/CalculateInterest&flat_id=<?php echo $arr_details->id; ?>','Interest Calculation Details');"><i
                  class="fa fa-plus"></i></button></td>
            <td class="text-right"><?php echo Yii::app()->numberFormatter->formatCurrency($total_interest, ""); ?></td>
          </tr>
          <tr>
            <td>Depreciation<button class="btn-sm btn btn-success pull-right" type="button"
                onclick="loadPopupModal('purchasedflat/CalculateDepreciation&flat_id=<?php echo $arr_details->id; ?>','Depreciation Calculation Details');"><i
                  class="fa fa-plus"></i></button></td>
            <td class="text-right"><?php echo Yii::app()->numberFormatter->formatCurrency($total_depreciation, ""); ?></td>
          </tr>
        </tbody>
      </table>
    </div>
    <div class="col-sm-12 np">
      <table id="tbl_expense_table" class="exp-table">
        <thead>
          <tr>
            <th class="text-right col-sm-4">Total Income</th>
            <th class="text-right col-sm-2"><?php echo Yii::app()->numberFormatter->formatCurrency($income_total, ""); ?>
            </th>
            <th class="text-right col-sm-4">Total Expense</th>
            <th class="text-right col-sm-2"><?php echo Yii::app()->numberFormatter->formatCurrency($expense_total, ""); ?>
            </th>
          </tr>
        </thead>
      </table>
    </div>
  </div>
<?php } ?>