<!-- Start forms -->
<div class="page">  
    <div class="content">    
        <section class="panel">     
           <div class="panel-body">   
           <?php 
    // Get finance model for the flat
    $finance_model = Finance::model()->find(array('condition' => 'flat_id=' . (int)$flat_id));

    // Avoid null warnings by checking if model exists
    if ($finance_model !== null) {
        $down_pay_date = $finance_model->payment_date;
    } else {
        $down_pay_date = date("Y-m-d"); // fallback or handle differently
    }

    $today = date("Y-m-d");

    // strtotime null check fix
    if (!empty($down_pay_date)) {
        $diff = abs(strtotime($today) - strtotime($down_pay_date));
    } else {
        $diff = 0;
    }

    $months = floor($diff / (30 * 60 * 60 * 24));

    $interest_amount = 0;
    if ($finance_model !== null && $finance_model->down_payment > 0 && $finance_model->interest_percen > 0) {
        $interest_amount = (($finance_model->down_payment * $finance_model->interest_percen * $months) / (100 * 12));
    }

    // If you're passing $building from controller, use it — else get first related building
    if (isset($building)) {
        $building_model = Building::model()->findByPk($building);
    } else {
        // If no building id, you can optionally get building from flat if related
        $building_model = null;
    }

    $arr_cheque_details = Payment::model()->with('building_details', 'landlord_details')->findAll(array(
        'condition' => 't.flat_id=' . (int)$flat_id . ' AND t.payment_type=2 AND t.status=1'
    ));
?>
   
                <table class="table table-striped table-primary" id="tab_interest_details">
                    <thead>
                        <tr>                  
                            <th colspan="2"> Down Payment</th>
                            <th>Interest %</th>
                            <th>No.of.Months</th>
                            <th> InterestAmount</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                        <?php
                            // Ensure that $finance_model is not null before accessing its properties
                            if ($finance_model !== null) {
                                // Only output data if the model is valid
                                echo '<td colspan="2">' . Yii::app()->numberFormatter->formatCurrency($finance_model->down_payment, "") . '</td>';
                                echo '<td>' . $finance_model->interest_percen . '</td>';
                            } else {
                                // Handle the case where $finance_model is null
                                echo '<td colspan="2">No data available</td>';
                                echo '<td>No data available</td>';
                            }
                        ?>

                        <td><?php echo $months?></td>
                        <td class="text-right"> <?php echo Yii::app()->numberFormatter->formatCurrency($interest_amount,"")?></td>    
                        </tr>
                        <tr>
                            <th> Cheque No</th>
                            <th> Cheque Amount</th>
                            <th> RealisationDate</th>
                            <th> No.of.Months</th>
                            <th> InterestAmount</th>
                        </tr>
                        <?php 
                        $total_linterest        = 0;
                        $lmonths                 = 0;
                        if(!empty($arr_cheque_details)){
                            foreach ($arr_cheque_details as $each_detail){
                                $realisation_date       = $each_detail->realisation_date;
                                if($realisation_date !="0000-00-00"){
                                    $diff                   = abs(strtotime($today) - strtotime($realisation_date));
                                    $lmonths                 = floor($diff/ (30*60*60*24));
                                    $linterest_amount        = 0;
                                    if($each_detail->amount >0 && $finance_model->loan_percen>0){
                                        $linterest_amount    = (($each_detail->amount*$finance_model->loan_percen*$lmonths)/(100*12));
                                        $total_linterest    += $linterest_amount;
                                    }?>
                            <tr>
                                <td><?php echo $each_detail->cheque_no;?></td>
                                <td><?php echo Yii::app()->numberFormatter->formatCurrency($each_detail->amount,"");?></td>
                                <td><?php echo date("d/m/Y",strtotime($realisation_date));?></td>
                                <td><?php echo $lmonths;?></td>
                                <td class="text-right"> <?php echo Yii::app()->numberFormatter->formatCurrency($linterest_amount,"");?></td>
                            </tr>
                            <?php
                                }
                            } 
                            
                        }else{?>
                            <tr>
                               <td colspan="4"> No Details Found</td>
                            </tr>
                        <?php }
                        $total_interest=$interest_amount+$total_linterest;
                        ?>
                        <tr>
                            <th colspan="4"> Total</th>
                            <td class="text-right"> <?php echo Yii::app()->numberFormatter->formatCurrency($total_interest,"");?>
                            </td>
                        </tr>
                    </tbody>
                </table>
        
                   
            </div>
        </section>
    </div>

    </div>
<!-- End forms -->
    <?php $cs = Yii::app()->getClientScript(); 
    $cs->registerScript("depreciationprint", "function depreciationprint(){
            var url= '" . Yii::app()->createUrl('purchasedflat/PrintDepreciationPDF') . "';    
            var date_from=$('#date').val();
            var building=$('#building').val();
            window.open($('#liveSite').val()+'administrator.php?r=purchasedflat/PrintDepreciationPDF&date_from='+date_from+'&building='+building, '_blank');
    }", CClientScript::POS_HEAD);
    $cs->registerScript("excelDepreciation", "function excelDepreciation(){
                var url= '" . Yii::app()->createUrl('purchasedflat/DepreciationExcel') . "';
                var date_from=$('#date').val();
                var building=$('#building').val();
                window.open($('#liveSite').val()+'administrator.php?r=purchasedflat/DepreciationExcel&date_from='+date_from+'&building='+building, '_blank');
    }", CClientScript::POS_HEAD);