<!DOCTYPE html>
<html>
<head>
  <title>Payment Report PDF</title>
  <style type="text/css">
    
  </style>
</head>
<body>

  <?php $condition="1=1";
  if($date_from!='')
  {
    $date_from = str_replace('/', '-', $date_from);
    $date_from = date("Y-m-d", strtotime($date_from));
    $condition.=" AND payment_date>='$date_from'";
  }
  if($date_to!='')
  {
    $date_to = str_replace('/', '-', $date_to);
    $date_to = date("Y-m-d", strtotime($date_to));
    $condition.=" AND payment_date<='$date_to'";
  }
  if($rel_from!='')
  {
    $rel_from = str_replace('/', '-', $rel_from);
    $rel_from = date("Y-m-d", strtotime($rel_from));
    $condition.=" AND realisation_date>='$rel_from'";
  }
  if($rel_to!='')
  {
    $rel_to = str_replace('/', '-', $rel_to);
    $rel_to = date("Y-m-d", strtotime($rel_to));
    $condition.=" AND realisation_date<='$rel_to'";
  }
  if($cheque_from!='')
  {
    $cheque_from = str_replace('/', '-', $cheque_from);
    $cheque_from = date("Y-m-d", strtotime($cheque_from));
    $condition.=" AND cheque_date>='$cheque_from'";
  }
  if($cheque_to!='')
  {
    $cheque_to = str_replace('/', '-', $cheque_to);
    $cheque_to = date("Y-m-d", strtotime($cheque_to));
    $condition.=" AND cheque_date<='$cheque_to'";
  }
  if($building!='' && $building!="null")
  {
    $condition.=" AND building_id=$building";
  }
  if($payment!='' && $payment!="null")
  {
    $condition.=" AND payment_type=$payment";
  }
  if($landlord!='' && $landlord!="null")
  {
    $condition.=" AND landlord_id=$landlord";
  }
  $model = Payment::model()->findAll(array('condition'=>$condition));
  ?>


  <div class="report-container">
    <div class="heading">
      <div class="col-3" style="float:left;">
        <img src="images/logo.png" class="responsive">
      </div>
      <div class="col-8" style="float:left;">
        <div class="title"><h2>PAYMENT REPORT</h2></div>
      </div>
      <div class="clearfix"><br></div>
      <div class="col-6 left-label">
        <p>
          <?php if($building != '' && $building != "null"){
            echo '<label><b>Building</b></label>:' .Building::getBuildingName($building);
          } ?>
        </p>
        <p>
          <?php if($payment != '' && $payment != "null"){
            echo '<label><b>Payment</b></label>:';
            if($payment == "1"){
             echo 'Cash';
           }else{
             echo 'Cheque';
           } } ?>
         </p>
         <p>
           <?php if($landlord != '' && $landlord != "null"){
            echo '<label><b>Landlord</b></label>:' .Landlord::getLandlordName($landlord);
          } ?>
        </p>
      </div>
      <div class="col-4 col-offset-2 right-label">
        <p>
          <?php if($date_from != ''){
            echo '<label><b>Date From</b></label>:' .$date_from;
          } ?>
        </p>
        <p>
          <?php  if($date_to != ''){
            echo '<label><b>Date To</b></label>:' .$date_to;
          } ?>
        </p>
        <p>
          <?php if($rel_from != ''){
            echo '<label><b>Realisation From</b></label>:' .$rel_from;
          } ?>
        </p>
        <p>
          <?php if($rel_to != ''){
            echo '<label><b>Realisation To</b></label>:' .$rel_to;
          } ?>
        </p>
        <p>
          <?php if($cheque_from != ''){
            echo '<label><b>Cheque From</b></label>:' .$cheque_from;
          } ?>
        </p>
        <p>
          <?php if($cheque_to != ''){
            echo '<label><b>Cheque To</b></label>:' .$cheque_to;
          } ?>
        </p>
      </div>


    </div>
  </div>
  <div class="clearfix"><br></div>
  <table id="tbl_payment_table" class="table table-primary">
    <thead>
      <tr>
        <th>No</th>
        <th>Payment Date</th>
        <th>Cheque Date</th>
        <th>Realisation Date</th>
        <!-- <th>Flat</th>-->
        <!-- <th>Transaction Type</th>-->
        <th>Payment Type</th>
        <th>Status</th>
        <th class="text-right">Amount</th>
      </tr>
    </thead>
    <tbody>
      <?php
      foreach ($model as $i=>$row) {
        ?>
        <tr>
          <td><?php echo ($i+1);?></td>
            <?php if($row->payment_date != '0000-00-00') { ?>

          <td><?php echo date("d/m/Y",strtotime($row->payment_date));?></td>
            <?php } else { ?>
          <td> &nbsp; </td>
            <?php }?>
            <?php if($row->cheque_date != '0000-00-00') { ?>
          <td><?php echo date("d/m/Y",strtotime($row->cheque_date));?></td>
            <?php } else { ?>
          <td> &nbsp; </td>
            <?php }?>
            <?php if($row->realisation_date != '0000-00-00') { ?>
          <td><?php echo date("d/m/Y",strtotime($row->realisation_date));?></td>
            <?php } else { ?>
          <td> &nbsp; </td>
            <?php }?>
          <!-- <td><?php// echo $row->flat->flat_no;?></td>-->
          <!-- <td><?php // echo $row->transtype->trans_name;?></td>-->
          <td><?php echo Payment::getPaymentType($row->payment_type);?></td>
          <td><?php echo Payment::getPaymentStatus($row->status);?></td>
          <td class="text-right">
            <?php $total_amount+=$row->amount;
                  echo Yii::app()->numberFormatter->formatCurrency($row->amount,"");?>
          </td>
      </tr>
      <?php } ?>
    </tbody>
    <tfoot>
      <tr>
        <th colspan="6" class="text-right h4">Total</th>
        <th colspan="1" class="text-right h4"><?php echo Yii::app()->numberFormatter->formatCurrency($total_amount,"");?></th>
      </tr>
    </tfoot>
  </table>
</body>
</html>