<!-- Start forms -->
<div class="page">
  <div class="content">
    <section class="panel">
        <div class="top-box">
            <div class="col-xs-3">
              <h3 class="mrgn-1"><i class="fa fa-file-text"></i> Owner Summary</h3>
            </div>
            
            <div class="col-xs-3 text-right">
                <h4 class="mrgn-1">Landlord :<?php echo Landlord::getLandlordName($landlord); ?> </h4>
            </div>
          </div>
        <div class="panel-body">
      <div class="clearfix">
        <table id="tbl_owner_details" class="table table-striped table-primary dataTable">
        <thead>
            <tr>
              <th class="text-center">No</th>
              <th class="text-center">Building</th>
              <th class="text-center">Buying Date</th>
              <th class="text-center">Total SqFt</th>
              <th class="text-center">Buying Value</th>
              <th class="text-center">Income Share</th>
              <th class="text-center">Expense Share</th>
            </tr>
        </thead>
        <tbody>
            <?php 
                $total_feet =0;
                foreach ($building_model as $i=>$row) {
                    $each_percent = $row->percentage;
                    $date_to            = date("Y-m-d");
                    $income_total       = 0;
                    $total_rent_paid    = 0;
                    $total_rent_pending = 0;
                    $rent_connection = Yii::app()->db->createCommand()
                      ->select("SUM(LR.amount) as amount,LR.status")
                      ->from("{{lease_receipt}} LR")
                      ->where('LR.building_id="'. $row->building.'"')
                      ->andWhere('LR.payment_date<="'.$date_to.'"')
                      ->group("LR.status");
                
                    $arr_rent   = $rent_connection->queryAll();
                    //echo $rent_connection->text;
                    foreach($arr_rent as $each_rdetail){
                        if($each_rdetail["status"]==1){
                            $total_rent_paid +=$each_rdetail["amount"];
                        }
                        if($each_rdetail["status"]==0){
                            $total_rent_pending +=$each_rdetail["amount"];
                        }
                    }
                    $income_total     = $total_rent_pending+$total_rent_paid;
                    $expense_total   =0;
                    $total_onetime_paid =0;
                    $total_expense=0;
                    $onetime_connection = Yii::app()->db->createCommand()
                        ->select("id,amount")
                        ->from("{{onetime_payments}}")
                        ->where('building_id="'.$row->building.'"')
                        ->andWhere('paying_date<="'.$date_to.'"');
                    $arr_onetime   = $onetime_connection->queryAll();
                      //echo $onetime_connection->text;
                    foreach($arr_onetime as $each_odetail){
                        $total_onetime_paid +=$each_odetail["amount"];
                    }
                    
                    $expense_connection = Yii::app()->db->createCommand()
                        ->select("SUM(E.expense_amount) as expense_amount,ET.expense_type")
                        ->from("{{expense}} E")
                        ->leftjoin("{{expense_type}} ET" , "ET.id= E.expense_type")
                        ->where('E.building_id="'.$row->building.'"')
                        ->andWhere('E.expense_date<="'.$date_to.'"')
                        ->group("E.expense_type");
                    $arr_expenses   = $expense_connection->queryAll();
                    //echo $expense_connection->text;
                    foreach($arr_expenses as $each_edetail){
                        $total_expense +=$each_edetail["expense_amount"];
                    }
                    
                    $ts2                    = strtotime($date_to);
                    $total_buying_value     = $row->buiding_details->buying_value;
                    $ts1                    = strtotime($row->buiding_details->buying_date);
                    $year1          = date('Y', $ts1);
                    $year2          = date('Y', $ts2);
                    $month1         = date('m', $ts1);
                    $month2         = date('m', $ts2);
                    $diff           = (($year2 - $year1) * 12) + ($month2 - $month1);
                    if($diff ==0){
                        $total_depreciation = 0;
                    }else{
                        if($row->buiding_details->depreciation_months != 0){
                            $total_depreciation = ($total_buying_value * $diff)/($row->buiding_details->depreciation_months);
                        }
                        else {
                            $total_depreciation =0;
                        }
                        if($total_depreciation>$total_buying_value)
                            $total_depreciation=$total_buying_value;
                    }
                    
                    $total_interest         = 0;
                    $finance_model          = Finance::model()->find(array('condition'=>'building_id='.$row->building));

                    $down_pay_date          = $finance_model->payment_date;
                    $idiff                  = abs(strtotime($date_to) - strtotime($down_pay_date));
                    $imonths                 = floor($idiff/ (30*60*60*24));
                    $interest_amount        = 0;
                    if($finance_model->down_payment >0 && $finance_model->interest_percen>0){
                        $interest_amount    = (($finance_model->down_payment*$finance_model->interest_percen*$imonths)/(100*12));
                    }
                    $building_model         = Building::model()->findByPK($row->building);
                    $arr_cheque_details     = Payment::model()->with('building_details','landlord_details')->findAll(array('condition'=>'t.building_id='.$row->building.' AND t.payment_type =2 AND t.status =1' ));
                    $total_linterest        = 0;
                    $lmonths                = 0;
                    if(!empty($arr_cheque_details)){
                        foreach ($arr_cheque_details as $each_detail){
                            $realisation_date       = $each_detail->realisation_date;
                            if($realisation_date !="0000-00-00"){
                                $ldiff                    = abs(strtotime($date_to) - strtotime($realisation_date));
                                $lmonths                 = floor($ldiff/ (30*60*60*24));
                                $linterest_amount        = 0;
                                if($each_detail->amount >0 && $finance_model->loan_percen>0){
                                    $linterest_amount    = (($each_detail->amount*$finance_model->loan_percen*$lmonths)/(100*12));
                                    $total_linterest    += $linterest_amount;
                                }
                            }
                        }

                    }else{
                        $total_linterest                = 0;
                    }
                    $total_interest=$interest_amount+$total_linterest;
                            
                    
                    $expense_total   = $row->buiding_details->buying_value+$total_onetime_paid+$total_expense+$total_depreciation+$total_interest;      
                      ?>
                  <tr>      	 
                  <td><?php echo ($i+1);?></td>
                  <td><?php echo $row->buiding_details->building_name.'( '.$each_percent.'% )';?></td>
                  <td><?php if($row->buiding_details->buying_date != '0000-00-00') {  
                                echo date("d/m/Y",strtotime($row->buiding_details->buying_date));
                            } 
                            else {  
                                echo "";?> 
                        <?php } ?>
                  </td>
                  <td class="text-right"><?php echo $row->buiding_details->cmn_area_sqft+$row->buiding_details->squarefeet; ?>
                  <?php $total_feet +=$row->buiding_details->cmn_area_sqft+$row->buiding_details->squarefeet; ?></td>
                  <td class="text-right"><?php 
                        $buy_percent=($row->buiding_details->buying_value*$each_percent)/100;
                        echo Yii::app()->numberFormatter->formatCurrency($buy_percent,"");?></td>
                  <td class="text-right"><?php 
                        $income_percent=($income_total*$each_percent)/100;
                        echo Yii::app()->numberFormatter->formatCurrency($income_percent,"");?></td>
                  <td class="text-right"><?php
                        $expense_percent=($expense_total*$each_percent)/100;
                        echo Yii::app()->numberFormatter->formatCurrency($expense_percent,"");?>
                  </td>
            </tr>
                      <?php 	
                      }
                      ?>
        </tbody>
         <tfoot>
            <tr>
                <th colspan="3" class="text-right">Total</th>
              <th colspan="1" class="text-right"></th>
               <th colspan="1" class="text-right"></th>
                <th colspan="1" class="text-right"></th>
                <th colspan="1" class="text-right"></th>
            </tr>
        </tfoot>
        </table>
      </div>
        </div>
    </section> 
</div>
</div>
<!-- End forms -->
<script>
$(document).ready(function() {
    $('#tbl_owner_details').DataTable().destroy();
        var table =$('#tbl_owner_details').DataTable();
        table.destroy();
        table = $('#tbl_owner_details').DataTable({
           
        footerCallback: function ( row, data, start, end, display ) {
                var api = this.api(), data;
                // Remove the formatting to get integer data for summation
                var intVal = function ( i ) {
                    return typeof i === 'string' ?
                    i.replace(/[\$,]/g, '')*1 :
                    typeof i === 'number' ? i : 0;
                };
                
                // Total over all pages for 5th row
//                       total_revenue = api
//                            .column( 5, {search:'applied'} )
//                            .data()
//                            .reduce( function (a, b) {
//                                return intVal(a) + intVal(b);
//                            },0 );
                // Total over this page                  
                    pageTotal = api.column( 3, {search:'applied'} )
                            .data()
                            .reduce( function (a, b) {
                            return intVal(a) + intVal(b);
                            }, 0 );
                    
                    
                    $( api.column( 3 ).footer() ).html(
                        Number(parseFloat(pageTotal).toFixed(2)).toLocaleString('en',{minimumFractionDigits: 2})
                    );
                    pageTotal = api.column( 4, {search:'applied'} )
                            .data()
                            .reduce( function (a, b) {
                            return intVal(a) + intVal(b);
                            }, 0 );
                    
                    
                    $( api.column( 4 ).footer() ).html(
                        Number(parseFloat(pageTotal).toFixed(2)).toLocaleString('en',{minimumFractionDigits: 2})
                    );
                    pageTotal = api.column( 5, {search:'applied'} )
                            .data()
                            .reduce( function (a, b) {
                            return intVal(a) + intVal(b);
                            }, 0 );
                    
                    
                    $( api.column( 5 ).footer() ).html(
                        Number(parseFloat(pageTotal).toFixed(2)).toLocaleString('en',{minimumFractionDigits: 2})
                    );
                    pageTotal = api.column( 6, {search:'applied'} )
                            .data()
                            .reduce( function (a, b) {
                            return intVal(a) + intVal(b);
                            }, 0 );
                    
                    
                    $( api.column( 6 ).footer() ).html(
                        Number(parseFloat(pageTotal).toFixed(2)).toLocaleString('en',{minimumFractionDigits: 2})
                    );
                    
          }      
        });
$('#tbl_owner_details tfoot tr').css('display','table-row');
$('#tbl_owner_details tfoot td').css('display','table-cell');
$('#tbl_owner_details tfoot th').css('display','table-cell');
});
</script>

