<div class="page">
    <div class="content">
        <div class="panel">
            <div class="top-box">
                <h3><i class="fa fa-money"></i> Mortgage Payments</h3>
                 <div class="pull-right">
                    <div class="nav-controls">
                        <?php echo CHtml::textField('date_from', '',array('placeholder'=>'Date From','class' =>'form-control date-picker')); ?>
                        <?php echo CHtml::textField('date_to', '',array('placeholder'=>'Date To','class' =>'form-control date-picker')); ?>
                        <?php echo CHtml::dropDownList( 'building_id', '',Building::getAllBuilding(),array('placeholder'=>'Select Building','onChange'=>'getBuildingFilter()','class' =>'form-control','prompt'=>'-Select Building-')); ?>
                        <?php //CompanyBank::getCompanyBank()
                       echo CHtml::dropDownList( 'banks_id', '',MasterBank::getBank(),array('placeholder'=>'Select Bank','onChange'=>'getBuildingFilter()','class' =>'form-control','prompt'=>'-Select Bank-')); ?>
                       <?php echo CHtml::dropDownList( 'landlord_id', '',Landlord::getAllLandlord(),array('placeholder'=>'Select Owner','onChange'=>'getBuildingFilter()','class' =>'form-control','prompt'=>'-Select Owner-')); ?>
                    </div>
                    <?php if(Yii::app()->user->authorised_user == 1 || Yii::app()->user->havePermissionOn['mortgage_payment_add']){ ?>
                    <div class="btn-on-nav">
                      <a onclick="clearcheques();" id="clearcheque" title="Clear Cheques" class="btn btn-sm btn-white"><i class="fa fa-thumbs-o-up"></i></a>
                    </div>
                    <?php } ?>
                 </div>
            </div>
            <ul class="nav nav-tabs">
                <li class="active"><a data-toggle="tab" href="#div_inprocess_payment" ripple="ripple" ripple-color="#FFF">Not Cleared</a></li>
                <li><a data-toggle="tab" href="#div_completed_payment" ripple="ripple" ripple-color="#FFF">Cleared</a></li>
                <li><a data-toggle="tab" href="#div_bounced_payment" ripple="ripple" ripple-color="#FFF" id="materials">Bounced</a></li>
                <li><a data-toggle="tab" href="#div_cancelled_payment" ripple="ripple" ripple-color="#FFF" id="materials">Cancelled</a></li>
                <div class="pull-right">
                    <?php if(Yii::app()->user->authorised_user == 1 || Yii::app()->user->havePermissionOn['mortgage_payment_add']){ ?>
                    <a class="btn-add" ripple="ripple" ripple-color="#FFFFFF" data-toggle="modal" onclick="loadPopupModal('payment/create','Add Payment','sm');" id="addModalButton" title="Add">+</a>
                    <?php } ?>
                </div>
            </ul>
            <div class="tab-content">
                <div id="div_inprocess_payment" class="tab-pane fade in active">
                    <?php $this->renderPartial('inprocess');?>
                </div>
                <div id="div_completed_payment" class="tab-pane fade">
                    <?php $this->renderPartial('completed');?>
                </div>
                <div id="div_bounced_payment" class="tab-pane fade">
                    <?php $this->renderPartial('bounced');?>
                </div>
                <div id="div_cancelled_payment" class="tab-pane fade">
                    <?php $this->renderPartial('cancelled');?>
                </div>
            </div>
        </div>
    </div>
</div>
<?php
$cs = Yii::app()->getClientScript();
$baseUrl = Yii::app()->baseUrl;
$cs->registerScript("getBuildingFilter",  "function getBuildingFilter(){
    getInProcessPayments();
    getBouncedPayments();
    getCancelledPayments();
    getCompletedPayments();
};", CClientScript::POS_HEAD);
$cs->registerScript("change_from_date", "$(document).ready(function(){
    $('#date_from').datepicker({
       onSelect: function(dateText, inst) {
           var date_from=$('#date_from').val();
           var date_from=date_from.split('/').reverse().join('-');
           getInProcessPayments();
           getBouncedPayments();
           getCancelledPayments();
           getCompletedPayments();
       }
});
  })", CClientScript::POS_HEAD);
$cs->registerScript("change_to_date", "$(document).ready(function(){
    $('#date_to').datepicker({
       onSelect: function(dateText, inst) {
           var date_to=$('#date_to').val();
           var date_to=date_to.split('/').reverse().join('-');
           getInProcessPayments();
           getBouncedPayments();
           getCancelledPayments();
           getCompletedPayments();
       }
    });
})", CClientScript::POS_HEAD);
$cs->registerScript("getInProcessPayments", "
  function getInProcessPayments(){
            var building_id=$('#building_id').val();
            var bank_id=$('#banks_id').val();
            var landlord_id=$('#landlord_id').val();
            var date_to=$('#date_to').val();
            var date_to=date_to.split('/').reverse().join('-');
            var date_from=$('#date_from').val();
            var date_from=date_from.split('/').reverse().join('-');
            jQuery.ajax({
                    'type': 'post',
                    'data':{'date_to':date_to,'date_from':date_from,'building_id':building_id,'bank_id':bank_id,'landlord_id':landlord_id},
                    'url': '" . Yii::app()->createUrl('payment/getInProcessPayments') . "',
                    'cache': false,
                    'success': function(data)
                    {
                            $('#div_inprocess_payment').html(data);
                    }
            });
  }", CClientScript::POS_HEAD);
$cs->registerScript("getBouncedPayments", "
  function getBouncedPayments(){
            var building_id=$('#building_id').val();
            var bank_id=$('#banks_id').val();
            var landlord_id=$('#landlord_id').val();
            var date_to=$('#date_to').val();
            var date_to=date_to.split('/').reverse().join('-');
            var date_from=$('#date_from').val();
            var date_from=date_from.split('/').reverse().join('-');
            jQuery.ajax({
                    'type': 'post',
                    'data':{'date_to':date_to,'date_from':date_from,'building_id':building_id,'bank_id':bank_id,'landlord_id':landlord_id},
                    'url': '" . Yii::app()->createUrl('payment/getBouncedPayments') . "',
                    'cache': false,
                    'success': function(data)
                    {
                            $('#div_bounced_payment').html(data);
                    }
            });
  }", CClientScript::POS_HEAD);
$cs->registerScript("getCancelledPayments", "
  function getCancelledPayments(){
            var building_id=$('#building_id').val();
            var bank_id=$('#banks_id').val();
            var landlord_id=$('#landlord_id').val();
            var date_to=$('#date_to').val();
            var date_to=date_to.split('/').reverse().join('-');
            var date_from=$('#date_from').val();
            var date_from=date_from.split('/').reverse().join('-');
            jQuery.ajax({
                    'type': 'post',
                    'data':{'date_to':date_to,'date_from':date_from,'building_id':building_id,'bank_id':bank_id,'landlord_id':landlord_id},
                    'url': '" . Yii::app()->createUrl('payment/getCancelledPayments') . "',
                    'cache': false,
                    'success': function(data)
                    {
                            $('#div_cancelled_payment').html(data);
                    }
            });
  }", CClientScript::POS_HEAD);
$cs->registerScript("getCompletedPayments", "
  function getCompletedPayments(){
            var building_id=$('#building_id').val();
            var bank_id=$('#banks_id').val();
            var landlord_id=$('#landlord_id').val();
            var  date_to=$('#date_to').val();
            var date_to=date_to.split('/').reverse().join('-');
            var date_from=$('#date_from').val();
            var date_from=date_from.split('/').reverse().join('-');
            jQuery.ajax({
                    'type': 'post',
                    'data':{'date_to':date_to,'date_from':date_from,'building_id':building_id,'bank_id':bank_id,'landlord_id':landlord_id},
                    'url': '" . Yii::app()->createUrl('payment/getCompletedPayments') . "',
                    'cache': false,
                    'success': function(data)
                    {
                            $('#div_completed_payment').html(data);
                    }
            });
  }", CClientScript::POS_HEAD);

 ?>
