<?php
$tr_expense = ""; // Fix: define variable before usage
?>

<!-- Start forms -->
<div class="top-box">
  <div class="col-xs-3">
    <h3 class="mrgn-1"><i class="fa fa-file-text"></i> Flat Summary</h3>
  </div>
</div>

<div class="panel-body">
  <div class="clearfix"></div>

  <!-- Hidden filters -->
  <input type="hidden" name="date_from" id="date_from" value="<?php echo $date_from; ?>">
  <input type="hidden" name="date_to" id="date_to" value="<?php echo $date_to; ?>">
  <input type="hidden" name="building" id="building" value="<?php echo $building; ?>">
  <input type="hidden" name="flat" id="flat" value="<?php echo $flat; ?>">

  <!-- Flat Info Table -->
  <table id="tbl_flatdetail_table" class="table table-striped table-primary">
    <tbody>
      <tr>
        <th>Flat Name</th>
        <td><?php echo $flat_model->flat_no; ?></td>
        <th>Block</th>
        <td><?php echo $flat_model->block; ?></td>
        <th>Floor</th>
        <td><?php echo $flat_model->floor; ?></td>
        <th>Flat Type</th>
        <td><?php echo Flat::getFlatType($flat_model->floor); ?></td>
      </tr>
      <tr>
        <th>Landlord</th>
        <td>
          <?php 
            echo ($flat > 0) ? BuildingOwnerDetails::getFlatLandlordName($flat) : BuildingOwnerDetails::getBuildingLandlordName($building);
          ?>
        </td>
        <th>Tenant</th>
        <td><?php echo ($flat_model->status == '2' && $flat_model->tenant_id > 0) ? $flat_model->tenant->name : ''; ?></td>
        <th>Amount</th>
        <td><?php echo $flat_model->amount; ?></td>
        <th>Status</th>
        <td><?php echo Flat::getFlatStatus($flat_model->status); ?></td>
      </tr>
      <?php if (!empty($date_from) && $date_from != "null"): ?>
      <tr>
        <th colspan="2">From Date</th>
        <td colspan="2"><?php echo $date_from; ?></td>
      <?php endif; ?>
      <?php if (!empty($date_to) && $date_to != "null"): ?>
        <th colspan="2">To Date</th>
        <td colspan="2"><?php echo $date_to; ?></td>
      </tr>
      <?php endif; ?>
    </tbody>
  </table>

  <!-- Income and Expense -->
  <div class="clearfix"></div>

  <!-- INCOME TABLE -->
  <div class="col-sm-6 np">
    <?php
    $sq_feet_rate = $flat_model->building->squarefeet_rate;
    $flat_sq_ft = $flat_model->squarefeet;
    $flat_value = $flat_model->buying_value;
    $income_total = $total_rent = $total_rent_paid = $total_rent_pending = 0;

    $date_to = empty($date_to) || $date_to == "null" ? date("Y-m-d") : date("Y-m-d", strtotime(str_replace('/', '-', $date_to)));

    if (empty($date_from) || $date_from == "null") {
        $rent_connection = Yii::app()->db->createCommand()
            ->select("SUM(LR.amount) as amount,LR.status")
            ->from("{{lease_receipt}} LR")
            ->where('LR.building_id=:b AND LR.flat_id=:f AND LR.payment_date<=:to', [
                ':b' => $building, ':f' => $flat, ':to' => $date_to
            ])
            ->group("LR.status");
    } else {
        $date_from = date("Y-m-d", strtotime(str_replace('/', '-', $date_from)));
        $rent_connection = Yii::app()->db->createCommand()
            ->select("SUM(LR.amount) as amount,LR.status")
            ->from("{{lease_receipt}} LR")
            ->where('LR.building_id=:b AND LR.flat_id=:f AND LR.payment_date BETWEEN :from AND :to', [
                ':b' => $building, ':f' => $flat, ':from' => $date_from, ':to' => $date_to
            ])
            ->group("LR.status");
    }

    $arr_rent = $rent_connection->queryAll();

    foreach ($arr_rent as $each_rdetail) {
        if ($each_rdetail["status"] == 1) $total_rent_paid += $each_rdetail["amount"];
        if ($each_rdetail["status"] == 0) $total_rent_pending += $each_rdetail["amount"];
    }

    $total_rent = $total_rent_paid + $total_rent_pending;
    $income_total = $total_rent;
    ?>

    <table id="tbl_income_table" class="exp-table">
      <thead>
        <tr>
          <th class="col-xs-8">Income</th>
          <th class="col-xs-4 text-right">Amount</th>
        </tr>
      </thead>
      <tbody>
        <tr>
          <td>Rent
            <button class="btn-sm btn btn-success pull-right" type="button" onclick="loadPopupModal('lease/CalculateFlatRents&flat_id=<?php echo $flat_model->id; ?>','Rent Details');"><i class="fa fa-plus"></i></button>
          </td>
          <td class="text-right"><?php echo Yii::app()->numberFormatter->formatCurrency($total_rent, ""); ?></td>
        </tr>
        <tr class="show-expn">
          <td class="pad-1">Uncleared Cheques</td>
          <td class="text-right"><?php echo Yii::app()->numberFormatter->formatCurrency($total_rent_pending, ""); ?></td>
        </tr>
        <tr class="show-expn">
          <td class="pad-1">Cleared Cheques</td>
          <td class="text-right"><?php echo Yii::app()->numberFormatter->formatCurrency($total_rent_paid, ""); ?></td>
        </tr>
      </tbody>
    </table>
  </div>

  <!-- EXPENSE TABLE -->
  <div class="col-sm-6 np">
    <?php
    $expense_total = $total_depreciation = $total_interest = $total_expense = $total_onetime_paid = 0;
    $ts2 = strtotime($date_to);
    $ts1 = strtotime($flat_model->buying_date);
    $diff = ((date('Y', $ts2) - date('Y', $ts1)) * 12) + (date('m', $ts2) - date('m', $ts1));
    $diff1 = 0;

    if (!empty($date_from) && $date_from != "null") {
        $ts3 = strtotime($date_from);
        $diff1 = ((date('Y', $ts2) - date('Y', $ts3)) * 12) + (date('m', $ts2) - date('m', $ts3));
        $total_depreciation = $flat_model->depreciation_months > 0 && $diff1 > 0 ? ($flat_value * $diff1) / $flat_model->depreciation_months : 0;
    } else {
        $total_depreciation = $flat_model->depreciation_months > 0 && $diff > 0 ? ($flat_value * $diff) / $flat_model->depreciation_months : 0;
    }

    $expense_query = Yii::app()->db->createCommand()
        ->select("SUM(E.expense_amount) as expense_amount,ET.expense_type")
        ->from("{{expense}} E")
        ->leftjoin("{{expense_type}} ET", "ET.id = E.expense_type")
        ->where('E.building_id=:b AND flat_id=:f', [':b' => $building, ':f' => $flat]);

    if (!empty($date_from) && $date_from != "null") {
        $expense_query->andWhere('E.expense_date BETWEEN :from AND :to', [':from' => $date_from, ':to' => $date_to]);
    } else {
        $expense_query->andWhere('E.expense_date <= :to', [':to' => $date_to]);
    }

    $arr_expenses = $expense_query->group("E.expense_type")->queryAll();

    foreach ($arr_expenses as $each_edetail) {
        $total_expense += $each_edetail["expense_amount"];
        $tr_expense .= '<tr class="show-expn hidden">
                          <td class="pad-1">' . $each_edetail["expense_type"] . '</td>
                          <td class="text-right">' . $each_edetail["expense_amount"] . '</td>
                        </tr>';
    }

    $finance_model = Finance::model()->find("flat_id=:f", [':f' => $flat_model->id]);
    $interest_amount = 0;

    if ($finance_model) {
        $down_pay_date = $finance_model->payment_date ?? null;
        if ($down_pay_date) {
            $imonths = floor(abs(strtotime($date_to) - strtotime($down_pay_date)) / (30 * 60 * 60 * 24));
            if ($finance_model->down_payment > 0 && $finance_model->interest_percen > 0) {
                $interest_amount = (($finance_model->down_payment * $finance_model->interest_percen * $imonths) / (100 * 12));
            }
        }

        $arr_cheque_details = Payment::model()->findAll("flat_id=:f AND payment_type=2 AND status=1", [':f' => $flat_model->id]);
        foreach ($arr_cheque_details as $each_detail) {
            $realisation_date = $each_detail->realisation_date;
            if ($realisation_date && $realisation_date != "0000-00-00") {
                $lmonths = floor(abs(strtotime($date_to) - strtotime($realisation_date)) / (30 * 60 * 60 * 24));
                if ($each_detail->amount > 0 && $finance_model->loan_percen > 0) {
                    $total_linterest += (($each_detail->amount * $finance_model->loan_percen * $lmonths) / (100 * 12));
                }
            }
        }
    }

    $total_interest = $interest_amount + ($total_linterest ?? 0);

    $onetime_query = Yii::app()->db->createCommand()
        ->select("amount")
        ->from("{{onetime_payments}}")
        ->where('flat_id=:f', [':f' => $flat_model->id]);

    if (!empty($date_from) && $date_from != "null") {
        $onetime_query->andWhere('paying_date BETWEEN :from AND :to', [':from' => $date_from, ':to' => $date_to]);
    } else {
        $onetime_query->andWhere('paying_date <= :to', [':to' => $date_to]);
    }

    $arr_onetime = $onetime_query->queryAll();

    foreach ($arr_onetime as $each_odetail) {
        $total_onetime_paid += $each_odetail["amount"];
    }

    $expense_total = $total_expense + $total_depreciation + $total_onetime_paid + $total_interest;
    ?>

    <table id="tbl_expense_table" class="exp-table">
      <thead>
        <tr>
          <th class="col-xs-8">Expense</th>
          <th class="col-xs-4 text-right">Amount</th>
        </tr>
      </thead>
      <tbody>
        <tr>
          <td>One Time Payments</td>
          <td class="text-right"><?php echo Yii::app()->numberFormatter->formatCurrency($total_onetime_paid, ""); ?></td>
        </tr>
        <tr>
          <td>Expenses <button class="btn-sm btn btn-success pull-right" type="button" onclick="$('.show-expn').toggleClass('hidden');$('#icon_id1').toggleClass('fa-minus');"><i id="icon_id1" class="fa fa-plus"></i></button></td>
          <td class="text-right"><?php echo Yii::app()->numberFormatter->formatCurrency($total_expense, ""); ?></td>
        </tr>
        <?php echo $tr_expense; ?>
        <tr>
          <td>Interest <button class="btn-sm btn btn-success pull-right" type="button" onclick="loadPopupModal('purchasedflat/CalculateInterest&flat_id=<?php echo $flat_model->id; ?>','Interest Calculation Details');"><i class="fa fa-plus"></i></button></td>
          <td class="text-right"><?php echo Yii::app()->numberFormatter->formatCurrency($total_interest, ""); ?></td>
        </tr>
        <tr>
          <td>Depreciation <button class="btn-sm btn btn-success pull-right" type="button" onclick="loadPopupModal('lease/CalculateDepreciation&flat_id=<?php echo $flat_model->id; ?>','Depreciation Calculation Details');"><i class="fa fa-plus"></i></button></td>
          <td class="text-right"><?php echo Yii::app()->numberFormatter->formatCurrency($total_depreciation, ""); ?></td>
        </tr>
      </tbody>
    </table>
  </div>

  <!-- TOTAL SUMMARY -->
  <div class="col-sm-12 np">
    <table class="exp-table">
      <thead>
        <tr>
          <th class="text-right col-sm-4">Total Income</th>
          <th class="text-right col-sm-2"><?php echo Yii::app()->numberFormatter->formatCurrency($income_total, ""); ?></th>
          <th class="text-right col-sm-4">Total Expense</th>
          <th class="text-right col-sm-2"><?php echo Yii::app()->numberFormatter->formatCurrency($expense_total, ""); ?></th>
        </tr>
        <tr>
          <th colspan="2" class="text-right col-sm-8">Net Income</th>
          <th colspan="2" class="text-right col-sm-4">
            <?php echo Yii::app()->numberFormatter->formatCurrency($income_total - $expense_total, ""); ?>
          </th>
        </tr>
      </thead>
    </table>
  </div>
</div>
