<?php
$model  = Lease::model()->with('flat','tenant')->findByPk($lease_id);
    	 
$SQL    ="SELECT SUM(R.amount) AS total_amount,(SELECT SUM(amount) FROM re_lease_receipt WHERE flat_id='$flat_id' AND status=1 ) AS total_received_amount,(SELECT SUM(amount) FROM re_lease_receipt WHERE flat_id='$flat_id' AND status=2 ) AS total_bounced_amount,(SELECT SUM(amount) FROM re_lease_receipt WHERE flat_id='.$flat_id.'AND status=3 ) AS total_cancelled_amount 
          FROM  re_lease_receipt R 
          WHERE R.flat_id='$flat_id' 
          GROUP BY R.flat_id";
    	 
$arr_payment_amount = Yii::app()->db->createCommand($SQL)->queryAll();
?>
<html>
<head>
  <title>Payment Summary Print</title>
</head>
<body>
    <div class="report-container">
    <div class="heading">
      <div class="col-3" style="float:left;">
        <img src="images/logo.png" class="responsive">
      </div>
      <div class="col-8" style="float:left;">
        <div class="title"><h2>Payment Summary</h2></div>
      </div>
      <div class="clearfix"><br></div>
      <div class="col-6 left-label">
          <?php $pending_amount = ($arr_payment_amount[0]['total_amount'] - ($arr_payment_amount[0]['total_received_amount']));?>
                                
                                <p><b>Total Amount :</b> <?php echo Yii::app()->numberFormatter->formatCurrency($arr_payment_amount[0]['total_amount'],""); ?></p>
                                <p><b>Received Amount :</b> <?php echo Yii::app()->numberFormatter->formatCurrency($arr_payment_amount[0]['total_received_amount'],""); ?></p>
                                <p><b>Bounced Amount :</b> <?php echo Yii::app()->numberFormatter->formatCurrency($arr_payment_amount[0]['total_bounced_amount'],""); ?></p>
                                <p><b>Cancelled Amount :</b> <?php echo Yii::app()->numberFormatter->formatCurrency($arr_payment_amount[0]['total_cancelled_amount'],"") ?></p>
                                <p><b>Pending Amount :</b> <?php echo Yii::app()->numberFormatter->formatCurrency($pending_amount,""); ?></p>
      </div>
      <div class="col-4 col-offset-2 right-label">
          <?php if($flat_id != '' && $flat_id != "null"){
          echo '<p><label><b>Flat No : </b>' .$model->flat->flat_no.'</label> </p>';
          echo '<p><label><b>Tenant Name : </b>' .$model->tenant->name.'</label></p>';
          echo '<p><label><b>From : </b>' .date('d/m/Y',strtotime($model->from_date)).'</label></p>';
          echo '<p><label><b>To : </b>' .date('d/m/Y',strtotime($model->to_date)).'</label></p>';
         } ?>
      </div>


    </div>
  </div>
    <div class="clearfix"><br></div>
    <h3>In Process Payments</h3>
    <table id="tbl_magazine_table" class="table table-fixed table-primary dataTable">
                      <thead>
                        <tr>
                          <th>No</th>
                          <th>Date</th>
                          <th>Flat</th>
                          <th>Transaction Type</th>
                          <th>Receipt Type</th>
                          <th>Amount</th>
                          <th>Status</th>
                        </tr>
                      </thead>
                      <tbody>
                      <?php
                      
                      $arr_inprocess_payment = Receipt::model()->with('flat','transtype')->findAll(array('condition'=>'t.status=0 AND t.flat_id='.$flat_id));
                      if(!empty($arr_inprocess_payment)){
                        foreach ($arr_inprocess_payment as $i=>$row) {
                      ?>
                      	 <tr>
                          <td><?php echo ($i+1);?></td>
                          <?php if($row->payment_date != '0000-00-00') { ?>
	                  <td class="text-center"><?php echo date("d/m/Y",strtotime($row->payment_date));?></td>
                          <?php } else { ?>
                          <td> &nbsp; </td>
                          <?php } ?>
                          <td><?php echo $row->flat->flat_no;?></td>
                          <td><?php echo $row->transtype->trans_name;?></td>
                          <td><?php echo Receipt::getPaymentType($row->payment_type);?></td>
                          <td class="text-right"><?php echo Yii::app()->numberFormatter->formatCurrency($row->amount,"");?></td>
                          <td><?php echo Receipt::getPaymentStatus($row->status);?></td>
                          
                        </tr>
                      	<?php 
                        }
                      }else{ ?>
                        <tr><td colspan="7" class="text-center">No Details Found</td></tr>
                      <?php } ?>
                       
                        
                      </tbody>
                    </table>
    <div class="clearfix"><br></div>
    <h3>Completed Payments</h3>
     <table id="tbl_magazine_table" class="table table-fixed table-primary dataTable">
                      <thead>
                        <tr>
                          <th>No</th>
                          <th>Date</th>
                          <th>Flat</th>
                          <th>Transaction Type</th>
                          <th>Receipt Type</th>
                          <th>Amount</th>
                          <th>Status</th>
                        </tr>
                      </thead>
                      <tbody>
                      <?php
                      $arr_completed_payment = Receipt::model()->with('flat','transtype')->findAll(array('condition'=>'t.status=1 AND t.flat_id='.$flat_id));
                      if(!empty($arr_completed_payment)){
                        foreach ($arr_completed_payment as $i=>$row) {
                      ?>
                      	 <tr>
                          <td><?php echo ($i+1);?></td>
                          <?php if($row->payment_date != '0000-00-00') { ?>
	                  <td class="text-center"><?php echo date("d/m/Y",strtotime($row->payment_date));?></td>
                          <?php } else { ?>
                          <td> &nbsp; </td>
                          <?php } ?>
                          <td><?php echo $row->flat->flat_no;?></td>
                          <td><?php echo $row->transtype->trans_name;?></td>
                          <td><?php echo Receipt::getPaymentType($row->payment_type);?></td>
                          <td class="text-right"><?php echo Yii::app()->numberFormatter->formatCurrency($row->amount,"");?></td>
                          <td><?php echo Receipt::getPaymentStatus($row->status);?></td>
                          
                        </tr>
                      	<?php 
                        }
                      }else{ ?>
                        <tr><td colspan="7" class="text-center">No Details Found</td></tr>
                      <?php } 
                      ?>
                       
                        
                      </tbody>
                    </table>
    <div class="clearfix"><br></div>
    <h3>Bounced Payments</h3>
    <table id="tbl_bounced_payments" class="table table-striped table-primary">
        <thead>
                        <tr>
                          <th>No</th>
                          <th>Date</th>
                          <th>Flat</th>
                          <th>Transaction Type</th>
                          <th>Receipt Type</th>
                          <th>Amount</th>
                          <th>Status</th>
                        </tr>
                      </thead>
                      <tbody>
                      <?php
                      $arr_bounced_payment = Receipt::model()->with('flat','transtype')->findAll(array('condition'=>'t.status=2 AND t.flat_id='.$flat_id));
                      if(!empty($arr_bounced_payment)){
                          foreach ($arr_bounced_payment as $i=>$row) {
                      ?>
                      	 <tr>
                          <td><?php echo ($i+1);?></td>
                          <?php if($row->payment_date != '0000-00-00') { ?>
	                  <td class="text-center"><?php echo date("d/m/Y",strtotime($row->payment_date));?></td>
                          <?php } else { ?>
                          <td> &nbsp; </td>
                          <?php } ?>
                          <td><?php echo $row->flat->flat_no;?></td>
                          <td><?php echo $row->transtype->trans_name;?></td>
                          <td><?php echo Receipt::getPaymentType($row->payment_type);?></td>
                          <td class="text-right"><?php echo Yii::app()->numberFormatter->formatCurrency($row->amount,"");?></td>
                          <td><?php echo Receipt::getPaymentStatus($row->status);?></td>
                          
                        </tr>
                      	<?php 
                      
                      }
                      }else{ ?>
                        <tr><td colspan="7" class="text-center">No Details Found</td></tr>
                      <?php }
                      ?>
                       
                        
                      </tbody>
        </table>
    <div class="clearfix"><br></div>
    <h3>Cancelled Payments</h3>
    <table id="tbl_cancelled_payments" class="table table-fixed table-primary dataTable">
                      <thead>
                        <tr>
                          <th>SI. No</th>
                          <th>Date</th>
                          <th>Flat</th>
                          <th>Transaction Type</th>
                          <th>Receipt Type</th>
                          <th>Amount</th>
                          <th>Status</th>
                        </tr>
                      </thead>
                      <tbody>
                      <?php
                      $arr_cancelled_payment = Receipt::model()->with('flat','transtype')->findAll(array('condition'=>'t.status=3 AND t.flat_id='.$flat_id));
                      if(!empty($arr_cancelled_payment)){
                          foreach ($arr_cancelled_payment as $i=>$row) {
                      ?>
                      	 <tr>
                          <td><?php echo ($i+1);?></td>
                          <?php if($row->payment_date != '0000-00-00') { ?>
	                  <td class="text-center"><?php echo date("d/m/Y",strtotime($row->payment_date));?></td>
                          <?php } else { ?>
                          <td> &nbsp; </td>
                          <?php } ?>
                          <td><?php echo $row->flat->flat_no;?></td>
                          <td><?php echo $row->transtype->trans_name;?></td>
                          <td><?php echo Receipt::getPaymentType($row->payment_type);?></td>
                          <td class="text-right"><?php echo Yii::app()->numberFormatter->formatCurrency($row->amount,"");?></td>
                          <td><?php echo Receipt::getPaymentStatus($row->status);?></td>
                          
                        </tr>
                      	<?php 
                       }
                      }else{ ?>
                        <tr><td colspan="7" class="text-center">No Details Found</td></tr>
                      <?php } 
                      ?>
                       
                        
                      </tbody>
                    </table>
  
</body>