<div class="modal-body">
    <?php
    $form = $this->beginWidget('CActiveForm', array(
        'id' => 'cashflow-form',
        'enableAjaxValidation' => false,
        'enableClientValidation' => false,
    ));
    ?>
    <ul class="form-add clearfix">
        <li class="form-add col-sm-6">
            <div class="icon-box fa-user material m1">
                <?php echo CHtml::dropDownList('building_id', 'building_id', Building::getAllBuilding(), array('placeholder' => 'Building')); ?>
            </div>
        </li>
        <div id="div_flat">
            <li class="form-add col-sm-6">
                <div class="icon-box fa-user material m1">
                    <?php echo CHtml::dropDownList('flat_id', 'flat_id', array(), array('placeholder' => 'Flat', 'id' => 'flat_id')); ?>
                </div>
            </li>          
        </div>
    </ul>
    <div class="modal-footer">
        <button type="button" class="btn btn-default" id="cash_close_btn" data-dismiss="modal">Close</button>
        <?php
        echo CHtml::ajaxSubmitButton('Search', Yii::app()->createUrl('lease/cashflowDetails'), array(
            'dataType' => 'json',
            'type' => 'post',
            'success' => 'function(data) {
                                    if(data.status=="success"){
                                        $("#cash_close_btn").click();
                                        location.href=$("#liveSite").val()+"administrator.php?r=lease/rentalcashflow&building_id="+data.building+"&flat_id="+data.flat;
                                    } 
                                    else if(data.status=="fail"){
                                        notification("Please select a Flat!","error");
                                    }	    
                                    else 
                                    {  
                                        $.each(data, function(key, val) { 
                                        $("#"+key).addClass("error");
                                            }); 

                                    } 
                                }',
            'beforeSend' => 'function(){
                           
                                    $("#cashflow-form .cashflow-save-btn").prop("disabled", true);
                                }',
            'complete' => 'function(){
                                $("#cashflow-form .cashflow-save-btn").prop("disabled", false);
                                }'
                ), array('id' => 'mybtn' . rand(), 'class' => 'cashflow-save-btn btn btn-primary'));
        ?>

    </div>
<?php $this->endWidget(); ?>
</div>
<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("getFlat", "function getFlat(field,val){
                jQuery.ajax({
                'dataType': 'json',
                    'data' : {building_id:val},
                    'type':'post',
                    'url': '" . Yii::app()->createUrl('lease/getBuildingFlat') . "',
                    'cache': false,
                    'success': function(data) {
                        if(data.status==1){
                            $('#div_flat').show();
                            $('#div_flat').html(data.ft);
                        }else{
                            $('#div_flat').html(data.ft);
                            //$('#div_flat').hide();
                        }


                    }
                });
}", CClientScript::POS_HEAD);
