<!DOCTYPE html>
<html>
<head>
 <?php
    $cs = Yii::app()->getClientScript();
    $baseUrl = Yii::app()->baseUrl;
    ?>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>Real Estate | Dashboard</title>
    <!-- Tell the browser to be responsive to screen width -->
    <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
    <!-- fonts -->
    <link href='https://fonts.googleapis.com/css?family=Roboto:400,500,300,700' rel='stylesheet' type='text/css'><!-- Roboto -->
    <link href='https://fonts.googleapis.com/css?family=Kaushan+Script' rel='stylesheet' type='text/css'>
    <link rel="stylesheet" href="https://fonts.googleapis.com/icon?family=Material+Icons">
    <!-- Bootstrap 3.3.5 -->
    <?php $cs->registerCssFile($baseUrl . "/css/bootstrap.min.css"); ?>
    <?php $cs->registerCssFile($baseUrl . "/css/animate.css"); ?>
    <?php $cs->registerCssFile($baseUrl . "/css/jquery-ui.css"); ?>
    <?php $cs->registerCssFile($baseUrl . "/css/datepicker.min.css"); ?>
    <?php $cs->registerCssFile($baseUrl . "/css/bootstrap-clockpicker.min.css"); ?>
    <?php $cs->registerCssFile($baseUrl . "/css/bootstrap-multiselect.css"); ?>
    <?php $cs->registerCssFile($baseUrl . "/css/monthly.css"); ?>
    <!-- Font Awesome -->
    <?php $cs->registerCssFile($baseUrl . "/css/font-awesome.min.css"); ?>
    <?php $cs->registerCssFile($baseUrl . "/css/jquery.rippleria.min.css"); ?>
    <?php $cs->registerCssFile($baseUrl . "/css/jquery.material.form.css"); ?>
    <?php $cs->registerCssFile($baseUrl . "/css/datatable.css"); ?>
    <?php $cs->registerCssFile($baseUrl . "/css/select2.min.css"); ?>
    <?php $cs->registerCssFile($baseUrl . "/js/colorpicker/css/spectrum.css"); ?>
    <?php //$cs->registerCssFile($cs->getCoreScriptUrl() . '/jui/css/base/jquery-ui.css'); ?>
    <!-- Website style -->
    <?php $cs->registerCssFile($baseUrl . "/css/style.css"); ?>
    <?php $cs->registerCssFile($baseUrl . "/css/themes.css"); ?>
    <!-- jquery -->
    <?php $cs->registerScriptFile($baseUrl . "/js/jquery-2.1.4.js", CClientScript::POS_HEAD); ?>
    <?php $cs->registerScriptFile($baseUrl . "/js/jquery-ui.js", CClientScript::POS_HEAD); ?>
    <!-- bootstrap -->
    <?php $cs->registerScriptFile($baseUrl . "/js/bootstrap.min.js", CClientScript::POS_END); ?>
    <!-- Nice Scroll bar -->
    <?php $cs->registerScriptFile($baseUrl . "/js/jquery.nicescroll.js", CClientScript::POS_HEAD); ?>
    <!-- Charts -->
    <?php $cs->registerScriptFile($baseUrl . "/js/datepicker.min.js", CClientScript::POS_END); ?>
    <!-- Include English language -->
    <?php $cs->registerScriptFile($baseUrl . "/js/datepicker.en.js", CClientScript::POS_END); ?>
    <?php $cs->registerScriptFile($baseUrl . "/js/bootstrap-clockpicker.min.js", CClientScript::POS_END); ?>
    <?php $cs->registerScriptFile($baseUrl . "/js/jquery.material.form.js", CClientScript::POS_HEAD); ?>
    <?php $cs->registerScriptFile($baseUrl . "/js/Chart.js", CClientScript::POS_END); ?>
    <?php $cs->registerScriptFile($baseUrl . "/js/Chart.Doughnut.js", CClientScript::POS_END); ?>
    <?php $cs->registerScriptFile($baseUrl . "/js/jquery.rippleria.min.js", CClientScript::POS_END); ?>
    <?php $cs->registerScriptFile($baseUrl . "/js/select2.full.min.js", CClientScript::POS_END); ?>
    <?php $cs->registerScriptFile($baseUrl . "/js/bootstrap-multiselect.js", CClientScript::POS_END); ?>
    <?php $cs->registerScriptFile($baseUrl . "/js/monthly.js", CClientScript::POS_END); ?>
    <?php $cs->registerScriptFile($baseUrl . "/js/jquery.dataTables.js", CClientScript::POS_END); ?>
    <?php $cs->registerScriptFile($baseUrl . "/js/dataTables.bootstrap.js", CClientScript::POS_END); ?>
    <?php $cs->registerScriptFile($baseUrl . "/js/dataTables.fixedHeader.js", CClientScript::POS_END); ?>
    <?php $cs->registerScriptFile($baseUrl . "/js/colorpicker/js/spectrum.js", CClientScript::POS_END); ?>
    <?php $cs->registerScriptFile($baseUrl . "/js/common.js", CClientScript::POS_END); ?>
    <!-- website scripts -->
    <?php $cs->registerScriptFile($baseUrl . "/js/script.js", CClientScript::POS_HEAD); ?>
    <?php $cs->registerScriptFile($baseUrl . "/js/eModal.js", CClientScript::POS_HEAD); ?>
    <!-- Notifiaction  -->
    <?php $cs->registerCssFile($baseUrl . '/css/jquery.pnotify.default.css'); ?>
    <?php $cs->registerScriptFile($baseUrl . '/js/jquery.pnotify.min.js', CClientScript::POS_END); ?>
    <!-- END Notifiaction  -->
    <!--  JAlert script and Css -->
 <?php $cs->registerCssFile($baseUrl . "/css/jalert/jquery.alerts.css"); ?>
 <?php $cs->registerScriptFile($baseUrl . "/js/jalert/jquery.alerts.js", CClientScript::POS_HEAD); ?>
    <!-- Full Calender Script -->
    <?php // $cs->registerCssFile($baseUrl . '/css/fullcalendar/fullcalendar.css'); ?>
     <!-- END Full Calender Script -->
    <?php $cs->registerScript('pins-notify', 'function notification(msg,type) {
    var opts = {
        title: "Messages",
        text: msg,
        hide: true,
        nonblock: false,
        nonblock_opacity: .2,
         animation: {
            "effect_in": "drop",
        }
    };
    switch (type) {
    case "error":
        opts.title = "Error";
        opts.text = msg;
        opts.type = "error";
        opts.hide = false;
        break;
    case "info":
        opts.title = "Information";
        opts.text = msg;
        opts.type = "info";
        opts.hide = false;
        break;
    case "success":
        opts.title = "Success";
        opts.text = msg;
        opts.type = "success";
        opts.nonblock= true;
        break;
    }
    $.pnotify(opts);
}
    ', CClientScript::POS_HEAD); ?>
        <?php
        //jisha
        $cs->registerScript("isNumberKey", " function isNumberKey(evt) {
                console.log('is-number-key');
                var charCode = (evt.which) ? evt.which : evt.keyCode;
                if (charCode > 31 && (charCode < 48 || charCode > 57) && charCode !== 46 && charCode !== 37)
                    return false;
                return true;
        }", CClientScript::POS_HEAD);
        //jisha
        $cs->registerScript("isNumber", " function isNumber(n) {
            console.log('is-number');
            return !isNaN(parseFloat(n)) && isFinite(n);
        } ", CClientScript::POS_HEAD);
        //jisha
        $cs->registerScript("addTableRow", "
            function addTableRow(jQtable) {
                var newrow= jQtable.find('tr:last').clone();
                var lastId = jQtable.find('tr:last td:gt(0) input').attr('id');
                var thenum = lastId.match(/\d+/g);
                var newId = Number(thenum) + 1;
                var newrow= jQtable.find('tr:last').clone();
                newrow.find('label').html(newId+1);
                newrow.find('.hasDatepicker').removeClass('hasDatepicker');
                newrow.find('.datepicker').siblings().remove();
                newrow.find('.datepicker').datepicker( 'destroy' );
                newrow.find('.clockpicker').siblings().remove();
                newrow.find('.clockpicker').clockpicker( 'destroy' );
                newrow.find('a,select,label,input,textarea,hidden,.errorMessage').each(function() {
                    this.id= this.id.replace(/\d+/,newId);
                    this.value  = '';
                    (this.name!==undefined) ? this.name= this.name.replace(/\d+/,newId) : this.style  =   'display:none;';
                });
                jQtable.append(newrow);
                var id='BuildingOwnerDetails_'+newId+'_landlord';
                var oldId=newId-1;
                var field='BuildingOwnerDetails_'+oldId+'_landlord';
                var select=document.getElementById(''+id+'');
                var value = $('#'+field+'').val();
                for (i=0;i<select.length;  i++) {
                   if (select.options[i].value==value) {
                     select.remove(i);
                   }
                }
        }", CClientScript::POS_HEAD);
        $cs->registerScript("addChequeTableRow", "
            function addChequeTableRow(jQtable) {
                var newrow= jQtable.find('tr:last').clone();
                var lastId = jQtable.find('tr:last td:gt(0) input').attr('id');
                var thenum = lastId.match(/\d+/g);
                var newId = Number(thenum) + 1;
                var newrow= jQtable.find('tr:last').clone();
                newrow.find('label').html(newId+1);
                newrow.find('.hasDatepicker').removeClass('hasDatepicker');
                newrow.find('.datepicker').siblings().remove();
                newrow.find('.datepicker').datepicker( 'destroy' );
                newrow.find('.clockpicker').siblings().remove();
                newrow.find('.clockpicker').clockpicker( 'destroy' );
                newrow.find('a,select,label,input,textarea,hidden,.errorMessage').each(function() {
                    this.id= this.id.replace(/\d+/,newId);
                    this.value  = '';
                    (this.name!==undefined) ? this.name= this.name.replace(/\d+/,newId) : this.style  =   'display:none;';
                });
                jQtable.append(newrow);
                $('#cheque_date_'+newId).datepicker({dateFormat: 'dd/mm/yyyy',language:'en'});
                var oldId           = newId-1;
                var cheque_date             = 'cheque_date_'+newId;
                var old_cheque_date_field   = 'cheque_date_'+oldId;
                var old_cheque_date         = $('#'+old_cheque_date_field+'').val();
                if(old_cheque_date ==''){
                    var today = new Date();
                    var dd = today.getDate();
                    var mm = today.getMonth()+1; //January is 0!
                    var yyyy = today.getFullYear();
                    if(dd<10){
                        dd='0'+dd
                    }
                    if(mm<10){
                        mm='0'+mm
                    }
                    old_cheque_date = dd+'/'+mm+'/'+yyyy;
                }
                arr_date                    = old_cheque_date.split('/');
                n_date                      = arr_date[1] + '/' + arr_date[0] + '/' +arr_date[2];
                var d                       = new Date( n_date );
                d.setMonth( d.getMonth( ) + 1 );
                    var dday = d.getDate();
                    var dm   = d.getMonth()+1; //January is 0!
                    if(dday < 10){
                        dday = '0'+ dday;
                    }
                    if(dm < 10){
                        dm = '0'+ dm;
                    }
                    mdate = dday+'/'+dm+'/'+d.getFullYear( );
                    //mdate    = d.getDate( ) + '/' + (d.getMonth( )+ 1 ) + '/' + d.getFullYear( );
                $('#'+cheque_date+'').val(mdate);
                var checkno_id              = 'cheque_no_'+newId;
                var old_checkno_field       = 'cheque_no_'+oldId;
                var old_checkno             = $('#'+old_checkno_field+'').val();
                var new_checkno             = Number(old_checkno)+1;
                $('#'+checkno_id+'').val(new_checkno);
                var amount          = 'amount_'+newId;
                var old_amount_field= 'amount_'+oldId;
                var old_amount      = $('#'+old_amount_field+'').val();
                $('#'+amount+'').val(old_amount);
                var bank            = 'bank_name_'+newId;
                var old_bank_field  = 'bank_name_'+oldId;
                var old_bank        = $('#'+old_bank_field+'').val();
                $('#'+bank+'').val(old_bank);
            }", CClientScript::POS_HEAD);
            $cs->registerScript("isRowEmpty", " function isRowEmpty(tr) {
                    var rowfilled=false; tr.find('td:gt(0)').each(function()
                    {
                        inpt    =   $(this).find('input').val();
                        if(typeof inpt !== 'undefined' && inpt!=='' && inpt!=='0.00') {
                            rowfilled=true; return false;
                        }
                    });
                    if(rowfilled) {
                        /*jConfirm('Do you want to remove this item?', 'Confirm', function(r) {
                        alert(r);
                            if(r==true)
                                return true;
                            else
                                return false;
                        });
                        */
                        return(confirm('Do you want to remove this item?'));
                    }
                    return true;
            } ", CClientScript::POS_HEAD);
            $cs->registerScript("removeRow", "function removeRow(jQtable,evt,field_id) {
                var arr_fields= field_id.split('_');
                var row_field=arr_fields[1];
                var num_rows    =   jQtable.find('tr:gt(0)').length;
                if(num_rows>1){
                    var tr  =   $(evt).parent().parent();
                    if(isRowEmpty(tr))
                    {
                        $(evt).parents('tr').remove();
                        var i=0;
                        jQtable.find('tr:gt(0)').each(function() {
                            $(this).find('input,textarea,.errorMessage').each(function()
                            {
                                old_id   =   $(this).attr('id');
                                new_id   =   old_id.replace(/\d+/,i);
                                $(this).attr('id',new_id);
                                old_name =   $(this).attr('name');
                                if(old_name!==undefined) {
                                    new_name =   old_name.replace(/\d+/,i);
                                    $(this).attr('name',new_name);
                                }
                            });
                            $(this).find('td:first label').html(++i);
                        });
                    }
                }else {
                        jAlert('Only one row remaining','Alert');
                }
            };", CClientScript::POS_HEAD);
            $cs->registerScript("removeTableRow", "function removeTableRow(jQtable,evt,field_id) {
                var arr_fields= field_id.split('_');
                var row_field=arr_fields[1];
                //var id=$('#JobCard_'+row_field+'_id').val();
                // formIdStarter   =   jQtable.attr('id').split(/_(.+)?/)[0];
                var num_rows    =   jQtable.find('tr:gt(0)').length;
                if(num_rows>1){
                    var tr  =   $(evt).parent().parent();
                    if(isRowEmpty(tr))
                    {
                        if(id!='')
                        {
                              /*  jQuery.ajax({
                                        'type': 'post',
                                        'dataType': 'json',
                                        'url': '" . Yii::app()->createUrl('appointment/deleteservice') . "',
                                        'data': {'id':id}  ,
                                        'cache': false,
                                        'success': function(data) {
                                            if(data.status=='success'){
                                                $(evt).parents('tr').remove();
                                                var i=0;
                                                jQtable.find('tr:gt(0)').each(function() { $(this).find('input,textarea,.errorMessage').each(function()
                                                {
                                                old_id   =   $(this).attr('id');
                                                new_id   =   old_id.replace(/\d+/,i);
                                                $(this).attr('id',new_id);
                                                old_name =   $(this).attr('name');
                                                if(old_name!==undefined) {
                                                new_name =   old_name.replace(/\d+/,i);
                                                $(this).attr('name',new_name);} });
                                                $(this).find('td:first label').html(++i); });
                                                 notification('Sevice Deleted','success');
                                                 $.pnotify_remove_all();
                                            }else{
                                              notification('Deletion Not Possible, History Exist','error');
                                              $.pnotify_remove_all();
                                            }
                                        }
                                });*/
                        }
                        else
                        {
                                $(evt).parents('tr').remove();
                                var i=0;
                                jQtable.find('tr:gt(0)').each(function() {
                                    $(this).find('input,textarea,.errorMessage').each(function()
                                    {
                                        old_id   =   $(this).attr('id');
                                        new_id   =   old_id.replace(/\d+/,i);
                                        $(this).attr('id',new_id);
                                        old_name =   $(this).attr('name');
                                        if(old_name!==undefined) {
                                            new_name =   old_name.replace(/\d+/,i);
                                            $(this).attr('name',new_name);
                                        }
                                    });
                                    $(this).find('td:first label').html(++i);
                                });
                        }
                        var total_amount=0;
                        var rowCount = $('#customer_jobcard_details tr').length;
                        rowCount = parseInt(rowCount)-parseInt(2);
                        fieldId=rowCount;
                        for(i=0;i<=fieldId;i++){
                            var amount= $('#JobCard_'+i+'_cost').val();
                                if(amount != ''){
                                    total_amount+=parseFloat(amount,10);
                                }
                        }
                        $('#total').val(Math.ceil(total_amount));
                    }else {
                        jAlert('Atleast one item needed here','Alert');
                    }
                }
            };", CClientScript::POS_HEAD);
            $cs->registerScript("autocomplete-keyup", "  $('.ui-autocomplete-input').on('keyup',function(){ console.log('auto-complete-keyup'); $(this).autocomplete('search',$(this).val()); });", CClientScript::POS_READY);
            $cs->registerScript("autocomplete-source-section", " function autoCompleteSource(request, response,url) {
                console.log('auto-complete-common');
                $.ajax({
                    type      : 'GET',
                    data    : 'term='+ request.term,
                    url       : url,
                    dataType  : 'json',
                    success : function(data) {
                        response($.map( data, function( n, i ) {
                            return { label :  n.label,  value : n.value, cost_rate : n.cost_rate, unit : n.unit, unit : n.unit, name : n.name   }
                        }));
                    }
                });
            } ", CClientScript::POS_HEAD);
            $cs->registerScript("autoCompleteOwner", "function autoCompleteOwner(field_id,frm,building_id)
            {
                var arr_fields      = field_id.split('_');
        var model_name      = arr_fields[0];
        var row_field_id    = arr_fields[2];
                if(frm == 'BuildingOwnerDetails'){
                    var url = '" . Yii::app()->createUrl('purchasedbuilding/SearchAllOwner') . "'+'&frm='+frm+'&building_id='+building_id;
                }
                if(frm == 'Payment'){
                    var url = '" . Yii::app()->createUrl('purchasedbuilding/SearchOwner') . "'+'&frm='+frm+'&building_id='+building_id;
                }
                $('#'+field_id).autocomplete({
                    minLength   : 1,
                    source      : function (request, response) { autoCompleteSource(request, response,url) },
                    focus       : function( event, ui ) { $(this).val((ui.item.label).split(':')[1]); return false;},
                    select          : function( event, ui ) {
                        event.preventDefault();
                        trigger_target_id   =   $(event.target).attr('id');
                        var landlord_id     = ui.item.value;
                        var label           = ui.item.label;
                        var landlord_name   = ui.item.name;
                        if(frm == 'BuildingOwnerDetails'){
                            $('#'+frm+'_'+row_field_id+'_landlord').val(landlord_id);
                        }
                        if(frm == 'Payment'){
                            $('#'+frm+'_landlord_id').val(landlord_id);
                        }
                    }
                })
            }", CClientScript::POS_HEAD);
     $cs->registerScript("addMinutes", "function addMinutes(time, minsToAdd) {
                    function D(J){ return (J<10? '0':'') + J;};
                    var piece = time.split(':');
                    var mins = piece[0]*60 + +piece[1] + +minsToAdd;
                    return D(mins%(24*60)/60 | 0) + ':' + D(mins%60);
  }", CClientScript::POS_HEAD);
        $cs->registerScript("dropdownChange", "
            function dropdownChange(field_id,val){
//                    alert(field_id);
                if(field_id=='Payment[payment_type]')
                {
                    getChequeDetails(field_id,val);
                }
                else if(field_id=='Receipt[payment_type]')
                {
                    getChequeDetails(field_id,val);
                }else if(field_id=='Payment[building_id]')
                {
                    getlandlord(field_id,val);
                }
                else if(field_id=='select_one')
                {
                            if(val=='1'){
                                $('#div_building').show();
                                $('#div_flat').hide();
                            }else{
                             $('#div_flat').show();
                             $('#div_building').hide();
                            }
                }
                else if(field_id=='Payment[status]')
                {
                    getRealisationDate(field_id,val);
                }
                else if(field_id=='Receipt[status]')
                {
                    getRealisationDate(field_id,val);
                }
                else if(field_id=='Expense[expense_type]')
                {
                    getSubledger(field_id,val);
                }
                else if(field_id=='Lease[building_id]')
                {
                    getFlatDetail(field_id,val);
                }
                else if(field_id=='Lease[flat_id]')
                {
                    getFlatAmount(field_id,val);
                }
                else if(field_id=='Expense[building_id]')
                {
                    getFlat(field_id,val);
                }
                else if(field_id=='Receipt[building_id]')
                {
                    getFlatNo(field_id,val);
                }
                else if(field_id=='Receipt[flat_id]')
                {
                    getLeaseCode(field_id,val);
                }
                else if(field_id=='Receipt[lease_id]')
                {
                    $('#hid_lease_id').val(val);
                }
                else if(field_id=='Tenant[building_id]')
                {
                    getBuildingFlat(field_id,val);
                }
                else if(field_id=='Maintenance[building_id]')
                {
                    getMaintenanceFlat(field_id,val);
                }
                else if(field_id=='Maintenance[flat_id]')
                {
                    getMaintenanceTenant(field_id,val);
                }
                else if(field_id=='OnetimePayments[payment_type]')
                {
                    getPaymentCheque(field_id,val);
                }
                else if(field_id=='Expense[payment_type]'){
                    getPaymentCheque(field_id,val);
                }
                else if(field_id=='building_id')
                {
                    getFlat(field_id,val);
                }
                else if(field_id=='flat_id')
                {
                    getOwner(field_id,val);
                }else if(field_id=='doc_type')
                {
                    getDocFilter(val);
                }
            }", CClientScript::POS_HEAD);
        ?>
    <!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->
    <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
        <!--[if lt IE 9]>
        <script src="https://oss.maxcdn.com/html5shiv/3.7.3/html5shiv.min.js"></script>
        <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
        <![endif]-->
<script>
$(document).ready(function() {
    var table = $('.dataTable').DataTable( {
        fixedHeader: true,
    } );
} );
</script>
    </head>
    <body class="pink">
        <header class="fixed pink" id="header">
            <div class="side-toggle" id="side-toggle"><a class="side-toggle-bar"><i class="fa fa-bars"></i></a></div>
            <div class="logo"><h1>Bluesky - Real Estate</h1></div>
            <ul class="head-dd">
                <li class="head-dd"><a onclick="requestFullScreen()"><i class="material-icons">fullscreen</i></a></li>
                <!-- li class="head-dd dropdown"><a data-toggle="dropdown"><i class="fa fa-envelope"></i></a>
                    <ul class="dropdown-menu dd-toggle">
                        <li><img src="img/thumb/01.jpg" class="mg-thumb-sm">
                            <div class="mg-ctn">
                                <h6>Amanda Wellsh</h6>
                                <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit.</p>
                            </div>
                        </li>
                        <li><img src="img/thumb/02.jpg" class="mg-thumb-sm">
                            <div class="mg-ctn">
                                <h6>Alisa Ahmann</h6>
                                <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit.</p>
                            </div>
                        </li>
                        <li><img src="img/thumb/03.jpg" class="mg-thumb-sm">
                            <div class="mg-ctn">
                                <h6>Aneta Pajak</h6>
                                <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit.</p>
                            </div>
                        </li>
                    </ul>
                </li!-->
                <?php 
                $tenancy_count=COUNT(Lease::model()->findAll(array('condition' => 't.flat_status=2  AND t.to_date >= "'.date("Y-m-d").'"  AND t.to_date <= "'.date("Y-m-d", strtotime("+3 months", strtotime(date("Y-m-d")))).'"')));
                $payment_count = count(Payment::model()->findAll(array('condition'=>'t.payment_type=2 AND t.status!=1 AND t.cheque_date <= "'.date("Y-m-d", strtotime("+15 days", strtotime(date("Y-m-d")))).'" AND t.cheque_date >= "'.date("Y-m-d").'"')));
                $receipt_count = count(Receipt::model()->findAll(array('condition'=>'t.payment_type=2 AND t.status!=1 AND t.cheque_date <= "'.date("Y-m-d", strtotime("+15 days", strtotime(date("Y-m-d")))).'" AND t.cheque_date >= "'.date("Y-m-d").'"')));
                $total_count = $tenancy_count + $payment_count + $receipt_count; 
                ?>
                <li class="head-dd dropdown"><a data-toggle="dropdown"><i class="fa fa-bell"></i><span class="badge"><?php echo $total_count; ?></span></a>
                    <ul class="dropdown-menu dd-toggle">
                        <li>
                            <img src="img/thumb/03.jpg" class="mg-thumb-sm">
                            <div class="mg-ctn">
                                <a href="<?php echo Yii::app()->createUrl('dashboard/tenancyexpiry').'&frm=1'; ?>">
                                        <h6>Tenancy Expiry</h6>
                                        <p><?php echo "<strong>$tenancy_count </strong>expire in 3 months"; ?></p>
                                </a>
                            </div>
                        </li>
                        <li>
                            <img src="img/thumb/02.jpg" class="mg-thumb-sm">
                            <div class="mg-ctn">
                                <a href="<?php echo Yii::app()->createUrl('dashboard/payments').'&frm=1'; ?>">
                                    <h6>Payments</h6>
                                    <p><?php echo "<strong>$payment_count</strong> "; ?></p>
                                </a>
                            </div>
                        </li>
                        <li>
                            <img src="img/thumb/01.jpg" class="mg-thumb-sm">
                            <div class="mg-ctn">
                                <a href="<?php echo Yii::app()->createUrl('dashboard/receipts').'&frm=1'; ?>">
                                    <h6>Receipts</h6>
                                    <p><?php echo "<strong>$receipt_count</strong>"; ?></p>
                                </a>
                            </div>
                        </li>
                    </ul>
                </li>
                <li class="dropdown head-dd"><a data-toggle="dropdown"><i class="fa fa-cog fa-spin"></i></a>
                    <ul class="dropdown-menu dd-toggle">
                        <div class="profile-box">
                            <div class="round-img"><img src="img/emp/01.jpg"></div>
                            <div class="toggle-mini">
                            <h5>Welcome</h5>
                            <h5><small><?php echo User::getName(Yii::app()->user->id);?></small></h5>
                            </div>
                        </div>
                        <!--li><a class="btn-link"><i class="material-icons">account_circle</i> Profile</a></li>
                        <li><a class="btn-link"><i class="material-icons">exit_to_app</i> Logout</a></li>-->
                        <li><a href="<?php echo $this->createUrl('site/logout') ?>" class="btn-link" ><i class="material-icons">exit_to_app</i> Log Out</a></li>
                    </ul>
                </li>
                <!-- li class="head-dd"><a id="side-swh"><i class="material-icons">brush</i></a></li> -->
            </ul>
        </header>
        <!-- div id="right-side-bar">
            <ul id="myTabs" class="dc" role="menu" aria-labelledby="dLabel">
                    <div class="ts">
                    <ul class="dc">
                      <li class="active"><a class="btn btn-link" href="#swh-sb" data-toggle="tab">Side Bar</a>           </li>
                      <li><a class="btn btn-link" href="#swh-tb" data-toggle="tab">Top Bar</a></li>
                      <li><a class="btn btn-link" href="#swh-b" data-toggle="tab">Body</a></li>
                    </ul>
                    <!-- Tab panes
                    <div class="tab-content dc">
                      <div class="tab-pane active" id="swh-sb">
                        <ul class="swicher-panel dc swh-sm">
                            <li class="clr-panel" data-theam="dark">
                                <div class="color" style="background:#000"></div>
                                Black
                            </li>
                            <li class="clr-panel" data-theam="pink">
                                <div class="color" style="background:#dd238b"></div>
                                Pink
                            </li>
                            <li class="clr-panel" data-theam="">
                                <div class="color" style="background:#495AB3"></div>
                                Blue
                            </li>
                            <div class="c-head material">
                                <input type="checkbox" id="s-cs" name="Custom" placeholder="Custom">
                            </div>
                        </ul>
                        <hr>
                        <div class="custom">
                            <div class="clearfix"></div>
                            <div id="s-body" class="disabled">
                                <div class="col-xs-12">
                                    <input type="text" id="s-bg">
                                    <label>Select your color</label>
                                </div>
                                <div class="col-xs-12 material">
                                    <label class="sm-l">Select menu style</label>
                                    <input type="radio" name="sm-style" value="style1" placeholder="Style 1">
                                    <input type="radio" name="sm-style" value="style2" placeholder="Style 2">
                                    <input type="radio" name="sm-style" value="style3" placeholder="Style 3">
                                </div>
                            </div>
                        </div>
                      </div>
                      <div class="tab-pane" id="swh-tb">
                        <ul class="swicher-panel swh-tb dc">
                            <li class="clr-panel" data-theam="dark">
                                <div class="color" style="background:#000"></div>
                                Black
                            </li>
                            <li class="clr-panel" data-theam="">
                                <div class="color" style="background:#495AB3"></div>
                                Blue
                            </li>
                            <li class="clr-panel" data-theam="pink">
                                <div class="color" style="background:#dd238b"></div>
                                Pink
                            </li>
                        </ul>
                      </div>
                      <div class="tab-pane" id="swh-b">
                        <ul class="swicher-panel swh-b dc">
                            <li class="clr-panel" data-theam="">
                                <div class="color" style="background:#495AB3"></div>
                                Blue
                            </li>
                            <li class="clr-panel" data-theam="dark">
                                <div class="color" style="background:#000"></div>
                                Black
                            </li>
                            <li class="clr-panel" data-theam="pink">
                                <div class="color" style="background:#dd238b"></div>
                                Pink
                            </li>
                        </ul>
                      </div>
                    </div>
                    </div>
                </ul>
        </div-->
        <aside class="big pink" id="side-bar-left">
            <!-- <div class="profile-box">
                <div class="round-img"><img src="img/emp/01.jpg"></div>
                <div class="toggle-mini">
                <h5>Welcome</h5>
                <h5><small>Mr. Ebin</small></h5>
                <div class="col-sm-12 side-menu">
                    <a class="btn-a btn-danger btn-small f-left">Logout <i class="glyphicon glyphicon-log-out"></i></a>
                    <a class="btn-a btn-primary btn-small f-right">Profile <i class="glyphicon glyphicon-user"></i></a>
                </div>
                </div>
            </div> -->
            <ul class="side-menu">
                <?php
                    //if(Yii::app()->controller->id == 'site' && Yii::app()->controller->action->id == 'index')
                    //    $open_index ='open';
                    //else
                    //    $open_index ='';
                ?>
<!--               <li class="side-menu expand-menu <?php //echo $open_index;?>" ><a href="<?php //echo Yii::app()->createUrl('site/index'); ?>"><div class="menu-iconbox"><i class="fa fa-home"></i></div><div class="text-a"> Home</div></a></li>-->
               <?php
                    if(Yii::app()->controller->id == 'dashboard')
                        $open_dashboard ='open';
                    else
                        $open_dashboard ='';
                //if(Yii::app()->user->authorised_user == 1 || Yii::app()->user->havePermissionOn["dashboard_vaccant_flat_view"] || Yii::app()->user->havePermissionOn["dashboard_not_handover_flat_view"] || Yii::app()->user->havePermissionOn["dashboard_payment_view"] || Yii::app()->user->havePermissionOn["dashboard_receipt_view"] || Yii::app()->user->havePermissionOn["dashboard_tenancy_expiry_view"] || Yii::app()->user->havePermissionOn["dashboard_owner_rep_sole_view"] || Yii::app()->user->havePermissionOn["dashboard_owner_rep_share_view"] || Yii::app()->user->havePermissionOn["dashboard_bank_statement_view"]){ ?>
               <li class="side-menu expand-menu <?php echo $open_dashboard;?>"><a href="<?php echo Yii::app()->createUrl('dashboard/index'); ?>"><div class="menu-iconbox"><i class="fa fa-dashcube"></i></div><div class="text-a">Dashboard</div></a></li>
               <?php //} ?>
                <?php
                    if(Yii::app()->controller->action->id == 'index'  && (Yii::app()->controller->id == 'purchasedbuilding' ||
                                                                            Yii::app()->controller->id == 'purchasedland' ||
                                                                            Yii::app()->controller->id == 'landlord' ||
                                                                            Yii::app()->controller->id == 'payment' ||
                                                                            Yii::app()->controller->id == 'building' ))
                        $open_mortgage ='open';
                    else
                        $open_mortgage ='';
                 ?>
               <li class="side-menu has-sub <?php echo $open_mortgage;?>"><a><div class="menu-iconbox"><i class="fa fa-building"></i></div><div class="text-a"> Mortgage</div></a>
                    <ul>
                    <?php if(Yii::app()->user->authorised_user == 1 || Yii::app()->user->havePermissionOn["mortgage_purch_building_view"]){ ?>
                        <li class="<?php if($open_mortgage == 'open' && Yii::app()->controller->id == 'purchasedbuilding')
                            echo 'active'; ?>"><a href="<?php echo Yii::app()->createUrl('purchasedbuilding/index'); ?>">Purchased Building</a></li>
                            <?php } ?>
                    <?php if(Yii::app()->user->authorised_user == 1 || Yii::app()->user->havePermissionOn["mortgage_purch_land_view"]){ ?>   
                        <li class="<?php if($open_mortgage == 'open' && Yii::app()->controller->id == 'purchasedland')
                            echo 'active'; ?>"><a href="<?php echo Yii::app()->createUrl('purchasedland/index'); ?>">Purchased Land</a></li>
                                  <?php } ?>
                    <?php if(Yii::app()->user->authorised_user == 1 || Yii::app()->user->havePermissionOn["mortgage_purch_flat_view"]){ ?>  
                        <li class="<?php if($open_mortgage == 'open' && Yii::app()->controller->id == 'purchasedflat')
                            echo 'active'; ?>"><a href="<?php echo Yii::app()->createUrl('purchasedflat/index'); ?>">Purchased Flat</a></li>
                        <?php } ?>
                    <?php if(Yii::app()->user->authorised_user == 1 || Yii::app()->user->havePermissionOn["mortgage_landlord_view"]){ ?>          
                        <li class="<?php if($open_mortgage == 'open' && Yii::app()->controller->id == 'landlord')
                            echo 'active'; ?>"><a href="<?php echo Yii::app()->createUrl('landlord/index'); ?>"> Landlord</a></li>
                             <?php } ?>
                    <?php if(Yii::app()->user->authorised_user == 1 || Yii::app()->user->havePermissionOn["mortgage_payment_view"]){ ?>   
                        <li class="<?php if($open_mortgage == 'open' && Yii::app()->controller->id == 'payment')
                            echo 'active'; ?>"><a href="<?php echo Yii::app()->createUrl('payment/index'); ?>">Payments</a></li>
                            <?php } ?>
                        <!--li class="<?php if($open_mortgage == 'open' && Yii::app()->controller->action->id == 'ownerSummary'  && Yii::app()->controller->id == 'purchasedbuilding')
                            echo 'active'; ?>"><a href="#" onclick="loadPopupModal('purchasedbuilding/ownerSummarySearch','OwnerSummary','sm');">Owner Summary</a></li-->
                        </ul>
                </li>
                <?php
                    if((Yii::app()->controller->action->id == 'index'  && Yii::app()->controller->id == 'expense')||
                      (Yii::app()->controller->action->id == 'index' && Yii::app()->controller->id == 'expensetype') ||
                      (Yii::app()->controller->action->id == 'index' && Yii::app()->controller->id == 'subledger' ) ||
                      (Yii::app()->controller->action->id == 'searchResults'  && Yii::app()->controller->id == 'purchasedbuilding') ||
                      (Yii::app()->controller->action->id == 'summaryResults'  && Yii::app()->controller->id == 'purchasedbuilding'))
                        $open_account ='open';
                    else
                        $open_account ='';
                ?>
                <li class="side-menu has-sub <?php echo $open_account;?>"><a><div class="menu-iconbox"><i class="material-icons">account_circle</i></div><div class="text-a"> Accounts</div></a>
                    <ul>
                    <?php if(Yii::app()->user->authorised_user == 1 || Yii::app()->user->havePermissionOn["accounts_expense_view"]){ ?>
                        <li class="<?php if($open_account == 'open' && Yii::app()->controller->id == 'expense')
                            echo 'active'; ?>"><a href="<?php echo Yii::app()->createUrl('expense/index'); ?>">Expenses</a></li>
                            <?php } ?>
                    <?php if(Yii::app()->user->authorised_user == 1 || Yii::app()->user->havePermissionOn["accounts_ledger_view"]){ ?>
                        <li class="<?php if($open_account == 'open' && Yii::app()->controller->id == 'expensetype')
                            echo 'active'; ?>"><a href="<?php echo Yii::app()->createUrl('expensetype/index'); ?>">Ledger</a></li>
                            <?php } ?>
                    <?php if(Yii::app()->user->authorised_user == 1 || Yii::app()->user->havePermissionOn["accounts_subledger_view"]){ ?>
                        <li class="<?php if($open_account == 'open' && Yii::app()->controller->id == 'subledger')
                            echo 'active'; ?>"><a href="<?php echo Yii::app()->createUrl('subledger/index'); ?>">Subledger</a></li>
                            <?php } ?>
                    <?php if(Yii::app()->user->authorised_user == 1 || Yii::app()->user->havePermissionOn["accounts_calc_depreciation_view"]){ ?>
                        <li class="<?php if($open_account == 'open' && Yii::app()->controller->action->id == 'searchResults'  && Yii::app()->controller->id == 'purchasedbuilding')
                            echo 'active'; ?>"><a href="#"  onclick="loadPopupModal('purchasedbuilding/search','Depreciation','sm');">Calculate Depreciation</a></li>
                            <?php } ?>
                    <?php if(Yii::app()->user->authorised_user == 1 || Yii::app()->user->havePermissionOn["accounts_summary_view"]){ ?>
                        <li class="<?php if($open_account == 'open' && Yii::app()->controller->action->id == 'summaryResults'  && Yii::app()->controller->id == 'purchasedbuilding')
                            echo 'active'; ?>"><a href="#"  onclick="loadPopupModal('purchasedbuilding/summarysearch','Income Expense','sm');">Summary </a></li>
                    <?php } ?>
                    </ul>
               </li>
               <?php
                    if((Yii::app()->controller->action->id == 'index'  && Yii::app()->controller->id == 'tenant') ||
                        (Yii::app()->controller->action->id == 'index'  &&  Yii::app()->controller->id == 'lease') ||
                        (Yii::app()->controller->action->id == 'index'  &&  Yii::app()->controller->id == 'flat') ||
                        (Yii::app()->controller->action->id == 'index'  &&  Yii::app()->controller->id == 'receipt') ||
                        (Yii::app()->controller->action->id == 'summaryResults'  && Yii::app()->controller->id == 'purchasedbuilding'))
                        $open_lease ='open';
                    else
                        $open_lease ='';
                ?>
               <li class="side-menu has-sub <?php echo $open_lease;?>"><a><div class="menu-iconbox"><i class="material-icons">event_note</i></div><div class="text-a"> Lease</div></a>
                    <ul>
                    <?php if(Yii::app()->user->authorised_user == 1 || Yii::app()->user->havePermissionOn["lease_tenant_view"]){ ?>
                        <li class="<?php if($open_lease == 'open' && Yii::app()->controller->id == 'tenant')
                            echo 'active'; ?>"><a href="<?php echo Yii::app()->createUrl('tenant/index'); ?>"> Tenant</a></li>
                            <?php } ?>
                    <?php if(Yii::app()->user->authorised_user == 1 || Yii::app()->user->havePermissionOn["lease_sub_lease_view"]){ ?>
                        <li class="<?php if($open_lease == 'open' && Yii::app()->controller->id == 'lease')
                            echo 'active'; ?>"><a href="<?php echo Yii::app()->createUrl('lease/index'); ?>"> Lease</a></li>
                            <?php } ?>
                    <?php if(Yii::app()->user->authorised_user == 1 || Yii::app()->user->havePermissionOn["lease_flat_view"]){ ?>
                        <li class="<?php if($open_lease == 'open' && Yii::app()->controller->id == 'flat')
                            echo 'active'; ?>"><a href="<?php echo Yii::app()->createUrl('flat/index'); ?>">Flat Details</a></li>
                            <?php } ?>
                    <?php if(Yii::app()->user->authorised_user == 1 || Yii::app()->user->havePermissionOn["lease_receipt_view"]){ ?>
                        <li class="<?php if($open_lease == 'open' && Yii::app()->controller->id == 'receipt')
                            echo 'active'; ?>"><a href="<?php echo Yii::app()->createUrl('receipt/index'); ?>">Receipts</a></li>
                            <?php } ?>
                    <?php if(Yii::app()->user->authorised_user == 1 || Yii::app()->user->havePermissionOn["lease_flat_summary_view"]){ ?>
                        <li class="<?php if($open_lease == 'open' && Yii::app()->controller->action->id == 'summaryResults'  && Yii::app()->controller->id == 'lease')
                            echo 'active'; ?>"><a href="#"  onclick="loadPopupModal('lease/summarysearch','Flat Summary','sm');">Flat Summary </a></li>
                    <?php } ?>
                         <?php if(Yii::app()->user->authorised_user == 1 || Yii::app()->user->havePermissionOn["lease_rentalcashflow_view"]){ ?>
                        <li class="<?php if($open_lease == 'open' && Yii::app()->controller->action->id == 'rentalcashflow'  && Yii::app()->controller->id == 'lease')
                            echo 'active'; ?>"><a href="#"  onclick="loadPopupModal('lease/cashflowsearch','Rental Cash Flow','sm');">Rental Cash Flow </a></li>
                    <?php } ?>
                    </ul>
               </li>
               <?php
                    if(Yii::app()->controller->id == 'maintenance' && Yii::app()->controller->action->id == 'index')
                        $open_maintenance ='open';
                    else
                        $open_maintenance ='';
                if(Yii::app()->user->authorised_user == 1 || Yii::app()->user->havePermissionOn["maintenance_maint_view"]){ ?>
               <li class="side-menu expand-menu <?php echo $open_maintenance;?>"><a href="<?php echo Yii::app()->createUrl('maintenance/index'); ?>"><div class="menu-iconbox"><i class="fa fa-chain-broken"></i></div><div class="text-a">Maintenance</div></a></li>
               <?php } ?>
               <?php
                    if((Yii::app()->controller->action->id == 'SearchResult1'  && Yii::app()->controller->id == 'receipt')||
                      (Yii::app()->controller->action->id == 'SearchResult1' && Yii::app()->controller->id == 'payment') ||
                      (Yii::app()->controller->action->id == 'getflatnotelist' && Yii::app()->controller->id == 'flatnote' ) ||
                      (Yii::app()->controller->action->id == 'getpaymentlist'  && Yii::app()->controller->id == 'receipt') ||
                      (Yii::app()->controller->action->id == 'getpaymentlist'  && Yii::app()->controller->id == 'payment')||
                      (Yii::app()->controller->action->id == 'flatreport'  && Yii::app()->controller->id == 'flatreportdetails')||
                      (Yii::app()->controller->action->id == 'buildingreport'  && Yii::app()->controller->id == 'buildingreportdetails')||
                      (Yii::app()->controller->id == 'report') )
                        $open_report ='open';
                    else
                        $open_report ='';
                ?>
               <li class="side-menu has-sub <?php echo $open_report;?>"><a><div class="menu-iconbox"><i class="fa fa-book"></i></div><div class="text-a">Reports</div></a>
                    <ul>
                    <?php if(Yii::app()->user->authorised_user == 1 || Yii::app()->user->havePermissionOn["report_own_summary_view"]){ ?>
                        <li class="<?php if($open_report == 'open' && Yii::app()->controller->action->id == 'ownerreport'  && Yii::app()->controller->id == 'report')
                            echo 'active'; ?>"><a href="<?php echo Yii::app()->createUrl('report/ownerreport'); ?>">Owner Summary</a></li>
                            <?php } ?>
                    <?php if(Yii::app()->user->authorised_user == 1 || Yii::app()->user->havePermissionOn["report_own_share_view"]){ ?>
                        <li class="<?php if($open_report == 'open' && Yii::app()->controller->action->id == 'ownerreport1'  && Yii::app()->controller->id == 'report')
                            echo 'active'; ?>"><a href="<?php echo Yii::app()->createUrl('report/ownerreport1'); ?>">Owner Share Summary</a></li>
                             <?php } ?>
                    <?php if(Yii::app()->user->authorised_user == 1 || Yii::app()->user->havePermissionOn["report_building_summary_view"]){ ?>
                        <li class="<?php if($open_report == 'open' && Yii::app()->controller->action->id == 'buildingreport'  && Yii::app()->controller->id == 'report')
                            echo 'active'; ?>"><a href="<?php echo Yii::app()->createUrl('report/buildingreport'); ?>">Building Summary</a></li>
                             <?php } ?>
                    <?php if(Yii::app()->user->authorised_user == 1 || Yii::app()->user->havePermissionOn["report_land_report_view"]){ ?>
                        <li class="<?php if($open_report == 'open' && Yii::app()->controller->action->id == 'landreport'  && Yii::app()->controller->id == 'report')
                            echo 'active'; ?>"><a href="#"  onclick="loadPopupModal('report/landreport','Land Report','sm');">Land Report</a></li>
                             <?php } ?>
                    <?php if(Yii::app()->user->authorised_user == 1 || Yii::app()->user->havePermissionOn["report_building_report_view"]){ ?>
                        <li class="<?php if($open_report == 'open' && Yii::app()->controller->action->id == 'buildingreport'  && Yii::app()->controller->id == 'report')
                            echo 'active'; ?>"><a href="#"  onclick="loadPopupModal('report/buildingreportdetail','Buliding Report','sm');">Buliding Report</a></li>
                             <?php } ?>
                    <?php if(Yii::app()->user->authorised_user == 1 || Yii::app()->user->havePermissionOn["report_flat_report_view"]){ ?>
                        <li class="<?php if($open_report == 'open' && Yii::app()->controller->action->id == 'buildingreport'  && Yii::app()->controller->id == 'report')
                            echo 'active'; ?>"><a href="#"  onclick="loadPopupModal('report/flatreport','Flat Report','sm');">Flat Report</a></li>
                             <?php } ?>
                    <?php if(Yii::app()->user->authorised_user == 1 || Yii::app()->user->havePermissionOn["report_tenant_report_view"]){ ?>
                        <li class="<?php if($open_report == 'open' && Yii::app()->controller->action->id == 'tenant'  && Yii::app()->controller->id == 'report')
                            echo 'active'; ?>"><a href="<?php echo Yii::app()->createUrl('report/tenant');?>">Tenant Report</a></li>
                             <?php } ?>
                    <?php if(Yii::app()->user->authorised_user == 1 || Yii::app()->user->havePermissionOn["report_expense_report_view"]){ ?>
                        <li class="<?php if($open_report == 'open' && Yii::app()->controller->action->id == 'expense'  && Yii::app()->controller->id == 'report')
                            echo 'active'; ?>"><a href="<?php echo Yii::app()->createUrl('report/expense');?>">Expense Report</a></li>
                             <?php } ?>
                    <?php if(Yii::app()->user->authorised_user == 1 || Yii::app()->user->havePermissionOn["report_receipt_view"]){ ?>
                        <li class="<?php if($open_report == 'open' && Yii::app()->controller->action->id == 'SearchResult1'  && Yii::app()->controller->id == 'receipt')
                            echo 'active'; ?>"><a href="#"  onclick="loadPopupModal('receipt/search','Receipt Report','sm');">Receipts</a></li>
                             <?php } ?>
                    <?php if(Yii::app()->user->authorised_user == 1 || Yii::app()->user->havePermissionOn["report_payment_view"]){ ?>
                        <li class="<?php if($open_report == 'open' && Yii::app()->controller->action->id == 'SearchResult1' && Yii::app()->controller->id == 'payment')
                            echo 'active'; ?>"><a href="#"  onclick="loadPopupModal('payment/search','Payment Report','sm');">Payments</a></li>
                             <?php } ?>
                        <li class="submenu">
                            <a href="#">Reminder <i class="fa fa-angle-double-down" aria-hidden="true"></i> </a>
                            <ul>
                            <?php if(Yii::app()->user->authorised_user == 1 || Yii::app()->user->havePermissionOn["report_remainder_note_view"]){ ?>
                                <li class="<?php if($open_report == 'open' && Yii::app()->controller->action->id == 'getflatnotelist' && Yii::app()->controller->id == 'flatnote') echo 'active'; ?>">
                                    <a href="<?php echo Yii::app()->createUrl('flatnote/getflatnotelist'); ?>">Note</a>
                                </li>
                                <?php } ?>
                            <?php if(Yii::app()->user->authorised_user == 1 || Yii::app()->user->havePermissionOn["report_remainder_receipt_view"]){ ?>
                                <li class="<?php if($open_report == 'open' && Yii::app()->controller->action->id == 'getpaymentlist'  && Yii::app()->controller->id == 'receipt') echo 'active'; ?>">
                                    <a href="<?php echo Yii::app()->createUrl('receipt/getpaymentlist'); ?>">Receipts</a>
                                </li>
                             <?php } ?>
                            <?php if(Yii::app()->user->authorised_user == 1 || Yii::app()->user->havePermissionOn["report_remainder_payment_view"]){ ?>
                                <li class="<?php if($open_report == 'open' && Yii::app()->controller->action->id == 'getpaymentlist'  && Yii::app()->controller->id == 'payment') echo 'active'; ?>">
                                    <a href="<?php echo Yii::app()->createUrl('payment/getpaymentlist'); ?>">Payments</a>
                                </li>
                                <?php } ?>
                            </ul>
                        </li>
                        <?php if(Yii::app()->user->authorised_user == 1 || Yii::app()->user->havePermissionOn["report_bank_statement_view"]){ ?>
                         <li class="<?php if($open_report == 'open' && Yii::app()->controller->action->id == 'bankstatement'  && Yii::app()->controller->id == 'report')
                            echo 'active'; ?>"><a href="<?php echo Yii::app()->createUrl('report/bankstatement'); ?>">Bank Statement</a></li>
                            <?php } ?>
                     </ul>
               </li>
               <?php
                    if((Yii::app()->controller->action->id == 'index'  && (Yii::app()->controller->id == 'building' ||
                                                                            Yii::app()->controller->id == 'buildingClass' ||
                                                                            Yii::app()->controller->id == 'maintenancework' ||
                                                                            Yii::app()->controller->id == 'subcontractors'||
                                                                            Yii::app()->controller->id == 'settings'||
                                                                            Yii::app()->controller->id == 'flat'  ||
                                                                            Yii::app()->controller->id == 'bank'))||
                            (Yii::app()->controller->action->id == 'changepassword'  && Yii::app()->controller->id == 'settings')||
                            (Yii::app()->controller->action->id == 'listbanks'  && Yii::app()->controller->id == 'settings'))
                        $open_masters ='open';
                    else
                        $open_masters ='';
                ?>
               <li class="side-menu has-sub <?php echo $open_masters;?>"><a><div class="menu-iconbox"><i class="fa fa-user"></i></div><div class="text-a"> Masters</div></a>
                    <ul>
                        <?php if(Yii::app()->user->authorised_user == 1 || Yii::app()->user->havePermissionOn["master_building_view"]){ ?>
                        <li class="<?php if($open_masters == 'open' && Yii::app()->controller->id == 'building')
                            echo 'active'; ?>"><a href="<?php echo Yii::app()->createUrl('Building/index'); ?>">Building</a></li>
                            <?php } ?>
                        <?php if(Yii::app()->user->authorised_user == 1 || Yii::app()->user->havePermissionOn["master_flat_view"]){ ?>    
                        <li class="<?php if($open_masters == 'open' && Yii::app()->controller->id == 'flat')
                            echo 'active'; ?>"><a href="<?php echo Yii::app()->createUrl('flat/index'); ?>">Flat</a></li>
                            <?php } ?>
                        <?php if(Yii::app()->user->authorised_user == 1 || Yii::app()->user->havePermissionOn["master_settings_view"]){ ?>        
                        <li class="<?php if($open_masters == 'open' && Yii::app()->controller->id == 'settings'&& Yii::app()->controller->action->id == 
                            'index')
                            echo 'active'; ?>"><a href="<?php echo Yii::app()->createUrl('settings/index'); ?>">Settings</a></li>
                            <?php } ?>
                        <?php if(Yii::app()->user->authorised_user == 1 || Yii::app()->user->havePermissionOn["master_company_bank_view"]){ ?>    
                        <li class="<?php if($open_masters == 'open' && Yii::app()->controller->action->id == 'listbanks')
                            echo 'active'; ?>"><a href="<?php echo Yii::app()->createUrl('settings/listbanks'); ?>">Company Bank</a></li>
                            <?php } ?>
                        <?php if(Yii::app()->user->authorised_user == 1 || Yii::app()->user->havePermissionOn["master_flat_type_view"]){ ?>  
                        <li class="<?php if($open_masters == 'open' && Yii::app()->controller->id == 'buildingClass')
                            echo 'active'; ?>"><a href="<?php echo Yii::app()->createUrl('BuildingClass/index'); ?>">Type of Flat</a></li>
                            <?php } ?>
                        <?php if(Yii::app()->user->authorised_user == 1 || Yii::app()->user->havePermissionOn["master_maintenance_type_view"]){ ?>     
                        <li class="<?php if($open_masters == 'open' && Yii::app()->controller->id == 'maintenancework')
                            echo 'active'; ?>"><a href="<?php echo Yii::app()->createUrl('maintenancework/index'); ?>">Maintenance Type</a></li>
                            <?php } ?>
                        <?php if(Yii::app()->user->authorised_user == 1 || Yii::app()->user->havePermissionOn["master_subcontractor_view"]){ ?>    
                        <li class="<?php if($open_masters == 'open' && Yii::app()->controller->id == 'subcontractors')
                            echo 'active'; ?>"><a href="<?php echo Yii::app()->createUrl('subcontractors/index'); ?>">Sub Contractor</a></li>
                            <?php } ?>
                        <?php if(Yii::app()->user->authorised_user == 1 || Yii::app()->user->havePermissionOn["master_bank_view"]){ ?>
                        <li class="<?php if($open_masters == 'open' && Yii::app()->controller->id == 'bank')
                            echo 'active'; ?>"><a href="<?php echo Yii::app()->createUrl('bank/index'); ?>">Bank</a></li>
                            <?php } ?>
                        <?php if(Yii::app()->user->authorised_user == 1 || Yii::app()->user->havePermissionOn["master_change_pass_view"]){ ?>
                        <li class="<?php if($open_masters == 'open' && Yii::app()->controller->action->id == 'changepassword')
                            echo 'active'; ?>"><a href="<?php echo Yii::app()->createUrl('settings/changepassword'); ?>">Change Password</a></li>
                            <?php } ?>
                     </ul>
               </li>
               <?php
                    if(Yii::app()->controller->action->id == 'index'  && (Yii::app()->controller->id == 'user' ||
                                                                            Yii::app()->controller->id == 'usergroup'))
                        $open_admin ='open';
                    else
                        $open_admin ='';
                ?>
                <li class="side-menu has-sub <?php echo $open_admin;?>"><a><div class="menu-iconbox"><i class="fa fa-user"></i></div><div class="text-a"> Admin</div></a>
                    <ul>
                    <?php if(Yii::app()->user->authorised_user == 1 || Yii::app()->user->havePermissionOn["user_view"]){ ?>
                        <li class="<?php if($open_admin == 'open' && Yii::app()->controller->id == 'user')
                            echo 'active'; ?>"><a href="<?php echo Yii::app()->createUrl('user/index'); ?>">User</a></li>
                    <?php } ?>
                    <?php if(Yii::app()->user->authorised_user == 1 || Yii::app()->user->havePermissionOn["usergroup_view"]){ ?>
                        <li class="<?php if($open_admin == 'open' && Yii::app()->controller->id == 'usergroup')
                            echo 'active'; ?>"><a href="<?php echo Yii::app()->createUrl('usergroup/index'); ?>">User Group</a></li>
                    <?php } ?>
                    </ul>
                </li>
            </ul>
        </aside>
<section class="main-contant">
<?php echo $content;?>
</section><!-- main section Panel -->
<input type="hidden" name="liveSite" id="liveSite" value="<?php echo $baseUrl . "/"; ?>">
<div id="load_popup_content" class="modal fade" role="dialog"  tabindex="-1">
</div>
</body>
<div class="an-main-box">
    <img src="img/an.logo-2.png" class="an-logo-2">
    <img src="img/bg-01.png" class="an-bg">
    <img src="img/an.logo.png" class="an-logo">
    <div class="fade-white"></div>
    <div class="cssload-loader">
    <div>
        <div class="cssload-dot"></div>
        <div class="cssload-dot"></div>
        <div class="cssload-dot"></div>
        <div class="cssload-dot"></div>
        <div class="cssload-dot"></div>
        <div class="cssload-dot"></div>
        <div class="cssload-dot"></div>
    </div>
    <div>
        <div class="cssload-dotb"></div>
        <div class="cssload-dotb"></div>
        <div class="cssload-dotb"></div>
        <div class="cssload-dotb"></div>
        <div class="cssload-dotb"></div>
        <div class="cssload-dotb"></div>
        <div class="cssload-dotb"></div>
    </div>
</div>
</div>
</html>