<!-- Start forms -->
<div class="page">
    <div class="content">
        <section class="panel">
                 <div class="top-box">
                    <div class="col-sm-12">
                        <h3><i class="fa fa-money"></i> Expense</h3>
                        <div class="tbl-control">
                          <div class="add-search">
                           <a class="search-ic">
                              <i class="fa fa-search"></i>
                            </a>
                            <div class="tbl-srh">
                            <input type="text" class="serch" placeholder="Search by Name">
                        </div>
                          </div>
                          <div class="">
                          <?php if(Yii::app()->user->authorised_user == 1 || Yii::app()->user->havePermissionOn['accounts_expense_add']){ ?>
                              <a class="btn-add" ripple="ripple" ripple-color="#FFFFFF" data-toggle="modal" onclick="loadPopupModal('expense/create','Add Expense','sm');" id="addModalButton" title="Add">+</a>
                          <?php } ?>    
                          </div>
                        </div>
                        </div>
                    </div>


                <div class="panel-body">
                <div class="table-responsive tbl-zoom">
                 <div class="add-zoom">
                  <small>Text Size</small>
                  <a class="btn btn-default btn-round-sm z-plus"><i class="fa fa-plus"></i></a>
                  <a class="btn btn-default btn-round-sm z-min"><i class="fa fa-minus"></i></a>
                </div>
                    <table id="tbl_expense_table" class="table table-striped table-primary dataTable">
                      <thead>
                        <tr>
                          <th class="text-center">No</th>
                          <th class="text-center">Building</th>
                          <th class="text-center">Flat</th>
                          <th class="text-center">Ledger</th>
                          <th class="text-center">Subledger</th>
                          <th class="text-center">Amount</th>
                          <th class="text-center">Action</th>
                        </tr>
                      </thead>
                      <tbody>
                      <?php
                      foreach ($model as $i=>$row) {
                      ?>
                      	 <tr>
                          <td><?php echo ($i+1);?></td>
                          <td class="nw"><?php echo $row->building_details->building_name;?></td>
                          <td><?php echo isset($row->flat_details) ? $row->flat_details->flat_no : ''; ?></td>
                          <td><?php echo $row->expense_type_details->expense_type;?></td>
                          <td><?php echo isset($row->subledger_details) ? $row->subledger_details->sub_ledger : ''; ?></td>
<!--                          <td><?php //echo $row->landlord_details->name;?></td>-->

                          <td class="text-right"><?php echo Yii::app()->numberFormatter->formatCurrency($row->expense_amount,"");?></td>
                          <td><span class="btn-span">
                          <?php if(Yii::app()->user->authorised_user == 1 || Yii::app()->user->havePermissionOn['accounts_expense_edit']){ ?>
                            <a href="#" onclick="loadPopupModal('expense/create&id=<?php echo $row->id;?>','Edit Expense','sm');" title="Edit"> <i class="fa fa-pencil-square-o"></i> </a>
                          <?php } ?>
                          <?php if(Yii::app()->user->authorised_user == 1 || Yii::app()->user->havePermissionOn['accounts_expense_delete']){ ?>
                            <a href ="#" onclick="deleteExpense(<?php echo $row->id;?>);" title="Delete"><i class="fa fa-trash"></i> </a>
                          <?php } ?>
                          <?php if(Yii::app()->user->authorised_user == 1 || Yii::app()->user->havePermissionOn['accounts_expense_print']){ ?>
                            <a title="Print" onclick="location.href='administrator.php?r=expense/expensePrint&receipt_id=<?php echo $row->id;?>'" hreh="#"><i class="fa fa-print"></i></a>
                          <?php } ?>
                              
                              
                              </span></td>
                        </tr>
                      	<?php
                      }
                      ?>


                      </tbody>
                      <tfoot>
                           <tr>
                            <th colspan="5" class="text-right">Total</th>
                          <th colspan="1" class="text-right"></th>
                          <th colspan="1"></th>
                        </tr>
                      </tfoot>    
                    </table>
                </div>
            </div>
        </section>
    </div>
</div>
<!-- End forms -->
<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("deleteExpense",  "function deleteExpense(id){
    jConfirm('Are you sure to delete this?', 'Confirm', function(r) {
        if(r==true)
        {
            jQuery.ajax({
              'type'  : 'post',
              'data'  : 'id=' + id,
              'url'  : $('#liveSite').val()+'administrator.php?r=expense/delete',
              'cache': false,
              'success':function(data){
                if(data=='fail')
                    jAlert('Expense Cannot be deleted', 'Alert');
                else {
                    location.href=$('#liveSite').val()+'administrator.php?r=expense/index';
                    notification('Expense Deleted SuccessFully!','success');
                }
               }
            });
        }

    });
};", CClientScript::POS_HEAD);
?>
<script>
$(document).ready(function() {
    $('#tbl_expense_table').DataTable().destroy();
        var table =$('#tbl_expense_table').DataTable();
        table.destroy();
        table = $('#tbl_expense_table').DataTable({
           
        footerCallback: function ( row, data, start, end, display ) {
                var api = this.api(), data;
                // Remove the formatting to get integer data for summation
                var intVal = function ( i ) {
                    return typeof i === 'string' ?
                    i.replace(/[\$,]/g, '')*1 :
                    typeof i === 'number' ? i : 0;
                };
                
                // Total over all pages for 5th row
//                       total_revenue = api
//                            .column( 5, {search:'applied'} )
//                            .data()
//                            .reduce( function (a, b) {
//                                return intVal(a) + intVal(b);
//                            },0 );
                // Total over this page
                    pageTotal = api.column( 5, {search:'applied'} )
                            .data()
                            .reduce( function (a, b) {
                            return intVal(a) + intVal(b);
                            }, 0 );
                    
                    
                   $( api.column( 5 ).footer() ).html(
                        Number(parseFloat(pageTotal).toFixed(2)).toLocaleString('en',{minimumFractionDigits: 2})
                    );
          }      
        });
$('#tbl_expense_table tfoot tr').css('display','table-row');
$('#tbl_expense_table tfoot td').css('display','table-cell');
$('#tbl_expense_table tfoot th').css('display','table-cell');
});
</script>


