<?php

/**
 * This is the model class for table "{{user}}".
 *
 * The followings are the available columns in table '{{user}}':
 * @property integer $id
 * @property string $username
 * @property string $password
 * @property string $is_active
 *
 */
class User extends CActiveRecord {

    public $confirm_password;
    public function tableName() {
        return '{{user}}';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('username, first_name, last_name, email, phone, password', 'required'),
            array('username', 'unique'),
            array('username, password, first_name, last_name, email', 'length', 'max' => 255),
            array('owner_id', 'length', 'max' => 11),	
            array('password', 'compare', 'compareAttribute'=>'confirm_password'),
            array('is_active', 'length', 'max' => 1),
            //array('username', 'filter', 'filter'=>'trim'),
            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array('user_id, username, password, is_active', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
                    //'dept' => array(self::BELONGS_TO, 'Department', 'department'),      
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array( 
            'id' => 'ID',
            'username' => 'User Name',
            'first_name' => 'First Name',
            'last_name' => 'Last Name',
            'password' => 'Password',
            'phone' => 'Phone No',
            'email' => 'E-mail',
            'user_group_id' => 'User Group',
            'user_level' => 'Level',
        	'owner_id'	=> 'Tenant',
            'is_active' => 'Active',
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */
    public function search() {
        // @todo Please modify the following code to remove attributes that should not be searched.
		$search= trim(Yii::app()->request->getParam('usersearch'));

		$criteria = new CDbCriteria;
		$criteria->addCondition('is_active="Y"');
                if(!empty($search)){
                    $criteria->addCondition('t.username like "%'.$search.'%" OR t.first_name like "%'.$search.'%" OR t.last_name like "%'.$search.'%" OR t.email like "%'.$search.'%" OR t.phone like "%'.$search.'%" OR t.designation like "%'.$search.'%" ','AND');
                }
  
        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,

            'sort' => array(
                'defaultOrder' => 't.username ASC',
            ),
 
			'pagination'=>array('pageSize'=>Yii::app()->params['defaultPageSize'])
        ));
    }

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return User the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

    /**
     * Authenticates the password.
     * This is the 'authenticate' validator as declared in rules().

    public function authenticate($attribute, $params) {
        if (!$this->hasErrors()) {
            $this->_identity = new UserIdentity($this->username, $this->password);
            if (!$this->_identity->authenticate())
                $this->addError('password', 'Incorrect username or password.');
        }
    }
     */
    /**
     * Logs in the user using the given username and password in the model.
     * @return boolean whether login is successful

    public function login() {
        if ($this->_identity === null) {
            $this->_identity = new UserIdentity($this->username, $this->password);
            $this->_identity->authenticate();
        }
        if ($this->_identity->errorCode === UserIdentity::ERROR_NONE) {
            $duration = $this->rememberMe ? 3600 * 24 * 30 : 0; // 30 days
            Yii::app()->user->login($this->_identity, $duration);
            return true;
        } else {
            return false;
        }
    }

    /* bfeore save function for password enecryption 
     * 
     */

   /*  function beforeSave() {
        if (isset($_POST['User']['password']) && $_POST['User']['password'] != '')
            $this->password = crypt($_POST['User']['password'], $_POST['User']['password']);
        return true;
    }

     */
    public function getFullname() {
        return ($this->first_name . ' ' . $this->last_name);
    }


    public static function getUser() {
         $condition = 'is_active =  "Y"';
        $model = self::model()->findAll(array('condition' => $condition, 'order' => 't.first_name,t.username'));
        return CHtml::listData($model, 'user_id', 'fullname');
    }

    
  public static function getName($id){
      $model = User::model()->findByPk($id);
      return $model->first_name." ".$model->last_name;
  }
}