<?php

/**
 * This is the model class for table "re_tenant".
 *
 * The followings are the available columns in table 're_tenant':
 * @property integer $id
 * @property integer $tenant_code
 * @property integer $name
 * @property string $address1
 * @property string $address2
 * @property string $tel1
 * @property string $tel2
 * @property string $mob1
 * @property string $mob2
 * @property string $email1
 * @property string $email2
 * @property string $fax
 * @property string $contact_person
 * @property string $contact_person_mob
 * @property string $paid_by
 * @property string $mode_of_pay
 * @property string $from_date
 * @property string $to_date
 * @property string $family_bach
 * @property string $tenancy_no
 * @property string $contract_date
 * @property string $contract_exp_date
 * @property string $elect_metr_no
 * @property string $elect_cons_no
 * @property string $water_metr_no
 * @property string $gas_metr_no
 * @property integer $created_by
 * @property string $created_date
 * @property integer $updated_by
 * @property string $updated_date
 */
class Tenant extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return Tenant the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
        public $flat_count;
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 're_tenant';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('name,tel1', 'required'),
			array('created_by, updated_by,building_id', 'numerical', 'integerOnly'=>true),
			array('address1, address2', 'length', 'max'=>250),
                        //array('tel1,tel2','length','min'=>12,'max'=>12),
			//array('mob1,mob2','length','min'=>12,'max'=>12),
                        //array('contact_person_mob','length','min'=>12,'max'=>12),
                        array('tenant_code, name, tel1, tel2, mob1, mob2, email1, email2, fax, contact_person, contact_person_mob', 'length', 'max'=>50),
			array('paid_by, family_bach', 'length', 'max'=>1),
			array('mode_of_pay', 'length', 'max'=>2),
			array('alias,tenancy_no, elect_metr_no, elect_cons_no, water_metr_no, gas_metr_no', 'length', 'max'=>30),
                        //array('flat_id', 'flatRequired'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, tenant_code, name, address1, address2, tel1, tel2, mob1, mob2, email1, email2, fax, contact_person, contact_person_mob, paid_by, mode_of_pay, from_date, to_date, family_bach, tenancy_no, contract_date, contract_exp_date, elect_metr_no, elect_cons_no, water_metr_no, gas_metr_no, created_by, created_date, updated_by, updated_date', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
        public function flatRequired($attribute,$params)
        {			
            if($this->flat_count > 0)
            {   
                if($this->flat_id == '')
                $this->addError($attribute, 'Flat cannot be blank');			
            }        
                
        }
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
				'flat' => array(self::BELONGS_TO, 'Flat', 'flat_id'),
				'user' =>  array(self::HAS_MANY, 'User', 'tenant_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'tenant_code' => 'Tenant Code',
			'name' => 'Name',
			'address1' => 'Address1',
			'address2' => 'Address2',
			'tel1' => 'Tel1',
			'tel2' => 'Tel2',
			'mob1' => 'Mob1',
			'mob2' => 'Mob2',
			'email1' => 'Email1',
			'email2' => 'Email2',
			'fax' => 'Fax',
			'contact_person' => 'Contact Person',
			'contact_person_mob' => 'Contact Person Mob',
			'paid_by' => 'Paid By',
			'mode_of_pay' => 'Mode Of Pay',
			'from_date' => 'From Date',
			'to_date' => 'To Date',
			'family_bach' => 'Family Bach',
			'tenancy_no' => 'Tenancy No',
			'contract_date' => 'Contract Date',
			'contract_exp_date' => 'Contract Exp Date',
			'elect_metr_no' => 'Elect Metr No',
			'elect_cons_no' => 'Elect Cons No',
			'water_metr_no' => 'Water Metr No',
			'gas_metr_no' => 'Gas Metr No',
			'flat_id' => 'Flat',
			'building_id' => 'Building',
			'created_by' => 'Created By',
			'created_date' => 'Created Date',
			'updated_by' => 'Updated By',
			'updated_date' => 'Updated Date',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('tenant_code',$this->tenant_code);
		$criteria->compare('name',$this->name);
		$criteria->compare('address1',$this->address1,true);
		$criteria->compare('address2',$this->address2,true);
		$criteria->compare('tel1',$this->tel1,true);
		$criteria->compare('tel2',$this->tel2,true);
		$criteria->compare('mob1',$this->mob1,true);
		$criteria->compare('mob2',$this->mob2,true);
		$criteria->compare('email1',$this->email1,true);
		$criteria->compare('email2',$this->email2,true);
		$criteria->compare('fax',$this->fax,true);
		$criteria->compare('contact_person',$this->contact_person,true);
		$criteria->compare('contact_person_mob',$this->contact_person_mob,true);
		$criteria->compare('paid_by',$this->paid_by,true);
		$criteria->compare('mode_of_pay',$this->mode_of_pay,true);
		$criteria->compare('from_date',$this->from_date,true);
		$criteria->compare('to_date',$this->to_date,true);
		$criteria->compare('family_bach',$this->family_bach,true);
		$criteria->compare('tenancy_no',$this->tenancy_no,true);
		$criteria->compare('contract_date',$this->contract_date,true);
		$criteria->compare('contract_exp_date',$this->contract_exp_date,true);
		$criteria->compare('elect_metr_no',$this->elect_metr_no,true);
		$criteria->compare('elect_cons_no',$this->elect_cons_no,true);
		$criteria->compare('water_metr_no',$this->water_metr_no,true);
		$criteria->compare('gas_metr_no',$this->gas_metr_no,true);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('created_date',$this->created_date,true);
		$criteria->compare('updated_by',$this->updated_by);
		$criteria->compare('updated_date',$this->updated_date,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
	public static function getList() {
        $model = self::model()->findAll(array('condition' =>'status="Y"'));
            $list =  CHtml::listData($model, 'id', 'name');
            return $list;
        }
        
        public static function getAllTenant() {
        	$condition = 'status =  "Y"';
        	$model = self::model()->findAll(array('condition' => $condition));
        	return CHtml::listData($model, 'id', 'name');
        }
}