<?php

/**
 * This is the model class for table "re_subcontractors".
 *
 * The followings are the available columns in table 're_subcontractors':
 * @property integer $id
 * @property integer $maintenance_id
 * @property string $subcontractor_name
 * @property string $tel
 * @property string $status
 * @property integer $created_by
 * @property integer $updated_by
 * @property string $created_date
 * @property string $updated_date
 */
class Subcontractors extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return Subcontractors the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 're_subcontractors';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('maintenance_id, subcontractor_name, tel', 'required'),
			array('maintenance_id, created_by, updated_by,tel', 'numerical', 'integerOnly'=>true),
			array('subcontractor_name', 'length', 'max'=>50),
			array('tel,contact_person_mob', 'length','min'=>12, 'max'=>12),
                        array('notes,email', 'length', 'max'=>250),
			array('status', 'length', 'max'=>1),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, maintenance_id, subcontractor_name, tel,email, status, created_by, updated_by, created_date, updated_date', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(

				'maintenance_work' => array(self::BELONGS_TO, 'MaintenanceWorks', 'maintenance_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'maintenance_id' => 'Maintenance',
			'subcontractor_name' => 'Subcontractor Name',
			'tel' => 'Telephone No',
			'email' =>'Email',	
			'status' => 'Status',
			'created_by' => 'Created By',
			'updated_by' => 'Updated By',
			'created_date' => 'Created Date',
			'updated_date' => 'Updated Date',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('maintenance_id',$this->maintenance_id);
		$criteria->compare('subcontractor_name',$this->subcontractor_name,true);
		$criteria->compare('tel',$this->tel,true);
		$criteria->compare('status',$this->status,true);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('updated_by',$this->updated_by);
		$criteria->compare('created_date',$this->created_date,true);
		$criteria->compare('updated_date',$this->updated_date,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
         public static function getList() {
        	$model = self::model()->findAll();
        	return CHtml::listData($model, 'id', 'subcontractor_name');
        }
}