<?php

/**
 * This is the model class for table "{{payment}}".
 *
 * The followings are the available columns in table '{{payment}}':
 * @property integer $id
 * @property string $payment_date
 * @property integer $flat_id
 * @property integer $transaction_type
 * @property integer $payment_type
 * @property string $amount
 * @property string $realisation_date
 * @property string $cheque_date
 * @property string $bank_id
 * @property string $cheque_no
 * @property string $payee_name
 * @property string $remarks
 * @property integer $status
 * @property integer $created_by
 * @property string $created_date
 * @property integer $updated_by
 * @property string $updated_date
 */
class Receipt extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
        public $date1;
        public $date2;
        public $realisation_date1;
        public $realisation_date2;
        public $cheque_date1;
        public $cheque_date2;
        public $flat_count;
        public function tableName()
	{
		return '{{lease_receipt}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('payment_date, building_id, transaction_type, payment_type,lease_id, amount', 'required'),
			array('flat_id, transaction_type, payment_type, status, created_by, updated_by,lease_id,bank_id ', 'numerical', 'integerOnly'=>true),
			array('amount,cheque_date', 'length', 'max'=>15),
                        array('flat_id', 'flatRequired'),
			array('cheque_no,realisation_date,remarks', 'length', 'max'=>255),
			array('id,receipt_no, payment_date, building_id,flat_id,lease_id, transaction_type, payment_type, amount, realisation_date, cheque_date, bank_id, cheque_no, remarks, status, created_by, created_date, updated_by, updated_date', 'safe', 'on'=>'search'),
		);
	}
        public function flatRequired($attribute,$params)
        {			
            if($this->flat_count > 0)
            {   
                if($this->flat_id == '')
                $this->addError($attribute, 'Flat cannot be blank');			
            }        
                
        }
	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
				'building_details' => array(self::BELONGS_TO, 'Building', 'building_id'),
                                'flat' => array(self::BELONGS_TO, 'Flat', 'flat_id'),
				'transtype' => array(self::BELONGS_TO, 'TransactionType', 'transaction_type'),
				'tenant' => array(self::BELONGS_TO, 'Tenant', 'flat_id'),
                                'lease' => array(self::BELONGS_TO, 'Lease', 'lease_id'),
                                'bank_details' => array(self::BELONGS_TO, 'MasterBank', 'bank_id'),
                                'company_bank_details' => array(self::BELONGS_TO, 'MasterBank', 'company_bank_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
                        'receipt_no'=>'Receipt No',
			'payment_date' => 'Payment Date',
			'building_id' => 'Building',	
			'flat_id' => 'Flat',
                        'lease_id' => 'Lease Code',
			'transaction_type' => 'Transaction Type',
			'payment_type' => 'Receipt Type(1-Cash,2-Cheque)',
			'amount' => 'Amount',
			'realisation_date' => 'Realisation Date',
			'cheque_date' => 'Cheque Date',
			'bank_id' => 'Bank Name',
                        'company_bank_id'=>'Company Bank',
			'cheque_no' => 'Cheque No',
			'remarks' => 'Remarks',
			'status' => 'Status(1-Completed,2-Bounced,3-Cancelled)',
			'created_by' => 'Created By',
			'created_date' => 'Created Date',
			'updated_by' => 'Updated By',
			'updated_date' => 'Updated Date',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('payment_date',$this->payment_date,true);
		$criteria->compare('building_id',$this->building_id);
		$criteria->compare('flat_id',$this->flat_id);
		$criteria->compare('lease_id',$this->lease_id);
                $criteria->compare('transaction_type',$this->transaction_type);
		$criteria->compare('payment_type',$this->payment_type);
		$criteria->compare('amount',$this->amount,true);
		$criteria->compare('realisation_date',$this->realisation_date,true);
		$criteria->compare('cheque_date',$this->cheque_date,true);
		$criteria->compare('bank_id',$this->bank_id,true);
		$criteria->compare('cheque_no',$this->cheque_no,true);
		$criteria->compare('remarks',$this->remarks,true);
		$criteria->compare('status',$this->status);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('created_date',$this->created_date,true);
		$criteria->compare('updated_by',$this->updated_by);
		$criteria->compare('updated_date',$this->updated_date,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return Payment the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
	
	public static function getPaymentStatus($status) {
		switch ($status) {
			case '1':
				return "Completed";
				break;
			case '2':
				return "Bounced";
				break;
			case '3':
				return "Cancelled";
				break;
			default:
				return "In Process";
				break;
		}
	}
	
	public static function getPaymentType($type) {
		switch ($type) {
			case '1':
				return "Cash";
				break;
			case '2':
				return "Cheque";
				break;
			default:
				return "";
				break;
		}
	}
}
