<?php

/**
 * This is the model class for table "{{payment}}".
 *
 * The followings are the available columns in table '{{payment}}':
 * @property integer $id
 * @property string $payment_date
 * @property integer $landlord_id
 * @property integer $transaction_type
 * @property integer $payment_type
 * @property string $amount
 * @property string $realisation_date
 * @property string $cheque_date
 * @property string $bank_name
 * @property string $cheque_no
 * @property string $payee_name
 * @property string $remarks
 * @property integer $status
 * @property integer $created_by
 * @property string $created_date
 * @property integer $updated_by
 * @property string $updated_date
 */
class Payment extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
        public $date1;
        public $date2;
        public $realisation_date1;
        public $realisation_date2;
        public $cheque_date1;
        public $cheque_date2;
        public $landowner_count;
        public function tableName()
	{
		return '{{mortgage_payment}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('payment_date, building_id,payment_type, amount', 'required'),
			array('landlord_id, transaction_type, payment_type, status, created_by, updated_by', 'numerical', 'integerOnly'=>true),
			array('amount,cheque_date', 'length', 'max'=>15),
			array('cheque_no,realisation_date,remarks', 'length', 'max'=>255),
                        array('landlord_id','landlordRequired'),
			array('id, payment_date, building_id,landlord_id, transaction_type, payment_type, amount, realisation_date, cheque_date, bank_id, cheque_no, remarks, status, created_by, created_date, updated_by, updated_date', 'safe', 'on'=>'search'),
		);
	}
        public function landlordRequired($attribute,$params)
        {			
            if($this->landowner_count > 0)
            {   
                if($this->landlord_id == '')
                $this->addError($attribute, 'Landlord cannot be blank');			
            }        
                
        }
	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
                        'landlord_details' => array(self::BELONGS_TO, 'Landlord', 'landlord_id'),
                        'building_details' => array(self::BELONGS_TO, 'Building', 'building_id'),
                        'flat_details' => array(self::BELONGS_TO, 'Flat', 'flat_id'),
                        'transtype' => array(self::BELONGS_TO, 'TransactionType', 'transaction_type'),
                        'bank_details' => array(self::BELONGS_TO, 'MasterBank', 'bank_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'payment_date'  => 'Payment Date',
			'building_id'   => 'Building',	
			'landlord_id'   => 'Land Owner',
                        'transaction_type' => 'Transaction Type',
			'payment_type'  => '1-Cash,2-Cheque',
			'amount'        => 'Amount',
			'realisation_date' => 'Realisation Date',
			'cheque_date'   => 'Cheque Date',
			'bank_name'     => 'Bank Name',
			'cheque_no'     => 'Cheque No',
			'remarks'       => 'Remarks',
			'status'        => '1-Completed,2-Bounced,3-Cancelled',
			'created_by'    => 'Created By',
			'created_date'  => 'Created Date',
			'updated_by'    => 'Updated By',
			'updated_date'  => 'Updated Date',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('payment_date',$this->payment_date,true);
		$criteria->compare('building_id',$this->building_id);
		$criteria->compare('landlord_id',$this->landlord_id);
		$criteria->compare('transaction_type',$this->transaction_type);
		$criteria->compare('payment_type',$this->payment_type);
		$criteria->compare('amount',$this->amount,true);
		$criteria->compare('realisation_date',$this->realisation_date,true);
		$criteria->compare('cheque_date',$this->cheque_date,true);
		$criteria->compare('bank_name',$this->bank_name,true);
		$criteria->compare('cheque_no',$this->cheque_no,true);
		$criteria->compare('remarks',$this->remarks,true);
		$criteria->compare('status',$this->status);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('created_date',$this->created_date,true);
		$criteria->compare('updated_by',$this->updated_by);
		$criteria->compare('updated_date',$this->updated_date,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return Payment the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
	
	public static function getPaymentStatus($status) {
		switch ($status) {
			case '1':
				return "Completed";
				break;
			case '2':
				return "Bounced";
				break;
			case '3':
				return "Cancelled";
				break;
			default:
				return "In Process";
				break;
		}
	}
	
	public static function getPaymentType($type) {
		switch ($type) {
			case '1':
				return "Cash";
				break;
			case '2':
				return "Cheque";
				break;
			default:
				return "";
				break;
		}
	}
        public static function listFrequency() {
		$arr_frequency = Array (0=>'Monthly',1 => 'Quaterly', 2 =>'HalfYearly',3 =>'Yearly' );
                return $arr_frequency;
	}
}
