<?php

/**
 * This is the model class for table "{{onetime_payments}}".
 *
 * The followings are the available columns in table '{{onetime_payments}}':
 * @property integer $id
 * @property string $paying_date
 * @property integer $building_id
 * @property string $pay_name
 * @property string $amount
 * @property string $description
 * @property integer $status
 * @property integer $created_by
 * @property string $created_date
 * @property integer $updated_by
 * @property string $updated_date
 */
class OnetimePayments extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{onetime_payments}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('paying_date, building_id, pay_name, amount,payment_type', 'required'),
			array('building_id, status, created_by, updated_by,bank_id', 'numerical', 'integerOnly'=>true),
			array('pay_name', 'length', 'max'=>100),
			array('amount', 'length', 'max'=>15),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, paying_date, building_id, pay_name, amount,payment_type,cheque_date,bank_id,cheque_no, description, status, created_by, created_date, updated_by, updated_date', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
                    'building_details' => array(self::BELONGS_TO, 'Building', 'building_id'),
                    'bank_details' => array(self::BELONGS_TO, 'MasterBank', 'bank_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'paying_date' => 'Paying Date',
			'building_id' => 'Building',
			'pay_name' => 'Pay Name',
			'amount' => 'Amount',
                        'payment_type' => 'Payment Type',
			'cheque_date' => 'Cheque Date',
			'bank_id' => 'Bank Name',
			'cheque_no' => 'Cheque No',
			'description' => 'Description',
			'status' => 'Status',
			'created_by' => 'Created By',
			'created_date' => 'Created Date',
			'updated_by' => 'Updated By',
			'updated_date' => 'Updated Date',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('paying_date',$this->paying_date,true);
		$criteria->compare('building_id',$this->building_id);
		$criteria->compare('pay_name',$this->pay_name,true);
		$criteria->compare('amount',$this->amount,true);
                $criteria->compare('payment_type',$this->payment_type,true);
		$criteria->compare('cheque_date',$this->cheque_date);
		$criteria->compare('bank_id',$this->bank_id,true);
		$criteria->compare('cheque_no',$this->cheque_no,true);
		$criteria->compare('description',$this->description,true);
		$criteria->compare('status',$this->status);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('created_date',$this->created_date,true);
		$criteria->compare('updated_by',$this->updated_by);
		$criteria->compare('updated_date',$this->updated_date,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return OnetimePayments the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
        public static function getPaymentType($type) {
		switch ($type) {
			case '1':
				return "Cash";
				break;
			case '2':
				return "Cheque";
				break;
			default:
				return "";
				break;
		}
	}
}
