<?php

/**
 * This is the model class for table "re_maintenance".
 *
 * The followings are the available columns in table 're_maintenance':
 * @property integer $id
 * @property integer $tenant_id
 * @property integer $building_id
 * @property integer $flat_id
 * @property integer $maintenance_work_id
 * @property integer $subcontract_id
 * @property integer $status
 * @property string $remark
 */
class Maintenance extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return Complaint the static model class
	 */
	public $tenant_name;
	public $building_name;
	public $flat_name;
        public $flat_count;
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 're_maintenance';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('building_id, maintenance_work_id,maintenance_type,remark', 'required'),
			array('tenant_id, building_id, flat_id, maintenance_work_id, subcontract_id, status', 'numerical', 'integerOnly'=>true),
			array('remark,maintenance_date_time,prefered_time', 'length', 'max'=>255),
                        array('flat_id', 'flatRequired'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, tenant_id, building_id, flat_id, maintenance_work_id, subcontract_id, status, remark,maintenance_date_time', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
        public function flatRequired($attribute,$params)
        {			
            if($this->flat_count > 0)
            {   
                if($this->flat_id == '')
                $this->addError($attribute, 'Flat cannot be blank');			
            }        
                
        }
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
				'flat' => array(self::BELONGS_TO, 'Flat', 'flat_id'),
                                'building' => array(self::BELONGS_TO, 'Building', 'building_id'),
				'tenant' => array(self::BELONGS_TO, 'Tenant', 'tenant_id'),
				'maintenancetype' => array(self::BELONGS_TO, 'MaintenanceWorks', 'maintenance_work_id'),
				'subcontractor' => array(self::BELONGS_TO, 'Subcontractors', 'subcontract_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'tenant_id' => 'Tenant',
			'building_id' => 'Building',
			'Maintenance Date Time' => 'Maintenance Date Time',	
			'flat_id' => 'Flat',
			'maintenance_work_id' => 'Maintenance Work',
			'subcontract_id' => 'Subcontract',
			'maintenance_type' => 'Maintenance Type',	
			'status' => 'Status',
			'remark' => 'Remark',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('tenant_id',$this->tenant_id);
		$criteria->compare('building_id',$this->building_id);
		$criteria->compare('flat_id',$this->flat_id);
		$criteria->compare('maintenance_work_id',$this->maintenance_work_id);
		$criteria->compare('subcontract_id',$this->subcontract_id);
		$criteria->compare('status',$this->status);
		$criteria->compare('remark',$this->remark,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
	
	public static function getMaintenanceStatus($type) {
		switch ($type) {
			case '1':
				return "Completed";
				break;
			default:
				return "In Process";
				break;
		}
	}
	public static function getMaintenanceType($type) {
		switch ($type) {
			case '1':
				return "Low";
				break;
			case '2':
				return "Normal";
				break;
			case '3':
				return "Critical";
				break;
			default:
				return "Low";
				break;
		}
	}
}