<?php

/**
 * This is the model class for table "re_lease".
 *
 * The followings are the available columns in table 're_lease':
 * @property integer $id
 * @property string $lease_code
 * @property integer $tenant_id
 * @property integer $flat_id
 * @property string $from_date
 * @property string $to_date
 * @property integer $created_by
 * @property string $created_date
 * @property integer $updated_by
 * @property string $updated_date
 */
class Lease extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return Lease the static model class
	 */
    public $flat_count;
        
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 're_lease';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('tenant_id,lease_code,building_id,from_date,to_date,flat_status,lease_amount', 'required'),
			array('tenant_id, flat_id, created_by, updated_by', 'numerical', 'integerOnly'=>true),
			array('lease_code', 'length', 'max'=>25),
                        array('flat_id', 'flatRequired'),
			
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, lease_code, tenant_id, flat_id, from_date,lease_amount, to_date, created_by,flat_status, created_date, updated_by, updated_date', 'safe', 'on'=>'search'),
		);
	}
        public function flatRequired($attribute,$params)       
        {	
            if($this->flat_count>0)			
            {          
                if($this->flat_id == '')
                $this->addError($attribute, 'Flat cannot be blank');	
            }                       
        }
	
	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
                                'building' => array(self::BELONGS_TO, 'Building', 'building_id'),
				'flat' => array(self::BELONGS_TO, 'Flat', 'flat_id'),
				'tenant' => array(self::BELONGS_TO, 'Tenant', 'tenant_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'lease_code' => 'Lease Code',
			'tenant_id' => 'Tenant',
			'flat_id' => 'Flat',
			'from_date' => 'From Date',
			'to_date' => 'To Date',
                        'lease_amount' =>'Lease Amount',
			'created_by' => 'Created By',
			'created_date' => 'Created Date',
			'updated_by' => 'Updated By',
			'updated_date' => 'Updated Date',
                        'flat_status'=>'Status'
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('lease_code',$this->lease_code,true);
		$criteria->compare('tenant_id',$this->tenant_id);
		$criteria->compare('flat_id',$this->flat_id);
		$criteria->compare('lease_amount',$this->lease_amount);
		$criteria->compare('from_date',$this->from_date,true);
		$criteria->compare('to_date',$this->to_date,true);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('created_date',$this->created_date,true);
		$criteria->compare('updated_by',$this->updated_by);
		$criteria->compare('updated_date',$this->updated_date,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
        public static function getTenantDetail($flat_id) {
                $model = array();
                $date = date('Y-m-d');
        	$condition = 't.flat_id='.$flat_id.' AND t.from_date <= "'.$date.'" and t.to_date >= "'.$date.'"';
                $model = self::model()->with('flat','tenant')->find(array('condition' => $condition));
        	return $model;
        }
        public static function getFlatLease($flat_id) {
                $model = self::model()->findAll(array('condition'=>'flat_id="'.$flat_id.'"','order'=>'lease_code'));
		return CHtml::listData($model, 'id', 'lease_code');
        }
    }