<?php

/**
 * This is the model class for table "re_landlord".
 *
 * The followings are the available columns in table 're_landlord':
 * @property integer $id
 * @property string $landlord_code
 * @property string $name
 * @property string $address1
 * @property string $address2
 * @property string $tel1
 * @property string $tel2
 * @property string $mob1
 * @property string $mob2
 * @property string $email1
 * @property string $email2
 * @property string $fax
 * @property string $contact_person
 * @property string $contact_person_mob
 * @property string $status
 * @property integer $created_by
 * @property string $created_date
 * @property integer $updated_by
 * @property string $updated_date
 */
class Landlord extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return Landlord the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 're_landlord';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('name, mob1', 'required'),
			array('created_by, updated_by', 'numerical', 'integerOnly'=>true),
			array('alias,landlord_code, name', 'length', 'max'=>30),
			array('address1, address2', 'length', 'max'=>250),
                       // array('tel1,tel2','length','min'=>12,'max'=>12),
                       // array('mob1,mob2','length','min'=>12,'max'=>12),
                       // array('contact_person_mob','length','min'=>12,'max'=>12),
			array('passport, nationality, mob1, mob2, email1,emirates_id, contact_person, contact_person_mob', 'length', 'max'=>50),
			array('status', 'length', 'max'=>1),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, landlord_code, name, address1, address2, passport, nationality, mob1, mob2, email1, emirated_id, passport_expiry, contact_person, contact_person_mob, status, created_by, created_date, updated_by, updated_date', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'landlord_code' => 'Landlord Code',
			'name' => 'Name',
			'address1' => 'Address1',
			'address2' => 'Address2',
			'passport' => 'Passport',
			'nationality' => 'Nationality',
			'mob1' => 'Mobile',
			'mob2' => 'Mobile 2',
			'email1' => 'Email1',
			'emirates_id' => 'Emirates ID',
			'passport_expiry' => 'Passport Expiry',
			'contact_person' => 'Contact Person',
			'contact_person_mob' => 'Contact Person Mob',
			'status' => 'Status',
			'created_by' => 'Created By',
			'created_date' => 'Created Date',
			'updated_by' => 'Updated By',
			'updated_date' => 'Updated Date',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('landlord_code',$this->landlord_code,true);
		$criteria->compare('name',$this->name,true);
		$criteria->compare('address1',$this->address1,true);
		$criteria->compare('address2',$this->address2,true);
		$criteria->compare('passport',$this->passport,true);
		$criteria->compare('nationality',$this->nationality,true);
		$criteria->compare('mob1',$this->mob1,true);
		$criteria->compare('mob2',$this->mob2,true);
		$criteria->compare('email1',$this->email1,true);
		$criteria->compare('emirates_id',$this->emirates_id,true);
		$criteria->compare('passport_expiry',$this->passport_expiry,true);
		$criteria->compare('contact_person',$this->contact_person,true);
		$criteria->compare('contact_person_mob',$this->contact_person_mob,true);
		$criteria->compare('status',$this->status,true);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('created_date',$this->created_date,true);
		$criteria->compare('updated_by',$this->updated_by);
		$criteria->compare('updated_date',$this->updated_date,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
	
	public static function getAllLandlord() {
		$condition = 'status =  "Y"';
		$model = self::model()->findAll(array('condition' => $condition,'order'=>'name'));
		return CHtml::listData($model, 'id', 'name');
	}
         public static function getLandlordName($id) {
        	$model = self::model()->findByPk($id);
			if(!empty($model)){
				return $model->name;
			}else{
				return false;
			}
        	
        }
}