<?php

/**
 * This is the model class for table "{{flat_notes}}".
 *
 * The followings are the available columns in table '{{flat_notes}}':
 * @property integer $id
 * @property string $reminder_date
 * @property string $notes
 * @property integer $note_status
 * @property integer $flat_id
 * @property integer $created_by
 * @property string $created_user
 * @property string $building_name
 * @property string $building_class_name
 * @property string $landlord_name
 * @property string $tenant_name
 * @property string $created_date_time
 * @property integer $updated_by
 * @property string $updated_date_time
 */
class FlatNotes extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	
	public $building_name;
	public $flat_name;
	
	public function tableName()
	{
		return '{{flat_notes}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('reminder_date, notes, flat_id', 'required'),
			array('id, note_status, flat_id, created_by, updated_by', 'numerical', 'integerOnly'=>true),
			array('created_user, building_name, building_class_name, landlord_name, tenant_name', 'length', 'max'=>255),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, reminder_date, notes, note_status, flat_id, created_by, created_user, building_name, building_class_name, landlord_name, tenant_name, created_date_time, updated_by, updated_date_time', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
				'flat' => array(self::BELONGS_TO, 'Flat', 'flat_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'reminder_date' => 'Reminder Date',
			'notes' => 'Notes',
			'note_status' => 'Note Status',
			'flat_id' => 'Flat',
			'created_by' => 'Created By',
			'created_user' => 'Created User',
			'building_name' => 'Building Name',
			'building_class_name' => 'building Class Name',
			'landlord_name' => 'Landlord Name',
			'tenant_name' => 'Tenant Name',
			'created_date_time' => 'Created Date Time',
			'updated_by' => 'Updated By',
			'updated_date_time' => 'Updated Date Time',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('reminder_date',$this->reminder_date,true);
		$criteria->compare('notes',$this->notes,true);
		$criteria->compare('note_status',$this->note_status);
		$criteria->compare('flat_id',$this->flat_id);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('created_user',$this->created_user,true);
		$criteria->compare('building_name',$this->building_name,true);
		$criteria->compare('building_class_name',$this->building_class_name,true);
		$criteria->compare('landlord_name',$this->landlord_name,true);
		$criteria->compare('tenant_name',$this->tenant_name,true);
		$criteria->compare('created_date_time',$this->created_date_time,true);
		$criteria->compare('updated_by',$this->updated_by);
		$criteria->compare('updated_date_time',$this->updated_date_time,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return FlatNotes the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
