<?php

/**
 * This is the model class for table "{{flat}}".
 *
 * The followings are the available columns in table '{{flat}}':
 * @property integer $id
 * @property integer $building_id
 * @property string $block
 * @property string $floor
 * @property string $flat_no
 * @property integer $flat_type
 * @property integer $building_class_id
 * @property integer $landlord_id
 * @property integer $tenant_id
 * @property string $amount
 * @property integer $squarefeet
 * @property integer $status
 * @property integer $created_by
 * @property string $created_date
 * @property integer $updated_by
 * @property string $updated_date
 */
class Flat extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{flat}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('building_id,floor, flat_no, flat_type, building_class_id,squarefeet', 'required'),
			array('building_id, flat_type, building_class_id, landlord_id, tenant_id, status, created_by, updated_by', 'numerical', 'integerOnly'=>true),
			array('block, floor, flat_no', 'length', 'max'=>255),
			array('amount', 'length', 'max'=>15),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, building_id, block, floor, flat_no, flat_type, building_class_id,construction_status, landlord_id, tenant_id, amount,squarefeet, status, created_by, created_date, updated_by, updated_date', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
				'building' => array(self::BELONGS_TO, 'Building', 'building_id'),
                                'buildings' => array(self::BELONGS_TO, 'Building', 'building_id'),
				'building_class' => array(self::BELONGS_TO, 'BuildingClass', 'building_class_id'),
				'landlord' => array(self::BELONGS_TO, 'Landlord', 'landlord_id'),
				'tenant' => array(self::BELONGS_TO, 'Tenant', 'tenant_id'),
                                'ownerdetail' => array(self::HAS_MANY, 'BuildingOwnerDetails', 'flat'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'building_id' => 'Building',
			'block' => 'Block',
			'floor' => 'Floor',
			'flat_no' => 'Flat No',
			'flat_type' => '1-Residential,2-Commercial',
			'building_class_id' => 'Building Class',
			'landlord_id' => 'Landlord',
			'tenant_id' => 'Tenant',
			'amount' => 'Amount',
			'squarefeet'=>'No of squarefeet',
			'status' => '1-Vaccant,2-Occupied,3-Hold',
			'created_by' => 'Created By',
			'created_date' => 'Created Date',
			'updated_by' => 'Updated By',
			'updated_date' => 'Updated Date',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('building_id',$this->building_id);
		$criteria->compare('block',$this->block,true);
		$criteria->compare('floor',$this->floor,true);
		$criteria->compare('flat_no',$this->flat_no,true);
		$criteria->compare('flat_type',$this->flat_type);
		$criteria->compare('building_class_id',$this->building_class_id);
		$criteria->compare('landlord_id',$this->landlord_id);
		$criteria->compare('tenant_id',$this->tenant_id);
		$criteria->compare('amount',$this->amount,true);
		$criteria->compare('squarefeet',$this->squarefeet,true);
		$criteria->compare('status',$this->status);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('created_date',$this->created_date,true);
		$criteria->compare('updated_by',$this->updated_by);
		$criteria->compare('updated_date',$this->updated_date,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return ReFlat the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
	
	public static function getFlatStatus($status) {
		switch ($status) {
			case '1':
				return "Vaccant";
				break;
			case '2':
				return "Occupied";
				break;
			case '3':
				return "Hold";
				break;
			default:
				return "";
				break;
		}
	}
	
	public static function getFlatType($type) {
		switch ($type) {
			case '1':
				return "Residential";
				break;
			case '2':
				return "Commercial";
				break;
			default:
				return "";
				break;
		}
	}
	
	public static function getAllFlat() {
		$model = self::model()->findAll(array('order'=>'flat_no'));
		return CHtml::listData($model, 'id', 'flat_no');
	}
        public static function getPurchasedFlat() {
		$model = self::model()->findAll(array('condition'=>'purchase_status="1"','order'=>'flat_no'));
		return CHtml::listData($model, 'id', 'flat_no');
	}
        public static function getBuildingFlat($building_id) {
		$model = self::model()->findAll(array('condition'=>'building_id="'.$building_id.'"','order'=>'flat_no'));
		return CHtml::listData($model, 'id', 'flat_no');
	}
        public static function getFlatName($id) {
        	$model = self::model()->findByPk($id);
        	return $model->flat_no;
        }
        public static function getVacantFlatBuilding() {
		$model = self::model()->with('building')->findAll(array('condition'=>'t.status="1"','order'=>'building.building_name'));
		return CHtml::listData($model, 'building_id', 'building.building_name');
	}
        public static function getOccupiedFlatBuilding() {
		$model = self::model()->with('building')->findAll(array('condition'=>'t.status="2"','order'=>'building.building_name'));
		return CHtml::listData($model, 'building_id', 'building.building_name');
	}
        public static function getUnderConstructionFlatBuilding() {
		$model = self::model()->with('building')->findAll(array('condition'=>'t.construction_status="2"','order'=>'building.building_name'));
		return CHtml::listData($model, 'building_id', 'building.building_name');
	}
}
