<?php

/**
 * This is the model class for table "{{onetime_payments}}".
 *
 * The followings are the available columns in table '{{onetime_payments}}':
 * @property integer $id
 * @property string $paying_date
 * @property integer $building_id
 * @property string $pay_name
 * @property string $amount
 * @property string $description
 * @property integer $status
 * @property integer $created_by
 * @property string $created_date
 * @property integer $updated_by
 * @property string $updated_date
 */
class Finance extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{finance}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('down_payment,payment_date', 'required'),
			array('down_payment', 'length', 'max'=>15),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, down_payment,building_id,loan_amount,pdc_amount,loan_percen,installment_no, payment_date,cheque_date,cheque_no,interest_percen,interest_type, created_by, created_date_time, updated_by, updated_date_time', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
                    'building_details' => array(self::BELONGS_TO, 'Building', 'building_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'down_payment' => 'Down Payment',
			'building_id' => 'Building',
			'payment_date' => 'Payment Date',
                        'loan_amount' => 'Loan Amount',
			'cheque_date' => 'Cheque Date',
			'cheque_no' => 'Cheque No',
			'interest_percen' => 'Percentage',
			'interest_type' => 'Type',
                        'loan_percen' => 'Loan percentage',
			'installment_no' => 'Installment No',
			'pdc_amount' => 'Amount',
			'created_by' => 'Created By',
			'created_date_time' => 'Created Date',
			'updated_by' => 'Updated By',
			'updated_date_time' => 'Updated Date',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('payment_date',$this->payment_date,true);
		$criteria->compare('building_id',$this->building_id);
		$criteria->compare('down_payment',$this->down_payment,true);
                $criteria->compare('loan_amount',$this->loan_amount,true);
		$criteria->compare('cheque_date',$this->cheque_date);
		$criteria->compare('cheque_no',$this->cheque_no,true);
		$criteria->compare('interest_percen',$this->interest_percen,true);
		$criteria->compare('interest_type',$this->interest_type);
                $criteria->compare('loan_percen',$this->loan_percen,true);
		$criteria->compare('installment_no',$this->installment_no,true);
		$criteria->compare('pdc_amount',$this->pdc_amount);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('created_date_time',$this->created_date_time,true);
		$criteria->compare('updated_by',$this->updated_by);
		$criteria->compare('updated_date_time',$this->updated_date_time,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return OnetimePayments the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
        public function getInterestType($type) {
		switch ($type) {
			case '1':
				return "Flat";
				break;
			case '2':
				return "Diminishing";
				break;
			default:
				return "";
				break;
		}
	}
}
