<?php

/**
 * This is the model class for table "re_building_class".
 *
 * The followings are the available columns in table 're_building_class':
 * @property integer $id
 * @property string $class_name
 * @property string $facilities
 * @property string $rent
 * @property string $min_rent
 * @property string $created_date
 * @property string $updated_date
 * @property integer $created_by
 * @property integer $updated_by
 */
class Expense extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return BuildingClass the static model class
	 */
        public $subledger_count;
        
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 're_expense';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('expense_type,building_id,expense_amount', 'required'),
                        array('expense_amount', 'length', 'max'=>15),
                        array('remarks', 'length', 'max'=>255),
                        array('subledger_id', 'subLedgerRequired'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, expense_type,flat_id,remarks,status,expense_date,bank_id,created_by,created_date,updated_by,updated_date', 'safe', 'on'=>'search'),
		);
	}

 	public function subLedgerRequired($attribute,$params)
        {			
            if($this->subledger_count > 0)
            {   
                if($this->subledger_id == '')
                $this->addError($attribute, 'Subledger cannot be blank');			
            }        
                
        }
	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
                    'expense_type_details' => array(self::BELONGS_TO, 'ExpenseType', 'expense_type'),
                    'flat_details' => array(self::BELONGS_TO, 'Flat', 'flat_id'),
                    'subledger_details' => array(self::BELONGS_TO, 'SubLedger', 'subledger_id'),
                    'landlord_details' => array(self::BELONGS_TO, 'Landlord', 'landlord_id'),
                    'building_details' => array(self::BELONGS_TO, 'Building', 'building_id'),
                    'bank_details' => array(self::BELONGS_TO, 'MasterBank', 'bank_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
                    'id' => 'ID',
                    
                    'expense_type'=> 'Ledger',
                    'subledger_id'=> 'Sub Ledger',
                    'landlord_id'=> 'Land Owner',
                    'flat_id' => 'Flat No',
                    'expense_date' => 'Expense Date',
                    'building_id'=> 'Building',
                    'expense_amount' => 'Expense Amount',
                    'remarks' => 'Remarks',
                    'status' => '1-Completed,2-Bounced,3-Cancelled',
                    'created_by' => 'Created By',
                    'created_date' => 'Created Date',
                    'updated_by' => 'Updated By',
                    'updated_date' => 'Updated Date',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('expense_amount',$this->expense_amount,true);
                $criteria->compare('expense_type',$this->expense_type);
                $criteria->compare('flat_id',$this->flat_id);
                $criteria->compare('subledger_id',$this->subledger_id);
                $criteria->compare('building_id',$this->building_id);
                $criteria->compare('remarks',$this->remarks);
                $criteria->compare('expense_date',$this->expense_date);
                $criteria->compare('status',$this->status);
                $criteria->compare('created_by',$this->created_by);
                $criteria->compare('landlord_id',$this->landlord_id);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
	
//	public static function getExpense() {
//		$condition = 'isActive =  "Y"';
//		$model = self::model()->findAll(array('condition' => $condition));
//		return CHtml::listData($model, 'id', 'expense_type');
//	}
        
        
}