<?php

/**
 * This is the model class for table "{{company_bank}}".
 *
 * The followings are the available columns in table '{{company_bank}}':
 * @property integer $id
 * @property integer $bankid
 * @property string $branch
 * @property string $account_name
 * @property string $account_no
 * @property string $iban_no
 * @property string $swift_code
 * @property string $other_details
 * @property string $is_active
 * @property integer $created_by
 * @property string $created_date
 * @property integer $updated_by
 * @property string $updated_date
 */
class CompanyBank extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{company_bank}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('bankid', 'required'),
			array('bankid, created_by, updated_by', 'numerical', 'integerOnly'=>true),
			array('branch', 'length', 'max'=>250),
			array('account_name', 'length', 'max'=>200),
			array('account_no, iban_no, swift_code', 'length', 'max'=>100),
			array('is_active', 'length', 'max'=>1),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, bankid, branch, account_name, account_no, iban_no,opening_balance,opening_date, swift_code, other_details, is_active, created_by, created_date, updated_by, updated_date', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
                    'bank_details'=>array(self::BELONGS_TO, 'MasterBank', 'bankid'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'bankid' => 'Bankid',
			'branch' => 'Branch',
			'account_name' => 'Account Name',
			'account_no' => 'Account No',
			'iban_no' => 'Iban No',
			'swift_code' => 'Swift Code',
                        'opening_balance'=>'Opening Balance',
			'opening_date'=>'Opening Date',
			'other_details' => 'Other Details',
			'is_active' => 'Is Active',
			'created_by' => 'Created By',
			'created_date' => 'Created Date',
			'updated_by' => 'Updated By',
			'updated_date' => 'Updated Date',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('bankid',$this->bankid);
		$criteria->compare('branch',$this->branch,true);
		$criteria->compare('account_name',$this->account_name,true);
		$criteria->compare('account_no',$this->account_no,true);
		$criteria->compare('iban_no',$this->iban_no,true);
		$criteria->compare('swift_code',$this->swift_code,true);
		$criteria->compare('other_details',$this->other_details,true);
		$criteria->compare('is_active',$this->is_active,true);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('created_date',$this->created_date,true);
		$criteria->compare('updated_by',$this->updated_by);
		$criteria->compare('updated_date',$this->updated_date,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return CompanyBank the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
         public static function getCompanyBank() {
		$condition = 'is_active =  "Y"';
		$model = self::model()->with('bank_details')->findAll(array('condition' => $condition,'order'=>'bank_details.bank_name'));
		return CHtml::listData($model, 'bankid', 'bank_details.bank_name');
	}
}
