<?php

/**
 * This is the model class for table "{{building_owner_details}}".
 *
 * The followings are the available columns in table '{{building_owner_details}}':
 * @property string $id
 * @property integer $building
 * @property integer $landlord
 * @property integer $percentage
 * @property integer $created_by
 * @property string $created_date
 * @property integer $updated_by
 * @property string $updated_date
 */
class BuildingOwnerDetails extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{building_owner_details}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('building, landlord, percentage,percentage_amount', 'required'),
			array('building, landlord,created_by, updated_by', 'numerical', 'integerOnly'=>true),
			array('id', 'length', 'max'=>20),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, building, landlord, percentage,percentage_amount, created_by, created_date, updated_by, updated_date', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
                    'buiding_details'=>array(self::BELONGS_TO, 'Building', 'building'),
                    'flat_details'=>array(self::BELONGS_TO, 'Flat', 'flat'),
                    'landlord_details'=>array(self::BELONGS_TO, 'Landlord', 'landlord'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'building' => 'Building',
			'landlord' => 'Landlord',
			'percentage' => 'Percentage',
                        'percentage_amount'=>'Amount',
			'created_by' => 'Created By',
			'created_date' => 'Created Date',
			'updated_by' => 'Updated By',
			'updated_date' => 'Updated Date',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id,true);
		$criteria->compare('building',$this->building);
		$criteria->compare('landlord',$this->landlord);
		$criteria->compare('percentage',$this->percentage);
                $criteria->compare('percentage_amount',$this->percentage_amount);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('created_date',$this->created_date,true);
		$criteria->compare('updated_by',$this->updated_by);
		$criteria->compare('updated_date',$this->updated_date,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return BuildingOwnerDetails the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
        public static function getBuildingLandlord($building) {
		$condition = 'landlord_details.status =  "Y" and building = "'.$building.'"';
		$model = self::model()->with('landlord_details')->findAll(array('condition' => $condition,'order'=>'landlord_details.name'));
		return CHtml::listData($model, 'landlord_details.id', 'landlord_details.name');
	}
        public static function getFlatLandlord($flat) {
		$condition = 'landlord_details.status =  "Y" and flat = "'.$flat.'"';
		$model = self::model()->with('landlord_details')->findAll(array('condition' => $condition,'order'=>'landlord_details.name'));
		return CHtml::listData($model, 'landlord_details.id', 'landlord_details.name');
	}
	
        
	public static function getBuildingLandlordName($building) {
		$condition = 'landlord_details.status =  "Y" and building = "'.$building.'"';
		$model = self::model()->with('landlord_details')->findAll(array('condition' => $condition,'order'=>'landlord_details.name'));
		$arr_landlord = array();
		foreach($model as $each_detail){
			$arr_landlord[] = $each_detail->landlord_details->name;
		}
		$landlord_name = implode(',',$arr_landlord);
		return $landlord_name;
	}
        public static function getFlatLandlordName($flat) {
		$condition = 'landlord_details.status =  "Y" and flat = "'.$flat.'"';
		$model = self::model()->with('landlord_details')->findAll(array('condition' => $condition,'order'=>'landlord_details.name'));
		$arr_landlord = array();
		foreach($model as $each_detail){
			$arr_landlord[] = $each_detail->landlord_details->name;
		}
		$landlord_name = implode(',',$arr_landlord);
		return $landlord_name;
	}
}
