<?php

/**
 * This is the model class for table "re_building_class".
 *
 * The followings are the available columns in table 're_building_class':
 * @property integer $id
 * @property string $class_name
 * @property string $facilities
 * @property string $created_date
 * @property string $updated_date
 * @property integer $created_by
 * @property integer $updated_by
 */
class BuildingClass extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return BuildingClass the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 're_building_class';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('class_name,building_id, facilities', 'required'),
			array('created_by, updated_by', 'numerical', 'integerOnly'=>true),
			array('class_name', 'length', 'max'=>30),
			array('facilities', 'length', 'max'=>255),
			
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, class_name,building_id, facilities, created_date, updated_date, created_by, updated_by', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'class_name' => 'Class Name',
                        'building_id' => 'Building',
			'facilities' => 'Facilities',
			
			'created_date' => 'Created Date',
			'updated_date' => 'Updated Date',
			'created_by' => 'Created By',
			'updated_by' => 'Updated By',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('class_name',$this->class_name,true);
                $criteria->compare('building_id',$this->building_id,true);
		$criteria->compare('facilities',$this->facilities,true);
		$criteria->compare('created_date',$this->created_date,true);
		$criteria->compare('updated_date',$this->updated_date,true);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('updated_by',$this->updated_by);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
	
	public static function getAllBuildingClass() {
		$condition = 'status =  "Y"';
		$model = self::model()->findAll(array('condition' => $condition));
		return CHtml::listData($model, 'id', 'class_name');
	}
        
}