<?php

/**
 * This is the model class for table "re_building".
 *
 * The followings are the available columns in table 're_building':
 * @property integer $id
 * @property string $Building_name
 * @property string $makani
 * @property string $builder_name
 * @property string $squaremetre
 * @property integer $buying_value
 * @property string $status
 * @property integer $created_by
 * @property string $created_date
 * @property integer $updated_by
 * @property string $updated_date
 */
class Building extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return Building the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 're_building';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('building_name,buying_date', 'required'),
			array('created_by, updated_by,construction_status,country', 'numerical', 'integerOnly'=>true),
			array('building_name,building_id, makani,emirate,location,builder_name', 'length', 'max'=>50),
                        //array('telephone','length','min'=>12,'max'=>12),
                        //array('mobile','length','min'=>12,'max'=>12),
			array('status', 'length', 'max'=>1),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, building_name,building_id,address,telephone,mobile,builder_name,state, makani,construction_status,country,buying_date,buying_value,squarefeet,squaremetre,squarefeet_rate,floors,flats,landlords,depreciation_months,depreciation,status,purchase_status, building_or_land,created_by, created_date, updated_by, updated_date', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
                    'countrydetail'=>array(self::BELONGS_TO, 'MasterCountry', 'country'),
                    'country_name'=>array(self::BELONGS_TO, 'MasterCountry', 'country'),
                    
                    'ownerdetail' => array(self::HAS_MANY, 'BuildingOwnerDetails', 'building'),  
                    //'state_name'=>array(self::BELONGS_TO, 'MasterState', 'state'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'building_name' => 'Building Name/Land Name',
                        'building_id' => 'Building Id',
                        'builder_name'=>'Builder Name',
			'makani' => 'Makani',
                        'country' => 'Country',
                        'state' => 'State',
                        'telephone' => 'Telephone',
                        'address' => 'Address',
                        'mobile' => 'Mobile',
                        'buying_date' => 'Buying Date',
                        'buying_value' => 'Buying Value',
                        'squarefeet' => 'No Of SquareFeets',
                        'squaremetre'=> 'Square Metre',
                        'squarefeet_rate'=>'Squarefeet Rate',
                        'floors' => 'No of Floors',
                        'flats' => 'No of Flats',
                        'landlords' => 'Land Owners',
                        'depreciation_months' => 'Depreciation in Months',
                        'depreciation' => 'Depreciation Percentage',
			'status' => 'Status',
                        'construction_status'=>'ConstructionStatus',
                        'building_or_land'=>'Building/Land',
			'created_by' => 'Created By',
			'created_date' => 'Created Date',
			'updated_by' => 'Updated By',
			'updated_date' => 'Updated Date',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('building_name',$this->Building_name,true);
		$criteria->compare('makani',$this->makani,true);
		$criteria->compare('status',$this->status,true);
                $criteria->compare('country',$this->country,true);
		$criteria->compare('construction_status',$this->construction_status,true);
                $criteria->compare('cmn_area_sqft',$this->cmn_area_sqft,true);
                $criteria->compare('cmn_area_sqm',$this->cmn_area_sqm,true);
                $criteria->compare('landlords',$this->landlords,true);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('created_date',$this->created_date,true);
		$criteria->compare('updated_by',$this->updated_by);
		$criteria->compare('updated_date',$this->updated_date,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
        public static function getList() {
        $model = self::model()->findAll(array('condition' =>'status="Y"','order'=>'building_name'));
            $list =  CHtml::listData($model, 'id', 'building_name');
            return $list;
        }
        
        public static function getAllBuilding() {
        	$condition = 'status =  "Y" AND building_or_land="0"';
        	$model = self::model()->findAll(array('condition' => $condition,'order'=>'building_name'));
        	return CHtml::listData($model, 'id', 'building_name');
        }
        
        public static function getBuildingName($id) {
        	$model = self::model()->findByPk($id);
        	return $model->building_name;
        }
        public static function getPurchasedBuilding() {
        	$condition = 'status =  "Y"';
        	$model = self::model()->findAll(array('condition'=>'status="Y" AND purchase_status = 1','order'=>'building_name'));
        	return CHtml::listData($model, 'id', 'building_name');
        }
        public static function getFlatBuilding() {
        	$condition = 'status =  "Y"';
        	$model = self::model()->findAll(array('condition'=>'status="Y" AND purchase_status = 0','order'=>'building_name'));
        	return CHtml::listData($model, 'id', 'building_name');
        }
        
        public static function getLand() {
        	$model = self::model()->findAll(array('condition'=>'status="Y" AND purchase_status = 2 AND building_or_land= 1','order'=>'building_name'));
        	return CHtml::listData($model, 'id', 'building_name');
        }
        public static function getReadyOccupyBuilding() {
        	$condition = 'status =  "Y" AND construction_status="1"';
        	$model = self::model()->findAll(array('condition' => $condition,'order'=>'building_name'));
        	return CHtml::listData($model, 'id', 'building_name');
        }
        public static function getStates() {
            $model = self::model()->findAll(array('order'=>'state'));
            return CHtml::listData($model, 'state', 'state');
        }
        public static function getLocations() {
            $condition = 'location != ""';
            $model = self::model()->findAll(array('condition'=>$condition,'order'=>'location'));
            return CHtml::listData($model, 'location', 'location');
        }
        public static function getCountry() {
            $model = self::model()->findAll(array('order'=>'country'));
            return CHtml::listData($model, 'country', 'countrydetail.country_name');
        }
        public function int_to_words($x)
{
    $nwords = array(
        0 => 'Zero', 1 => 'One', 2 => 'Two', 3 => 'Three', 4 => 'Four',
        5 => 'Five', 6 => 'Six', 7 => 'Seven', 8 => 'Eight', 9 => 'Nine',
        10 => 'Ten', 11 => 'Eleven', 12 => 'Twelve', 13 => 'Thirteen',
        14 => 'Fourteen', 15 => 'Fifteen', 16 => 'Sixteen', 17 => 'Seventeen',
        18 => 'Eighteen', 19 => 'Nineteen', 20 => 'Twenty',
        30 => 'Thirty', 40 => 'Forty', 50 => 'Fifty', 60 => 'Sixty',
        70 => 'Seventy', 80 => 'Eighty', 90 => 'Ninety'
    );

    if (!is_numeric($x)) {
        return '#';
    } else if (fmod($x, 1) != 0) {
        return '#';
    }

    $x = (int)$x;

    if ($x < 0) {
        $w = 'minus ';
        $x = -$x;
    } else {
        $w = '';
    }

    if ($x < 21) {
        $w .= $nwords[$x];
    } else if ($x < 100) {
        $w .= $nwords[10 * floor($x / 10)];
        $r = $x % 10;
        if ($r > 0) {
            $w .= '-' . $nwords[$r];
        }
    } else if ($x < 1000) {
        $w .= $nwords[floor($x / 100)] . ' Hundred';
        $r = $x % 100;
        if ($r > 0) {
            $w .= ' and ' . $this->int_to_words($r);
        }
    } else if ($x < 1000000) {
        $w .= $this->int_to_words(floor($x / 1000)) . ' Thousand';
        $r = $x % 1000;
        if ($r > 0) {
            if ($r < 100) {
                $w .= ' and ';
            } else {
                $w .= ' ';
            }
            $w .= $this->int_to_words($r);
        }
    } else {
        $w .= $this->int_to_words(floor($x / 1000000)) . ' Million';
        $r = $x % 1000000;
        if ($r > 0) {
            if ($r < 100) {
                $w .= ' and ';
            } else {
                $w .= ' ';
            }
            $w .= $this->int_to_words($r);
        }
    }

    return $w;
}

        public static function getMultipleBuildingName($building) {
		$condition = 'id IN ('.$building.')';
		$model = self::model()->findAll(array('condition' => $condition,'order'=>'building_name ASC'));
		$arr_b = array();
		foreach($model as $each_detail){
			$arr_b[] = $each_detail->building_name;
		}
		$building_name = implode(',',$arr_b);
		return $building_name;
	}
}