<?php

class UserGroupController extends Controller
{
        public function filters()

	{

		return array(

			'accessControl', // perform access control for CRUD operations

		);

	}


	public function accessRules()
    {

        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
              ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index','Create','Save','Delete'),
                 'expression' => '$user->isMember()',
            ),
             array('deny', // deny all users
                'users' => array('*'),
              ),
            
        );

    }

	public function actionIndex()
	{
                $model = UserGroup::model()->findAll(array('condition'=>'isActive="Y"'));
                $this->render('index',array(
                     'model'=>$model,
                ));

	}

  public function actionCreate()
  {

      $id = (int) Yii::app()->request->getParam('id');
            
      $model = new UserGroup();
            
      if($id > 0)
      {
        $model=$model->findByPk($id);
      }

      Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);

      $this->render('create',array('model'=>$model,'title' => 'Add New User Group'));

  }

  public function actionSave()
        {
            $model=new UserGroup();
            /************ START Code for Save ***************/
            if (isset($_POST['UserGroup'])) {
        
        if ((int) @$_POST['UserGroup']['id'] > 0) {
          $model->id = (int) $_POST['UserGroup']['id'];
          $model = $model->findByPK($model->id);
        }
                $model->attributes = $_POST['UserGroup'];
                $allPermissions = array();
                foreach ($_POST['UserGroup']['permissions'] as $eachPermissionArray)
                { 
                    if (is_array($eachPermissionArray)){ 
                        foreach ($eachPermissionArray as $eachPermission){
                            $allPermissions[$eachPermission] = 1;
                        }
                    }
                }
                $model->permissions = json_encode($allPermissions);
                if ($model->save())
                {
                    $jsonData['status'] = 'success';
                    echo CJSON::encode($jsonData);
                }
                else
                {
                        $error = CActiveForm::validate($model, '', false);
                        if ($error != '[]')
                            echo $error;
                }
            }
        } 

  public function actionDelete() {
        $id = (int) Yii::app()->request->getParam('id');
        if ($id != 0) {
            $q = User::model()->count(array('condition' => 'user_group_id in (' . (int) $id . ') AND is_active ="Y"'));
           if ($q == 0) {
                UserGroup::model()->deleteByPK($id);
                echo CJSON::encode(array('status' => 'success'));
            } else {
                echo CJSON::encode(array('status' => 'fail'));
            }
        }else{
             echo CJSON::encode(array('status' => 'fail'));
        }
    }   
       
}