<?php

class TenantuploadController extends Controller
{
                public function filters()

	{

		return array(

			'accessControl', // perform access control for CRUD operations

		);

	}
        public function accessRules()
        {

            return array(
                array('allow', // allow all users to perform 'index' and 'view' actions
                    'actions' => array('login', 'error', 'logout'),
                    'users' => array('*'),
                  ),
                array('allow', // allow authenticated user to perform 'create' and 'update' actions
                    'actions' => array('Listupload','Save','Create','Delete','Upload','getTenantDocument','Download','CreateDocument','SaveDocument','DownloadDocument'),
                     'expression' => '$user->isMember()',
                ),
                 array('deny', // deny all users
                    'users' => array('*'),
                  ),

            );

        }
    	
        public function actionListupload()
	{
                $tenant_id=(int) Yii::app()->request->getParam('tenant_id');   
                $model = TenantUpload::model()->findAll(array('condition'=>'tenant_id="'.$tenant_id.'"'));
                $this->render('listupload',array(
                     'model'=>$model,
                ));

	}
        public function actionCreate()
	{

            $id = (int) Yii::app()->request->getParam('id');
            $tenant_id=(int) Yii::app()->request->getParam('tenant_id');
	    $model = new TenantUpload();
            
            if($id > 0)
            {
    		$model=$model->findByPk($id);
                if(isset($model->expiry_date) && $model->expiry_date!="0000-00-00")
                {
                    $arr_expiry_date = explode("-",$model->expiry_date);
                    $model->expiry_date=$arr_expiry_date[2]."/".$arr_expiry_date[1]."/".$arr_expiry_date[0];
                }
                else
                {
                    $model->expiry_date="";
                }
                if(isset($model->renewal_date) && $model->renewal_date!="0000-00-00")
                {
                    $arr_renewal_date = explode("-",$model->renewal_date);
                    $model->renewal_date=$arr_renewal_date[2]."/".$arr_renewal_date[1]."/".$arr_renewal_date[0];
                }
                else
                {
                    $model->renewal_date="";
                }
            }

            Yii::app()->clientScript->scriptMap = array( 'jquery.min.js' => false);

            $this->render('create',array(

                    'model'=>$model,

                    'title' => 'Add New Tenant Document',
                
                    'tenant_id' =>$tenant_id

            ));
       }
       
       public function actionCreateDocument()
	{

            $id = (int) Yii::app()->request->getParam('id');
            $tenant_id=(int) Yii::app()->request->getParam('tenant_id');
	    $model = new TenantDocument();
            
            if($id > 0)
            {
    		$model=$model->findByPk($id);
            }

            Yii::app()->clientScript->scriptMap = array( 'jquery.min.js' => false);

            $this->render('createdocument',array(

                    'model'=>$model,

                    'title' => 'Add New Tenant Document',
                
                    'tenant_id' =>$tenant_id

            ));
       }

    public function actionSave()
    {
    	$model=new TenantUpload();
    	/************ START Code for Save ***************/
    	if (isset($_POST['TenantUpload'])) {
    		
    		if ((int) @$_POST['TenantUpload']['id'] > 0) {
    			$model->id = (int) $_POST['TenantUpload']['id'];
                        $model = $model->findByPK($model->id);
    			$model->updated_by = Yii::app()->user->id;
    			$model->updated_date_time = date('Y-m-d h:i:s');
    		}
                else {
    			$model->created_by = Yii::app()->user->id;
    			$model->created_date_time = date('Y-m-d h:i:s');
    		}
    	
    			$model->attributes = $_POST['TenantUpload'];
                        if($_POST['TenantUpload']['expiry_date'] != '') {
                        $model->expiry_date= DateTime::createFromFormat('d/m/Y', $_POST['TenantUpload']['expiry_date'])->format('Y-m-d');
                        }
                        if($_POST['TenantUpload']['renewal_date'] != '') {
                        $model->renewal_date= DateTime::createFromFormat('d/m/Y', $_POST['TenantUpload']['renewal_date'])->format('Y-m-d');
                        }
                        $model->document_name = $_POST['TenantUpload']['document_name'];
                        $model->tenant_id = $_POST['tenant_id'];
	    		if ($model->save())
	    		{
	    			$jsonData['status'] = 'success';
	                        echo CJSON::encode($jsonData);
	    		}
	    		else
	    		{
		    		$error = CActiveForm::validate($model, '', false);
		                if ($error != '[]')
		                    echo $error;
		        }
    	}
     }
     
     public function actionSaveDocument()
    {
    	$model=new TenantDocument();
    	/************ START Code for Save ***************/
    	if (isset($_POST['TenantDocument'])) {
    		
    		if ((int) @$_POST['TenantDocument']['id'] > 0) {
    			$model->id = (int) $_POST['TenantDocument']['id'];
                        $model = $model->findByPK($model->id);
    			$model->updated_by = Yii::app()->user->id;
    			$model->updated_date_time = date('Y-m-d h:i:s');
    		}
                else {
    			$model->created_by = Yii::app()->user->id;
    			$model->created_date_time = date('Y-m-d h:i:s');
    		}
    	
    			$model->attributes = $_POST['TenantDocument'];
                        $model->document_name = $_POST['TenantDocument']['document_name'];
                        $model->tenant_id = $_POST['tenant_id'];
	    		if ($model->save())
	    		{
	    			$jsonData['status'] = 'success';
	                        echo CJSON::encode($jsonData);
	    		}
	    		else
	    		{
		    		$error = CActiveForm::validate($model, '', false);
		                if ($error != '[]')
		                    echo $error;
		        }
    	}
     }

     public function actionDelete()
     {
                $id = $_POST['id'];
                $model=new TenantUpload();
                $model->deleteByPk($id);
                echo "success";
    }
    public function actiongetTenantDocument()
	{
    	$tenant_id        = (int) Yii::app()->request->getParam('tenant_id');
    	$model        = new TenantUpload();
    	if($tenant_id > 0)
    	{
                $arr_upload = $model->findAll(array('condition'=>'tenant_id='.$tenant_id));
    	}
    	
    	$this->render('listupload',array('model'=>$model,'tenant_id'=>$tenant_id));
    }
//    public function actionDownload(){     
//        $id= (int) Yii::app()->request->getparam('id'); 
//        $sfile =TenantUpload::model()->findByPk($id);  
//        $arr_doc_val = explode(',',$sfile->document_name);
//        for($i=0;$i<count($arr_doc_val);$i++){
//            $path = Yii::getPathOfAlias('webroot')."/uploads/documents/".$arr_doc_val[$i];
//            $this->downloadFile($path);
//        } 
//        
//    }
    public function actionDownload(){     
        $id= (int) Yii::app()->request->getparam('id'); 
        $sfile =TenantUpload::model()->findByPk($id);  
        $arr_doc_val = explode(',',$sfile->document_name);
        $zip = new ZipArchive();
        $zip_file_path = Yii::getPathOfAlias('webroot')."/downloadzip/".$sfile->file_name."_".date('d-m-Y').".zip";
        
        if($zip->open($zip_file_path,1?ZIPARCHIVE::OVERWRITE:ZIPARCHIVE::CREATE)===TRUE)
        {
            for($i=0;$i<count($arr_doc_val);$i++){
                $path = "uploads/documents/".$arr_doc_val[$i];
                // Add the files to the .zip file
                $zip->addFile($path, $arr_doc_val[$i]);
            }
            // Closing the zip file
            $zip->close();
        }

        header("Content-type:application/zip"); //for pdf file
        //if you want to read text file using text/plain header
         header('Content-Disposition: attachment; filename="'.basename($zip_file_path).'"');
         header('Content-Length: ' . filesize($zip_file_path));
         readfile($zip_file_path);

         @unlink($zip_file_path);
         Yii::app()->end();
    }
    public function downloadFile($fullpath){
            if(!empty($fullpath)){ 
                header("Content-type:application/force-download"); //for txt file
                //header("Content-type:application/txt"); //for txt file
                //header('Content-Type:text/plain; charset=ISO-8859-15');
                //if you want to read text file using text/plain header 
                header('Content-Disposition: attachment; filename="'.basename($fullpath).'"'); 
                header('Content-Length: ' . filesize($fullpath));
                readfile($fullpath);
                Yii::app()->end();
            }
    }
    public function actionDownloadDocument(){     
        $id= (int) Yii::app()->request->getparam('id'); 
        $sfile =TenantDocument::model()->findByPk($id);  
        $arr_doc_val = explode(',',$sfile->document_name);
        $zip = new ZipArchive();
        $zip_file_path = Yii::getPathOfAlias('webroot')."/downloadzip/".$sfile->file_name."_".date('d-m-Y').".zip";
        
        if($zip->open($zip_file_path,1?ZIPARCHIVE::OVERWRITE:ZIPARCHIVE::CREATE)===TRUE)
        {
            for($i=0;$i<count($arr_doc_val);$i++){
                $path = "uploads/documents/".$arr_doc_val[$i];
                // Add the files to the .zip file
                $zip->addFile($path, $arr_doc_val[$i]);
            }
            // Closing the zip file
            $zip->close();
        }

        header("Content-type:application/zip"); //for pdf file
        //if you want to read text file using text/plain header
         header('Content-Disposition: attachment; filename="'.basename($zip_file_path).'"');
         header('Content-Length: ' . filesize($zip_file_path));
         readfile($zip_file_path);

         @unlink($zip_file_path);
         Yii::app()->end();
    }
}