<?php

class TenantController extends Controller
{
                public function filters()

	{

		return array(

			'accessControl', // perform access control for CRUD operations

		);

	}
        public function accessRules()
        {

            return array(
                array('allow', // allow all users to perform 'index' and 'view' actions
                    'actions' => array('login', 'error', 'logout'),
                    'users' => array('*'),
                  ),
                array('allow', // allow authenticated user to perform 'create' and 'update' actions
                    'actions' => array('index','Save','Create','Delete','Details','getBuildingFlat'),
                     'expression' => '$user->isMember()',
                ),
                 array('deny', // deny all users
                    'users' => array('*'),
                  ),

            );

        }
    	
        public function actionIndex()
	{
                $model = Tenant::model()->findAll(array('condition'=>'status="Y"'));
                $this->render('index',array(
                     'model'=>$model,
                ));

	}
        public function actionCreate()
	{

            $id = (int) Yii::app()->request->getParam('id');
        
            
	    $model = new Tenant();
            
            $model_upload = new TenantUpload();
            
            if($id > 0)
            {
    		$model=$model->findByPk($id);
                if(isset($model->contract_date) && $model->contract_date!="0000-00-00")
                {
                    $arr_contract_date = explode("-",$model->contract_date);
                    $model->contract_date=$arr_contract_date[2]."/".$arr_contract_date[1]."/".$arr_contract_date[0];
                }
                else
                {
                    $model->contract_date="";
                }
                if(isset($model->contract_exp_date) && $model->contract_exp_date!="0000-00-00")
                {
                    $arr_contract_exp_date = explode("-",$model->contract_exp_date);
                    $model->contract_exp_date=$arr_contract_exp_date[2]."/".$arr_contract_exp_date[1]."/".$arr_contract_exp_date[0];
                }
                else
                {
                    $model->contract_exp_date="";
                }
            }

                Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);

		$this->render('create',array(

			'model'=>$model, 'model_upload'=> $model_upload,

                        'title' => 'Add New Tenant'

		));
       }

//     public function actionSave()
//     {
//     	$model=new Tenant();
//     	/************ START Code for Save ***************/
//     	if (isset($_POST['Tenant'])) {
    		
//     		if ((int) @$_POST['Tenant']['id'] > 0) {
//     			$model->id = (int) $_POST['Tenant']['id'];
//                         $model = $model->findByPK($model->id);
//     			$model->updated_by = Yii::app()->user->id;
//     			$model->updated_date = date('Y-m-d h:i:s');
//     		}
//                 else {
//     			$model->created_by = Yii::app()->user->id;
//     			$model->created_date = date('Y-m-d h:i:s');
//     		}
    	
//     			$model->attributes = $_POST['Tenant'];
//                         $date = str_replace('/', '-', $_POST['Tenant']['contract_date']);
//                         $model->contract_date = date("Y-m-d", strtotime($date));
//                         $date = str_replace('/', '-', $_POST['Tenant']['contract_exp_date']);
//                         $model->contract_exp_date = date("Y-m-d", strtotime($date));
//                         $flat_count            = 0;
//                         if(isset($_POST['Tenant']['building_id']) && $_POST['Tenant']['building_id']!='')
//                             $flat_count = Yii::app()->db->createCommand('SELECT COUNT(*) FROM re_flat WHERE building_id ='. $_POST['Tenant']['building_id'])->queryScalar();
//                         $model->flat_count = 0;
//                         if($flat_count > 0){
//                          $model->flat_count = $flat_count;
//                         }
                        
                        
// 	    		if ($model->save())
// 	    		{
// 	    			$flat_details=Flat::model()->findByPk($_POST['Tenant']['flat_id']);
	    			
// 	    			if ((int) @$_POST['Tenant']['id'] == 0) {
	    				
// 	    				$tenant_id = $model->id;
// //		    			$modelUser = new User();
// //		    			$tenant_user_name = strtolower($flat_details->flat_no);
// //		    			
// //		    			$password_string=$tenant_user_name."001";
// //		    			$salt = '$2a$10$1qAz2wSx3eDc4rFv5tGb5t';
// //		    			 
// //		    			$password = crypt($password_string, $salt);
// //		    			
// //		    			
// //		    			$SQL	=	"INSERT INTO re_user(first_name,username,password,email,phone,user_group_id,user_level,tenant_id,created_by,created_date_time,is_active)
// //		    			VALUES('".$_POST['Tenant']['name']."','".$tenant_user_name."','".$password."','".$_POST['Tenant']['email1']."','".$_POST['Tenant']['mob1']."',2,1,".$tenant_id.",".Yii::app()->user->id.",'".date('Y-m-d h:i:s')."','Y')";
// //		    			Yii::app()->db->createCommand($SQL)->execute();
		    			
// 	    			}
	    			
	    			
// 	    			$jsonData['status'] = 'success';
// 	                        echo CJSON::encode($jsonData);
// 	    		}
// 	    		else
// 	    		{
// 		    		$error = CActiveForm::validate($model, '', false);
// 		                if ($error != '[]')
// 		                    echo $error;
// 		        }
//     	}
//      }
public function actionSave()
{
    $model = new Tenant();

    
    if (isset($_POST['Tenant'])) {

        if (!empty($_POST['Tenant']['id']) && (int) $_POST['Tenant']['id'] > 0) {
            $model->id = (int) $_POST['Tenant']['id'];
            $model = $model->findByPk($model->id);
            $model->updated_by = Yii::app()->user->id;
            $model->updated_date = date('Y-m-d h:i:s');
        } else {
            $model->created_by = Yii::app()->user->id;
            $model->created_date = date('Y-m-d h:i:s');
        }

        
        $model->attributes = $_POST['Tenant'];

       
        if (!empty($_POST['Tenant']['contract_date'])) {
            $date = str_replace('/', '-', $_POST['Tenant']['contract_date']);
            $model->contract_date = date("Y-m-d", strtotime($date));
        } else {
            $model->contract_date = null;
        }

       
        if (!empty($_POST['Tenant']['contract_exp_date'])) {
            $date = str_replace('/', '-', $_POST['Tenant']['contract_exp_date']);
            $model->contract_exp_date = date("Y-m-d", strtotime($date));
        } else {
            $model->contract_exp_date = null;
        }

        
        $flat_count = 0;
        if (!empty($_POST['Tenant']['building_id'])) {
            $building_id = (int) $_POST['Tenant']['building_id'];
            $flat_count = Yii::app()->db->createCommand('SELECT COUNT(*) FROM re_flat WHERE building_id = ' . $building_id)->queryScalar();
        }
        $model->flat_count = $flat_count;

        if ($model->save()) {

            $flat_details = null;
            if (!empty($_POST['Tenant']['flat_id'])) {
                $flat_details = Flat::model()->findByPk((int) $_POST['Tenant']['flat_id']);
            }

            
            if (empty($_POST['Tenant']['id']) || (int) $_POST['Tenant']['id'] == 0) {
                $tenant_id = $model->id;

                // Optionally, user creation logic can be enabled here if needed
                /*
                if ($flat_details !== null) {
                    $tenant_user_name = strtolower($flat_details->flat_no);
                    $password_string = $tenant_user_name . "001";
                    $salt = '$2a$10$1qAz2wSx3eDc4rFv5tGb5t';
                    $password = crypt($password_string, $salt);

                    $SQL = "INSERT INTO re_user(first_name,username,password,email,phone,user_group_id,user_level,tenant_id,created_by,created_date_time,is_active)
                            VALUES('" . $_POST['Tenant']['name'] . "','" . $tenant_user_name . "','" . $password . "','" . $_POST['Tenant']['email1'] . "','" . $_POST['Tenant']['mob1'] . "',2,1," . $tenant_id . "," . Yii::app()->user->id . ",'" . date('Y-m-d h:i:s') . "','Y')";
                    Yii::app()->db->createCommand($SQL)->execute();
                }
                */
            }

            $jsonData['status'] = 'success';
            echo CJSON::encode($jsonData);
        } else {
            $error = CActiveForm::validate($model, '', false);
            if ($error != '[]') {
                echo $error;
            }
        }
    }
}


     public function actionDelete()
     {
        $id = $_POST['id'];
        $model=new Tenant();
        $arr_lease = Lease::model()->findAll(array('condition'=>'tenant_id='.$id));
        //$arr_receipt = Receipt::model()->findAll(array('condition'=>'flat_id='.$id));
        if(empty($arr_lease)){
            $model->deleteByPk($id);
            echo "success";
        }else{
                echo "fail";
        }
    }
    public function actionDetails()
    {   
       $id = Yii::app()->request->getparam('id');
//       $model = Tenant::model()->findAll(array('condition'=>'status="Y"'));
                $this->render('details',array(
                     'id'=>$id,
                ));  
    }
    public function actiongetBuildingFlat()
    {
       $id=Yii::app()->request->getparam("building_id");  
        $condition = 'building_id="'.$id.'" ';
        $status=0;
	$model = Flat::model()->findAll(array('condition' => $condition));
        $flat= '<li class="form-add col-sm-3"><div class="icon-box fa-user material m1">' ;
        $details=CHtml::listData($model, 'id', 'flat_no');
        if(!empty($details))
        $status=1;
        $flat.=CHtml::dropDownList('Tenant[flat_id]','' , $details,  array('class'=>'','placeholder'=>'Flat <span class="red">*</span>'), array('options' => array('title'=>array('selected'=>true))));
        $flat.='</div></li>';
        $status=array("dt" => $flat,"status" => $status);
        echo CJSON::encode($status);
    }
}