<?php

class SubLedgerController extends Controller
{
        public function filters()

	{

		return array(

			'accessControl', // perform access control for CRUD operations

		);

	}


	public function accessRules()
    {

        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
              ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index','Create','SaveSubLedger','Delete'),
                 'expression' => '$user->isMember()',
            ),
             array('deny', // deny all users
                'users' => array('*'),
              ),
            
        );

    }

	public function actionIndex()
	{
                $model = SubLedger::model()->findAll(array('condition'=>'isActive="Y"'));
                $this->render('index',array(
                     'model'=>$model,
                ));

	}

        public function actionCreate()
	{

            $id = (int) Yii::app()->request->getParam('id');
            
	    $model = new SubLedger();
            
            if($id > 0)
            {
    		$model=$model->findByPk($id);
            }

                Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);

		$this->render('create',array(

			'model'=>$model,

                        'title' => 'Add New SubLedger'

		));
       }

    public function actionSaveSubLedger()
    {
    	$model=new SubLedger();
    	/************ START Code for Save ***************/
    	if (isset($_POST['SubLedger'])) {
    		
    		if ((int) @$_POST['SubLedger']['id'] > 0) {
    			$model->id = (int) $_POST['SubLedger']['id'];
                        $model = $model->findByPK($model->id); 
                }
    			$model->attributes = $_POST['SubLedger'];
                        $model->expense_type_id = $_POST['SubLedger']['expense_type_id'];
	    		if ($model->save())
	    		{
	    			$jsonData['status'] = 'success';
	                        echo CJSON::encode($jsonData);
	    		}
	    		else
	    		{
		    		$error = CActiveForm::validate($model, '', false);
		                if ($error != '[]')
		                    echo $error;
		        }
    	}
     }

     public function actionDelete()
     {
                $id = $_POST['id'];
                $model=new SubLedger();
                $model->deleteByPk($id);
                echo "success";
    }

	
	
}