<?php

class SettingsController extends Controller
{
        public function filters()

	{

		return array(

			'accessControl', // perform access control for CRUD operations

		);

	}
        public function accessRules()
        {

            return array(
                array('allow', // allow all users to perform 'index' and 'view' actions
                    'actions' => array('login', 'error', 'logout'),
                    'users' => array('*'),
                  ),
                array('allow', // allow authenticated user to perform 'create' and 'update' actions
                    'actions' => array('Index','Save','ChangePassword','UpdatePassword','listbanks','createbank','savebank','deletebank'),
                     'expression' => '$user->isMember()',
                ),
                 array('deny', // deny all users
                    'users' => array('*'),
                  ),

            );

    }

    public function actionIndex()
    {
            $model = Settings::model()->findByPk('1');
            if(empty($model)){
                $model = new Settings();
            }
            $this->render('create',array(
                 'model'=>$model,
            ));

    }
    public function actionCreateBank() {
        $id = (int) Yii::app()->request->getParam('id');
        $model = new CompanyBank();
        if($id>0){
            $model = $model->findByPk($id);
        }
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->render('create_bank',array(
                 'model'=>$model,
            ));
    }
    public function actionListBanks()
    {
            $model = CompanyBank::model()->findAll(array('condition'=>'is_active="Y"'));
            $this->render('list_company_banks',array(
                 'model'=>$model,
            ));

    }
    public function actionChangePassword() {
        $this->render('changepassword');
    }
    public function actionUpdatePassword() {
        $curr_pwd      = $_POST['user_current_password'];
        $new_pwd       = $_POST['user_new_password'];
        $rep_pwd       = $_POST['user_reenter_password'];
        $login_user_id = Yii::app()->user->id;
        $arr_user_details= User::model()->findByPk($login_user_id);
        $salt       = '$2a$10$1qAz2wSx3eDc4rFv5tGb5t';
        $password   = crypt($_POST['user_current_password'], $salt);
        if($arr_user_details->password == $password){
            $new_password   = crypt($_POST['user_new_password'], $salt);
            $arr_user_details->password=$new_password;
            $arr_user_details->save(false);
            $json['status'] = "success";
        }
        else
        {  
            $json['status'] = "fail";
        }
        echo CJSON::encode($json);
    }

    public function actionSave()
    {
    	$model=new Settings();
        //$model = $model->findByPK('1');
    	/************ START Code for Save ***************/
    	if (isset($_POST['Settings'])) {
    		
    		if ((int) @$_POST['Settings']['id'] > 0) {
    			$model->id = (int) $_POST['Settings']['id'];
                        $model = $model->findByPK($model->id);
    			$model->updated_by = Yii::app()->user->id;
    			$model->updated_date = date('Y-m-d h:i:s');
    		}
                $model->attributes = $_POST['Settings'];
                $model->aed_jd_eqvlnt = $_POST['Settings']['aed_jd_eqvlnt'];
                if ($model->save())
                {
                        $jsonData['status'] = 'success';
                        echo CJSON::encode($jsonData);
                }
                else
                {
                        $error = CActiveForm::validate($model, '', false);
                        if ($error != '[]')
                            echo $error;
                }
    	}
     }
     public function actionSaveBank()
    {
    	$model=new CompanyBank();
        /************ START Code for Save ***************/
    	if (isset($_POST['CompanyBank'])) {
    		
    		if ((int) @$_POST['CompanyBank']['id'] > 0) {
    			$model->id = (int) $_POST['CompanyBank']['id'];
                        $model = $model->findByPK($model->id);
    			$model->updated_by = Yii::app()->user->id;
    			$model->updated_date = date('Y-m-d');
    		} else {
                        $model->created_by = Yii::app()->user->id;
    			$model->created_date = date('Y-m-d');
                }
                $model->attributes = $_POST['CompanyBank'];
                $model->opening_balance = $_POST['CompanyBank']['opening_balance'];
                if($_POST['CompanyBank']['opening_date']!='' && $_POST['CompanyBank']['opening_date']!='0000-00-00'){
                    $model->opening_date     = DateTime::createFromFormat('d/m/Y', $_POST['CompanyBank']['opening_date'])->format('Y-m-d');
                }else{
                    $model->opening_date     = '';
                }
                $model->other_details=$_POST['CompanyBank']['other_details'];
                if ($model->save())
                {
                        $jsonData['status'] = 'success';
                        echo CJSON::encode($jsonData);
                }
                else
                {
                        $error = CActiveForm::validate($model, '', false);
                        if ($error != '[]')
                            echo $error;
                }
    	}
    }

    public function actiondeletebank()
    {
               $id = $_POST['id'];
               $model=CompanyBank::model()->updateByPk($id, array('is_active' => "N"));
               if ($model>0)
               { 
               //$model->deleteByPk($id);
                   echo "success";
               }else{
                   echo "fail";
               }
   }
}