<?php

class ReportController extends Controller
{
    public function filters()
    {

            return array(

                    'accessControl', // perform access control for CRUD operations

            );

    }
    public function accessRules()
    {

        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
              ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('OwnerReport','PdfOwnerReport','getOwnerSummary','BuildingReport','getBuildingSummary','BuildingreportDetail','BuildingreportDetails',
                    'FlatReport','LandReport','LandSummary','FlatreportDetails','BankStatement','getOwnerSummary1','OwnerReport1','PdfOwnerReport1','getBankSummary',
                    'Tenant','getTenantReport','PdfBuildingReport','LandsummaryPdf','BuildingsummaryPdf','FlatsummaryPdf','PdfTenantReport','PdfBankStatement',
                    'WeeklynotesReport','MonthlynotesReport','NotesSummaryReport','WeeklyreceiptReport','MonthlyreceiptReport','ReceiptsummaryReport','WeeklyPaymentReport',
                    'MonthlyPaymentReport','PaymentSummaryReport','Expense','GetExpenseReport','PdfExpenseReport','ExcelRentalCashFlow'),
                 'expression' => '$user->isMember()',
            ),
             array('deny', // deny all users
                'users' => array('*'),
              ),
            
        );

    }
    public function actionOwnerReport() 
    {
        $model = Landlord::model()->findAll();
            $this->render('owner_summary',array(
                 'model'=>$model,
            ));
    }
    public function actionPdfOwnerReport()
    {
        $landlord_id=Yii::app()->request->getparam("landlord_id");
        $state=Yii::app()->request->getparam("state");
        $country=Yii::app()->request->getparam("country");
        $type=Yii::app()->request->getparam("type");
        $percent_type=Yii::app()->request->getparam("percent_type");
        $from_date=Yii::app()->request->getparam("from_date");
        $to_date=Yii::app()->request->getparam("to_date");
        if($landlord_id != "" && $landlord_id != 'null'){ 
            $condition="landlord IN (".$landlord_id.")";
            $building_model = BuildingOwnerDetails::model()->findAll(array('condition'=>$condition));
            $model = Landlord::model()->findAll(array('condition'=>'id IN ('.$landlord_id.')'));
        }else{ //all
            $model = Landlord::model()->findAll();
            $building_model = BuildingOwnerDetails::model()->findAll();
        }
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        ob_start();
        $stylesheet = file_get_contents('css/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.views.admin.report.pdf.ownerreport_pdf', array('landlord_id'=>$landlord_id,'model'=>$model,'building_model'=>$building_model,'state'=>$state,'country'=>$country,'type'=>$type,'percent_type'=>$percent_type,"from_date"=>$from_date,"to_date"=>$to_date), true));
        ob_end_clean();
        $mPDF1->Output();
    }
    public function actionOwnerReport1() 
    {
        $model = Landlord::model()->findAll();
            $this->render('owner_summary1',array(
                 'model'=>$model,
            ));
    }
    public function actionPdfOwnerReport1()
    {
        $landlord_id=Yii::app()->request->getparam("landlord_id");
        $state=Yii::app()->request->getparam("state");
        $country=Yii::app()->request->getparam("country");
        $type=Yii::app()->request->getparam("type");
        $from_date=Yii::app()->request->getparam("from_date");
        $to_date=Yii::app()->request->getparam("to_date");
        if($landlord_id != "" && $landlord_id !='null'){ 
            $condition="landlord IN (".$landlord_id.")";
            $building_model = BuildingOwnerDetails::model()->findAll(array('condition'=>$condition));
            $model = Landlord::model()->findAll(array('condition'=>'id IN ('.$landlord_id.')'));
        }else{ //all
            $model = Landlord::model()->findAll();
            $building_model = BuildingOwnerDetails::model()->findAll();                        
        } 
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        ob_start();
        $stylesheet = file_get_contents('css/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.views.admin.report.pdf.ownerreport1_pdf', array('landlord_id'=>$landlord_id,'model'=>$model,'building_model'=>$building_model,'state'=>$state,'country'=>$country,'type'=>$type,"from_date"=>$from_date,"to_date"=>$to_date), true));
        ob_end_clean();
        $mPDF1->Output();
    }
    public function actionLandReport() 
    {
        $model = Building::model()->findAll(array('condition'=>'building_or_land="1"'));
            $this->render('land_report',array(
                 'model'=>$model,
            ));
    }
    public function actionLandSummary()
    {
        $id =Yii::app()->request->getParam('id');
        $model = new Building();
        if($id > 0)
        {   
            $arr_details=$model->findByPk($id); 
        }
        $this->render('land_summary',array('arr_details'=>$arr_details,'title' => 'Land Summary','id'=>$id));
    }
    public function actionBuildingReport() 
    {
        $model = Building::model()->findAll();
            $this->render('building_summary',array(
                 'model'=>$model,
            ));
    }
    public function actiongetOwnerSummary(){
        $landlord_id=Yii::app()->request->getparam("landlord_id");
        $state=Yii::app()->request->getparam("state");
        $country=Yii::app()->request->getparam("country");
        $type=Yii::app()->request->getparam("type");
        $percent_type=Yii::app()->request->getparam("percent_type");
        $from_date=Yii::app()->request->getparam("from_date");
        $to_date=Yii::app()->request->getparam("to_date");
        if($landlord_id != "" && $landlord_id != 'null'){ 
            $condition="landlord IN (".$landlord_id.")";
            $building_model = BuildingOwnerDetails::model()->findAll(array('condition'=>$condition));
            $model = Landlord::model()->findAll(array('condition'=>'id IN ('.$landlord_id.')'));
        }else{ //all
            $model = Landlord::model()->findAll();
            $building_model = BuildingOwnerDetails::model()->findAll();
        }
        $this->renderPartial('owner_report2',array('model'=>$model,'building_model'=>$building_model,'state'=>$state,'country'=>$country,'type'=>$type,'percent_type'=>$percent_type,'from_date'=>$from_date,'to_date'=>$to_date));       
    }
    public function actiongetOwnerSummary1(){
        $landlord_id=Yii::app()->request->getparam("landlord_id");
        $state=Yii::app()->request->getparam("state");
        $country=Yii::app()->request->getparam("country");
        $type=Yii::app()->request->getparam("type");
        $from_date=Yii::app()->request->getparam("from_date");
        $to_date=Yii::app()->request->getparam("to_date");
        if($landlord_id != "" && $landlord_id !='null'){ 
            $condition="landlord IN (".$landlord_id.")";
            $building_model = BuildingOwnerDetails::model()->findAll(array('condition'=>$condition));
            $model = Landlord::model()->findAll(array('condition'=>'id IN ('.$landlord_id.')'));
        }else{ //all
            $model = Landlord::model()->findAll();
            $building_model = BuildingOwnerDetails::model()->findAll();                        
        } 
        $this->renderPartial('owner_report1',array('model'=>$model,'building_model'=>$building_model,'post_landlord'=>$landlord_id,'state'=>$state,'country'=>$country,'type'=>$type,'from_date'=>$from_date,'to_date'=>$to_date));       
    }
    public function actionPdfBuildingReport()
    {
        $building_id=Yii::app()->request->getparam("building_id");
        if($building_id != ""){ 
            $model = Building::model()->findAll(array('condition'=>'id="'.$building_id.'"'));
        }else{ //all
            $model = Building::model()->findAll();
        }        
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        ob_start();
        $stylesheet = file_get_contents('css/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.views.admin.report.pdf.buildingreport_pdf', array('building_id'=>$building_id,'model'=>$model), true));
        ob_end_clean();
        $mPDF1->Output();
    }
    public function actiongetBuildingSummary(){
        $building_id=Yii::app()->request->getparam("building_id");
        if($building_id != ""){ 
            //$condition="landlord=".$building_id;
            //$building_model = BuildingOwnerDetails::model()->findAll(array('condition'=>$condition));
            $model = Building::model()->findAll(array('condition'=>'id="'.$building_id.'"'));
        }else{ //all
            $model = Building::model()->findAll();
        }
        $this->renderPartial('building_table',array('model'=>$model));       
    }
    
     public function actionBuildingreportDetail() 
    {
        $model = Building::model()->findAll();
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);     
            $this->render('building_report',array(
                 'model'=>$model,
            ));
        
        
    }
    public function actionBuildingreportDetails()
	{
            
            $id =Yii::app()->request->getParam('id');
            $model = Building::model()->findByPk($id);
		$this->render('building_report_details',array('model'=>$model,'id'=>$id,'title' => 'Building Report'
		));
    }
     public function actionFlatReport() 
    {
        $model = Building::model()->findAll();
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);     
            $this->render('flat_report',array(
                 'model'=>$model,
            ));
        
        
    }
    public function actionFlatreportDetails()
	{
            
            $id =Yii::app()->request->getParam('id');
            $model_flat = Flat::model()->findByPk($id);
            $model = Building::model()->findByPk($model_flat->building_id);
		$this->render('flat_report_details',array('model'=>$model,'model_flat'=>$model_flat,'id'=>$id,'title' => 'Building Report'
		));
    }
    public function actionBankStatement()
    {
        $this->render('bank_statements',array('title' => 'Bank Statement'));
    }
    public function actiongetBankSummary()
    {
        $bank_id =Yii::app()->request->getparam("bank_id");
        if($bank_id==''){
            $bank_array         = CompanyBank::model()->with('bank_details')->findAll();
        }else{
            $bank_array         = CompanyBank::model()->with('bank_details')->findAll(array('condition'=>'bankid="'.$bank_id.'"'));
        }
        $this->renderPartial('bank_statement_table',array('title' => 'Bank Statement','bank_array'=>$bank_array));
    }
    public function actionTenant()
    {
        $this->render('tenant_list',array('title' => 'Tenant Report'));
    }
    public function actionExpense()
    {
        $this->render('expense_list',array('title' => 'Expense Report'));
    }
    public function actionGetTenantReport()
    {
        $landlord_id =Yii::app()->request->getparam("landlord_id");
        $location =Yii::app()->request->getparam("location");
        $build_id = Yii::app()->request->getparam("building_id");
        $country=Yii::app()->request->getparam("country");
        $this->renderPartial('tenant_table',array('title' => 'Tenant Report','landlord_id'=>$landlord_id,'location'=>$location,'building_id'=>$build_id,'country'=>$country));
    }
    public function actionGetExpenseReport()
    {
        $build_id = Yii::app()->request->getparam("building_id");
        $ledger_id = Yii::app()->request->getparam("ledger_id");
        $from_date=Yii::app()->request->getparam("from_date");
        $to_date=Yii::app()->request->getparam("to_date");
        $this->renderPartial('expense_table',array('title' => 'Tenant Report','ledger_id'=>$ledger_id,'from_date'=>$from_date,'building_id'=>$build_id,'to_date'=>$to_date));
    }
     public function actionLandsummaryPdf()
    {
        $id =Yii::app()->request->getParam('id');
        $model = new Building();
        if($id > 0)
        {   
            $arr_details=$model->findByPk($id); 
        }   
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        ob_start();
        $stylesheet = file_get_contents('css/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.views.admin.report.pdf.land_summary', array('arr_details'=>$arr_details), true));
        ob_end_clean();
        $mPDF1->Output();
    }
    public function actionBuildingsummaryPdf()
    {
        $id =Yii::app()->request->getParam('id');
        $model = Building::model()->findByPk($id);  
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        ob_start();
        $stylesheet = file_get_contents('css/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.views.admin.report.pdf.building_summary', array('model'=>$model), true));
        ob_end_clean();
        $mPDF1->Output();
    }
    
     public function actionFlatsummaryPdf()
    {
        $id =Yii::app()->request->getParam('id');
        $model_flat = Flat::model()->findByPk($id);
        $model = Building::model()->findByPk($model_flat->building_id);
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        ob_start();
        $stylesheet = file_get_contents('css/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.views.admin.report.pdf.flat_summary', array('model'=>$model,'model_flat'=>$model_flat), true));
        ob_end_clean();
        $mPDF1->Output();
    }
    public function actionPdfTenantReport()
    {
        $landlord_id =Yii::app()->request->getparam("landlord_id");
        $location =Yii::app()->request->getparam("location");
        $build_id = Yii::app()->request->getparam("building_id");
        $country=Yii::app()->request->getparam("country");
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        ob_start();
        $stylesheet = file_get_contents('css/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.views.admin.report.pdf.tenant_summary', array('landlord_id'=>$landlord_id,'location'=>$location,'building_id'=>$build_id,'country'=>$country), true));
        ob_end_clean();
        $mPDF1->Output();
    }
    public function actionPdfExpenseReport()
    {
        $build_id = Yii::app()->request->getparam("building_id");
        $ledger_id = Yii::app()->request->getparam("ledger_id");
        $from_date=Yii::app()->request->getparam("from_date");
        $to_date=Yii::app()->request->getparam("to_date");
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        ob_start();
        $stylesheet = file_get_contents('css/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.views.admin.report.pdf.expense_report', array('ledger_id'=>$ledger_id,'from_date'=>$from_date,'building_id'=>$build_id,'to_date'=>$to_date), true));
        ob_end_clean();
        $mPDF1->Output();
    }
    public function actionPdfBankStatement()
    {
        $bank_id =Yii::app()->request->getparam("bank_id");
        if($bank_id==''){
            $bank_array         = CompanyBank::model()->with('bank_details')->findAll();
        }else{
            $bank_array         = CompanyBank::model()->with('bank_details')->findAll(array('condition'=>'bankid="'.$bank_id.'"'));
        }
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        ob_start();
        $stylesheet = file_get_contents('css/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.views.admin.report.pdf.bankstatement_pdf', array('bank_array'=>$bank_array,'bank_id'=>$bank_id), true));
        ob_end_clean();
        $mPDF1->Output();
    }
    
     public function actionWeeklynotesReport()
    {
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        ob_start();
        $stylesheet = file_get_contents('css/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.views.admin.report.pdf.weekly_notes', array('model'=>new FlatNotes()), true));
        ob_end_clean();
        $mPDF1->Output();
    }
    public function actionMonthlynotesReport()
    {
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        ob_start();
        $stylesheet = file_get_contents('css/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.views.admin.report.pdf.monthly_notes', array('model'=>new FlatNotes()), true));
        ob_end_clean();
        $mPDF1->Output();
    }
    public function actionNotesSummaryReport()
    {
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        ob_start();
        $stylesheet = file_get_contents('css/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.views.admin.report.pdf.listallnotes', array('model'=>new FlatNotes()), true));
        ob_end_clean();
        $mPDF1->Output();
    }
    public function actionWeeklyreceiptReport()
    {
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        ob_start();
        $stylesheet = file_get_contents('css/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.views.admin.report.pdf.weeklyreceipt', array('model'=>new FlatNotes()), true));
        ob_end_clean();
        $mPDF1->Output();
    }
     public function actionMonthlyreceiptReport()
    {
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        ob_start();
        $stylesheet = file_get_contents('css/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.views.admin.report.pdf.monthlyreceipt', array('model'=>new FlatNotes()), true));
        ob_end_clean();
        $mPDF1->Output();
    }
    public function actionReceiptsummaryReport()
    {
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        ob_start();
        $stylesheet = file_get_contents('css/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.views.admin.report.pdf.listallreceipt', array('model'=>new FlatNotes()), true));
        ob_end_clean();
        $mPDF1->Output();
    }
     public function actionWeeklyPaymentReport()
    {
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        ob_start();
        $stylesheet = file_get_contents('css/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.views.admin.report.pdf.weeklypayment', array('model'=>new FlatNotes()), true));
        ob_end_clean();
        $mPDF1->Output();
    }
     public function actionMonthlyPaymentReport()
    {
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        ob_start();
        $stylesheet = file_get_contents('css/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.views.admin.report.pdf.monthlypayment', array('model'=>new FlatNotes()), true));
        ob_end_clean();
        $mPDF1->Output();
    }
    public function actionPaymentsummaryReport()
    {
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        ob_start();
        $stylesheet = file_get_contents('css/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.views.admin.report.pdf.listallpayment', array('model'=>new FlatNotes()), true));
        ob_end_clean();
        $mPDF1->Output();
    }
    public function actionExcelRentalCashFlow(){

        $id = Yii::app()->request->getparam('id');
        $param = array(		
            'id' => $id,
        );
        $filename = 'RentalCashFlow.xls';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        //Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, 'jquery-2.1.4.js' => false);
        $this->renderPartial('../report/excel/rentalcashflow', $param);
        Yii::app()->end();
    }
}
