<?php
class ReceiptController extends Controller
{
    public function filters()
    {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }
    public function accessRules()
    {
        return array(
            array(
                'allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array(
                'allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array(
                    'Index',
                    'Create',
                    'Save',
                    'Delete',
                    'Search',
                    'SearchResult',
                    'SearchResult1',
                    'GetPaymentList',
                    'PrintReceiptExcel',
                    'PrintReceiptPDF',
                    'getFlatNo',
                    'ReceiptPrint',
                    'getLeaseCode',
                    'GetAmountDetails',
                    'getInProcessPayments',
                    'getCompletedPayments',
                    'getCancelledPayments',
                    'getReceiptLists',
                    'getBouncedPayments',
                    'clearBulkCheques'
                ),
                'expression' => '$user->isMember()',
            ),
            array(
                'deny', // deny all users
                'users' => array('*'),
            ),
        );
    }
    public function actionIndex()
    {
        $this->render('index');
        /* $model = Receipt::model()->with('flat','transtype')->findAll();
        $this->render('index',array(
             'model'=>$model,
        )); */
    }
    public function actionCreate()
    {
        $id = (int) Yii::app()->request->getParam('id');
        $model = new Receipt();
        $lease_id = '';
        if ($id > 0) {
            $model = $model->findByPk($id);
            $arr_payment_date = explode("-", $model->payment_date);
            $model->payment_date = $arr_payment_date[2] . "/" . $arr_payment_date[1] . "/" . $arr_payment_date[0];
            if (isset($model->cheque_date) && $model->cheque_date != "0000-00-00") {
                $arr_cheque_date = explode("-", $model->cheque_date);
                $model->cheque_date = $arr_cheque_date[2] . "/" . $arr_cheque_date[1] . "/" . $arr_cheque_date[0];
            } else {
                $model->cheque_date = "";
            }
            if (isset($model->realisation_date) && $model->realisation_date != "0000-00-00") {
                $arr_realisation_date = explode("-", $model->realisation_date);
                $model->realisation_date = $arr_realisation_date[2] . "/" . $arr_realisation_date[1] . "/" . $arr_realisation_date[0];
            } else {
                $model->realisation_date = "";
            }
            $lease_id = $model->lease_id;
        }
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->render('create', array(
            'model' => $model,
            'lease_id' => $lease_id,
            'title' => 'Add New Receipt'
        ));
    }
    public function actionSave()
    {
        $model = new Receipt();
        /************ START Code for Save ***************/
        if (isset($_POST['Receipt'])) {
            $realisation_date = "";
            $arr_payment_date = explode("/", $_POST['Receipt']['payment_date']);
            $payment_date = $arr_payment_date[2] . "-" . $arr_payment_date[1] . "-" . $arr_payment_date[0];
            $cheque_date = "0000-00-00";
            if ((int) @$_POST['Receipt']['id'] > 0) {
                $model->id = (int) $_POST['Receipt']['id'];

                $model = $model->findByPK($model->id);
                $model->payment_date = $payment_date;
                $flat_count = 0;
                if (isset($_POST['Receipt']['building_id']) && $_POST['Receipt']['building_id'] != '')
                    $flat_count = Yii::app()->db->createCommand('SELECT COUNT(*) FROM re_flat WHERE building_id =' . $_POST['Receipt']['building_id'])->queryScalar();
                $model->flat_count = 0;
                if ($flat_count > 0) {
                    $model->flat_count = $flat_count;
                }
                if ($_POST['Receipt']['payment_type'] == 2) {
                    if (isset($_POST['Receipt']['company_bank_id']) && $_POST['Receipt']['company_bank_id'] != "") {
                        $model->company_bank_id = $_POST['Receipt']['company_bank_id'];
                    }
                    if ($_POST['Receipt']['realisation_date'] != "") {
                        $arr_realisation_date = explode("/", $_POST['Receipt']['realisation_date']);
                        $realisation_date = $arr_realisation_date[2] . "-" . $arr_realisation_date[1] . "-" . $arr_realisation_date[0];
                    }
                    $status = $_POST['Receipt']['status'];
                    $model->bank_id = $_POST['Receipt']['bank_id'];

                    if (isset($_POST['Receipt']['cheque_date']) && $_POST['Receipt']['cheque_date'] != "") {
                        $arr_cheque_date = explode("/", $_POST['Receipt']['cheque_date']);
                        $cheque_date = $arr_cheque_date[2] . "-" . $arr_cheque_date[1] . "-" . $arr_cheque_date[0];
                    }
                }
                $model->updated_by = Yii::app()->user->id;
                $model->updated_date = date('Y-m-d h:i:s');
                if ($_POST['Receipt']['payment_type'] == 1) {
                    $realisation_date = date('Y-m-d');
                    $status = 1;
                }
                $model->attributes = $_POST['Receipt'];
                $model->payment_date = $payment_date;
                $model->cheque_date = $cheque_date;
                $model->realisation_date = $realisation_date;
                $model->status = $status;
                if ($model->save()) {
                    $jsonData['status'] = 'success';
                    $jsonData['action'] = 'edit';
                    echo CJSON::encode($jsonData);
                } else {
                    $error = CActiveForm::validate($model, '', false);
                    if ($error != '[]')
                        echo $error;
                }
            } else {
                $payment_type = $_POST['Receipt']['payment_type'];
                if ($payment_type == 1) {
                    $flat_count = 0;
                    if (isset($_POST['Receipt']['building_id']) && $_POST['Receipt']['building_id'] != '')
                        $flat_count = Yii::app()->db->createCommand('SELECT COUNT(*) FROM re_flat WHERE building_id =' . $_POST['Receipt']['building_id'])->queryScalar();
                    $receipt_no = Yii::app()->db->createCommand('SELECT MAX(receipt_no)+1 FROM re_lease_receipt')->queryScalar();
                    if ($receipt_no == '' || $receipt_no == NULL) {
                        $model_settings = Settings::model()->getSettings();
                        $receipt_no = $model_settings->receipt_start_no;
                    }
                    $model->flat_count = 0;
                    if ($flat_count > 0) {
                        $model->flat_count = $flat_count;
                    }
                    $realisation_date = date('Y-m-d');
                    $status = 1;
                    $model->created_by = Yii::app()->user->id;
                    $model->created_date = date('Y-m-d h:i:s');
                    $model->building_id = $_POST['Receipt']['building_id'];
                    $model->transaction_type = $_POST['Receipt']['transaction_type'];
                    $model->flat_id = $_POST['Receipt']['flat_id'];
                    $model->lease_id = $_POST['Receipt']['lease_id'];
                    $model->payment_type = $_POST['Receipt']['payment_type'];
                    $model->remarks = $_POST['Receipt']['remarks'];
                    $model->amount = $_POST['Receipt']['amount'];
                    $model->payment_date = $payment_date;
                    $model->cheque_date = $cheque_date;
                    $model->realisation_date = $realisation_date;
                    $model->status = $status;
                    $model->receipt_no = $receipt_no;
                    if ($model->save()) {
                        $jsonData['status'] = 'success';
                        $jsonData['action'] = 'add';
                        $jsonData['payment_type'] = $payment_type;
                        $jsonData['receipt_no'] = $receipt_no;
                        echo CJSON::encode($jsonData);
                    } else {
                        $error = CActiveForm::validate($model, '', false);
                        if ($error != '[]')
                            echo $error;
                    }
                } else if ($payment_type == 2) {
                    $building_id = $_POST['Receipt']['building_id'];
                    $receipt_no = Yii::app()->db->createCommand('SELECT MAX(receipt_no)+1 FROM re_lease_receipt')->queryScalar();
                    $flat_count = 0;
                    if (isset($_POST['Receipt']['building_id']) && $_POST['Receipt']['building_id'] != '')
                        $flat_count = Yii::app()->db->createCommand('SELECT COUNT(*) FROM re_flat WHERE building_id =' . $_POST['Receipt']['building_id'])->queryScalar();
                    $flat_id = $_POST['Receipt']['flat_id'];
                    $lease_id = $_POST['Receipt']['lease_id'];
                    $transaction_type = $_POST['Receipt']['transaction_type'];
                    $remarks = $_POST['Receipt']['remarks'];
                    $status = 0;
                    $arr_date = $_POST['cheque_date'];
                    $count = count($arr_date);
                    for ($i = 0; $i < $count; $i++) {
                        $model_payment = new Receipt();
                        $arr_cheque_date = explode("/", $_POST['cheque_date'][$i]);
                        $cheque_date = $arr_cheque_date[2] . "-" . $arr_cheque_date[1] . "-" . $arr_cheque_date[0];
                        $cheque_no = $_POST['cheque_no'][$i];
                        $amount = $_POST['amount'][$i];
                        $bank = $_POST['bank_id'][$i];
                        $model_payment->flat_count = 0;
                        if ($flat_count > 0) {
                            $model_payment->flat_count = $flat_count;
                        }
                        $model_payment->building_id = $building_id;
                        $model_payment->flat_id = $flat_id;
                        $model_payment->lease_id = $lease_id;
                        $model_payment->transaction_type = $transaction_type;
                        $model_payment->payment_type = $payment_type;
                        $model_payment->remarks = $remarks;
                        $model_payment->payment_date = $payment_date;
                        $model_payment->cheque_date = $cheque_date;
                        $model_payment->realisation_date = $realisation_date;
                        $model_payment->status = $status;
                        $model_payment->amount = $amount;
                        $model_payment->bank_id = $bank;
                        $model_payment->cheque_no = $cheque_no;
                        $model_payment->created_by = Yii::app()->user->id;
                        $model_payment->created_date = date('Y-m-d h:i:s');
                        $model_payment->receipt_no = $receipt_no;
                        if ($model_payment->save()) {
                            $jsonData['receipt_no'] = $receipt_no;
                            $jsonData['action'] = 'add';
                            $jsonData['payment_type'] = $payment_type;
                            $jsonData['status'] = 'success';
                        } else {
                            $error = CActiveForm::validate($model_payment, '', false);

                        }
                    }
                    if ($error != '')
                        echo $error;
                    else
                        echo CJSON::encode($jsonData);
                } else {
                    $jsonData['status'] = 'fail';
                    echo CJSON::encode($jsonData);
                }

            }
        }
    }
    public function actionDelete()
    {
        $id = $_POST['id'];
        $model = new Receipt();
        $model->deleteByPk($id);
        echo "success";
    }
    public function actionGetAmountDetails()
    {
        $lease_id = $_POST['lease_id'];
        $receipt_id = (int) $_POST['receipt_id'];
        $lease_details = Lease::model()->find(array('select' => 'IFNULL(lease_amount,0) AS lease_amount', 'condition' => 'id=' . $lease_id));
        $arr_receipts = Receipt::model()->find(array('select' => 'IFNULL(SUM(amount),0) AS amount', 'group' => 'lease_id', 'condition' => 'lease_id=' . $lease_id . ' AND (status ="0" OR status="1") AND transaction_type="1"'));
        if ($receipt_id > 0)
            $arr_receipts = Receipt::model()->find(array('select' => 'IFNULL(SUM(amount),0) AS amount', 'group' => 'lease_id', 'condition' => 'lease_id=' . $lease_id . ' AND (status ="0" OR status="1") AND id !=' . $receipt_id));
        $jsonData['lease_amount'] = $lease_details->lease_amount;
        $jsonData['receipt_amount'] = $arr_receipts->amount;
        echo CJSON::encode($jsonData);
    }

    public function actionSearch()
    {
        $model = new Receipt();
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->render('search', array(
            'model' => $model,
            'title' => 'Report Option'
        ));
    }
    public function actionSearchResult()
    {
        $date_from = isset($_POST['Receipt']['date1']) ? $_POST['Receipt']['date1'] : '';
        $date_to = isset($_POST['Receipt']['date2']) ? $_POST['Receipt']['date2'] : '';
        $rel_from = isset($_POST['Receipt']['realisation_date1']) ? $_POST['Receipt']['realisation_date1'] : '';
        $rel_to = isset($_POST['Receipt']['drealisation_date2']) ? $_POST['Receipt']['drealisation_date2'] : '';
        $cheque_from = isset($_POST['Receipt']['cheque_date1']) ? $_POST['Receipt']['cheque_date1'] : '';
        $cheque_to = isset($_POST['Receipt']['cheque_date2']) ? $_POST['Receipt']['cheque_date2'] : '';
        $building = isset($_POST['Receipt']['building_id']) ? $_POST['Receipt']['building_id'] : '';
        $flat = isset($_POST['Receipt']['flat_id']) ? $_POST['Receipt']['flat_id'] : '';
        $transaction = isset($_POST['Receipt']['transaction_type']) ? $_POST['Receipt']['transaction_type'] : '';
        $payment = isset($_POST['Receipt']['payment_type']) ? $_POST['Receipt']['payment_type'] : '';

        $jsonData['date_from'] = $date_from;
        $jsonData['date_to'] = $date_to;
        $jsonData['rel_from'] = $rel_from;
        $jsonData['rel_to'] = $rel_to;
        $jsonData['cheque_from'] = $cheque_from;
        $jsonData['cheque_to'] = $cheque_to;
        $jsonData['building'] = $building;
        $jsonData['flat'] = $flat;
        $jsonData['transaction'] = $transaction;
        $jsonData['payment'] = $payment;
        $jsonData['status'] = 'success';
        echo CJSON::encode($jsonData);
    }
    public function actionSearchResult1()
    {
        $date_from = Yii::app()->request->getParam('date1');
        $date_to = Yii::app()->request->getParam('date2');
        $rel_from = Yii::app()->request->getParam('realisation_date1');
        $rel_to = Yii::app()->request->getParam('realisation_date2');
        $cheque_from = Yii::app()->request->getParam('cheque_date1');
        $cheque_to = Yii::app()->request->getParam('cheque_date2');
        $building = Yii::app()->request->getParam('building_id');
        $flat = Yii::app()->request->getParam('flat_id');
        $transaction = Yii::app()->request->getParam('transaction_type');
        $payment = Yii::app()->request->getParam('payment_type');
        $this->render('search_result', array(
            'date_from' => $date_from,
            'date_to' => $date_to,
            'rel_from' => $rel_from,
            'rel_to' => $rel_to,
            'cheque_from' => $cheque_from,
            'cheque_to' => $cheque_to,
            'building' => $building,
            'flat' => $flat,
            'transaction' => $transaction,
            'payment' => $payment,
            'title' => 'Search Receipt'
        ));
    }
    public function actionGetPaymentList()
    {
        $this->render('paymentlist', array('model' => new Receipt()));
    }
    public function actiongetInProcessPayments()
    {
        $date_from = $_POST['date_from'];
        $date_to = $_POST['date_to'];
        $payment_type = $_POST['payment_type'];
        $this->render('inprocess', array('datefrom' => $date_from, 'date_to' => $date_to, 'payment_type' => $payment_type));
    }
    public function actiongetCancelledPayments()
    {
        $date_from = $_POST['date_from'];
        $date_to = $_POST['date_to'];
        $payment_type = $_POST['payment_type'];
        $this->render('cancelled', array('datefrom' => $date_from, 'date_to' => $date_to, 'payment_type' => $payment_type));
    }
    public function actiongetCompletedPayments()
    {
        $date_from = $_POST['date_from'];
        $date_to = $_POST['date_to'];
        $payment_type = $_POST['payment_type'];
        $this->render('completed', array('datefrom' => $date_from, 'date_to' => $date_to, 'payment_type' => $payment_type));
    }
    public function actiongetReceiptLists()
    {
        $date_from = $_POST['date_from'];
        $date_to = $_POST['date_to'];
        $payment_type = $_POST['payment_type'];
        $this->render('receipt_list', array('datefrom' => $date_from, 'date_to' => $date_to, 'payment_type' => $payment_type));
    }
    public function actiongetBouncedPayments()
    {
        $date_from = $_POST['date_from'];
        $date_to = $_POST['date_to'];
        $payment_type = $_POST['payment_type'];
        $this->render('bounced', array('datefrom' => $date_from, 'date_to' => $date_to, 'payment_type' => $payment_type));
    }
    public function actionPrintReceiptExcel()
    {
        $date_from = Yii::app()->request->getParam('date_from');
        $date_to = Yii::app()->request->getParam('date_to');
        $rel_from = Yii::app()->request->getParam('rel_from');
        $rel_to = Yii::app()->request->getParam('rel_to');
        $cheque_from = Yii::app()->request->getParam('cheque_from');
        $cheque_to = Yii::app()->request->getParam('cheque_to');
        $building = Yii::app()->request->getParam('building');
        $flat = Yii::app()->request->getParam('flat');
        $transaction = Yii::app()->request->getParam('transaction');
        $payment = Yii::app()->request->getParam('payment');
        $condition = "1=1";
        if ($date_from != '') {
            $date_from = str_replace('/', '-', $date_from);
            $date_from = date("Y-m-d", strtotime($date_from));
            $condition .= " AND payment_date>='$date_from'";
        }
        if ($date_to != '') {
            $date_to = str_replace('/', '-', $date_to);
            $date_to = date("Y-m-d", strtotime($date_to));
            $condition .= " AND payment_date<='$date_to'";
        }
        if ($rel_from != '') {
            $rel_from = str_replace('/', '-', $rel_from);
            $rel_from = date("Y-m-d", strtotime($rel_from));
            $condition .= " AND realisation_date>='$rel_from'";
        }
        if ($rel_to != '') {
            $rel_to = str_replace('/', '-', $rel_to);
            $rel_to = date("Y-m-d", strtotime($rel_to));
            $condition .= " AND realisation_date<='$rel_to'";
        }
        if ($cheque_from != '') {
            $cheque_from = str_replace('/', '-', $cheque_from);
            $cheque_from = date("Y-m-d", strtotime($cheque_from));
            $condition .= " AND cheque_date>='$cheque_from'";
        }
        if ($cheque_to != '') {
            $cheque_to = str_replace('/', '-', $cheque_to);
            $cheque_to = date("Y-m-d", strtotime($cheque_to));
            $condition .= " AND cheque_date<='$cheque_to'";
        }
        if ($building != '' && $building != "null") {
            $condition .= " AND building_id IN(" . $building . ")";
        }
        if ($flat != '' && $flat != "null") {
            $condition .= " AND flat_id=$flat";
        }
        if ($transaction != '' && $transaction != "null") {
            $condition .= " AND transaction_type=$transaction";
        }
        if ($payment != '' && $payment != "null") {
            $condition .= " AND payment_type=$payment";
        }
        $model = Receipt::model()->findAll(array('condition' => $condition));
        $file = fopen("csvs/realestate.csv", "w");
        $total_amount = 0;
        $i=0;
        foreach ($model as $i => $value) {
            if ($i == 0) {
                $list[$i] = 'No,Receipt Date,Cheque Date,Realisation Date,Flat,Tenant,Transaction Type,Receipt Type,Amount,Status';
            }
            $payment_date = $value->payment_date;
            if ($payment_date != '0000-00-00') {
                $payment_date = date("d/m/Y", strtotime($payment_date));
            } else {
                $payment_date = '';
            }
            $cheque_date = $value->cheque_date;
            if ($cheque_date != '0000-00-00') {
                $cheque_date = date("d/m/Y", strtotime($cheque_date));
            } else {
                $cheque_date = '';
            }
            $realisation_date = $value->realisation_date;
            if ($realisation_date != '0000-00-00') {
                $realisation_date = date("d/m/Y", strtotime($realisation_date));
            } else {
                $realisation_date = '';
            }
            $total_amount += $value->amount;
            $list[$i + 1] = ($i + 1) . ',' . $payment_date . ',' . $cheque_date . ',' . $realisation_date . ',' . $value->flat->flat_no . ',' . $value->lease->tenant->name . ',' . $value->transtype->trans_name . ',' . Receipt::getPaymentType($value->payment_type) . ',' . $value->amount . ',' . Receipt::getPaymentStatus($value->status);
        }
        $list[$i + 1] = ',,,,,,,Total,' . $total_amount;
        foreach ($list as $line) {
            fputcsv($file, explode(',', $line));
        }
        fclose($file);
        $filename = 'csvs/realestate.csv';
        $path = 'csvs';
        header('Content-Type: application/csv');
        header("Content-disposition: attachment; filename=\"realestate.csv\"");
        readfile($filename);
        Yii::app()->end();
        return;
    }
    public function actionPrintReceiptPDF()
    {
        $date_from = Yii::app()->request->getParam('date_from');
        $date_to = Yii::app()->request->getParam('date_to');
        $rel_from = Yii::app()->request->getParam('rel_from');
        $rel_to = Yii::app()->request->getParam('rel_to');
        $cheque_from = Yii::app()->request->getParam('cheque_from');
        $cheque_to = Yii::app()->request->getParam('cheque_to');
        $building = Yii::app()->request->getParam('building');
        $flat = Yii::app()->request->getParam('flat');
        $transaction = Yii::app()->request->getParam('transaction');
        $payment = Yii::app()->request->getParam('payment');
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        ob_start();
        $stylesheet = file_get_contents('css/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.views.admin.receipt.search_result_pdf', array('date_from' => $date_from, 'date_to' => $date_to, 'rel_from' => $rel_from, 'rel_to' => $rel_to, 'cheque_from' => $cheque_from, 'cheque_to' => $cheque_to, 'building' => $building, 'flat' => $flat, 'transaction' => $transaction, 'payment' => $payment), true));
        ob_end_clean();
        $mPDF1->Output();
    }
    public function actionReceiptPrint()
    {
        $receipt_no = Yii::app()->request->getParam('receipt_no');
        $payment_type = Yii::app()->request->getParam('payment_type');
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        ob_start();
        $stylesheet = file_get_contents('css/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.views.admin.receipt.print_receipt', array('receipt_no' => $receipt_no, 'payment_type' => $payment_type), true));
        ob_end_clean();
        $mPDF1->Output();
    }
    public function actiongetFlatNo()
    {
        $id = Yii::app()->request->getparam("building_id");
        $condition = 'building_id="' . $id . '" ';
        $status = 0;
        $model = Flat::model()->findAll(array('condition' => $condition));
        $flat = '<li class="form-add col-sm-6"><div class="icon-box fa-th-large material m1">';
        $details = CHtml::listData($model, 'id', 'flat_no');
        if (!empty($details))
            $status = 1;
        $flat .= CHtml::dropDownList('Receipt[flat_id]', '', $details, array('class' => '', 'placeholder' => 'Flat <span class="red">*</span>'), array('options' => array('title' => array('selected' => true))));
        $flat .= '</div></li>';
        $status = array("ft" => $flat, "status" => $status);
        echo CJSON::encode($status);
    }

    public function actiongetLeaseCode()
    {
        $flat_id = Yii::app()->request->getparam("flat_id");
        $status = 0;
        $lease = '<li class="form-add col-sm-6"><div class="icon-box fa-th-large material m1">';
        $details = Lease::getFlatLease($flat_id);
        if (!empty($details))
            $status = 1;
        $lease .= CHtml::dropDownList('Receipt[lease_id]', '', $details, array('class' => '', 'placeholder' => 'Lease Code <span class="red">*</span>'), array('options' => array('title' => array('selected' => true))));
        $lease .= '</div></li>';
        $status = array("ft" => $lease, "status" => $status);
        echo CJSON::encode($status);
    }
    public function actionClearBulkCheques()
    {
        $receipt_array = Yii::app()->request->getparam("checked");
        $id_array = explode(',', $receipt_array);
        for ($i = 0; $i < count($id_array); $i++) {
            $model = new Receipt();
            $model = Receipt::model()->findByPk($id_array[$i]);
            $model->updated_by = Yii::app()->user->id;
            $model->updated_date = date('Y-m-d h:i:s');
            $model->realisation_date = date('Y-m-d');
            $model->status = 1;
            $model->save(false);

        }
        echo "success";
    }
}