<?php
class PurchasedlandController extends Controller
{
    public function filters()
    {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }
    public function accessRules()
    {
        return array(
            array(
                'allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array(
                'allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array(
                    'Index',
                    'Create',
                    'Save',
                    'Delete',
                    'Search',
                    'SearchResults',
                    'SearchData',
                    'SummarySearch',
                    'summaryDetails',
                    'summaryResults',
                    'PrintDepreciationPDF',
                    'DepreciationExcel',
                    'PrintSummaryPDF',
                    'SummaryExcel',
                    'GetOneTimePayments',
                    'GetOwnerDetails',
                    'GetChequeDetails',
                    'LoadChequeDetails',
                    'getLandlordName',
                    'getLandlordNamebyId',
                    'int_to_words',
                    'GetFinance',
                    'CalculateDepreciation',
                    'CalculateInterest',
                    'SearchAllOwner',
                    'SearchOwner',
                    'CreateDocument',
                    'DownloadDocument',
                    'SaveDocument',
                    'Upload'
                ),
                'expression' => '$user->isMember()',
            ),
            array(
                'deny', // deny all users
                'users' => array('*'),
            ),
        );
    }
    public function actionIndex()
    {
        $condition = 'status="Y" AND purchase_status = 2 AND building_or_land=1';
        if (Yii::app()->user->authorised_user != 1) {
            $user_id = Yii::app()->user->id;
            $modeluser = User::model()->findByPk($user_id);
            if (($modeluser->user_group_id == "4") && ($modeluser->owner_id != 0))
                $condition .= " AND ownerdetail.landlord = " . $modeluser->owner_id;
        }
        $model = Building::model()->with('ownerdetail')->findAll(array('condition' => $condition, 'order' => 'building_name'));
        $this->render('index', array(
            'model' => $model,
        ));
    }
    public function actionCreate()
    {
        $id = (int) Yii::app()->request->getParam('id');
        $model = new Building();
        $model_owner = new BuildingOwnerDetails();
        $model_details = array(new BuildingOwnerDetails());
        if ($id > 0) {
            $model = $model->findByPk($id);
            $condition = 'building = ' . $id;
            $model_details = $model_owner->findAll(array('condition' => $condition));
            if (isset($model->buying_date) && $model->buying_date != "0000-00-00" && $model->buying_date != '') {
                $arr_buying_date = explode("-", $model->buying_date);
                $model->buying_date = $arr_buying_date[2] . "/" . $arr_buying_date[1] . "/" . $arr_buying_date[0];
            } else {
                $model->buying_date = "";
            }
            if (empty($model_details))
                $model_details = array(new BuildingOwnerDetails());
        }
        $this->render('create', array(
            'model' => $model,
            'model_details' => $model_details,
            'building_id' => $id,
            'title' => 'Add Purchased Land'
        ));
    }
    public function actionSave()
    {
        $model = new Building();
        if (isset($_POST['Building'])) {
            if ((int) @$_POST['Building']['id'] > 0) {
                $model->id = (int) $_POST['Building']['id'];
                $model = $model->findByPK($model->id);
                $model->updated_by = Yii::app()->user->id;
                $model->updated_date = date('Y-m-d h:i:s');
            } else {
                $model->created_by = Yii::app()->user->id;
                $model->created_date = date('Y-m-d h:i:s');
            }
            $model->attributes = $_POST['Building'];
            if ($_POST['Building']['buying_date'] != '' && $_POST['Building']['buying_date'] != '0000-00-00') {
                $dateObj = DateTime::createFromFormat('d/m/Y', $_POST['Building']['buying_date']);
                if ($dateObj !== false) {
                    $model->buying_date = $dateObj->format('Y-m-d');
                } else {
                    $model->buying_date = ''; // or handle invalid date format here
                }
            } else {
                $model->buying_date = '';
            }

            $model->purchase_status = 2;
            $model->building_or_land = 1;
            $model->address = isset($_POST['Building']['address']) ? $_POST['Building']['address'] : '';
            $model->building_id = isset($_POST['Building']['building_id']) ? $_POST['Building']['building_id'] : '';
            $model->buying_value = isset($_POST['Building']['buying_value']) ? $_POST['Building']['buying_value'] : '';
            $model->country = isset($_POST['Building']['country']) ? $_POST['Building']['country'] : '';
            $model->depreciation = isset($_POST['Building']['depreciation']) ? $_POST['Building']['depreciation'] : '';
            $model->depreciation_months = isset($_POST['Building']['depreciation_months']) ? $_POST['Building']['depreciation_months'] : '';
            $model->email = isset($_POST['Building']['email']) ? $_POST['Building']['email'] : '';
            $model->emirate = isset($_POST['Building']['emirate']) ? $_POST['Building']['emirate'] : '';
            $model->flats = isset($_POST['Building']['flats']) ? $_POST['Building']['flats'] : '';
            $model->floors = isset($_POST['Building']['floors']) ? $_POST['Building']['floors'] : '';
            $model->location = isset($_POST['Building']['location']) ? $_POST['Building']['location'] : '';
            $model->mobile = isset($_POST['Building']['mobile']) ? $_POST['Building']['mobile'] : '';
            $model->builder_name = isset($_POST['Building']['builder_name']) ? $_POST['Building']['builder_name'] : '';
            $model->squarefeet = isset($_POST['Building']['squarefeet']) ? $_POST['Building']['squarefeet'] : '';
            $model->squarefeet_rate = isset($_POST['Building']['squarefeet_rate']) ? $_POST['Building']['squarefeet_rate'] : '';
            $model->squaremetre = isset($_POST['Building']['squaremetre']) ? $_POST['Building']['squaremetre'] : '';
            $model->state = isset($_POST['Building']['state']) ? $_POST['Building']['state'] : '';
            $model->telephone = isset($_POST['Building']['telephone']) ? $_POST['Building']['telephone'] : '';
            
            if ($model->save()) {
                $jsonData['status'] = 'success';
                $jsonData['id'] = $model->id;
                $output = CJSON::encode($jsonData);
                if (isset($_POST['BuildingOwnerDetails'])) {
                    $arr_details = $_POST['BuildingOwnerDetails'];
                    foreach ($arr_details as $each_detail) {
                        $details_id = $each_detail['id'];
                        $model_owner = new BuildingOwnerDetails();
                        if ($details_id > 0) {
                            $model_owner = $model_owner->findByPK($details_id);
                            $model_owner->id = $details_id;
                            $model_owner->updated_by = Yii::app()->user->id;
                            $model_owner->updated_date = date('Y-m-d h:i:s');
                        } else {
                            $model_owner->created_by = Yii::app()->user->id;
                            $model_owner->created_date = date('Y-m-d h:i:s');
                        }
                        $model_owner->building = $model->id;
                        $model_owner->landlord = $each_detail['landlord'];
                        $model_owner->percentage_amount = '0';
                        $model_owner->percentage = '0';
                        if ($each_detail['percentage'] != '') {
                            $model_owner->percentage = $each_detail['percentage'];
                        }
                        if ($each_detail['percentage'] != '') {
                            $model_owner->percentage_amount = $each_detail['percentage_amount'];
                        }
                        $model_owner->save();
                    }
                    $jsonData['status'] = 'success';
                    $jsonData['id'] = $model->id;
                    $jsonData['owner_status'] = '1';
                    $output = CJSON::encode($jsonData);
                }
            } else {
                $error = CActiveForm::validate($model, '', false);
                if ($error != '[]')
                    $output = $error;
            }
        }

        echo $output;
    }
    public function actionGetOwnerDetails()
    {
        $building_id = $_POST['building_id'];
        $model = new Building();
        $model_owner = new BuildingOwnerDetails();
        $model_details = array(new BuildingOwnerDetails());
        if ($building_id > 0) {
            $model = $model->findByPk($building_id);
            $condition = 'building = ' . $building_id;
            $model_details = $model_owner->findAll(array('condition' => $condition));
            if (empty($model_details))
                $model_details = array(new BuildingOwnerDetails());
        }
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->render('owner_details', array('model' => $model, 'model_details' => $model_details, 'building_id' => $building_id));
    }
    public function actionGetOneTimePayments()
    {
        $building_id = $_POST['building_id'];
        $model = new OnetimePayments();
        $arr_details = array();
        if ($building_id > 0) {
            $condition = 'building_id = ' . $building_id;
            $arr_details = $model->findAll(array('condition' => $condition));
        }
        $this->renderPartial('payments_onetime_details', array('model' => $model, 'arr_details' => $arr_details, 'building_id' => $building_id));
    }
    public function actionGetFinance()
    {
        $building_id = $_POST['building_id'];
        $model = new Finance();
        $model_building = new Building();
        $arr_details = array();
        if ($building_id > 0) {
            $condition = 'building_id = ' . $building_id;
            $arr_details = $model->findAll(array('condition' => $condition));
        }
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->render('finance_detail', array('model' => $model, 'arr_details' => $arr_details, 'building_id' => $building_id, 'model_building' => $model_building));
    }
    public function actionGetChequeDetails()
    {
        $building_id = $_POST['building_id'];
        $this->renderPartial('cheque_details', array('building_id' => $building_id));
    }
    /* public function actionCalculateDepreciation()
    {
        $building   = Yii::app()->request->getParam('building_id');
        $condition="status='y' AND id=$building";
        $building_model = Building::model()->findAll(array('condition'=>$condition));
        $this->render('building_depreciation',array('building_model'=>$building_model,'building'=>$building,'title' => 'Calculate Depreciation'));
    }*/
    public function actionCalculateInterest()
    {
        $building = Yii::app()->request->getParam('building_id');
        $condition = "id=$building";
        $building_model = Building::model()->findAll(array('condition' => $condition));
        $this->render('interest_calculation', array('building_model' => $building_model, 'building' => $building, 'title' => 'Calculate Interest'));
    }
    public function actionLoadChequeDetails()
    {
        $amount = $_POST['amount'];
        $arr_bank = $_POST['arr_bank'];
        $no_installments = $_POST['no_installments'];
        $arr_start_cheque = $_POST['arr_start_cheque'];
        $arr_stop_cheque = $_POST['arr_stop_cheque'];
        $start_date = $_POST['start_date'];
        $frequency = $_POST['frequency'];
        $landlord = $_POST['landlord'];
        $div_details = '<table class="table table-striped table-primary" id="tab_cheque_details">';
        $div_details .= '<input type="hidden" name="landlord_id" id="landlord_id" value="' . $landlord . '">';
        $div_details .= '<thead><tr><th>No</th><th>Date</th><th>Cheque No</th><th>Amount</th><th>Bank</th></tr></thead>';
        for ($j = 0; $j < count($arr_start_cheque); $j++) {
            for ($k = $arr_start_cheque[$j]; $k <= $arr_stop_cheque[$j]; $k++) {
                $arr_checkno[] = $k;
                $arr_bankname[] = $arr_bank[$j];
            }

        }
        for ($i = 0; $i < $no_installments; $i++) {
            $j = $i + 1;
            $div_details .= '<tr>';
            $div_details .= '<td>' . $j . '</td>';
            $div_details .= '<td><div class="material m1">' . CHtml::textField('date[]', $start_date, array('class' => 'date-picker', 'id' => 'date' . $i)) . '</div></td>';
            $div_details .= '<td><div class="material m1">' . CHtml::textField('cheque_no[]', $arr_checkno[$i], array('id' => 'cheque_no' . $i, 'onkeypress' => 'return isNumberKey(event)')) . '</div></td>';
            $div_details .= '<td><div class="material m1">' . CHtml::textField('amount[]', $amount, array('id' => 'amount' . $i, 'onkeypress' => 'return isNumberKey(event)', 'class' => 'text-right')) . '</div></td>';
            $div_details .= '<td><div class="material m1">' . CHtml::textField('bank[]', $arr_bankname[$i], array('id' => 'bank' . $i)) . '</div></td>';
            $div_details .= '</tr>';
            $start_cheque_no = $start_cheque_no + 1;
            if ($frequency == '0') { //monthly
                $newdate = DateTime::createFromFormat('d/m/Y', $start_date)->format('Y-m-d');
                $mdate = strtotime($newdate . " +1 month") . '<br/>';
                $start_date = date('d/m/Y', $mdate);
            } else if ($frequency == '1') { //quaterly
                $newdate = DateTime::createFromFormat('d/m/Y', $start_date)->format('Y-m-d');
                $mdate = strtotime($newdate . " +3 month") . '<br/>';
                $start_date = date('d/m/Y', $mdate);
            } else if ($frequency == '2') { //quaterly
                $newdate = DateTime::createFromFormat('d/m/Y', $start_date)->format('Y-m-d');
                $mdate = strtotime($newdate . " +6 month") . '<br/>';
                $start_date = date('d/m/Y', $mdate);
            } else if ($frequency == '3') { //quaterly
                $newdate = DateTime::createFromFormat('d/m/Y', $start_date)->format('Y-m-d');
                $mdate = strtotime($newdate . " +1 year") . '<br/>';
                $start_date = date('d/m/Y', $mdate);
            }
        }
        $div_details .= '</table>';
        echo $div_details;
    }

    public function actionDelete()
    {
        $id = $_POST['id'];
        $model = new Building();
        $arr_landlord = BuildingOwnerDetails::model()->findAll(array('condition' => 'building=' . $id));
        $arr_pay = Payment::model()->findAll(array('condition' => 'building_id=' . $id));
        if (empty($arr_landlord) && empty($arr_pay)) {
            $model->deleteByPk($id);
            echo "success";
        } else {
            echo "fail";
        }

    }
    /*public function actionSearch()
    {
            $model = new Building();
            Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
                    $this->render('search',array(
                            'model'=>$model,
                            'title' => 'Calculate Depreciation'
                    ));
    }*/
    public function actionSummarySearch()
    {
        $model = new Building();
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->render('summary_search', array(
            'model' => $model,
            'title' => 'Summary'
        ));
    }
    public function actionSummaryDetails()
    {
        $date_from = $_POST['date1'];
        $date_to = $_POST['date2'];
        $building = $_POST['building_id'];
        $jsonData['date_from'] = $date_from;
        $jsonData['date_to'] = $date_to;
        $jsonData['building'] = $building;
        $jsonData['status'] = 'success';
        echo CJSON::encode($jsonData);
    }
    public function actionSummaryResults()
    {
        $date_from = Yii::app()->request->getParam('date1');
        $date_to = Yii::app()->request->getParam('date2');
        $building = Yii::app()->request->getParam('building_id');
        $condition = "status='y' AND purchase_status = 1";

        if ($date_to != '') {
            $date_to = str_replace('/', '-', $date_to);
            $date_to = date("Y-m-d", strtotime($date_to));
            $condition .= " AND buying_date <='$date_to'";
        }
        if ($building != '' && $building != "null") {
            $condition .= " AND id=$building";
            $building_name = Building::model()->getBuildingName($building);
        } else {
            $building_name = 'All';
        }
        $building_model = Building::model()->findAll(array('condition' => $condition));
        $this->render('search_result', array('building_model' => $building_model, 'date_from' => $date_from, 'date_to' => $date_to, 'building' => $building, 'building_name' => $building_name, 'title' => 'Calculate Depreciation'));
    }
    public function actionSearchData()
    {
        $date_from = $_POST['date1'];
        $building = $_POST['building_id'];
        $jsonData['date_from'] = $date_from;
        $jsonData['building'] = $building;
        $jsonData['status'] = 'success';
        echo CJSON::encode($jsonData);
    }
    public function actionSearchResults()
    {
        $date_from = Yii::app()->request->getParam('date1');
        $building = Yii::app()->request->getParam('building_id');
        $condition = "status='y' AND purchase_status = 1";
        if ($date_from != '') {
            $date_from = str_replace('/', '-', $date_from);
            $date_from = date("Y-m-d", strtotime($date_from));
            $condition .= " AND buying_date <='$date_from'";
        }
        if ($building != '' && $building != "null") {
            $condition .= " AND id=$building";
            $building_name = Building::model()->getBuildingName($building);
        } else {
            $building_name = 'All';
        }
        $building_model = Building::model()->findAll(array('condition' => $condition));
        $this->render('calculate_depreciation', array('building_model' => $building_model, 'date_from' => $date_from, 'building' => $building, 'building_name' => $building_name, 'title' => 'Calculate Depreciation'));
    }
    /*
    public function actionPrintDepreciationPDF()
    {
        $date=Yii::app()->request->getParam('date_from');
        $building=Yii::app()->request->getParam('building');
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents('css/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.views.admin.purchasedbuilding.depreciation_pdf', array('date' => $date,'building'=>$building), true));
        $mPDF1->Output();
    }
    
    public function actionDepreciationExcel()
    {
        $date=Yii::app()->request->getParam('date_from');
        $building=Yii::app()->request->getParam('building');
        $condition="status='y' AND purchase_status = 1";
        if($date_from=="" || $date_from=='0000-00-00')
            $date_from=date("Y-m-d");
        if($date_from!='')
        {
            $condition.=" AND buying_date <='$date_from'";
        }
        if($building!='' && $building!="null")
        {
            $condition.=" AND id=$building";
            $building_name = Building::model()->getBuildingName($building);
        }else{
            $building_name = 'All';
        }
        $building_model = Building::model()->findAll(array('condition'=>$condition));
        $file = fopen("csvs/realestate.csv","w");
        $ts2 = strtotime($date_from);
        $j=0;
        $list[$j]='Building,'.$building_name.',,,Date,'.$date_from;
        $j++;$j++;
        foreach ($building_model as $i=>$row) {
            $each_buying_value = $row->buying_value;
            $each_buying_date  = $row->buying_date;
            $each_depreciation_months=$row->depreciation_months;
            $ts1 = strtotime($each_buying_date);
            $mdate =$ts1;               
            $year1 = date('Y', $ts1);
            $year2 = date('Y', $ts2);
            $month1 = date('m', $ts1);
            $month2 = date('m', $ts2);
            $diff = (($year2 - $year1) * 12) + ($month2 - $month1);
            $j+=$i;
            $list[$j++]='Building,'.$row->building_name.',No.Of.Months,'.$diff.',Value,'.$each_buying_value;
            $j++;
            $list[$j++]='Month,Value,Depreciation,Amount';
            if($diff ==0){
              $each_depreciation = 0; 
              $list[$j++]='No Details Found';
            }else{
                if($each_depreciation_months != 0)
                    $each_depreciation = ($each_buying_value * $diff)/$each_depreciation_months;
                else {
                    $each_depreciation =0;
                }
                $cur_amnt = $each_buying_value;
                $current_value =$each_buying_value;
                $depr_month    = 0;
                $depr_per_month = $each_buying_value/$each_depreciation_months;
                for($i=1;$i<=$diff;$i++){
                    $buying_value=$current_value-$depr_month;
                    $depr_month += $depr_per_month;
                    if($cur_amnt > 0){
                        $cur_amnt= number_format((float)$buying_value, 2, '.', '')-number_format((float)$depr_per_month, 2, '.', '');
                        $dateObj   = DateTime::createFromFormat('!m', $month1);
                        $monthName = $dateObj->format('F');
                        $month_year = $monthName.' '.$year1;
                        $mdate = strtotime(date("Y-m-d", $mdate) . " +1 month");
                        $year1 = date('Y', $mdate);
                        $month1 = date('m', $mdate);
                        $list[$j++]=$month_year.','.number_format((float)$buying_value, 2, '.', '').','.number_format((float)$depr_per_month, 2, '.', '').','.number_format((float)$cur_amnt, 2, '.', '').',';

                    } 
                }
            }
            
        }
        foreach ($list as $line)
        {
              fputcsv($file,explode(',',$line));
        }
        fclose($file);
        $filename = Yii::app()->getBaseUrl(true).'/csvs/realestate.csv';
        $path=Yii::app()->getBaseUrl(true).'/csvs';
        header('Content-Type: application/csv');
        header("Content-disposition: attachment; filename=\"realestate.csv\"");
        readfile($filename);
        Yii::app()->end();
        return;
    }
    public function actionPrintSummaryPDF()
    {
        $date_from  = Yii::app()->request->getParam('date_from');
        $date_to    = Yii::app()->request->getParam('date_to');
        $my_hidden  = Yii::app()->request->getParam('my_hidden');
        $building=Yii::app()->request->getParam('building');
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents('css/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.views.admin.purchasedbuilding.summary_pdf', array('date_from' => $date_from,'date_to' => $date_to,'building'=>$building,'my_hidden'=>$my_hidden), true));
        $mPDF1->Output();
    }
    public function actionSummaryExcel()
    {
        $date_from  = Yii::app()->request->getParam('date_from');
        $date_to    = Yii::app()->request->getParam('date_to');
        $my_hidden  = Yii::app()->request->getParam('my_hidden');
        $building   = Yii::app()->request->getParam('building');
        $condition="status='y' AND purchase_status = 1";
        if($date_from!='')
        {
            $condition.=" AND buying_date >='$date_from'";
        }
        if($date_to!='')
        {
            $condition.=" AND buying_date <='$date_to'";
        }
        if($building!='' && $building!="null")
        {
            $condition.=" AND id=$building";
            $building_name = Building::model()->getBuildingName($building);
        }else{
            $building_name = 'All';
        }
        $building_model = Building::model()->findAll(array('condition'=>$condition));
        $income_total           = 0;
        $total_rent             = 0;
        $total_rent_paid        = 0;
        $total_rent_pending     = 0;
        $expense_total          = 0;
        $total_buying_value     = 0;
        $total_depreciation     = 0;
        $total_expense          = 0;
        $total_mortgage_paid    = 0;
        $total_mortgage_pending = 0;
        if($date_to=="" || $date_to=='0000-00-00')
                $date_to        = date("Y-m-d");
        $ts2                    = strtotime($date_to);
        $tr_expense             = '';
        foreach ($building_model as $i=>$row) {
            $each_buying_value = $row->buying_value;
            $each_buying_date  = $row->buying_date;
            $each_depreciation_months=$row->depreciation_months;
            $total_buying_value +=$each_buying_value;
            $ts1 = strtotime($each_buying_date);
            $year1 = date('Y', $ts1);
            $year2 = date('Y', $ts2);
            $month1 = date('m', $ts1);
            $month2 = date('m', $ts2);
                        //echo $month2." ".$month1." ".($month2 - $month1)." ";
            $diff = (($year2 - $year1) * 12) + ($month2 - $month1);
            if($diff ==0){
                $each_depreciation = 0;
            }else{
                if($each_depreciation_months != 0)
                  $each_depreciation = ($each_buying_value * $diff)/$each_depreciation_months;
                else {
                  $each_depreciation =0;
                }
            }
            $total_depreciation +=$each_depreciation;
            if($date_from!="" && $date_from!='0000-00-00'&& $date_to!="" && $date_to!='0000-00-00'){
                $rent_connection = Yii::app()->db->createCommand()
                  ->select("SUM(LR.amount) as amount,LR.status")
                  ->from("{{lease_receipt}} LR")
                  ->where('LR.building_id="'.$row->id.'"')
                  ->andWhere('LR.payment_date<="'.$date_to.'"')
                  ->andWhere('LR.payment_date>="'.$date_from.'"')
                  ->group("LR.status");
                $expense_connection = Yii::app()->db->createCommand()
                    ->select("SUM(E.expense_amount) as expense_amount,ET.expense_type")
                    ->from("{{expense}} E")
                    ->leftjoin("{{expense_type}} ET" , "ET.id= E.expense_type")
                    ->where('E.building_id="'.$row->id.'"')
                    ->andWhere('E.expense_date<="'.$date_to.'"')
                    ->andWhere('E.expense_date>="'.$date_from.'"')
                    ->group("E.expense_type");
                $mortgage_connection = Yii::app()->db->createCommand()
                  ->select("SUM(P.amount) as amount,P.status")
                  ->from("{{mortgage_payment}} P")
                  ->where('P.building_id="'.$row->id.'"')
                  ->andWhere('P.payment_date<="'.$date_to.'"')
                  ->andWhere('P.payment_date>="'.$date_from.'"')
                  ->group("P.status");
            }else if($date_from!="" && $date_from!='0000-00-00'){
                $rent_connection = Yii::app()->db->createCommand()
                    ->select("SUM(LR.amount) as amount,LR.status")
                    ->from("{{lease_receipt}} LR")
                    ->where('LR.building_id="'.$row->id.'"')
                    ->andWhere('LR.payment_date>="'.$date_from.'"')
                    ->group("LR.status");
                $expense_connection = Yii::app()->db->createCommand()
                    ->select("SUM(E.expense_amount) as expense_amount,ET.expense_type")
                    ->from("{{expense}} E")
                    ->leftjoin("{{expense_type}} ET" , "ET.id= E.expense_type")
                    ->where('E.building_id="'.$row->id.'"')
                    ->andWhere('E.expense_date>="'.$date_from.'"')
                    ->group("E.expense_type");
                $mortgage_connection = Yii::app()->db->createCommand()
                    ->select("SUM(P.amount) as amount,P.status")
                    ->from("{{mortgage_payment}} P")
                    ->where('P.building_id="'.$row->id.'"')
                    ->andWhere('P.payment_date>="'.$date_from.'"')
                    ->group("P.status");
            }else if($date_to!="" && $date_to!='0000-00-00'){
                $rent_connection = Yii::app()->db->createCommand()
                    ->select("SUM(LR.amount) as amount,LR.status")
                    ->from("{{lease_receipt}} LR")
                    ->where('LR.building_id="'.$row->id.'"')
                    ->andWhere('LR.payment_date<="'.$date_to.'"')
                    ->group("LR.status");
                $expense_connection = Yii::app()->db->createCommand()
                    ->select("SUM(E.expense_amount) as expense_amount,ET.expense_type")
                    ->from("{{expense}} E")
                    ->leftjoin("{{expense_type}} ET" , "ET.id= E.expense_type")
                    ->where('E.building_id="'.$row->id.'"')
                    ->andWhere('E.expense_date<="'.$date_to.'"')
                    ->group("E.expense_type");
                $mortgage_connection = Yii::app()->db->createCommand()
                    ->select("SUM(P.amount) as amount,P.status")
                    ->from("{{mortgage_payment}} P")
                    ->where('P.building_id="'.$row->id.'"')
                    ->andWhere('P.payment_date<="'.$date_to.'"')
                    ->group("P.status");
            }else{
                $rent_connection = Yii::app()->db->createCommand()
                  ->select("SUM(LR.amount) as amount,LR.status")
                  ->from("{{lease_receipt}} LR")
                  ->where('LR.building_id="'.$row->id.'"')
                  ->group("LR.status");
                $expense_connection = Yii::app()->db->createCommand()
                    ->select("SUM(E.expense_amount) as expense_amount,ET.expense_type")
                    ->from("{{expense}} E")
                    ->leftjoin("{{expense_type}} ET" , "ET.id= E.expense_type")
                    ->where('E.building_id="'.$row->id.'"')
                    ->group("E.expense_type");
                $mortgage_connection = Yii::app()->db->createCommand()
                    ->select("SUM(P.amount) as amount,P.status")
                    ->from("{{mortgage_payment}} P")
                    ->where('P.building_id="'.$row->id.'"')
                    ->group("P.status");
            }
            $arr_rent   = $rent_connection->queryAll();
            foreach($arr_rent as $each_rdetail){
              if($each_rdetail["status"]==1){
                $total_rent_paid +=$each_rdetail["amount"];
              }
              if($each_rdetail["status"]==0){
                $total_rent_pending +=$each_rdetail["amount"];
              }
            }
            $arr_expenses   = $expense_connection->queryAll();
            foreach($arr_expenses as $each_edetail){
                $total_expense +=$each_edetail["expense_amount"];
            }
            $arr_mortgage   = $mortgage_connection->queryAll();
            //echo $mortgage_connection->text;
            foreach($arr_mortgage as $each_mdetail){
              if($each_mdetail["status"]==1){
                $total_mortgage_paid +=$each_mdetail["amount"];
              }
              if($each_mdetail["status"]==0){
                $total_mortgage_pending +=$each_mdetail["amount"];
              }
            }
        }
        $total_rent     = $total_rent_pending+$total_rent_paid;
        $income_total   = number_format((float)$total_rent, 2, '.', '');
        $expense_total  = number_format((float)($total_mortgage_pending+$total_mortgage_paid+$total_expense+$total_depreciation), 2, '.', '');
        $net_total      = number_format((float)($income_total-$expense_total), 2, '.', '');
        $file = fopen("csvs/realestate.csv","w");
        $j=0;
        $list[$j]='Building,'.$building_name.',,Date From,'.$date_from.',,Date To,'.$date_to;
        $j++;$j++;
        $list[$j++]='Income,Amount,Expense,Amount';
        $list[$j++]='Rent,'.number_format((float)$total_rent, 2, '.', '').',Mortgage Paid,'.number_format((float)$total_mortgage_paid, 2, '.', '').',';
        $list[$j++]=',,Mortgage Pending,'.number_format((float)$total_mortgage_pending, 2, '.', '').',';
        $list[$j++]=',,Expenses,'.number_format((float)$total_expense, 2, '.', '').',';
        if($my_hidden !=0){
            foreach($arr_expenses as $each_edetail){
                $list[$j++]=',,'.$each_edetail["expense_type"].','.number_format((float)$each_edetail["expense_amount"], 2, '.', '').',';
            }
        }
        $list[$j++]=',,Depreciation,'.number_format((float)$total_depreciation, 2, '.', '').',';
        $list[$j++]='Total Income,'.number_format((float)$income_total, 2, '.', '').',Total Expense,'.number_format((float)$expense_total, 2, '.', '').',';
        $list[$j++]=',,Net P/L,'.number_format((float)$net_total, 2, '.', '');
        
        foreach ($list as $line)
        {
              fputcsv($file,explode(',',$line));
        }
        fclose($file);
        $filename = Yii::app()->getBaseUrl(true).'/csvs/realestate.csv';
        $path=Yii::app()->getBaseUrl(true).'/csvs';
        header('Content-Type: application/csv');
        header("Content-disposition: attachment; filename=\"realestate.csv\"");
        readfile($filename);
        Yii::app()->end();
        return;
    }*/
    public function actiongetLandlordName()
    {
        $search_char = $_POST['search_char'];
        $building_id = $_POST['building_id'];
        $field_id = $_POST['field_id'];
        $arrids = explode('landlord_id_value_', $field_id);
        $repeat_id = $arrids[1];
        $condition = 'name LIKE "' . $search_char . '%"';
        $arr_landlord = Landlord::model()->findAll(array('condition' => $condition));
        $jsonData['landlorddetail'] = '<div class="pu-content">
                <div class="pu-body">
            <div class="col-xs-4 np pu-table">
            <table id="landlord_name_details" class="table-tab striped-table">
                <thead>
                 <tr class="">
                    <th>Landlord Name</th>
                 </tr>
                </thead>
                <tbody>';


        foreach ($arr_landlord as $i => $landlord_name):
            $jsonData['landlorddetail'] .= '<tr>
                     <td onclick="setlandlordvalue(' . $landlord_name->id . ',' . $repeat_id . ');$(\'#' . $field_id . '\').val(\'' . $landlord_name->name . '\');$(\'#' . $field_id . '\').text(\'' . $landlord_name->name . '\');" class="">' . $landlord_name->name . '</td>                   
                    </tr>';
        endforeach;
        $jsonData['landlorddetail'] .= ' </tbody>
                </table></div></div></div>';
        echo CJSON::encode($jsonData);
    }
    public function actiongetLandlordNamebyId()
    {
        $id = $_POST['landlord_id'];
        $model_landlord = Landlord::model()->findbyPk($id);
        $jsonData['landlordname'] = $model_landlord->name;
        echo CJSON::encode($jsonData);
    }
    public function actionSearchAllOwner()
    {
        $from = $_GET['frm'];
        $building_id = $_GET['building_id'];
        $searchTerm = $_GET['term'];
        $condition = 'name LIKE "' . $searchTerm . '%"';
        $model = new Landlord();
        $model = $model->findAll(array('select' => 'id,name', 'condition' => $condition, 'order' => 'name'));

        $i = 0;
        foreach ($model as $eachModel) {
            $data[$i]['value'] = $eachModel->id;

            $data[$i]['label'] = $eachModel->id . " : " . $eachModel->name;
            $data[$i]['name'] = $eachModel->name;
            $i++;
        }
        echo CJSON::encode($data);
        Yii::app()->end();
    }
    public function actionSearchOwner()
    {
        $from = $_GET['frm'];
        $building_id = $_GET['building_id'];
        $searchTerm = $_GET['term'];
        $condition = 'L.name LIKE "' . $searchTerm . '%" AND L.status =  "Y"';
        if ($building_id > 0) {
            $condition .= ' AND building = "' . $building_id . '"';
        }
        $model = BuildingOwnerDetails::model()->with('landlord_details')->findAll(array('condition' => $condition, 'order' => 'L.name', 'join' => 'LEFT JOIN re_landlord AS L ON t.landlord = L.id '));
        $i = 0;
        foreach ($model as $eachModel) {
            $data[$i]['value'] = $eachModel->id;

            $data[$i]['label'] = $eachModel->id . " : " . $eachModel->landlord_details->name;
            $data[$i]['name'] = $eachModel->landlord_details->name;
            $i++;
        }
        echo CJSON::encode($data);
        Yii::app()->end();
    }
    public function actionCreateDocument()
    {

        $id = (int) Yii::app()->request->getParam('id');
        $building_id = (int) Yii::app()->request->getParam('building_id');
        $model = new PurchasedDocuments();

        if ($id > 0) {
            $model = $model->findByPk($id);
        }

        Yii::app()->clientScript->scriptMap = array('jquery.min.js' => false);

        $this->render('createdocument', array(

            'model' => $model,

            'title' => 'Add New Land Document',

            'building_id' => $building_id

        ));
    }
    public function actionSaveDocument()
    {
        $model = new PurchasedDocuments();
        /************ START Code for Save ***************/
        if (isset($_POST['PurchasedDocuments'])) {

            if ((int) @$_POST['PurchasedDocuments']['id'] > 0) {
                $model->id = (int) $_POST['PurchasedDocuments']['id'];
                $model = $model->findByPK($model->id);
                $model->updated_by = Yii::app()->user->id;
                $model->updated_date_time = date('Y-m-d h:i:s');
            } else {
                $model->created_by = Yii::app()->user->id;
                $model->created_date_time = date('Y-m-d h:i:s');
            }

            $model->attributes = $_POST['PurchasedDocuments'];
            $model->document_file = $_POST['PurchasedDocuments']['document_file'];
            $model->building_id = $_POST['building_id'];
            $model->purchased_type = '3';
            if ($model->save()) {
                $jsonData['status'] = 'success';
                $jsonData['building_id'] = $_POST['building_id'];
                echo CJSON::encode($jsonData);
            } else {
                $error = CActiveForm::validate($model, '', false);
                if ($error != '[]')
                    echo $error;
            }
        }
    }
    public function actionDownloadDocument()
    {
        $id = (int) Yii::app()->request->getparam('id');
        $sfile = PurchasedDocuments::model()->findByPk($id);
        $arr_doc_val = explode(',', $sfile->document_file);
        $zip = new ZipArchive();
        $zip_file_path = Yii::getPathOfAlias('webroot') . "/downloadzip/" . $sfile->file_name . "_" . date('d-m-Y') . ".zip";

        if ($zip->open($zip_file_path, 1 ? ZIPARCHIVE::OVERWRITE : ZIPARCHIVE::CREATE) === TRUE) {
            for ($i = 0; $i < count($arr_doc_val); $i++) {
                $path = "uploads/documents/" . $arr_doc_val[$i];
                // Add the files to the .zip file
                $zip->addFile($path, $arr_doc_val[$i]);
            }
            // Closing the zip file
            $zip->close();
        }

        header("Content-type:application/zip"); //for pdf file
        //if you want to read text file using text/plain header
        header('Content-Disposition: attachment; filename="' . basename($zip_file_path) . '"');
        header('Content-Length: ' . filesize($zip_file_path));
        readfile($zip_file_path);

        @unlink($zip_file_path);
        Yii::app()->end();
    }
    public function int_to_words($x)
    {
        $nwords = array('Zero', 'One', 'Two', 'Three', 'Four', 'Five', 'Six', 'Seven', 'Eight', 'Nine', 'Ten', 'Eleven', 'Twelve', 'Thirteen', 'Fourteen', 'Fifteen', 'Sixteen', 'Seventeen', 'Eighteen', 'Nineteen', 'Twenty', 30 => 'Thirty', 40 => 'Forty', 50 => 'Fifty', 60 => 'Sixty', 70 => 'Seventy', 80 => 'Eighty', 90 => 'Ninety');
        if (!is_numeric($x)) {
            $w = '#';
        } else if (fmod($x, 1) != 0) {
            $w = '#';
        } else {
            if ($x < 0) {
                $w = 'minus';
                $x = -$x;
            } else {
                $w = '';
            }
            if ($x < 21) {
                $w .= $nwords[$x];
            } else if ($x < 100) {
                $w .= $nwords[10 * floor($x / 10)];
                $r = fmod($x, 10);
                if ($r > 0) {
                    $w .= '-' . $nwords[$r];
                }
            } else if ($x < 1000) {
                $w .= $nwords[floor($x / 100)] . ' Hundred';
                $r = fmod($x, 100);
                if ($r > 0) {
                    $w .= ' and ' . $this->int_to_words($r);
                }
            } else if ($x < 1000000) {
                $w .= $this->int_to_words(floor($x / 1000)) . ' Thousand ';
                $r = fmod($x, 1000);
                if ($r > 0) {
                    $w .= '';
                    if ($r < 100) {
                        $w .= 'and ';
                    }
                    $w .= $this->int_to_words($r);
                }
            } else //if($x < 10000000)
            {
                $w .= $this->int_to_words(floor($x / 1000000)) . ' Million ';
                $r = fmod($x, 1000000);
                if ($r > 0) {
                    $w .= '';
                    if ($r < 100) {
                        $word .= 'and ';
                    }
                    $w .= $this->int_to_words($r);
                }
            }
            /*else {
                $w .= $this->int_to_words(floor($x/10000000)) .' Crore ';
                $r = fmod($x, 10000000);
                if($r > 0)
                {
                    $w .= '';
                    if($r < 100)
                    {
                        $word .= 'and ';
                    }
                    $w .= $this->int_to_words($r);
                } 
            }*/
        }
        return $w;
    }

}