<?php
class PurchasedflatController extends Controller
{
        public function filters()
    {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }
        public function accessRules()
        {
            return array(
                array('allow', // allow all users to perform 'index' and 'view' actions
                    'actions' => array('login', 'error', 'logout'),
                    'users' => array('*'),
                  ),
                array('allow', // allow authenticated user to perform 'create' and 'update' actions
                    'actions' => array('Index','Create','Save','Delete','GetOwnerDetails','GetOneTimePayments','GetChequeDetails',
                     'GetFinance' ,'int_to_words' ,'CalculateDepreciation','CalculateInterest','SearchResults','CreateDocument' ,
                        'DownloadDocument','SaveDocument','Upload'),
                    /*,'Search','SearchData','SummarySearch',
                        'summaryDetails','summaryResults','PrintDepreciationPDF','DepreciationExcel','PrintSummaryPDF','SummaryExcel',
                        'LoadChequeDetails','getLandlordName','getLandlordNamebyId',
                        'SearchAllOwner','SearchOwner','OwnerSummarySearch','SearchOwnerData','OwnerSummary',*/
                     'expression' => '$user->isMember()',
                ),
                 array('deny', // deny all users
                    'users' => array('*'),
                  ),
            );
        }
    public function actionIndex()
    {
        $condition = 'purchase_status = 1'; 
        if(Yii::app()->user->authorised_user != 1)
        {
            $user_id = Yii::app()->user->id;
            $modeluser = User::model()->findByPk($user_id);
            if(($modeluser->user_group_id == "4")&&($modeluser->owner_id !=0))
                $condition .= " AND ownerdetail.landlord = ".$modeluser->owner_id;
        }
        $model = Flat::model()->with('ownerdetail')->findAll(array('condition'=>$condition,'order'=>'flat_no'));
        $this->render('index',array(
             'model'=>$model,
        ));
    }
    public function actionCreate()
    {
        $id = (int) Yii::app()->request->getParam('id');
        $model = new Flat();
        $model_owner    = new BuildingOwnerDetails();
        $model_details =array(new BuildingOwnerDetails());
        if($id > 0)
        {
            $model          = $model->findByPk($id);
            $condition      = 'flat = '.$id;
            $model_details  = $model_owner->findAll(array('condition' => $condition));
            if(isset($model->buying_date) && $model->buying_date!="0000-00-00")
            {
                $arr_buying_date = explode("-",$model->buying_date);
                $model->buying_date=$arr_buying_date[2]."/".$arr_buying_date[1]."/".$arr_buying_date[0];
            }
            else
            {
                $model->buying_date="";
            }
            if(isset($model->expected_delivery_date) && $model->expected_delivery_date!="0000-00-00")
            {
                $arr_expected_delivery_date = explode("-",$model->expected_delivery_date);
                $model->expected_delivery_date=$arr_expected_delivery_date[2]."/".$arr_expected_delivery_date[1]."/".$arr_expected_delivery_date[0];
            }
            else
            {
                $model->expected_delivery_date="";
            }
            if(empty($model_details))
                $model_details =array(new BuildingOwnerDetails());
        }
        $this->render('create',array(
                    'model'=>$model,
                    'model_details'=>$model_details,'flat_id'=>$id,
                    'title' => 'Add Purchased Flat'
        ));
    }
    public function actionSave()
    {
        $model          = new Flat();
        if (isset($_POST['Flat'])) {
            if ((int) @$_POST['Flat']['id'] > 0) {
                $model->id = (int) $_POST['Flat']['id'];
                $model = $model->findByPK($model->id);
                $model->updated_by = Yii::app()->user->id;
                $model->updated_date = date('Y-m-d h:i:s');
            }
            else {
                $model->created_by = Yii::app()->user->id;
                $model->created_date = date('Y-m-d h:i:s');
                $model->status = '1';
            }
            $model->attributes      = $_POST['Flat'];
            if($_POST['Flat']['buying_date']!='' && $_POST['Flat']['buying_date']!='0000-00-00'){
                $model->buying_date     = DateTime::createFromFormat('d/m/Y', $_POST['Flat']['buying_date'])->format('Y-m-d');
            }else{
                $model->buying_date     = '';
            }
            if($_POST['Flat']['expected_delivery_date']!=''){
                $model->expected_delivery_date     = DateTime::createFromFormat('d/m/Y', $_POST['Flat']['expected_delivery_date'])->format('Y-m-d');
            }else{
                $model->expected_delivery_date     = $model->buying_date;
            }
            $model->purchase_status = 1;
            $model->buying_value    = $_POST['Flat']['buying_value'];
            $model->depreciation    = $_POST['Flat']['depreciation'];
            $model->depreciation_months = $_POST['Flat']['depreciation_months'];
            $model->construction_status = $_POST['Flat']['construction_status'];
            $model->squarefeet      =  $_POST['Flat']['squarefeet'];
            $model->squarefeet_rate =  $_POST['Flat']['squarefeet_rate'];
            $model->squaremetre     =  $_POST['Flat']['squaremetre'];
            if ($model->save())
            {    
                $jsonData['status'] = 'success';
                $jsonData['id']     = $model->id;
                if (isset($_POST['BuildingOwnerDetails'])) {
                    $arr_details            = $_POST['BuildingOwnerDetails'];
                    foreach($arr_details as $each_detail){
                        $details_id         = $each_detail['id'];
                        $model_owner        = new BuildingOwnerDetails();
                        if ($details_id > 0) {
                                $model_owner = $model_owner->findByPK($details_id);
                                $model_owner->id = $details_id;
                                $model_owner->updated_by = Yii::app()->user->id;
                                $model_owner->updated_date = date('Y-m-d h:i:s');
                        }
                        else {
                                $model_owner->created_by = Yii::app()->user->id;
                                $model_owner->created_date = date('Y-m-d h:i:s');
                        }
                        $model_owner->flat   = $model->id;
                        $model_owner->building   = $model->building_id;
                        $model_owner->landlord   = $each_detail['landlord'];
                        $model_owner->percentage_amount = '0';
                        $model_owner->percentage = '0';
                        if($each_detail['percentage']!=''){
                           $model_owner->percentage = $each_detail['percentage']; 
                        }
                        if($each_detail['percentage']!=''){
                            $model_owner->percentage_amount = $each_detail['percentage_amount'];
                        }
                        $model_owner->save(false);
                    } 
                    $jsonData['owner_status'] = '1';
                    
                }
                $output = CJSON::encode($jsonData);
            } 
            else
            {
                $error = CActiveForm::validate($model, '', false);
                if ($error != '[]')
                    $output = $error;
            }
            
        }
        
        echo $output;
    }
    
    public function actionGetOwnerDetails()
    {
    	$flat_id        = $_POST['flat_id'];
    	$model          = new Flat();
        $model_owner    = new BuildingOwnerDetails();
        $model_details  = array(new BuildingOwnerDetails());
        if($flat_id > 0)
        {
            $model          = $model->findByPk($flat_id);
            $condition      = 'flat = '.$flat_id;
            $model_details  = $model_owner->findAll(array('condition' => $condition));
            if(empty($model_details))
                $model_details =array(new BuildingOwnerDetails());
        }
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->render('owner_details',array('model'=>$model,'model_details'=>$model_details,'flat_id'=>$flat_id));
    }
    
    public function actionGetOneTimePayments()
    {
    	$flat_id        = $_POST['flat_id'];
    	$model              = new OnetimePayments();
        $arr_details        = array();
        if($flat_id > 0)
        {
            $condition      = 'flat_id = '.$flat_id;
            $arr_details    = $model->findAll(array('condition' => $condition));
        }
        $this->renderPartial('payments_onetime_details',array('model'=>$model,'arr_details'=>$arr_details,'flat_id'=>$flat_id));
    }
    public function actionGetFinance()
    {
    	$flat_id            = $_POST['flat_id'];
    	$model              = new Finance();
        $model_flat         = new Flat();
        if($flat_id > 0)
        {
            $condition      = 'flat_id = '.$flat_id;
            $model          = $model->find(array('condition' => $condition));
            $model_flat     = $model_flat->findByPk($flat_id);
            $building_id    = $model_flat->building_id;
            if(empty($model)){
                   $model = new Finance();
            }
        }
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->render('finance_detail',array('model'=>$model,'building_id'=>$building_id,'flat_id'=>$flat_id,'model_flat'=>$model_flat));
    }
    public function actionGetChequeDetails()
    {
    	$flat_id          = $_POST['flat_id'];
        $model_flat       = new Flat();
        if($flat_id > 0)
        {
          $model_flat     = $model_flat->findByPk($flat_id);
          $building_id    = $model_flat->building_id;  
        }
    	$this->renderPartial('cheque_details',array('flat_id'=>$flat_id,'building_id'=>$building_id));
    } 
    public function actionCalculateDepreciation()
    {
        $flat_id    = Yii::app()->request->getParam('flat_id');
        $flat_model = Flat::model()->findByPk($flat_id);
        $this->render('flat_depreciation',array('flat_model'=>$flat_model,'flat_id'=>$flat_id,'title' => 'Calculate Depreciation'));
    }
    public function actionCalculateInterest()
    {
        $flat_id    = Yii::app()->request->getParam('flat_id');
        $flat_model = Flat::model()->findByPk($flat_id);
        // $condition ='1=1';
        $building_model = Building::model()->findAll(array('condition'=>$condition));
        $this->render('interest_calculation',array('flat_model'=>$flat_model,'flat_id'=>$flat_id,'title' => 'Calculate Interest'));
    }
    public function actionSearchResults()
    {
        $date_from  = Yii::app()->request->getParam('date1');
        $flat_id   = Yii::app()->request->getParam('flat_id');
        $date_from  = Yii::app()->request->getParam('date1');
        $flat_model = Flat::model()->findByPk($flat_id);
        $this->render('flat_depreciation',array('flat_model'=>$flat_model,'flat_id'=>$flat_id,'title' => 'Calculate Depreciation'));
        
    }
        public function actionCreateDocument()
	{

            $id         = (int) Yii::app()->request->getParam('id');
            $building_id=(int) Yii::app()->request->getParam('building_id');
	    $flat_id    =(int) Yii::app()->request->getParam('flat_id');
	    $model      = new PurchasedDocuments();
            
            if($id > 0)
            {
    		$model=$model->findByPk($id);
            }
            Yii::app()->clientScript->scriptMap = array( 'jquery.min.js' => false);
            $this->render('createdocument',array(
                    'model'=>$model,
                    'title' => 'Add New Flat Document',
                    'building_id' =>$building_id,
                    'flat_id'=>$flat_id
            ));
        }
        public function actionSaveDocument()
        {
            $model=new PurchasedDocuments();
            /************ START Code for Save ***************/
            if (isset($_POST['PurchasedDocuments'])) {

                    if ((int) @$_POST['PurchasedDocuments']['id'] > 0) {
                            $model->id = (int) $_POST['PurchasedDocuments']['id'];
                            $model = $model->findByPK($model->id);
                            $model->updated_by = Yii::app()->user->id;
                            $model->updated_date_time = date('Y-m-d h:i:s');
                    }
                    else {
                            $model->created_by = Yii::app()->user->id;
                            $model->created_date_time = date('Y-m-d h:i:s');
                    }

                            $model->attributes      = $_POST['PurchasedDocuments'];
                            $model->document_file   = $_POST['PurchasedDocuments']['document_file'];
                            $model->building_id     = $_POST['building_id'];
                            $model->flat_id         = $_POST['flat_id'];
                            $model->purchased_type  = '2';
                            if ($model->save())
                            {
                                    $jsonData['status'] = 'success';
                                    $jsonData['flat_id'] = $_POST['flat_id'];
                                    echo CJSON::encode($jsonData);
                            }
                            else
                            {
                                    $error = CActiveForm::validate($model, '', false);
                                    if ($error != '[]')
                                        echo $error;
                            }
            }
        }
        public function actionDownloadDocument(){     
            $id= (int) Yii::app()->request->getparam('id'); 
            $sfile =PurchasedDocuments::model()->findByPk($id);  
            $arr_doc_val = explode(',',$sfile->document_file);
            $zip = new ZipArchive();
            $zip_file_path = Yii::getPathOfAlias('webroot')."/downloadzip/".$sfile->file_name."_".date('d-m-Y').".zip";
        
            if($zip->open($zip_file_path,1?ZIPARCHIVE::OVERWRITE:ZIPARCHIVE::CREATE)===TRUE)
            {
                for($i=0;$i<count($arr_doc_val);$i++){
                    $path = "uploads/documents/".$arr_doc_val[$i];
                    // Add the files to the .zip file
                    $zip->addFile($path, $arr_doc_val[$i]);
                }
                // Closing the zip file
                $zip->close();
            }

            header("Content-type:application/zip"); //for pdf file
            //if you want to read text file using text/plain header
            header('Content-Disposition: attachment; filename="'.basename($zip_file_path).'"');
            header('Content-Length: ' . filesize($zip_file_path));
            readfile($zip_file_path);

            @unlink($zip_file_path);
            Yii::app()->end();          
        }
       
        public function int_to_words($x)
        {       
           $nwords = array('Zero', 'One', 'Two', 'Three', 'Four', 'Five', 'Six', 'Seven', 'Eight', 'Nine', 'Ten', 'Eleven', 'Twelve', 'Thirteen', 'Fourteen', 'Fifteen', 'Sixteen', 'Seventeen', 'Eighteen', 'Nineteen', 'Twenty', 30 => 'Thirty', 40 => 'Forty', 50 => 'Fifty', 60 => 'Sixty', 70 => 'Seventy', 80 => 'Eighty', 90 => 'Ninety' );
           if(!is_numeric($x))
           {
               $w = '#';
           }else if(fmod($x, 1) != 0)
           {
               $w = '#'; 
           }else{
               if($x < 0)
               {
                   $w = 'minus';
                   $x = -$x;
               }else{
                   $w = '';
               } 
               if($x < 21)
               {
                   $w .= $nwords[$x];
               }else if($x < 100)
               {
                   $w .= $nwords[10 * floor($x/10)];
                   $r = fmod($x, 10); 
                   if($r > 0)
                   {
                       $w .= '-'. $nwords[$r];
                   }
               } else if($x < 1000)
               {
                   $w .= $nwords[floor($x/100)] .' Hundred'; 
                   $r = fmod($x, 100);
                   if($r > 0)
                   {
                       $w .= ' and '. $this->int_to_words($r);
                   }
               } else if($x < 1000000) 
               {
                   $w .= $this->int_to_words(floor($x/1000)) .' Thousand ';
                   $r = fmod($x, 1000);
                   if($r > 0)
                   {
                       $w .= ''; 
                       if($r < 100)
                       {
                           $w .= 'and ';
                       }
                       $w .= $this->int_to_words($r);
                   } 
               } else //if($x < 10000000)
                   {
                   $w .= $this->int_to_words(floor($x/1000000)) .' Million ';
                   $r = fmod($x, 1000000);
                   if($r > 0)
                   {
                       $w .= ''; 
                       if($r < 100)
                       {
                           $word .= 'and ';
                       }
                       $w .= $this->int_to_words($r);
                   } 
               } 
           }
           return $w;
        }
}   
                                
                     