<?php
class PaymentController extends Controller
{
    public function filters()
    {
            return array(
                    'accessControl', // perform access control for CRUD operations
            );
    }
    public function accessRules()
    {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
              ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index','Create','Save','Delete','Search','SearchResult',
                    'SearchResult1','GetPaymentList','PrintPaymentExcel','PrintPaymentPDF','GetLandlord',
                    'finance_create','getLandlordName','getLandlordNamebyId','Cheque_Create','SaveFinance'
                    ,'getInProcessPayments','getCompletedPayments','getCancelledPayments','getBouncedPayments','ClearBulkCheques'),
                 'expression' => '$user->isMember()',
            ),
             array('deny', // deny all users
                'users' => array('*'),
              ),
        );
    }
    public function actionIndex()
    {
        $this->render('index');
                /* $model = Payment::model()->with('flat','transtype')->findAll();
                $this->render('index',array(
                     'model'=>$model,
                )); */
    }
    
    public function actionCreate()
    {
            $id = (int) Yii::app()->request->getParam('id');
            $model = new Payment();
            if($id > 0)
            {
                $model=$model->findByPk($id);
                $arr_payment_date = explode("-",$model->payment_date);
                $model->payment_date=$arr_payment_date[2]."/".$arr_payment_date[1]."/".$arr_payment_date[0];
                if(isset($model->cheque_date) && $model->cheque_date!="0000-00-00")
                {
                    $arr_cheque_date = explode("-",$model->cheque_date);
                    $model->cheque_date=$arr_cheque_date[2]."/".$arr_cheque_date[1]."/".$arr_cheque_date[0];
                }
                else
                {
                    $model->cheque_date="";
                }
                if(isset($model->realisation_date) && $model->realisation_date!="0000-00-00")
                {
                    $arr_realisation_date = explode("-",$model->realisation_date);
                    $model->realisation_date=$arr_realisation_date[2]."/".$arr_realisation_date[1]."/".$arr_realisation_date[0];
                }
                else
                {
                    $model->realisation_date="";
                }
            }
                Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
            $this->render('create',array(
                'model'=>$model,
                            'title' => 'Add New Payment'
            ));
    }
    public function actionCheque_Create()
    {
        $amount                 = (int) Yii::app()->request->getParam('amount');
    	$arr_bank               = Yii::app()->request->getParam('arr_bank');
        $arr_bank               = explode(',', $arr_bank);
    	$no_installments        = (int) Yii::app()->request->getParam('no_installments');
    	$arr_start_cheque       = Yii::app()->request->getParam('arr_start_cheque');
        $arr_start_cheque       = explode(',', $arr_start_cheque);
    	$arr_stop_cheque        = Yii::app()->request->getParam('arr_stop_cheque');
        $arr_stop_cheque        = explode(',', $arr_stop_cheque);
    	$start_date             = Yii::app()->request->getParam('start_date');
        $frequency              = (int) Yii::app()->request->getParam('frequency');
        $landlord               = (int) Yii::app()->request->getParam('landlord');
        $building_id            = (int) Yii::app()->request->getParam('building_id');
        $flat_id                = (int) Yii::app()->request->getParam('flat_id');
        for($j=0; $j<count($arr_start_cheque);$j++){
            for($k=$arr_start_cheque[$j];$k<=$arr_stop_cheque[$j];$k++){
                $arr_checkno[]  = $k;
                $arr_bankname[] = $arr_bank[$j] ;
            }
            
        }
        $model = new Payment();
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
            $this->render('cheque_create',array(
                'model'=>$model,
                'amount'                 => $amount,
                'arr_checkno'            => $arr_checkno,
                'no_installments'        => $no_installments,
                'arr_bankname'           => $arr_bankname ,
                'start_date'             => $start_date,
                'frequency'              => $frequency ,
                'landlord'               => $landlord, 
                'building_id'            => $building_id,
                'flat_id'            => $flat_id,
                'title'                  => 'Add Cheque'
            ));
    }
    public function actionSaveFinance(){
        $payment_type       = 2;//cheque
        $building_id        = $_POST['building_id'];
        $flat_id            = $_POST['flat_id'];
        $landowner_count    = 0;
        if($building_id>0)
        $landowner_count    = Yii::app()->db->createCommand('SELECT COUNT(*) FROM re_building_owner_details WHERE building ='. $building_id)->queryScalar();
        if($flat_id>0)
        $landowner_count    = Yii::app()->db->createCommand('SELECT COUNT(*) FROM re_building_owner_details WHERE flat ='. $flat_id)->queryScalar();
        $payment_date       = date('Y-m-d');
        $realisation_date   = '';
        $landlord_id        = $_POST['landlord_id'];
        $remarks            = '';
        $status             = 0;
        $arr_date           = $_POST['date'];
        $count              = count($arr_date);
        $error ='';
        for($i=0;$i<$count;$i++){
            $model_payment   = new Payment();
            $arr_cheque_date = explode("/",$_POST['date'][$i]);
            $cheque_date     = $arr_cheque_date[2]."-".$arr_cheque_date[1]."-".$arr_cheque_date[0];
            $cheque_no       =  $_POST['cheque_no'][$i];
            $amount          =  $_POST['amount'][$i];
            $bank            =  $_POST['bank'][$i];
            $model_payment->landowner_count    = 0;
            if($landowner_count > 0){
             $model_payment->landowner_count   = $landowner_count;
            }
            $model_payment->building_id        = $building_id;
            $model_payment->flat_id            = $flat_id;
            $model_payment->landlord_id        = $landlord_id;
            $model_payment->payment_type       = $payment_type;
            $model_payment->remarks            = $remarks;
            $model_payment->payment_date       = $payment_date;
            $model_payment->cheque_date        = $cheque_date;
            $model_payment->realisation_date   = $realisation_date;
            $model_payment->status             = $status;
            $model_payment->amount             = $amount;
            $model_payment->bank_id          = $bank;
            $model_payment->cheque_no          = $cheque_no;
            $model_payment->created_by         = Yii::app()->user->id;
            $model_payment->created_date       = date('Y-m-d h:i:s');
            if ($model_payment->save())
            {
                $jsonData['status'] = 'success';           
            }
            else
            {
                $error = CActiveForm::validate($model_payment, '', false);

            }
        }
        if ($error != '')
            echo $error;
        else
        {
            $jsonData['status'] = 'success';
            echo CJSON::encode($jsonData);
        }
    }
    public function actionSave()
    {
        //print_r($_POST); die();
        $model=new Payment();
        /************ START Code for Save ***************/
        $realisation_date="";
        if (isset($_POST['Payment'])) {
            $arr_payment_date = explode("/",$_POST['Payment']['payment_date']);
            $payment_date = $arr_payment_date[2]."-".$arr_payment_date[1]."-".$arr_payment_date[0];
            $cheque_date = "0000-00-00";
            
            if ((int) @$_POST['Payment']['id'] > 0) {
                $model->id = (int) $_POST['Payment']['id'];
                $model = $model->findByPK($model->id);
                $model->payment_date=$payment_date;
                
                $landowner_count            = 0;
                if(isset($_POST['Payment']['building_id']) && $_POST['Payment']['building_id']!='')
                    $landowner_count = Yii::app()->db->createCommand('SELECT COUNT(*) FROM re_building_owner_details WHERE building ='. $_POST['Payment']['building_id'])->queryScalar();
                $model->landowner_count = 0;
                if($landowner_count > 0){
                 $model->landowner_count = $landowner_count;
                }
                if($_POST['Payment']['payment_type']==2)
                {
                    if($_POST['Payment']['realisation_date']!="")
                    {
                        $arr_realisation_date = explode("/",$_POST['Payment']['realisation_date']);
                        $realisation_date = $arr_realisation_date[2]."-".$arr_realisation_date[1]."-".$arr_realisation_date[0];
                    }
                    $status = $_POST['Payment']['status'];
                    if(isset($_POST['Payment']['cheque_date']) && $_POST['Payment']['cheque_date']!="")
                    {
                        $arr_cheque_date = explode("/",$_POST['Payment']['cheque_date']);
                        $cheque_date = $arr_cheque_date[2]."-".$arr_cheque_date[1]."-".$arr_cheque_date[0];
                    }
                }
                
                $model->updated_by = Yii::app()->user->id;
                $model->updated_date = date('Y-m-d h:i:s');
                
                if($_POST['Payment']['payment_type']==1)
                {
                    $realisation_date= date('Y-m-d');
                    $status= 1;
                }
                $model->attributes = $_POST['Payment'];
                $model->bank_id=$_POST['Payment']['bank_id'];
                $model->payment_date=$payment_date;
                $model->cheque_date=$cheque_date;
                $model->realisation_date= $realisation_date;
                $model->status= $status;
                if ($model->save())
                {
                    $jsonData['status'] = 'success';
                            echo CJSON::encode($jsonData);
                }
                else
                {
                    $error = CActiveForm::validate($model, '', false);
                        if ($error != '[]')
                            echo $error;
                }
            }
            else
            {   
                $payment_type       = $_POST['Payment']['payment_type'];
                if($payment_type==1)
                {
                    $landowner_count            = 0;
                    if(isset($_POST['Payment']['building_id']) && $_POST['Payment']['building_id']!='')
                        $landowner_count = Yii::app()->db->createCommand('SELECT COUNT(*) FROM re_building_owner_details WHERE building ='. $_POST['Payment']['building_id'])->queryScalar();
                    $model->landowner_count = 0;
                    if($landowner_count > 0){
                     $model->landowner_count = $landowner_count;
                    }
                    $realisation_date          = date('Y-m-d');
                    $status= 1;
                    $model->created_by         = Yii::app()->user->id;
                    $model->created_date       = date('Y-m-d h:i:s');
                    $model->building_id        = $_POST['Payment']['building_id'];
                    $model->landlord_id        = $_POST['Payment']['landlord_id'];
                    $model->payment_type       = $_POST['Payment']['payment_type'];
                    $model->remarks            = $_POST['Payment']['remarks'];
                    $model->amount             = $_POST['Payment']['amount'];
                    $model->payment_date       = $payment_date;
                    $model->cheque_date        = $cheque_date;
                    $model->realisation_date   = $realisation_date;
                    $model->status             = $status;
                    if ($model->save())
                    {
                        $jsonData['status'] = 'success';
                                echo CJSON::encode($jsonData);
                    }
                    else
                    {
                        $error = CActiveForm::validate($model, '', false);
                            if ($error != '[]')
                                echo $error;
                    }
                }
                else if($payment_type==2)
                {
                    $building_id        = $_POST['Payment']['building_id'];
                    $landowner_count    = 0;
                    if(isset($_POST['Payment']['building_id']) && $_POST['Payment']['building_id']!='')
                        $landowner_count= Yii::app()->db->createCommand('SELECT COUNT(*) FROM re_building_owner_details WHERE building ='. $_POST['Payment']['building_id'])->queryScalar();
                    
                    $landlord_id        = $_POST['Payment']['landlord_id'];
                    $remarks            = $_POST['Payment']['remarks'];
                    $status             = 0;
                    $arr_date           = $_POST['cheque_date'];
                    $count              = count($arr_date);
                    for($i=0;$i<$count;$i++){
                        $model_payment   = new Payment();
                        $arr_cheque_date = explode("/",$_POST['cheque_date'][$i]);
                        $cheque_date     = $arr_cheque_date[2]."-".$arr_cheque_date[1]."-".$arr_cheque_date[0];
                        $cheque_no       =  $_POST['cheque_no'][$i];
                        $amount          =  $_POST['amount'][$i];
                        $bank            =  $_POST['bank_id'][$i];
                        $model_payment->landowner_count    = 0;
                        if($landowner_count > 0){
                         $model_payment->landowner_count   = $landowner_count;
                        }
                        $model_payment->building_id        = $building_id;
                       echo  $model_payment->landlord_id        = $landlord_id;
                        $model_payment->payment_type       = $payment_type;
                        $model_payment->remarks            = $remarks;
                        $model_payment->payment_date       = $payment_date;
                        $model_payment->cheque_date        = $cheque_date;
                        $model_payment->realisation_date   = $realisation_date;
                        $model_payment->status             = $status;
                        $model_payment->amount             = $amount;
                        $model_payment->bank_id             = $bank;
                        $model_payment->cheque_no          = $cheque_no;
                        $model_payment->created_by         = Yii::app()->user->id;
                        $model_payment->created_date       = date('Y-m-d h:i:s');
                        if ($model_payment->save())
                        {
                            $jsonData['status'] = 'success';           
                        }
                        else
                        {
                            $error = CActiveForm::validate($model_payment, '', false);
                                
                        }
                    }
                    if ($error != '')
                        echo $error;
                    else
                    {
                        $jsonData['status'] = 'success';
                        echo CJSON::encode($jsonData);
                    }
                }else{
                    $jsonData['status'] = 'fail';
                    echo CJSON::encode($jsonData);
                }
                
            }
        }
    }
     public function actionDelete()
     {
                $id = $_POST['id'];
                $model=new Payment();
                $model->deleteByPk($id);
                echo "success";
    }
    public function actionSearch()
    {
            $model = new Payment();
                Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
            $this->render('search',array(
                'model'=>$model,
                            'title' => 'Report Option'
            ));
    }
    public function actionGetLandlord()
    {
        $id=Yii::app()->request->getparam("building_id");  
        $condition = 'landlord_details.status =  "Y" and building = "'.$id.'"';
        $status = 0;$span = '';
	$model = BuildingOwnerDetails::model()->with('landlord_details')->findAll(array('condition' => $condition));
        $details=CHtml::listData($model, 'landlord_details.id', 'landlord_details.name');
        if(!empty($details)){
            $status = 1;
            $span   = '<span class="red">*</span>';
        }
        $drop= '<li class="form-add col-sm-6"><div class="icon-box fa-user material m1">' ;
        $drop.=CHtml::dropDownList('Payment[landlord_id]','' , $details,  array('class'=>'','placeholder'=>'Landlord'.$span), array('options' => array('title'=>array('selected'=>true))));
        $drop.='</div></li>';
        $status=array("dt" => $drop,"status" => $status);
        echo CJSON::encode($status);
    }
    public function actionSearchResult()
    {
        $date_from     = isset($_POST['Payment']['date1']) ? $_POST['Payment']['date1'] : '';
        $date_to       = isset($_POST['Payment']['date2']) ? $_POST['Payment']['date2'] : '';
        $rel_from      = isset($_POST['Payment']['realisation_date1']) ? $_POST['Payment']['realisation_date1'] : '';
        $rel_to        = isset($_POST['Payment']['drealisation_date2']) ? $_POST['Payment']['drealisation_date2'] : '';
        $cheque_from   = isset($_POST['Payment']['cheque_date1']) ? $_POST['Payment']['cheque_date1'] : '';
        $cheque_to     = isset($_POST['Payment']['cheque_date2']) ? $_POST['Payment']['cheque_date2'] : '';
        $building      = isset($_POST['Payment']['building_id']) ? $_POST['Payment']['building_id'] : '';
        $landlord      = isset($_POST['Payment']['landlord_id']) ? $_POST['Payment']['landlord_id'] : '';
        $transaction   = isset($_POST['Payment']['transaction_type']) ? $_POST['Payment']['transaction_type'] : '';
        $payment       = isset($_POST['Payment']['payment_type']) ? $_POST['Payment']['payment_type'] : '';
        
        $jsonData['date_from']  = $date_from;
        $jsonData['date_to']    = $date_to;
        $jsonData['rel_from']   = $rel_from;
        $jsonData['rel_to']     = $rel_to;
        $jsonData['cheque_from'] = $cheque_from;
        $jsonData['cheque_to']  = $cheque_to;
        $jsonData['building']   = $building;
        $jsonData['landlord']   = $landlord;
        $jsonData['transaction'] = $transaction;
        $jsonData['payment']    = $payment;
        $jsonData['status']     = 'success';
        echo CJSON::encode($jsonData);
    }
    public function actionSearchResult1()
    {
        $date_from  = Yii::app()->request->getParam('date1');
        $date_to    = Yii::app()->request->getParam('date2');
        $rel_from   = Yii::app()->request->getParam('realisation_date1');
        $rel_to     = Yii::app()->request->getParam('drealisation_date2');
        $cheque_from= Yii::app()->request->getParam('cheque_date1');
        $cheque_to  = Yii::app()->request->getParam('cheque_date2');
        $building   = Yii::app()->request->getParam('building_id');
        $landlord   = Yii::app()->request->getParam('landlord');
        $payment    = Yii::app()->request->getParam('payment_type');
        $this->render('search_result', array('date_from'=>$date_from,'date_to'=>$date_to,'rel_from'=>$rel_from,'rel_to'=>$rel_to,
         'cheque_from'=>$cheque_from,'cheque_to'=>$cheque_to,'building'=>$building,'payment'=>$payment,'landlord'=>$landlord,'title' => 'Search Payment'));
    }
    public function actionGetPaymentList()
    {
        $this->render('paymentlist',array('model'=>new Payment()));
    }
    public function actionPrintPaymentExcel()
    {
        $date_from=Yii::app()->request->getParam('date_from');
        $date_to=Yii::app()->request->getParam('date_to');
        $rel_from=Yii::app()->request->getParam('rel_from');
        $rel_to=Yii::app()->request->getParam('rel_to');
        $cheque_from=Yii::app()->request->getParam('cheque_from');
        $cheque_to=Yii::app()->request->getParam('cheque_to');
        $building=Yii::app()->request->getParam('building');
        $payment=Yii::app()->request->getParam('payment');
        $landlord=Yii::app()->request->getParam('landlord');
        $condition="1=1";
        if($date_from!='')
        {
            $date_from = str_replace('/', '-', $date_from);
            $date_from = date("Y-m-d", strtotime($date_from));
            $condition.=" AND payment_date>='$date_from'";
        }
        if($date_to!='')
        {
            $date_to = str_replace('/', '-', $date_to);
            $date_to = date("Y-m-d", strtotime($date_to));
            $condition.=" AND payment_date<='$date_to'";
        }
        if($rel_from!='')
        {
            $rel_from = str_replace('/', '-', $rel_from);
            $rel_from = date("Y-m-d", strtotime($rel_from));
            $condition.=" AND realisation_date>='$rel_from'";
        }
        if($rel_to!='')
        {
            $rel_to = str_replace('/', '-', $rel_to);
            $rel_to = date("Y-m-d", strtotime($rel_to));
            $condition.=" AND realisation_date<='$rel_to'";
        }
        if($cheque_from!='')
        {
            $cheque_from = str_replace('/', '-', $cheque_from);
            $cheque_from = date("Y-m-d", strtotime($cheque_from));
            $condition.=" AND cheque_date>='$cheque_from'";
        }
        if($cheque_to!='')
        {
            $cheque_to = str_replace('/', '-', $cheque_to);
            $cheque_to = date("Y-m-d", strtotime($cheque_to));
            $condition.=" AND cheque_date<='$cheque_to'";
        }
        if($building!='' && $building!="null")
        {
            $condition.=" AND building_id IN(".$building.")"; 
        }
        if($payment!='' && $payment!="null")
        {
           $condition.=" AND payment_type=$payment";
        }
        if($landlord!='' && $landlord!="null")
        {
            $condition.=" AND landlord_id=$landlord";
        }
        $model = Payment::model()->findAll(array('condition'=>$condition));
        $file = fopen("csvs/realestate.csv","w");
        $total_amount=0;
        $i=0;
        if($i==0){
            $list[$i]='No,Payment Date,Cheque Date,Realisation Date,Payment Type,Amount,Status';
        }            
        foreach($model as $i=>$value)
        {
            $payment_date=$value->payment_date;
            if($payment_date != '0000-00-00'){
                $payment_date=date("d/m/Y",strtotime($payment_date));
            }else{
             $payment_date = '';
            }
            $cheque_date=$value->cheque_date;
            if($cheque_date != '0000-00-00'){
                $cheque_date=date("d/m/Y",strtotime($cheque_date));
            }else{
             $cheque_date = '';
            }
            $realisation_date=$value->realisation_date;
            if($realisation_date != '0000-00-00'){
                $realisation_date=date("d/m/Y",strtotime($realisation_date));
            }else{
             $realisation_date = '';
            }
            $total_amount+=$value->amount;
                $list[$i+1] =($i+1).','.$payment_date.','.$cheque_date.','.$realisation_date.','.Receipt::getPaymentType($value->payment_type).','.$value->amount.','.Receipt::getPaymentStatus($value->status);
        }
        $list[$i+2]=',,,,Total,'.$total_amount;
        
        
        foreach ($list as $line)
        {
              fputcsv($file,explode(',',$line));
        }
        fclose($file);
        $filename = 'csvs/realestate.csv';
        $path=Yii::app()->getBaseUrl(true).'/csvs';
        header('Content-Type: application/csv');
        header("Content-disposition: attachment; filename=\"realestate.csv\"");
        readfile($filename);
        Yii::app()->end();
        return;
    }
    public function actionPrintPaymentPDF()
    {
        $date_from=Yii::app()->request->getParam('date_from');
        $date_to=Yii::app()->request->getParam('date_to');
        $rel_from=Yii::app()->request->getParam('rel_from');
        $rel_to=Yii::app()->request->getParam('rel_to');
        $cheque_from=Yii::app()->request->getParam('cheque_from');
        $cheque_to=Yii::app()->request->getParam('cheque_to');
        $building=Yii::app()->request->getParam('building');
        $payment=Yii::app()->request->getParam('payment');
        $landlord=Yii::app()->request->getParam('landlord');
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        ob_start();
        $stylesheet = file_get_contents('css/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.views.admin.payment.search_result_pdf', array('date_from' => $date_from,'date_to'=>$date_to,'rel_from'=>$rel_from,'rel_to'=>$rel_to,'cheque_from'=>$cheque_from,'cheque_to'=>$cheque_to,'building'=>$building,'payment'=>$payment,'landlord'=>$landlord), true));
        ob_end_clean();
        $mPDF1->Output();
    }
    public function actionFinance_create()
    {
        $model = new Payment();
        $building_id = Yii::app()->request->getParam('building_id');
        $flat_id = Yii::app()->request->getParam('flat_id');
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->render('finance_create',array( 'model'=>$model, 'title' => 'Add Finance','building_id'=>$building_id ,'flat_id'=>$flat_id ));
    }
    public function actiongetLandlordName()
        {
            $search_char    =   $_POST['search_char'];
            $building_id   =   $_POST['building_id'];
            
            if($building_id!=""){
                $condition = 'name LIKE "' . $search_char . '%" AND t.building="'.$building_id.'"';
            }  else {
                $condition = 'name LIKE "' . $search_char . '%"';
            }
            
            $arr_landlord= BuildingOwnerDetails::model()->with('landlord_details')->findAll(array('condition'=>$condition,'group'=>'landlord'));
  $jsonData['landlorddetail'] =  '<div class="pu-content">
                <div class="pu-body">
            <div class="col-xs-4 np pu-table">
            <table id="landlord_name_details" class="table-tab striped-table">
                <thead>
                 <tr class="">
                    <th>Landlord Name</th>
                 </tr>
                </thead>
                <tbody>';
                
                  
                      foreach($arr_landlord as $i=>$landlord_name): 
             $jsonData['landlorddetail'].= '<tr>
                     <td onclick="setlandlordvalue('.$landlord_name->landlord.');" class="">'.$landlord_name->landlord_details->name.'</td>                   
                    </tr>';
                    endforeach;
               $jsonData['landlorddetail'].= ' </tbody>
                </table></div></div></div>';  
            echo CJSON::encode($jsonData);
        }
        public function actiongetLandlordNamebyId()
        {
            $id    =   $_POST['landlord_id'];
            $model_landlord= Landlord::model()->findbyPk($id);
            $jsonData['landlordname']= $model_landlord->name;
            echo CJSON::encode($jsonData);
        }
        public function actiongetInProcessPayments()
    {
        $date_from=$_POST['date_from'];
        $date_to=$_POST['date_to'];
        $building_id=$_POST['building_id'];
        $bank_id=$_POST['bank_id'];
        $landlord_id=$_POST['landlord_id'];
        $this->render('inprocess',array('datefrom'=>$date_from,'date_to'=>$date_to,'building_id'=>$building_id,'bank_id'=>$bank_id,'landlord_id'=>$landlord_id));
    }
    public function actiongetCancelledPayments()
    {
        $date_from=$_POST['date_from'];
        $date_to=$_POST['date_to'];
        $building_id=$_POST['building_id'];
        $bank_id=$_POST['bank_id'];
        $landlord_id=$_POST['landlord_id'];
        $this->render('cancelled',array('datefrom'=>$date_from,'date_to'=>$date_to,'building_id'=>$building_id,'bank_id'=>$bank_id,'landlord_id'=>$landlord_id));
    }
     public function actiongetCompletedPayments()
    {
        $date_from=$_POST['date_from'];
        $date_to=$_POST['date_to'];
        $building_id=$_POST['building_id'];
        $bank_id=$_POST['bank_id'];
        $landlord_id=$_POST['landlord_id'];
        $this->render('completed',array('datefrom'=>$date_from,'date_to'=>$date_to,'building_id'=>$building_id,'bank_id'=>$bank_id,'landlord_id'=>$landlord_id));
    }
    public function actiongetBouncedPayments()
    {
        $date_from=$_POST['date_from'];
        $date_to=$_POST['date_to'];
        $building_id=$_POST['building_id'];
        $bank_id=$_POST['bank_id'];
        $landlord_id=$_POST['landlord_id'];
        $this->render('bounced',array('datefrom'=>$date_from,'date_to'=>$date_to,'building_id'=>$building_id,'bank_id'=>$bank_id,'landlord_id'=>$landlord_id));
    }
    public function actionClearBulkCheques(){
        $receipt_array      = Yii::app()->request->getparam("checked");  
        $id_array           =  explode(',', $receipt_array);
        for($i=0;$i<count($id_array);$i++){
            $model= new Payment();
            $model=Payment::model()->findByPk($id_array[$i]);
                $model->updated_by         = Yii::app()->user->id;
                $model->updated_date = date('Y-m-d h:i:s');
                $model->realisation_date   = date('Y-m-d');
                $model->status             = 1;
                $model->save(false);
                
        }
        echo "success";
    }
}