<?php

class OnetimepaymentController extends Controller
{
	public function accessRules()
        {
            return array(
                array('allow', // allow all users to perform 'index' and 'view' actions
                    'actions' => array('login', 'error', 'logout'),
                    'users' => array('*'),
                  ),
                array('allow', // allow authenticated user to perform 'create' and 'update' actions
                    'actions' => array('Index','Create','Save','Delete'),
                     'expression' => '$user->isMember()',
                ),
                 array('deny', // deny all users
                    'users' => array('*'),
                  ),
            );
        }
        public function actionIndex()
	{
		$this->render('index');
	}
        public function actionCreate()
        {
            $id = (int) Yii::app()->request->getParam('id');
            $building_id = (int) Yii::app()->request->getParam('building_id');
            $flat_id = (int) Yii::app()->request->getParam('flat_id');
            if($flat_id>0){
                $flatmodel  = Flat::model()->findByPk($flat_id);
                $building_id = $flatmodel->building_id;
            }
            $model = new OnetimePayments();
            if($id > 0)
            {
                $model  = $model->findByPk($id);
                $model->cheque_date    = DateTime::createFromFormat('Y-m-d', $model->cheque_date)->format('d/m/Y');
                
            }
            Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
            $this->render('create',array(
                        'model'=>$model,
                        'title' => 'Add Onetime Payments',
                        'building_id'=>$building_id,
                        'flat_id'=>$flat_id
            ));
        }
          public function actionSave()
        {
            $model=new OnetimePayments();
            /************ START Code for Save ***************/
            if (isset($_POST['OnetimePayments'])) {
                if ((int) @$_POST['OnetimePayments']['id'] > 0) {
                    $model->id = (int) $_POST['OnetimePayments']['id'];
                    $model = $model->findByPK($model->id);
                    $model->updated_by  = Yii::app()->user->id;
                    $model->updated_date = date('Y-m-d');
                }else {
                    $model->created_by  = Yii::app()->user->id;
                    $model->created_date = date('Y-m-d');
                }
                    $model->attributes          = $_POST['OnetimePayments'];
                    if($_POST['OnetimePayments']['paying_date']!='')
                        $model->paying_date         = DateTime::createFromFormat('d/m/Y', $_POST['OnetimePayments']['paying_date'])->format('Y-m-d');
                    $model->flat_id             = $_POST['OnetimePayments']['flat_id'];
                    $model->description         = $_POST['OnetimePayments']['description'];
                    $model->payment_type         = $_POST['OnetimePayments']['payment_type'];
                    if($_POST['OnetimePayments']['payment_type'] == "2"){
                        if($_POST['OnetimePayments']['cheque_date']!='')
                            $model->cheque_date         = DateTime::createFromFormat('d/m/Y', $_POST['OnetimePayments']['cheque_date'])->format('Y-m-d');
                        $model->cheque_no         = $_POST['OnetimePayments']['cheque_no'];
                        $model->bank_id         = $_POST['OnetimePayments']['bank_id'];
                    }
                    if ($model->save())
                    {
                            $jsonData['status'] = 'success';
                            echo CJSON::encode($jsonData);
                    }
                    else
                    {
                            $error = CActiveForm::validate($model, '', false);
                            if ($error != '[]')
                                echo $error;
                    }
            }
        }
        public function actionDelete()
        {
                    $id = $_POST['id'];
                    $model=new OnetimePayments();
                    $model->deleteByPk($id);
                    echo "success";
        }
	// Uncomment the following methods and override them if needed
	/*
	public function filters()
	{
		// return the filter configuration for this controller, e.g.:
		return array(
			'inlineFilterName',
			array(
				'class'=>'path.to.FilterClass',
				'propertyName'=>'propertyValue',
			),
		);
	}

	public function actions()
	{
		// return external action classes, e.g.:
		return array(
			'action1'=>'path.to.ActionClass',
			'action2'=>array(
				'class'=>'path.to.AnotherActionClass',
				'propertyName'=>'propertyValue',
			),
		);
	}
	*/
}