<?php

class MaintenanceworkController extends Controller
{
        public function filters()

	{

		return array(

			'accessControl', // perform access control for CRUD operations

		);

	}



	/**

	 * Specifies the access control rules.

	 * This method is used by the 'accessControl' filter.

	 * @return array access control rules

	 */

	public function accessRules()
        {

            return array(
                array('allow', // allow all users to perform 'index' and 'view' actions
                    'actions' => array('login', 'error', 'logout'),
                    'users' => array('*'),
                  ),
                array('allow', // allow authenticated user to perform 'create' and 'update' actions
                    'actions' => array('Index','SaveMaintenanceWork','Create','Delete'),
                     'expression' => '$user->isMember()',
                ),
                 array('deny', // deny all users
                    'users' => array('*'),
                  ),

            );

        }
	public function actionIndex()
	{
                $model = new MaintenanceWorks();

                $arr_maintenance_works = $model->findAll(array('condition'=>'status="Y"'));
                $this->render('index',array(
                     'model'=>$model,
                     'arr_maintenance_works' => $arr_maintenance_works
                ));

	}

        public function actionCreate()
	{

            $id = (int) Yii::app()->request->getParam('id');
            
	    $model = new MaintenanceWorks();
            
            if($id > 0)
            {
    		$model=$model->findByPk($id);
            }

                Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);

		$this->render('create',array(

			'model'=>$model,

                        'title' => 'Add New Maintenance'

		));
       }

    public function actionSaveMaintenanceWork()
    {
    	$model=new MaintenanceWorks();
    	/************ START Code for Save ***************/
    	if (isset($_POST['MaintenanceWorks'])) {
    		
    		if ((int) @$_POST['MaintenanceWorks']['id'] > 0) {
    			$model->id = (int) $_POST['MaintenanceWorks']['id'];
                        $model = $model->findByPK($model->id);
    			$model->updated_by = Yii::app()->user->id;
    			$model->updated_date = date('Y-m-d h:i:s');
    		}
                else {
    			$model->created_by = Yii::app()->user->id;
    			$model->created_date = date('Y-m-d h:i:s');
    		}
    	
    			$model->attributes = $_POST['MaintenanceWorks'];
	    		if ($model->save())
	    		{
	    			$jsonData['status'] = 'success';
	                        echo CJSON::encode($jsonData);
	    		}
	    		else
	    		{
		    		$error = CActiveForm::validate($model, '', false);
		                if ($error != '[]')
		                    echo $error;
		        }
    	}
     }

     public function actionDelete()
     {
                $id = $_POST['id'];
                $model=new MaintenanceWorks();
                $model->deleteByPk($id);
                echo "success";
    }

	
	
}