<?php

class MaintenanceController extends Controller
{
        public function filters()

	{
		return array(

			'accessControl', // perform access control for CRUD operations

		);
	}

        public function accessRules()
        {

            return array(
                array('allow', // allow all users to perform 'index' and 'view' actions
                    'actions' => array('login', 'error', 'logout'),
                    'users' => array('*'),
                  ),
                array('allow', // allow authenticated user to perform 'create' and 'update' actions
                    'actions' => array('Index','Create','Save','Delete','getBuildingFlat','getFlatTenant'),
                     'expression' => '$user->isMember()',
                ),
                 array('deny', // deny all users
                    'users' => array('*'),
                  ),

            );

        }
	
	public function actionIndex()
	{
                $model = Maintenance::model()->with('flat','tenant','subcontractor')->findAll();
                
                $this->render('index',array(
                     'model'=>$model,
                ));

	}

        public function actionCreate()
	{

            $id = (int) Yii::app()->request->getParam('id');
            
	    $model = new Maintenance();
            
            if($id > 0)
            {
    		$model=$model->findByPk($id);
            }

                Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);

		$this->render('create',array(

			'model'=>$model,

                        'title' => 'Add New Maintenance'

		));
       }

    public function actionSave()
    {
    	$model=new Maintenance();
    	/************ START Code for Save ***************/
    	if (isset($_POST['Maintenance'])) {
    		
    		if ((int) @$_POST['Maintenance']['id'] > 0) {
    			$model->id = (int) $_POST['Maintenance']['id'];
                        $model = $model->findByPK($model->id);
    			$model->updated_by = Yii::app()->user->id;
    			$model->updated_date = date('Y-m-d h:i:s');
    		}
                else {
    			$model->created_by = Yii::app()->user->id;
    			$model->created_date = date('Y-m-d h:i:s');
    		}
    	
    			$model->attributes = $_POST['Maintenance'];
                        $date = str_replace('/', '-', $_POST['Maintenance']['maintenance_date_time']);
                        $model->maintenance_date_time = date("Y-m-d", strtotime($date));
                        $flat_count            = 0;
                        if(isset($_POST['Maintenance']['building_id']) && $_POST['Maintenance']['building_id']!='')
                        $flat_count = Yii::app()->db->createCommand('SELECT COUNT(*) FROM re_flat WHERE building_id ='. $_POST['Maintenance']['building_id'])->queryScalar();
                        $model->flat_count = 0;
                        if($flat_count > 0){
                         $model->flat_count = $flat_count;
                        }
	    		if ($model->save())
	    		{
	    			$jsonData['status'] = 'success';
	                        echo CJSON::encode($jsonData);
	    		}
	    		else
	    		{
		    		$error = CActiveForm::validate($model, '', false);
		                if ($error != '[]')
		                    echo $error;
		        }
    	}
     }

     public function actionDelete()
     {
                $id = $_POST['id'];
                $model=new Maintenance();
                $model->deleteByPk($id);
                echo "success";
    }
    public function actiongetBuildingFlat()
    {
        $id=Yii::app()->request->getparam("building_id");  
        $condition = 'building_id="'.$id.'" ';
        $status=0;
	$model = Flat::model()->findAll(array('condition' => $condition));
        $flat= '<li class="form-add col-sm-6"><div class="icon-box fa-user material m1">' ;
        $details=CHtml::listData($model, 'id', 'flat_no');
        if(!empty($details))
        $status=1;
        $flat.=CHtml::dropDownList('Maintenance[flat_id]','' , $details,  array('class'=>'','placeholder'=>'Flat <span class="red">*</span>'), array('options' => array('title'=>array('selected'=>true))));
        $flat.='</div></li>';
        $status=array("dt" => $flat,"status" => $status);
        echo CJSON::encode($status);
    }
    public function actiongetFlatTenant()
    {
        $id=Yii::app()->request->getparam("flat_id");  
        $date = date('Y-m-d');
        $condition = 't.from_date <= "'.$date.'" and t.to_date >= "'.$date.'" and t.flat_id="'.$id.'" ';
        $status=0;
	$model_details = Lease::model()->with('tenant')->find(array('condition' => $condition));
        if(!empty($model_details))
            $status=1;
        $div_tenant= '<li class="form-add col-sm-6"><div class="icon-box fa-user material m1">' ;
        $div_tenant.=CHtml::textField('tenant_name',$model_details->tenant->name,  array('class'=>'','placeholder'=>'Tenant','readonly'=>true));
        $div_tenant.=CHtml::hiddenField('Maintenance[tenant_id]',$model_details->tenant_id);
        $div_tenant.='</div></li>';
        $div_tenant.= '<li class="form-add col-sm-6"><div class="icon-box fa-user material m1">' ;
        if($model_details->tenant->from_date != "0000-00-00"){
          $from_date = date("d/m/Y",strtotime($model_details->tenant->from_date));
        } else { 
            $from_date = '';
            }
        $div_tenant.=CHtml::textField('from_date',$from_date,  array('class'=>'','placeholder'=>'From Date','readonly'=>true));    
        $div_tenant.='</div></li>';
        $div_tenant.= '<li class="form-add col-sm-6"><div class="icon-box fa-user material m1">' ;
        if($model_details->tenant->to_date != "0000-00-00"){
          $to_date = date("d/m/Y",strtotime($model_details->tenant->to_date));
        } else { 
            $to_date = '';
            }
        $div_tenant.=CHtml::textField('to_date',$to_date,  array('class'=>'','placeholder'=>'To Date','readonly'=>true));
        $div_tenant.='</div></li>';
        $status=array("tnt" => $div_tenant,"status" => $status);
        echo CJSON::encode($status);
    }
	
}