<?php

class LeaseController extends Controller
{
    public function filters()
    {

            return array(

                    'accessControl', // perform access control for CRUD operations

            );

    }
    public function accessRules()
    {

        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
              ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index','Save','Create','Delete','PaymentSummary','getFlatDetails','SummarySearch','CashflowSearch',
                    'SummaryDetails','SummaryResults','getBuildingFlat','CalculateDepreciation','print_payment_summary','getFlatOwner',
                    'getFlatAmount','getLeaseFilter','CalculateFlatRents','CalculateFlatExpenses','CalculateBuidingExpenses','CashflowDetails','RentalCashflow',
                    'CalculateLandExpenses'),
                 'expression' => '$user->isMember()',
            ),
             array('deny', // deny all users
                'users' => array('*'),
              ),
            
        );

    }
    	
    public function actionIndex()
    {
            $model = Lease::model()->findAll(array('condition'=>'status="Y" AND flat_status ="2"'));
            $this->render('index',array(
                 'model'=>$model,
            ));

    }
    public function actionCreate()
    {

        $id = (int) Yii::app()->request->getParam('id');

        $model = new Lease();

        if($id > 0)
        {
            $model=$model->findByPk($id);
            if(isset($model->from_date) && $model->from_date!="0000-00-00")
                {
                    $arr_from_date = explode("-",$model->from_date);
                    $model->from_date=$arr_from_date[2]."/".$arr_from_date[1]."/".$arr_from_date[0];
                }
                else
                {
                    $model->from_date="";
                }
                if(isset($model->to_date) && $model->to_date!="0000-00-00")
                {
                    $arr_to_date = explode("-",$model->to_date);
                    $model->to_date=$arr_to_date[2]."/".$arr_to_date[1]."/".$arr_to_date[0];
                }
                else
                {
                    $model->to_date="";
                }
        }

            Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);

            $this->render('create',array(

                    'model'=>$model,

                    'title' => 'Add New Lease'

            ));
   }

    public function actionSave()
    {
    	$model=new Lease();
    	/************ START Code for Save ***************/
    	if (isset($_POST['Lease'])) {
    		
    		if ((int) @$_POST['Lease']['id'] > 0) {
    			$model->id = (int) $_POST['Lease']['id'];
                        $model = $model->findByPK($model->id);
                        $oldtenant_id  = $model->tenant_id;
                        $oldflat_id    = $model->flat_id;
            
    			$model->updated_by = Yii::app()->user->id;
    			$model->updated_date = date('Y-m-d h:i:s');
    		}
                else {
    			$model->created_by = Yii::app()->user->id;
    			$model->created_date = date('Y-m-d h:i:s');
                        $oldtenant_id  = 0;$oldflat_id    =0;
    		}
    	
    			$model->attributes = $_POST['Lease'];
                        if($_POST['Lease']['from_date']!=''){
                            $fdate = str_replace('/', '-', $_POST['Lease']['from_date']);
                            $model->from_date = date("Y-m-d", strtotime($fdate));
                        }
                        if($_POST['Lease']['to_date']!=''){
                            $tdate = str_replace('/', '-', $_POST['Lease']['to_date']);
                            $model->to_date = date("Y-m-d", strtotime($tdate));
                        }
                        $flat_count            = 0;
                        if(isset($_POST['Lease']['building_id']) && $_POST['Lease']['building_id']!='')
                            $flat_count = Yii::app()->db->createCommand('SELECT COUNT(*) FROM re_flat WHERE building_id ='. $_POST['Lease']['building_id'])->queryScalar();
                        $model->flat_count = 0;
                        if($flat_count > 0){
                          $model->flat_count = $flat_count;
                        }
                        $model->flat_id = $_POST['Lease']['flat_id'];
                        $tenant_id = $_POST['Lease']['tenant_id'];
                        $flat_id = $_POST['Lease']['flat_id'];
                        
	    		if ($model->save())
	    		{   
                            if(($oldtenant_id >0) && ($oldtenant_id != $tenant_id)){
                                $model_tenant = Tenant::model()->findByPK($oldtenant_id);
                                $model_tenant->contract_date = '';
                                $model_tenant->contract_exp_date = '';
                                $model_tenant->flat_id = '';
                                $model_tenant->building_id = '';
                                $model_tenant->save(FALSE);
                            }
                            if($tenant_id>0){
                                $model_tenant = Tenant::model()->findByPK($tenant_id);
                                $model_tenant->contract_date = date("Y-m-d", strtotime($fdate));
                                $model_tenant->contract_exp_date = date("Y-m-d", strtotime($tdate));
                                $model_tenant->flat_id      = $_POST['Lease']['flat_id'];
                                $model_tenant->building_id  = $_POST['Lease']['building_id'];
                                $model_tenant->save(FALSE);
                            }
                            if(($oldflat_id >0) && ($oldflat_id != $flat_id)){
                                $model_flat = Flat::model()->findByPK($oldflat_id);
                                $model_flat->tenant_id  = '';
                                $model_flat->status     = '1';
                                $model_flat->save(FALSE);
                            }
                            if($flat_id>0){
                                $model_flat = Flat::model()->findByPK($flat_id);
                                $model_flat->tenant_id  = $_POST['Lease']['tenant_id'];
                                $model_flat->status     = $_POST['Lease']['flat_status'];
                                $model_flat->save(FALSE);
                            }
                            $jsonData['status'] = 'success';
	                        echo CJSON::encode($jsonData);
	    		}
	    		else
	    		{
		    		$error = CActiveForm::validate($model, '', false);
		                if ($error != '[]')
		                    echo $error;
		        }
    	}
     }

     public function actionDelete()
     {
        $id = $_POST['id'];
        $model=new Lease();
        $arr_lease = Lease::model()->findByPk($id);
        $arr_receipt = Receipt::model()->findAll(array('condition'=>'lease_id='.$id));
        if(empty($arr_receipt)){
            $tenant_id  = $arr_lease->tenant_id;
            $flat_id    = $arr_lease->flat_id;
            $model_tenant   = Tenant::model()->findByPK($tenant_id);
            $model_tenant->contract_date = '';
            $model_tenant->contract_exp_date = '';
            $model_tenant->flat_id = '';
            $model_tenant->building_id = '';
            $model_tenant->save(FALSE);
                                
            $model_flat     = Flat::model()->findByPK($flat_id);
            $model_flat->tenant_id  = '';
            $model_flat->status     = '1';
            $model_flat->save(FALSE);
            $model->deleteByPk($id);
            echo "success";
        
        }
        else{
                
                echo "fail";
        }
    }
    
    public function actionPaymentSummary()
    {
    	 $id = (int) Yii::app()->request->getParam('id');
    	 $flat_id = (int) Yii::app()->request->getParam('flat_id');
    	 
    	 $model = Lease::model()->with('flat','tenant')->findByPk($id);
    	 
    	 $SQL="SELECT SUM(R.amount) AS total_amount,(SELECT SUM(amount) FROM re_lease_receipt WHERE flat_id='$flat_id' AND status=1 ) AS total_received_amount,(SELECT SUM(amount) FROM re_lease_receipt WHERE flat_id='$flat_id' AND status=2 ) AS total_bounced_amount,(SELECT SUM(amount) FROM re_lease_receipt WHERE flat_id='.$flat_id.'AND status=3 ) AS total_cancelled_amount 
                  FROM  re_lease_receipt R 
                  WHERE R.flat_id='$flat_id' 
                  GROUP BY R.flat_id";
    	 
    	 $arr_receipt_amount = Yii::app()->db->createCommand($SQL)->queryAll();
    	 
		    	 
    	 $this->render('paymentsummary',array(
    	 		'arr_payment_amount'=>$arr_receipt_amount,
    	 		'model'=>$model,
    	 		'flat_id'=>$flat_id,
                        'lease_id'=>$id
    	 ));
    	 
    	 
    }
    public function actionprint_payment_summary(){
        $lease_id       = (int) Yii::app()->request->getParam('lease_id');
    	$flat_id        = (int) Yii::app()->request->getParam('flat_id');
        $mPDF1          = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet     = file_get_contents('css/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.views.admin.lease.payment_summary_pdf', array('lease_id' => $lease_id,'flat_id'=>$flat_id), true));
        $mPDF1->Output();
    }
    //vaccant flat of building
    public function actiongetFlatDetails()
    {
        $id=Yii::app()->request->getparam("building_id");  
        $condition = 'building_id="'.$id.'" AND status="1" ';
        $status=0;
		$model = Flat::model()->findAll(array('condition' => $condition));
        $drop= '<li class="form-add col-sm-6"><div class="icon-box fa-user material m1">' ;
        $details=CHtml::listData($model, 'id', 'flat_no');
        if(!empty($details))
            $status=1;
        $drop.=CHtml::dropDownList('Lease[flat_id]','' , $details,  array('class'=>'','placeholder'=>'Flat <span class="red">*</span>'), array('options' => array('title'=>array('selected'=>true))));
        $drop.='</div></li>';
        $status=array("dt" => $drop,"status" => $status);
        echo CJSON::encode($status);
    }
    //flatamount
    public function actiongetFlatAmount()
    {
        $id     = Yii::app()->request->getparam("flat_id");  
        $model  = Flat::model()->findByPk($id);
        $amount = $model->amount;
        $status = array("amount" => $amount,"status" => 1);
        echo CJSON::encode($status);
    }
    public function actiongetLeaseFilter(){
        $lease_type=Yii::app()->request->getparam("lease_type");
        if($lease_type == "1"){ //all
            $model = Lease::model()->findAll(array('condition'=>'status="Y"'));
        }
        if($lease_type == "2"){//closed
            $model = Lease::model()->findAll(array('condition'=>'status="Y" AND flat_status ="1"'));
        }
        if($lease_type == "3"){//live
            $model = Lease::model()->findAll(array('condition'=>'status="Y" AND flat_status ="2"'));
        }
        $this->renderPartial('lease_table_content',array('model'=>$model));       
    }
    
    public function actiongetBuildingFlat()
    {
        $id=Yii::app()->request->getparam("building_id");  
        $condition = 'building_id="'.$id.'" ';
        $status=0;
		$model = Flat::model()->findAll(array('condition' => $condition));
        $flat= '<li class="form-add col-sm-6"><div class="icon-box fa-user material m1">' ;
        $details=CHtml::listData($model, 'id', 'flat_no');
        if(!empty($details))
        $status=1;
        $flat.=CHtml::dropDownList('flat_id','flat_id' , $details,  array('class'=>'','placeholder'=>'Flat','id'=>'flat_id'), array('options' => array('title'=>array('selected'=>true),'id'=>'flat_id')));
        $flat.='</div></li>';
        $status=array("ft" => $flat,"status" => $status);
        echo CJSON::encode($status);
    }
    public function actiongetFlatOwner()
    {
        $id=Yii::app()->request->getparam("flat_id");  
        $status=0;
	$flat= '<li class="form-add col-sm-6"><div class="icon-box fa-user material m1">' ;
        $details= BuildingOwnerDetails::getFlatLandlord($id);
        if(!empty($details))
            $status=1;
        $flat.=CHtml::dropDownList('owner_id','' , $details,  array('class'=>'','placeholder'=>'Owner'), array('options' => array('title'=>array('selected'=>true))));
        $flat.='</div></li>';
        $status=array("ft" => $flat,"status" => $status);
        echo CJSON::encode($status);
    }
    public function actionSummarySearch()
    {
            $model = new Flat();
            Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
                    $this->render('summary_search',array(
                            'model'=>$model,
                            'title' => 'Summary'
                    ));
    }
    public function actionCashflowSearch()
    {
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->render('cash_search');
    }
    public function actionCashflowDetails()
    {
        $building       = $_POST['building_id'];
        $flat       = $_POST['flat_id'];
        $jsonData['building']   = $building;
        $jsonData['flat']   = $flat;
        if($flat >0){
        $jsonData['status']     = 'success';
        }else{
            $jsonData['status']     = 'fail';
        }
        echo CJSON::encode($jsonData);
    }
    public function actionSummaryDetails()
    {
        $date_from      = $_POST['date1'];
        $date_to        = $_POST['date2'];
        $building       = $_POST['building_id'];
        $flat       = $_POST['flat_id'];
        $jsonData['date_from']  = $date_from;
        $jsonData['date_to']  = $date_to;
        $jsonData['building']   = $building;
        $jsonData['flat']   = $flat;
        if($flat >0){
        $jsonData['status']     = 'success';
        }else{
            $jsonData['status']     = 'fail';
        }
        echo CJSON::encode($jsonData);
    }
    public function actionSummaryResults()
    {
        $date_from  = Yii::app()->request->getParam('date_from');
        $date_to  = Yii::app()->request->getParam('date_to');
        $building   = Yii::app()->request->getParam('building_id');
        $flat   = Yii::app()->request->getParam('flat_id');
        $condition = 'building_id= "'.$building.'" and id = "'.$flat.'"';
        $flat_model = Flat::model()->find(array('condition'=>$condition));
        $this->render('search_result',array('flat_model'=>$flat_model,'date_from'=>$date_from,'date_to'=>$date_to,'building'=>$building,'flat'=>$flat,'title' => 'Flat Summary'));
    }
    public function actionRentalCashflow() {
        $building   = Yii::app()->request->getParam('building_id');
        $flat   = Yii::app()->request->getParam('flat_id');
        $this->render('rental_cashflow',array('building'=>$building,'flat'=>$flat,'title' => 'Rental Cash Flow'));
    
    }
    public function actionCalculateDepreciation(){
        $flat_id   = Yii::app()->request->getParam('flat_id');
        $flat_model = Flat::model()->findByPK($flat_id);
        $this->render('flat_depreciation',array('flat_model'=>$flat_model,'flat_id'=>$flat_id,'title' => 'Calculate Depreciation'));
    }
    public function actionCalculateFlatRents(){
        $flat_id   = Yii::app()->request->getParam('flat_id');
        $date_from   = Yii::app()->request->getParam('date_from');
        $date_to   = Yii::app()->request->getParam('date_to');
        $flat_model = Flat::model()->findByPK($flat_id);
        $this->render('flat_rents',array('flat_model'=>$flat_model,'flat_id'=>$flat_id,'date_from'=>$date_from,'date_to'=>$date_to,'title' => 'Flat Rents'));
    }
    public function actionCalculateFlatExpenses(){
        $flat_id   = Yii::app()->request->getParam('flat_id');
        $date_from   = Yii::app()->request->getParam('date_from');
        $date_to   = Yii::app()->request->getParam('date_to');
        $flat_model = Flat::model()->findByPK($flat_id);
        $this->render('flat_expenses',array('flat_model'=>$flat_model,'flat_id'=>$flat_id,'date_from'=>$date_from,'date_to'=>$date_to,'title' => 'Flat Expenses'));
    }
    public function actionCalculateBuidingExpenses(){
        $building_id   = Yii::app()->request->getParam('building_id');
        $building_model = Building::model()->findByPK($building_id);
        $this->render('building_expenses',array('building_model'=>$building_model,'building_id'=>$building_id,'title' => 'Building Expenses'));
    }
    public function actionCalculateLandExpenses(){
        $building_id   = Yii::app()->request->getParam('building_id');
        $building_model = Building::model()->findByPK($building_id);
        $this->render('land_expenses',array('building_model'=>$building_model,'building_id'=>$building_id,'title' => 'Land Expenses'));
    }
}