<?php

class LandlordUploadController extends Controller
{
                public function filters()

	{

		return array(

			'accessControl', // perform access control for CRUD operations

		);

	}
        public function accessRules()
        {

            return array(
                array('allow', // allow all users to perform 'index' and 'view' actions
                    'actions' => array('login', 'error', 'logout'),
                    'users' => array('*'),
                  ),
                array('allow', // allow authenticated user to perform 'create' and 'update' actions
                    'actions' => array('Index','Save','Create','Delete','Upload','getLandlordDocument','CreateDocument','SaveDocument','Download','DownloadDocument'),
                     'expression' => '$user->isMember()',
                ),
                 array('deny', // deny all users
                    'users' => array('*'),
                  ),

            );

        }
    	
        public function actionIndex()
	{
                $model = LandlordUpload::model()->findAll(array('condition'=>'isActive="Y"'));
                $this->render('index',array(
                     'model'=>$model,
                ));

	}
        public function actionCreate()
	{

            $id = (int) Yii::app()->request->getParam('id');
            $landlord_id=(int) Yii::app()->request->getParam('landlord_id');
	    $model = new LandlordUpload();
            
            if($id > 0)
            {
    		$model=$model->findByPk($id);
                if(isset($model->expiry_date) && $model->expiry_date!="0000-00-00")
                {
                    $arr_expiry_date = explode("-",$model->expiry_date);
                    $model->expiry_date=$arr_expiry_date[2]."/".$arr_expiry_date[1]."/".$arr_expiry_date[0];
                }
                else
                {
                    $model->expiry_date="";
                }
                if(isset($model->renewal_date) && $model->renewal_date!="0000-00-00")
                {
                    $arr_renewal_date = explode("-",$model->renewal_date);
                    $model->renewal_date=$arr_renewal_date[2]."/".$arr_renewal_date[1]."/".$arr_renewal_date[0];
                }
                else
                {
                    $model->renewal_date="";
                }
            }

            Yii::app()->clientScript->scriptMap = array( 'jquery.min.js' => false);

            $this->render('create',array(

                    'model'=>$model,

                    'title' => 'Add New Landlord Document',
                
                    'landlord_id' =>$landlord_id

            ));
       }

       public function actionCreateDocument()
	{

            $id = (int) Yii::app()->request->getParam('id');
            $landlord_id=(int) Yii::app()->request->getParam('landlord_id');
	    $model = new LandlordDocument();
            
            if($id > 0)
            {
    		$model=$model->findByPk($id);
            }

            Yii::app()->clientScript->scriptMap = array( 'jquery.min.js' => false);

            $this->render('createdocument',array(

                    'model'=>$model,

                    'title' => 'Add New Landlord Document',
                
                    'landlord_id' =>$landlord_id

            ));
       }
       
    public function actionSave()
    {
    	$model=new LandlordUpload();
    	/************ START Code for Save ***************/
    	if (isset($_POST['LandlordUpload'])) {
    		
    		if ((int) @$_POST['LandlordUpload']['id'] > 0) {
    			$model->id = (int) $_POST['LandlordUpload']['id'];
                        $model = $model->findByPK($model->id);
    			$model->updated_by = Yii::app()->user->id;
    			$model->updated_date_time = date('Y-m-d h:i:s');
    		}
                else {
    			$model->created_by = Yii::app()->user->id;
    			$model->created_date_time = date('Y-m-d h:i:s');
    		}
    	
    			$model->attributes = $_POST['LandlordUpload'];
                        if($_POST['LandlordUpload']['expiry_date'] != '') {
                        $model->expiry_date= DateTime::createFromFormat('d/m/Y', $_POST['LandlordUpload']['expiry_date'])->format('Y-m-d');
                        }
                        if($_POST['LandlordUpload']['renewal_date'] != '') {
                        $model->renewal_date= DateTime::createFromFormat('d/m/Y', $_POST['LandlordUpload']['renewal_date'])->format('Y-m-d');
                        }
                        $model->document_file = $_POST['LandlordUpload']['document_file'];
                        $model->landlord_id = $_POST['landlord_id'];
	    		if ($model->save())
	    		{
	    			$jsonData['status'] = 'success';
	                        echo CJSON::encode($jsonData);
	    		}
	    		else
	    		{
		    		$error = CActiveForm::validate($model, '', false);
		                if ($error != '[]')
		                    echo $error;
		        }
    	}
     }

     public function actionSaveDocument()
    {
    	$model=new LandlordDocument();
    	/************ START Code for Save ***************/
    	if (isset($_POST['LandlordDocument'])) {
    		
    		if ((int) @$_POST['LandlordDocument']['id'] > 0) {
    			$model->id = (int) $_POST['LandlordDocument']['id'];
                        $model = $model->findByPK($model->id);
    			$model->updated_by = Yii::app()->user->id;
    			$model->updated_date_time = date('Y-m-d h:i:s');
    		}
                else {
    			$model->created_by = Yii::app()->user->id;
    			$model->created_date_time = date('Y-m-d h:i:s');
    		}
    	
    			$model->attributes = $_POST['LandlordDocument'];
                        $model->document_file = $_POST['LandlordDocument']['document_file'];
                        $model->landlord_id = $_POST['landlord_id'];
	    		if ($model->save())
	    		{
	    			$jsonData['status'] = 'success';
	                        echo CJSON::encode($jsonData);
	    		}
	    		else
	    		{
		    		$error = CActiveForm::validate($model, '', false);
		                if ($error != '[]')
		                    echo $error;
		        }
    	}
     }
     
     public function actionDelete()
     {
                $id = $_POST['id'];
                $model=new LandlordUpload();
                $model->deleteByPk($id);
                echo "success";
    }
    public function actiongetLandlordDocument()
	{
    	$landlord_id        = (int) Yii::app()->request->getParam('landlord_id');
    	$model        = new LandlordUpload();
    	if($landlord_id > 0)
    	{
                $arr_upload = $model->findAll(array('condition'=>'landlord_id='.$landlord_id));
    	}
    	
    	$this->render('listupload',array('model'=>$model,'landlord_id'=>$landlord_id));
    }
    public function actionDownload(){
        $id= (int) Yii::app()->request->getparam('id'); 
        $sfile =LandlordUpload::model()->findByPk($id);  
        $arr_doc_val = explode(',',$sfile->document_file);
        $zip = new ZipArchive();
        $zip_file_path = Yii::getPathOfAlias('webroot')."/downloadzip/".$sfile->file_name."_".date('d-m-Y').".zip";
        
        if($zip->open($zip_file_path,1?ZIPARCHIVE::OVERWRITE:ZIPARCHIVE::CREATE)===TRUE)
        {
            for($i=0;$i<count($arr_doc_val);$i++){
                $path = "uploads/documents/".$arr_doc_val[$i];
                // Add the files to the .zip file
                $zip->addFile($path, $arr_doc_val[$i]);
            }
            // Closing the zip file
            $zip->close();
        }

        header("Content-type:application/zip"); //for pdf file
        //if you want to read text file using text/plain header
         header('Content-Disposition: attachment; filename="'.basename($zip_file_path).'"');
         header('Content-Length: ' . filesize($zip_file_path));
         readfile($zip_file_path);

         @unlink($zip_file_path);
         Yii::app()->end();
             //$id= (int) Yii::app()->request->getparam('id'); 
               //$sfile =LandlordUpload::model()->findByPk($id);  
          //$path = Yii::getPathOfAlias('webroot')."/uploads/documents/".$sfile->document_file;
          //$this->downloadFile($path);
        }
    public function downloadFile($fullpath){
            if(!empty($fullpath)){ 
                header("Content-type:application/force-download"); //for txt file
                //header("Content-type:application/txt"); //for txt file
                //header('Content-Type:text/plain; charset=ISO-8859-15');
                //if you want to read text file using text/plain header 
                header('Content-Disposition: attachment; filename="'.basename($fullpath).'"'); 
                header('Content-Length: ' . filesize($fullpath));
                readfile($fullpath);
                Yii::app()->end();
            }
    }
    public function actionDownloadDocument(){     
        $id= (int) Yii::app()->request->getparam('id'); 
        $sfile =LandlordDocument::model()->findByPk($id);  
        $arr_doc_val = explode(',',$sfile->document_file);
        $zip = new ZipArchive();
        $zip_file_path = Yii::getPathOfAlias('webroot')."/downloadzip/".$sfile->file_name."_".date('d-m-Y').".zip";
        
        if($zip->open($zip_file_path,1?ZIPARCHIVE::OVERWRITE:ZIPARCHIVE::CREATE)===TRUE)
        {
            for($i=0;$i<count($arr_doc_val);$i++){
                $path = "uploads/documents/".$arr_doc_val[$i];
                // Add the files to the .zip file
                $zip->addFile($path, $arr_doc_val[$i]);
            }
            // Closing the zip file
            $zip->close();
        }

        header("Content-type:application/zip"); //for pdf file
        //if you want to read text file using text/plain header
         header('Content-Disposition: attachment; filename="'.basename($zip_file_path).'"');
         header('Content-Length: ' . filesize($zip_file_path));
         readfile($zip_file_path);

         @unlink($zip_file_path);
         Yii::app()->end();
//             $id= (int) Yii::app()->request->getparam('id'); 
//               $sfile =LandlordDocument::model()->findByPk($id);  
//          $path = Yii::getPathOfAlias('webroot')."/uploads/documents/".$sfile->document_file;
//          $this->downloadFile($path);
          
        }
}