<?php

class LandlordController extends Controller
{
    public function filters()
    {
        return array(
                    'accessControl', // perform access control for CRUD operations
	);

    }
    public function accessRules()
    {

        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
              ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index','Save','Create','Delete'),
                 'expression' => '$user->isMember()',
            ),
             array('deny', // deny all users
                'users' => array('*'),
              ),
            
        );

    }
    
    public function actionIndex()
    {
            $model = Landlord::model()->findAll(array('condition'=>'status="Y"'));
            $this->render('index',array(
                 'model'=>$model,
            ));

    }
    public function actionCreate()
    {

        $id = (int) Yii::app()->request->getParam('id');

        $model = new Landlord();

        if($id > 0)
        {
            $model=$model->findByPk($id);
            if($model->passport_expiry !='0000-00-00')
                {
                    $passport_expiry = str_replace('-', '/', $model->passport_expiry);
                    $model->passport_expiry = date("d/m/Y", strtotime($passport_expiry));
                }else{
                    $model->passport_expiry ='';
                }
        }

            Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);

            $this->render('create',array(

                    'model'=>$model,

                    'title' => 'Add New Landlord'

            ));
    }

    public function actionSave()
    {
    	$model=new Landlord();
    	/************ START Code for Save ***************/
    	if (isset($_POST['Landlord'])) {
    		
    		if ((int) @$_POST['Landlord']['id'] > 0) {
    			$model->id = (int) $_POST['Landlord']['id'];
                        $model = $model->findByPK($model->id);
    			$model->updated_by = Yii::app()->user->id;
    			$model->updated_date = date('Y-m-d h:i:s');
    		}
                else {
    			$model->created_by = Yii::app()->user->id;
    			$model->created_date = date('Y-m-d h:i:s');
    		}
                $model->attributes = $_POST['Landlord'];
                if($_POST['Landlord']['passport_expiry']!='')
                {
                    $passport_expiry = str_replace('/', '-', $_POST['Landlord']['passport_expiry']);
                    $model->passport_expiry = date("Y-m-d", strtotime($passport_expiry));
                }
	    		if ($model->save())
	    		{
	    			$jsonData['status'] = 'success';
	                        echo CJSON::encode($jsonData);
	    		}
	    		else
	    		{
		    		$error = CActiveForm::validate($model, '', false);
		                if ($error != '[]')
		                    echo $error;
		        }
    	}
     }

    public function actionDelete()
    {
        $id = $_POST['id'];
        $model=new Landlord();
        $arr_landlord = BuildingOwnerDetails::model()->findAll(array('condition'=>'landlord='.$id));
        if(empty($arr_landlord)){
            $model->deleteByPk($id);
            echo "success";
        }else{
                echo "fail";
        }
    }
}