<?php

class FlatnoteController extends Controller
{

        public function filters()
        {

                return array(

                        'accessControl', // perform access control for CRUD operations

                );

        }
        public function accessRules()
        {

            return array(
                array('allow', // allow all users to perform 'index' and 'view' actions
                    'actions' => array('login', 'error', 'logout'),
                    'users' => array('*'),
                  ),
                array('allow', // allow authenticated user to perform 'create' and 'update' actions
                    'actions' => array('index','Save','Delete','EditNote','GetAllFlatNote','GetFlatNoteList'),
                     'expression' => '$user->isMember()',
                ),
                 array('deny', // deny all users
                    'users' => array('*'),
                  ),

            );

        }
    
	public function actionIndex()
	{
	
		$id = (int) Yii::app()->request->getParam('id');
	
		$model = new FlatNotes();
		 
		$model->flat_id=$id;
		 
		$arr_flat_details = Flat::model()->findByPk($id);
		 
		/* echo '<pre>';
		 print_r($arr_flat_details);
		exit; */
		 
		$arr_flat_notes = FlatNotes::model()->with('flat')->findAll(array('condition'=>'flat_id='.$id));
	
		Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
	
		$this->render('index',array(
				 
				'flat_id' =>$id,
	
				'model'=>$model,
				 
				'arr_flat_notes'=>$arr_flat_notes,
				 
				'arr_flat_details'=>$arr_flat_details,
	
				'title' => 'Add New Note'
	
		));
	}
	
	/* public function actionIndex()
	{
	
		$id = (int) Yii::app()->request->getParam('id');
	
		$model = new FlatNotes();
			
		$model->flat_id=$id;
			
		$arr_flat_details = Flat::model()->findByPk($id);
			
			
		$arr_flat_notes = FlatNotes::model()->findAll(array('condition'=>'flat_id='.$id));
	
		Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
	
		$this->render('index',array(
					
				'flat_id' =>$id,
	
				'model'=>$model,
					
				'arr_flat_notes'=>$arr_flat_notes,
					
				'arr_flat_details'=>$arr_flat_details,
	
				'title' => 'Add New Note'
	
		));
	} */
	
	public function actionEditNote()
	{
	
		$id = (int) Yii::app()->request->getParam('id');
	
		$model = new FlatNotes();
			
		$model = FlatNotes::model()->findByPk($id);
		
		$flat_id = $model->flat_id;
		
		$arr_flat_details = Flat::model()->findByPk($flat_id);
		
		 $json_data['id']=$model->id;
		 $json_data['reminder_date']=date('d/m/Y',strtotime($model->reminder_date));
		 $json_data['notes']=$model->notes;
		 echo json_encode($json_data);
		Yii::app()->end();
		
		$this->render('addnewnote',array(
					
				'flat_id' =>$model->flat_id,
		
				'model'=>$model,
					
				'flat_details'=>$arr_flat_details,
		
				'title' => 'Edit Note'
		
		)); 
	
	}
	
	public function actionSave()
	{
		$model=new FlatNotes();
		/************ START Code for Save ***************/
		if (isset($_POST['FlatNotes'])) {
	
			$flat_id=$_POST['FlatNotes']['flat_id'];
	
			$reminder_date="";
			if(isset($_POST['FlatNotes']['reminder_date']) && $_POST['FlatNotes']['reminder_date']!="")
			{
				$arr_reminder_date = explode("/",$_POST['FlatNotes']['reminder_date']);
				$reminder_date = $arr_reminder_date[2]."-".$arr_reminder_date[1]."-".$arr_reminder_date[0];
			}
	
			$model->updated_by=0;
	
			if ((int) @$_POST['FlatNotes']['id'] > 0) {
				$model->id = (int) $_POST['FlatNotes']['id'];
				$model = $model->findByPK($model->id);
				$model->updated_by = Yii::app()->user->id;
				$model->updated_date_time = date('Y-m-d h:i:s');
			}
			else {
				$model->created_by = Yii::app()->user->id;
				$model->created_date_time = date('Y-m-d h:i:s');
			}
	
			$modelFlatDetails=Flat::model()->with('building','building_class','landlord','tenant')->findByPk($flat_id);
	
	
			$model->attributes = $_POST['FlatNotes'];
			$model->reminder_date 		= $reminder_date;
			$model->flat_id 			= $flat_id;
			$model->building_name 		= $modelFlatDetails->building->building_name;
			$model->building_class_name = $modelFlatDetails->building_class->class_name;
	
			$model->landlord_name 		= "";
			if(isset($modelFlatDetails->landlord->name))
			{
				$model->landlord_name 		= $modelFlatDetails->landlord->name;
			}
			$model->tenant_name 		= "";
			if(isset($modelFlatDetails->tenant->name))
			{
				$model->tenant_name 		= $modelFlatDetails->tenant->name;
			}
			$model->created_user 		= User::getName(Yii::app()->user->id);
	
	
			if ($model->save())
			{
				$jsonData['status'] = 'success';
				echo CJSON::encode($jsonData);
			}
			else
			{
				$error = CActiveForm::validate($model, '', false);
				if ($error != '[]')
					echo $error;
			}
		}
	}
	
	public function actionGetAllFlatNote()
	{
	
		$id = (int) Yii::app()->request->getParam('flat_id');
	
		$arr_flat_notes = FlatNotes::model()->findAll(array('condition'=>'flat_id='.$id));
	
		Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
	
		$this->render('notehistory',array(
					
				'arr_flat_notes'=>$arr_flat_notes,
					
		));
	}
	
	public function actionDelete()
	{
		$id = $_POST['id'];
		$model=new FlatNotes();
		$model->deleteByPk($id);
		echo "success";
	}
	
	public function actionGetFlatNoteList()
	{
		$this->render('listflatnote',array('model'=>new FlatNotes()));
	}
}