<?php

class FlatController extends Controller
{
    public function filters()

    {

            return array(

                    'accessControl', // perform access control for CRUD operations

            );

    }
    public function accessRules()
    {

        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
              ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index','Save','Delete','Create'),
                 'expression' => '$user->isMember()',
            ),
             array('deny', // deny all users
                'users' => array('*'),
              ),

        );

    }
   
	public function actionIndex()
	{
                $model = Flat::model()->with('building','building_class')->findAll();
                $this->render('index',array(
                     'model'=>$model,
                ));

	}
    public function actionCreate()
	{

            $id = (int) Yii::app()->request->getParam('id');
            
	    	$model = new Flat();
            
            if($id > 0)
            {
    		$model=$model->findByPk($id);
            }

                Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);

			$this->render('create',array(
	
				'model'=>$model,
	
	                        'title' => 'Add New Flat'
	
			));
      }

    public function actionSave()
    {
    	$model=new Flat();
    	/************ START Code for Save ***************/
    	if (isset($_POST['Flat'])) {
    		
    		if ((int) @$_POST['Flat']['id'] > 0) {
    			$model->id = (int) $_POST['Flat']['id'];
                $model = $model->findByPK($model->id);
    			$model->updated_by = Yii::app()->user->id;
    			$model->updated_date = date('Y-m-d h:i:s');
    		}
                else {
    			$model->created_by = Yii::app()->user->id;
    			$model->created_date = date('Y-m-d h:i:s');
                        $model->status = '1';
    		}
    	
    			$model->attributes = $_POST['Flat'];
	    		if ($model->save())
	    		{
	    			$jsonData['status'] = 'success';
	                        echo CJSON::encode($jsonData);
	    		}
	    		else
	    		{
		    		$error = CActiveForm::validate($model, '', false);
		                if ($error != '[]')
		                    echo $error;
		        }
    	}
     }

     public function actionDelete()
     {
        $id = $_POST['id'];
        $model=new Flat();
        $arr_lease = Lease::model()->findAll(array('condition'=>'flat_id='.$id));
        $arr_receipt = Receipt::model()->findAll(array('condition'=>'flat_id='.$id));
        if(empty($arr_lease) && empty($arr_receipt)){
            $model->deleteByPk($id);
            echo "success";
        }else{
                echo "fail";
        }
    }
}